/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming.net;

import com.novell.service.jncpv2.net.NetService;
import com.novell.service.nds.naming.NdsEnvironment;
import com.novell.service.session.Session;
import com.novell.service.session.SessionAttrs;
import com.novell.service.session.SessionException;
import com.novell.service.session.SessionManager;
import com.novell.utility.naming.Environment;
import com.novell.utility.naming.URLParser;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;

public class NetEnvironment
extends NdsEnvironment
implements Cloneable,
Serializable {
    private static String[] attrsTable = new String[]{"OBJECT_ATTRS", "DSI_OBJECT_ATTRS"};
    private static String[] defsTable = new String[]{"CLASS_DEFS", "EXPANDED_CLASS_DEFS", "INFO_CLASS_DEFS", "FULL_CLASS_DEFS"};
    protected static final String defaultHost = null;
    protected String host = null;
    protected static final String defaultPrincipal = null;
    protected String principal = null;
    private static final String defaultObjectAttributeLevel = "OBJECT_ATTRS";
    private String objectAttributeLevel = "OBJECT_ATTRS";
    protected static final String defaultCredentials = "";
    protected String credentials = "";
    protected static final boolean defaultReferrals = false;
    protected boolean referrals = false;
    private static final int defaultClassAttributesLevel = 1;
    private int classAttributesLevel = 1;
    private static final String defaultClassAttributesLevelStr = "CLASS_DEFS";
    private String classAttributesLevelStr = "CLASS_DEFS";
    protected static final boolean defaultConnectionIsValid = false;
    protected boolean connectionIsValid;
    private int batchSize = 16384;
    private static final String defaultLastConnection = "";
    private String lastConnection = "";
    private static final int defaultConfidence = 0;
    private int confidence = 0;
    private static final int defaultNameCacheDepth = -1;
    private int nameCacheDepth = -1;
    private static final boolean defaultTypelessNames = true;
    private boolean typelessNames = true;
    private transient boolean setLastConnection = false;
    private transient Session session;
    private transient NetService service;
    private static final String defaultServiceKey = "com.novell.service.jncpv2.net.BasicNetService.1039844522";
    protected String serviceKey = "com.novell.service.jncpv2.net.BasicNetService.1039844522";
    private static final boolean defaultServiceIsValid = false;
    protected boolean serviceIsValid = false;

    public NetEnvironment(Hashtable hashtable) throws NamingException {
        super(hashtable);
        this.setState(hashtable, false);
        this.getSession();
    }

    public NetEnvironment(Environment environment) throws NamingException {
        super(environment);
        this.setState(this.environment, false);
        this.getSession();
    }

    public synchronized Object clone() {
        NetEnvironment netEnvironment = (NetEnvironment)super.clone();
        netEnvironment.host = this.host;
        netEnvironment.principal = this.principal;
        netEnvironment.credentials = this.credentials;
        netEnvironment.classAttributesLevel = this.classAttributesLevel;
        netEnvironment.classAttributesLevelStr = this.classAttributesLevelStr;
        netEnvironment.connectionIsValid = this.connectionIsValid;
        netEnvironment.session = this.session;
        netEnvironment.serviceIsValid = this.serviceIsValid;
        netEnvironment.service = this.service;
        netEnvironment.confidence = this.confidence;
        netEnvironment.nameCacheDepth = this.nameCacheDepth;
        netEnvironment.typelessNames = this.typelessNames;
        netEnvironment.batchSize = this.batchSize;
        return netEnvironment;
    }

    public Hashtable addToEnvironment(Hashtable hashtable) throws NamingException {
        this.setState(hashtable, false);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.environment.put(string, hashtable.get(string));
        }
        return (Hashtable)this.environment.clone();
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        Object object2 = super.addToEnvironment(string, object);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(1);
        hashtable.put(string, object);
        this.addToEnvironment(hashtable);
        return object2;
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        Object object = super.removeFromEnvironment(string);
        Hashtable<String, String> hashtable = new Hashtable<String, String>(1);
        hashtable.put(string, new String());
        this.setState(hashtable, true);
        return object;
    }

    public Hashtable getEnvironment() throws NamingException {
        return (Hashtable)this.environment.clone();
    }

    protected void setState(Hashtable hashtable, boolean bl) throws NamingException {
        Boolean bl2;
        Integer n;
        Integer n2;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8 = (String)hashtable.get("java.naming.provider.url");
        String string9 = new URLParser(string8).getHost();
        if (string9 != null) {
            if (bl) {
                string9 = null;
            } else if (!string9.equals(this.host)) {
                this.host = string9;
                this.connectionIsValid = false;
                this.serviceIsValid = false;
            }
        }
        if ((string7 = (String)hashtable.get("java.naming.nds.objectAttributeLevel")) != null) {
            this.objectAttributeLevel = bl || string7.length() == 0 ? defaultObjectAttributeLevel : string7;
        }
        if ((string6 = (String)hashtable.get("java.naming.nds.disallowReferrals")) != null) {
            if (bl) {
                this.referrals = false;
                this.connectionIsValid = false;
                this.serviceIsValid = false;
            } else {
                boolean bl3;
                boolean bl4 = bl3 = string6.equals("TRUE");
                if (bl3 != this.referrals) {
                    this.referrals = bl3;
                    this.connectionIsValid = false;
                    this.serviceIsValid = false;
                }
            }
        }
        if ((string5 = (String)hashtable.get("java.naming.security.principal")) != null) {
            if (bl) {
                string5 = null;
            } else if (!string5.equals(this.principal)) {
                this.principal = string5;
                this.connectionIsValid = false;
                this.serviceIsValid = false;
            }
        }
        if ((string4 = (String)hashtable.get("java.naming.security.credentials")) != null) {
            if (bl) {
                this.credentials = "";
            } else if (!string4.equals(this.credentials)) {
                this.credentials = string4;
                this.connectionIsValid = false;
                this.serviceIsValid = false;
            }
        }
        if ((string3 = (String)hashtable.get("java.naming.nds.classAttributeLevel")) != null) {
            if (bl || string3.length() == 0) {
                this.classAttributesLevel = 1;
                this.classAttributesLevelStr = defaultClassAttributesLevelStr;
            } else {
                this.classAttributesLevel = -1;
                this.classAttributesLevelStr = string3;
                int n3 = 0;
                while (n3 < defsTable.length) {
                    if (string3.equals(defsTable[n3])) {
                        this.classAttributesLevel = n3 + 1;
                    }
                    ++n3;
                }
            }
        }
        if ((string2 = (String)hashtable.get("java.naming.batchsize")) != null) {
            if (bl) {
                this.batchSize = 16384;
            } else {
                try {
                    this.batchSize = Integer.parseInt(string2);
                    if (this.batchSize > 64512) {
                        this.batchSize = 64512;
                    } else if (this.batchSize < 2048) {
                        this.batchSize = 2048;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.batchSize = 16384;
                }
            }
        }
        if ((string = (String)hashtable.get("java.naming.nds.lastConnection")) != null) {
            if (bl) {
                this.lastConnection = "";
            } else {
                this.lastConnection = string;
                this.setLastConnection = true;
            }
        }
        if ((n2 = (Integer)hashtable.get("java.naming.nds.confidence")) != null) {
            this.confidence = bl ? 0 : n2;
            this.serviceIsValid = false;
        }
        if ((n = (Integer)hashtable.get("java.naming.nds.nameCacheDepth")) != null) {
            this.nameCacheDepth = bl ? -1 : n;
            this.serviceIsValid = false;
        }
        if ((bl2 = (Boolean)hashtable.get("java.naming.nds.typelessNames")) != null) {
            this.typelessNames = bl ? true : bl2;
            this.serviceIsValid = false;
        }
    }

    public String getHost() {
        return this.host;
    }

    public String getServiceHost() {
        return this.host;
    }

    public boolean getDisallowReferrals() {
        return this.referrals;
    }

    int getBatchSize() {
        return this.batchSize;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public synchronized NetService getService() throws NamingException {
        if (!this.serviceIsValid) {
            try {
                Session session = this.getSession();
                this.service = (NetService)session.getService(this.serviceKey);
                this.service.setConfidence(this.confidence);
                if (this.nameCacheDepth != -1) {
                    this.service.setNameCacheDepth(this.nameCacheDepth);
                }
                this.service.setTypelessNames(this.typelessNames);
            }
            catch (SessionException sessionException) {
                AuthenticationException authenticationException = new AuthenticationException();
                authenticationException.setRootCause(sessionException);
                throw authenticationException;
            }
        }
        this.serviceIsValid = true;
        return this.service;
    }

    public synchronized Session getSession() throws NamingException {
        Object object;
        if (!this.connectionIsValid) {
            try {
                SessionManager sessionManager = this.getSessionManager();
                Session session = sessionManager.findSession("com.novell.service.session.nds.NDSInitialSession");
                object = this.principal != null ? session.getSession(this.host) : session.getSession(this.host);
                SessionAttrs sessionAttrs = object.getAttributes(new String[]{"SESSION_TYPE"});
                if (!((String)sessionAttrs.getValue("SESSION_TYPE")).equals("TREE")) {
                    throw new NamingException();
                }
                this.session = object;
                this.environment.put("java.naming.session", this.session);
            }
            catch (SessionException sessionException) {
                AuthenticationException authenticationException = new AuthenticationException();
                authenticationException.setRootCause(sessionException);
                throw authenticationException;
            }
        }
        if (!this.connectionIsValid && this.referrals && this.setLastConnection) {
            try {
                this.session = this.session.getSession(this.lastConnection);
                this.environment.put("java.naming.session", this.session);
            }
            catch (SessionException sessionException) {
                object = new NamingException();
                ((NamingException)object).setRootCause(sessionException);
                throw object;
            }
        }
        this.connectionIsValid = true;
        return this.session;
    }

    public String getObjectAttributeLevel() {
        return this.objectAttributeLevel;
    }

    public int getClassAttributesLevel() {
        return this.classAttributesLevel;
    }

    public String getClassAttributesLevelString() {
        return this.classAttributesLevelStr;
    }

    protected synchronized void setServiceKey(String string) {
        this.serviceKey = string;
        this.serviceIsValid = false;
    }
}

