/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming.net;

import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetEntryInfo;
import com.novell.service.jncpv2.net.NetIterationHandle;
import com.novell.service.jncpv2.net.NetListBuffer;
import com.novell.service.jncpv2.net.NetService;
import com.novell.service.nds.naming.NdsNameClassPair;
import com.novell.service.nds.naming.NdsNamingEnumeratorWrappable;
import com.novell.service.nds.naming.NdsNamingExceptionFactory;
import com.novell.service.nds.naming.net.NetEnvironment;
import com.novell.service.session.SessionException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

class NetFilteredNameClassEnumerator
implements NamingEnumeration,
NdsNamingEnumeratorWrappable {
    private static NdsNamingExceptionFactory exceptionFactory = new NdsNamingExceptionFactory();
    private boolean containers = false;
    private NetIterationHandle iterationHandle;
    private Enumeration entries;
    private String objectName;
    private String className;
    private String subordinateName;
    private NetService service;
    private NetListBuffer subordinates;

    NetFilteredNameClassEnumerator(String string, boolean bl, NetEnvironment netEnvironment) throws NamingException {
        this.objectName = string;
        this.containers = true;
        this.service = netEnvironment.getService();
        try {
            this.iterationHandle = new NetIterationHandle(this.service, 5);
            this.subordinates = new NetListBuffer(this.service, netEnvironment.getBatchSize());
            this.getSubordinates();
            return;
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
    }

    NetFilteredNameClassEnumerator(String string, String string2, String string3, NetEnvironment netEnvironment) throws NamingException {
        this.objectName = string;
        this.className = string2;
        this.subordinateName = string3;
        this.service = netEnvironment.getService();
        try {
            this.iterationHandle = new NetIterationHandle(this.service, 5);
            this.subordinates = new NetListBuffer(this.service, netEnvironment.getBatchSize());
            this.getSubordinates();
            return;
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
    }

    private void getSubordinates() throws NSIException {
        try {
            if (this.containers) {
                this.service.listContainers(this.objectName, this.iterationHandle, this.subordinates);
            } else {
                this.service.listByClassAndName(this.objectName, this.className, this.subordinateName, this.iterationHandle, this.subordinates);
            }
            this.entries = this.subordinates.getEntries();
            return;
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public boolean hasMoreElements() {
        return this.entries.hasMoreElements() || this.iterationHandle.moreIterations();
    }

    public boolean hasMore() throws NamingException {
        return this.hasMoreElements();
    }

    public Object next() throws NamingException {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        try {
            if (!this.entries.hasMoreElements()) {
                this.getSubordinates();
            }
            NetEntryInfo netEntryInfo = (NetEntryInfo)this.entries.nextElement();
            return new NdsNameClassPair(netEntryInfo.getEntryRDN(), netEntryInfo);
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
    }

    public Object nextElement() {
        try {
            return this.next();
        }
        catch (NamingException namingException) {
            throw new NoSuchElementException();
        }
    }

    public void close() throws NamingException {
        try {
            this.iterationHandle.closeIteration();
            return;
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
    }
}

