/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming.net;

import com.novell.service.jncp.NSIException;
import com.novell.service.nds.NdsAttributeValue;
import com.novell.service.nds.NdsPartition;
import com.novell.service.nds.ldap.LdapAttributeValueFactory;
import com.novell.service.nds.naming.NdsDataAccessor;
import com.novell.service.nds.naming.NdsPartitionNameParser;
import com.novell.service.nds.naming.NdsPartitionOperationException;
import com.novell.service.nds.naming.PartitionDirContextWrappable;
import com.novell.service.nds.naming.net.NetEnvironment;
import com.novell.service.nds.naming.net.NetPartitionBindingEnumerator;
import com.novell.service.nds.naming.net.NetPartitionDirContext;
import com.novell.service.nds.naming.net.NetPartitionNameClassEnumerator;
import com.novell.service.nds.naming.net.PartitionFunctions;
import com.novell.service.nds.naming.net.PendingOpObject;
import com.novell.service.rfc1960.Rfc1960Parser;
import com.novell.service.rfc1960.SearchStringComponent;
import com.novell.utility.naming.Environment;
import com.novell.utility.naming.directory.SearchEnumerator;
import com.novell.utility.naming.directory.SearchFilterFactory;
import com.sun.jndi.toolkit.ctx.AtomicDirContext;
import com.sun.jndi.toolkit.ctx.Continuation;
import com.sun.jndi.toolkit.ctx.HeadTail;
import com.sun.jndi.toolkit.ctx.StringHeadTail;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidSearchFilterException;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class NetPartitionRootContext
extends AtomicDirContext
implements NdsPartition,
NdsDataAccessor,
PartitionDirContextWrappable {
    private static NdsPartitionNameParser parser = new NdsPartitionNameParser();
    protected NetEnvironment netEnv;
    private static Hashtable partnOpns = new Hashtable();
    private PartitionFunctions pf;

    public NetPartitionRootContext(Name name, NetEnvironment netEnvironment) throws NamingException {
        this.netEnv = (NetEnvironment)netEnvironment.clone();
        this.pf = new PartitionFunctions(this.netEnv);
    }

    public String getNameInNamespace() throws NamingException {
        return "[Root]";
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        return this.netEnv.addToEnvironment(string, object);
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        return this.netEnv.removeFromEnvironment(string);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.netEnv.getEnvironment();
    }

    public void close() throws NamingException {
    }

    protected HeadTail p_parseComponent(Name name, Continuation continuation) throws NamingException {
        if (name.size() > 2) {
            throw continuation.fillInException(new InvalidNameException());
        }
        if (name.size() == 2) {
            return new HeadTail(name.getPrefix(1), name.getSuffix(1));
        }
        return new HeadTail(name, null);
    }

    protected StringHeadTail c_parseComponent(String string, Continuation continuation) throws NamingException {
        try {
            CompoundName compoundName = (CompoundName)parser.parse(string);
            if (compoundName.isEmpty() || compoundName.size() == 1) {
                return new StringHeadTail(string, null);
            }
            throw continuation.fillInException(new InvalidNameException());
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
    }

    protected void a_bind(String string, Object object, Continuation continuation) throws NamingException {
        this.notSupported(string, continuation);
    }

    protected Context a_createSubcontext(String string, Continuation continuation) throws NamingException {
        if (this.pf.IsPartitionRoot(string)) {
            continuation.setError((Object)this, string);
            throw continuation.fillInException(new NameAlreadyBoundException());
        }
        try {
            PendingOpObject pendingOpObject = new PendingOpObject(string, this.netEnv.getService(), "Split");
            partnOpns.put(pendingOpObject, string);
            this.pf.SplitPartition(string, pendingOpObject.getUniqueId());
            if (partnOpns.containsKey(pendingOpObject)) {
                partnOpns.remove(pendingOpObject);
            }
            NetPartitionDirContext netPartitionDirContext = new NetPartitionDirContext(string, this.netEnv);
            continuation.setSuccess();
            return netPartitionDirContext;
        }
        catch (NamingException namingException) {
            continuation.setError((Object)this, string);
            throw continuation.fillInException(namingException);
        }
    }

    protected void a_destroySubcontext(String string, Continuation continuation) throws NamingException {
        if (!this.pf.IsPartitionRoot(string)) {
            continuation.setError((Object)this, string);
            throw continuation.fillInException(new NameNotFoundException());
        }
        try {
            PendingOpObject pendingOpObject = new PendingOpObject(string, this.netEnv.getService(), "Join");
            partnOpns.put(pendingOpObject, string);
            this.pf.JoinPartition(string, pendingOpObject.getUniqueId());
            if (partnOpns.containsKey(pendingOpObject)) {
                partnOpns.remove(pendingOpObject);
            }
            continuation.setSuccess();
            return;
        }
        catch (NamingException namingException) {
            continuation.setError((Object)this, string);
            throw continuation.fillInException(namingException);
        }
    }

    protected NameParser a_getNameParser(Continuation continuation) throws NamingException {
        return parser;
    }

    protected NamingEnumeration a_list(Continuation continuation) throws NamingException {
        NetPartitionNameClassEnumerator netPartitionNameClassEnumerator = null;
        try {
            netPartitionNameClassEnumerator = new NetPartitionNameClassEnumerator(this.netEnv.getService(), "[Root]");
            continuation.setSuccess();
        }
        catch (NamingException namingException) {
            continuation.setError((Object)this, "");
            throw continuation.fillInException(namingException);
        }
        return netPartitionNameClassEnumerator;
    }

    protected NamingEnumeration a_listBindings(Continuation continuation) throws NamingException {
        NetPartitionBindingEnumerator netPartitionBindingEnumerator = null;
        netPartitionBindingEnumerator = new NetPartitionBindingEnumerator(this.netEnv, "[Root]");
        return netPartitionBindingEnumerator;
    }

    protected Object a_lookup(String string, Continuation continuation) throws NamingException {
        NetPartitionDirContext netPartitionDirContext = null;
        if (this.isEmpty(string)) {
            continuation.setSuccess();
            return this;
        }
        if (!this.pf.IsAPartition(string)) {
            continuation.setError((Object)this, string);
            throw continuation.fillInException(new NameNotFoundException());
        }
        CompoundName compoundName = (CompoundName)parser.parse(string);
        netPartitionDirContext = new NetPartitionDirContext(compoundName, this.netEnv);
        continuation.setSuccess();
        return netPartitionDirContext;
    }

    protected Object a_lookupLink(String string, Continuation continuation) throws NamingException {
        return this.a_lookup(string, continuation);
    }

    protected void a_rebind(String string, Object object, Continuation continuation) throws NamingException {
        this.notSupported(string, continuation);
    }

    protected void a_rename(String string, Name name, Continuation continuation) throws NamingException {
        this.notSupported(string, continuation);
    }

    protected void a_unbind(String string, Continuation continuation) throws NamingException {
        this.notSupported(string, continuation);
    }

    protected void a_bind(String string, Object object, Attributes attributes, Continuation continuation) throws NamingException {
        OperationNotSupportedException operationNotSupportedException = new OperationNotSupportedException();
        continuation.setError((Object)this, string);
        throw continuation.fillInException(operationNotSupportedException);
    }

    protected DirContext a_createSubcontext(String string, Attributes attributes, Continuation continuation) throws NamingException {
        OperationNotSupportedException operationNotSupportedException = new OperationNotSupportedException();
        continuation.setError((Object)this, string);
        throw continuation.fillInException(operationNotSupportedException);
    }

    protected Attributes a_getAttributes(String string, String[] stringArray, Continuation continuation) throws NamingException {
        OperationNotSupportedException operationNotSupportedException = new OperationNotSupportedException();
        continuation.setError((Object)this, string);
        throw continuation.fillInException(operationNotSupportedException);
    }

    protected DirContext a_getSchema(Continuation continuation) throws NamingException {
        OperationNotSupportedException operationNotSupportedException = new OperationNotSupportedException();
        continuation.setError((Object)this, "");
        throw continuation.fillInException(operationNotSupportedException);
    }

    protected DirContext a_getSchemaClassDefinition(Continuation continuation) throws NamingException {
        OperationNotSupportedException operationNotSupportedException = new OperationNotSupportedException();
        continuation.setError((Object)this, "");
        throw continuation.fillInException(operationNotSupportedException);
    }

    protected void a_modifyAttributes(String string, int n, Attributes attributes, Continuation continuation) throws NamingException {
        OperationNotSupportedException operationNotSupportedException = new OperationNotSupportedException();
        continuation.setError((Object)this, string);
        throw continuation.fillInException(operationNotSupportedException);
    }

    protected void a_modifyAttributes(String string, ModificationItem[] modificationItemArray, Continuation continuation) throws NamingException {
        OperationNotSupportedException operationNotSupportedException = new OperationNotSupportedException();
        continuation.setError((Object)this, string);
        throw continuation.fillInException(operationNotSupportedException);
    }

    protected void a_rebind(String string, Object object, Attributes attributes, Continuation continuation) throws NamingException {
        OperationNotSupportedException operationNotSupportedException = new OperationNotSupportedException();
        continuation.setError((Object)this, string);
        throw continuation.fillInException(operationNotSupportedException);
    }

    protected NamingEnumeration a_search(Attributes attributes, String[] stringArray, Continuation continuation) throws NamingException {
        if (attributes == null || attributes.size() == 0) {
            Vector<SearchResult> vector = new Vector<SearchResult>();
            NamingEnumeration namingEnumeration = this.listBindings("");
            while (namingEnumeration.hasMoreElements()) {
                Binding binding = (Binding)namingEnumeration.next();
                DirContext dirContext = (DirContext)binding.getObject();
                Attributes attributes2 = dirContext.getAttributes("", stringArray);
                vector.addElement(new SearchResult(binding.getName(), binding.getClassName(), null, attributes2, true));
            }
            continuation.setSuccess();
            return new SearchEnumerator(vector);
        }
        SearchFilterFactory searchFilterFactory = new SearchFilterFactory(attributes);
        SearchControls searchControls = new SearchControls();
        searchControls.setReturningAttributes(stringArray);
        return this.a_search("", searchFilterFactory.getExpression(), searchFilterFactory.getArgs(), searchControls, continuation);
    }

    protected NamingEnumeration a_search(String string, String string2, SearchControls searchControls, Continuation continuation) throws NamingException {
        if (searchControls == null) {
            new SearchControls();
        }
        return this.a_search(string, string2, null, searchControls, continuation);
    }

    /*
     * Unable to fully structure code
     */
    protected NamingEnumeration a_search(String var1_1, String var2_2, Object[] var3_3, SearchControls var4_4, Continuation var5_5) throws NamingException {
        if (!this.isEmpty(var1_1)) {
            var6_6 = this.a_lookup(var1_1, var5_5);
            if (var6_6 != null) {
                var5_5.setContinue(var6_6, var1_1, (Context)this, "");
            }
            return null;
        }
        if (var4_4 == null) {
            var4_4 = new SearchControls();
        }
        var6_7 = var4_4.getTimeLimit();
        var7_8 = 0L;
        var9_9 = 0L;
        var11_10 = false;
        var12_11 = var4_4.getCountLimit();
        var14_12 = var12_11 != 0L;
        var15_13 = var4_4.getSearchScope();
        if (var6_7 != 0) {
            var7_8 = System.currentTimeMillis() + (long)var6_7;
            var11_10 = true;
        }
        try {
            var16_14 = new Rfc1960Parser(var2_2);
        }
        catch (IllegalArgumentException var17_15) {
            var5_5.setError((Object)this, var1_1);
            var18_17 = new InvalidSearchFilterException();
            var18_17.setRootCause(var17_15);
            throw var5_5.fillInException(var18_17);
        }
        var17_16 = new Vector<SearchResult>();
        try {
            var18_18 = this.searchObject(var16_14, var4_4, var3_3);
            if (var18_18 != null) {
                var17_16.addElement((SearchResult)var18_18);
            }
            if (var15_13 == 0) {
                return new SearchEnumerator(var17_16);
            }
        }
        catch (NamingException var18_19) {
            var5_5.setError((Object)this, var1_1);
            throw var5_5.fillInException(var18_19);
        }
        var18_18 = new SearchControls(var15_13 == 1 ? 0 : var15_13, var12_11, var6_7, var4_4.getReturningAttributes(), var4_4.getReturningObjFlag(), var4_4.getDerefLinkFlag());
        var19_20 = this.listBindings("");
        while (var19_20.hasMoreElements()) {
            if (var11_10) {
                var9_9 = var7_8 - System.currentTimeMillis();
                if (var9_9 <= 0L) break;
                var18_18.setTimeLimit((int)var9_9);
            }
            if (var14_12) {
                if (var12_11 <= 0L) break;
                var18_18.setCountLimit(var12_11);
            }
            if (!((var21_22 = (var20_21 = (Binding)var19_20.next()).getObject()) instanceof DirContext)) continue;
            var22_23 = var20_21.getName();
            var23_24 = (DirContext)var21_22;
            try {
                var24_25 = var23_24.search("", var2_2, var3_3, (SearchControls)var18_18);
                if (true) ** GOTO lbl62
            }
            catch (NamingException var25_27) {
                var5_5.setError((Object)this, var1_1);
                throw var5_5.fillInException(var25_27);
            }
            do {
                var26_28 = (var26_28 = (var25_26 = var24_25.next()).getName()).length() == 0 ? var22_23 : var23_24.composeName(var26_28, var22_23);
                var25_26.setName(var26_28);
                var17_16.addElement(var25_26);
                if (!var14_12) continue;
                --var12_11;
lbl62:
                // 3 sources

            } while (var24_25.hasMoreElements());
        }
        var5_5.setSuccess();
        return new SearchEnumerator(var17_16);
    }

    public Reference getReference() throws NamingException {
        return null;
    }

    public void abortOperations(Name name) throws NdsPartitionOperationException {
        this.abortOperations(name.toString());
    }

    public void abortOperations(String string) throws NdsPartitionOperationException {
        this.pf.AbortOperations(string);
        if (partnOpns.containsKey(string)) {
            partnOpns.remove(string);
        }
    }

    private Object notSupported(String string, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, string);
        throw continuation.fillInException(new OperationNotSupportedException());
    }

    public static Hashtable getPendingPartitionOperations() {
        return partnOpns;
    }

    public String getBaseClass() throws NSIException {
        return "Partition Root";
    }

    public Environment getEnvironmentInstance() throws NamingException {
        return this.netEnv;
    }

    private SearchResult searchObject(Rfc1960Parser rfc1960Parser, SearchControls searchControls, Object[] objectArray) throws NamingException {
        Attributes attributes;
        String[] stringArray = searchControls.getReturningAttributes();
        try {
            attributes = this.getAttributes("");
            while (rfc1960Parser.hasMoreElements()) {
                boolean bl = false;
                SearchStringComponent searchStringComponent = rfc1960Parser.next();
                Attribute attribute = attributes.get(searchStringComponent.getAttributeId());
                if (attribute != null) {
                    NamingEnumeration<?> namingEnumeration = attribute.getAll();
                    while (namingEnumeration.hasMoreElements()) {
                        bl = this.compareValue(searchStringComponent, (NdsAttributeValue)namingEnumeration.nextElement(), objectArray);
                        if (bl) break;
                    }
                }
                rfc1960Parser.setCompareResult(searchStringComponent, bl);
            }
            if (!rfc1960Parser.compared()) {
                return null;
            }
        }
        catch (InvalidSearchFilterException invalidSearchFilterException) {
            throw invalidSearchFilterException;
        }
        catch (NamingException namingException) {
            return null;
        }
        if (stringArray != null) {
            attributes = this.getAttributes("", stringArray);
        }
        return new SearchResult("", searchControls.getReturningObjFlag() ? this.getInstance() : null, attributes, true);
    }

    private boolean compareValue(SearchStringComponent searchStringComponent, NdsAttributeValue ndsAttributeValue, Object[] objectArray) throws NamingException {
        NdsAttributeValue ndsAttributeValue2;
        boolean bl = false;
        int n = searchStringComponent.getOperationType();
        if (!ndsAttributeValue.supportsMatchingRules(n == 0 ? 1 : (n == 1 ? 2 : (n == 2 ? 4 : (n == 3 ? 4 : (n == 5 ? 8 : 0)))))) {
            return false;
        }
        if (searchStringComponent.operandReplacement()) {
            try {
                ndsAttributeValue2 = (NdsAttributeValue)objectArray[searchStringComponent.getReplacementIndex()];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                InvalidSearchFilterException invalidSearchFilterException = new InvalidSearchFilterException();
                invalidSearchFilterException.setRootCause(arrayIndexOutOfBoundsException);
                throw invalidSearchFilterException;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
        try {
            new LdapAttributeValueFactory();
            ndsAttributeValue2 = LdapAttributeValueFactory.createValue(ndsAttributeValue.getNdsSyntaxId(), searchStringComponent.getOperand());
        }
        catch (Exception exception) {
            return false;
        }
        try {
            switch (n) {
                case 0: 
                case 5: {
                    bl = ndsAttributeValue.equals(ndsAttributeValue2);
                    break;
                }
                case 1: {
                    bl = ndsAttributeValue.approximate(ndsAttributeValue2);
                    break;
                }
                case 2: {
                    bl = ndsAttributeValue.compareTo(ndsAttributeValue2) >= 0;
                    break;
                }
                case 3: {
                    bl = ndsAttributeValue.compareTo(ndsAttributeValue2) <= 0;
                    break;
                }
                case 4: {
                    bl = true;
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return bl;
    }

    protected Object getInstance() throws NamingException {
        return new NetPartitionRootContext(new CompositeName(), this.netEnv);
    }
}

