/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming.net;

import com.novell.java.lang.IntegerBuffer;
import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetService;
import com.novell.service.nds.NdsDistinguishedName;
import com.novell.service.nds.NdsObjectInfo;
import com.novell.service.nds.naming.NdsName;
import com.novell.service.nds.naming.net.NetDirContext;
import com.novell.service.nds.naming.net.NetEnvironment;
import com.novell.service.session.Session;
import com.novell.service.session.SessionAttrs;
import com.novell.service.session.SessionEnumerator;
import com.novell.service.session.SessionEnv;
import com.novell.service.session.SessionException;
import com.novell.service.session.SessionManager;
import com.novell.service.session.SessionManagerFactory;
import com.novell.utility.naming.spi.ReferenceFactory;
import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.spi.NamingManager;

public class NetQueueDirContext
extends NetDirContext {
    private Object nnsp;

    protected NetQueueDirContext(String string, NdsObjectInfo ndsObjectInfo, NetEnvironment netEnvironment) throws NamingException {
        super(string, ndsObjectInfo, netEnvironment);
    }

    private String getServerName() throws NamingException {
        NdsName ndsName = ((NdsName)this.nameParser.parse(this.getHostServer())).getTypelessName();
        return ndsName.get(ndsName.size() - 1);
    }

    private String getHostServer() throws NamingException {
        String[] stringArray = new String[]{"Host Server"};
        Attributes attributes = this.getAttributes("", stringArray);
        Attribute attribute = attributes.get("Host Server");
        NdsDistinguishedName ndsDistinguishedName = (NdsDistinguishedName)attribute.getAll().nextElement();
        return ndsDistinguishedName.getDistinguishedName();
    }

    private Session getHostServerSession() throws NamingException, SessionException {
        SessionManager sessionManager = this.environment.getSessionManager();
        Session session = sessionManager.findSession(this.getTreeName());
        return session.getSession(this.getHostServer());
    }

    public NetService getService(String string) throws NamingException {
        NetService netService = null;
        try {
            Session session = this.getSession(string);
            netService = (NetService)session.getService("com.novell.service.jncpv2.net.BasicNetService.1039844522");
        }
        catch (SessionException sessionException) {
            AuthenticationException authenticationException = new AuthenticationException();
            authenticationException.setRootCause(sessionException);
            throw authenticationException;
        }
        return netService;
    }

    public Session getSession(String string) throws NamingException {
        SessionEnv sessionEnv = new SessionEnv();
        Session session = null;
        try {
            sessionEnv.put("com.novell.service.session.spi.InitialSessionFactory", "com.novell.service.session.nds.NDSInitialSessionFactory:com.novell.service.session.bindery.BinderyInitialSessionFactory");
            SessionManager sessionManager = SessionManagerFactory.getSessionManager(sessionEnv);
            SessionAttrs sessionAttrs = new SessionAttrs();
            sessionAttrs.add("DOMAIN_NAME", "com.novell.service.session.nds.NDSInitialSession");
            sessionAttrs.add("SESSION_TYPE", "INITIAL_SESSION");
            SessionEnumerator sessionEnumerator = sessionManager.search(sessionAttrs);
            if (!sessionEnumerator.hasMoreElements()) {
                throw new NSIException();
            }
            Session session2 = sessionEnumerator.next();
            session = session2.getSession(string);
        }
        catch (SessionException sessionException) {
            AuthenticationException authenticationException = new AuthenticationException();
            authenticationException.setRootCause(sessionException);
            throw authenticationException;
        }
        return session;
    }

    String getResourceID() throws NamingException {
        NetService netService = this.getService(this.getServerName());
        IntegerBuffer integerBuffer = new IntegerBuffer(0);
        try {
            netService.mapNameToID(this.distinguishedName, integerBuffer);
        }
        catch (SessionException sessionException) {
            AuthenticationException authenticationException = new AuthenticationException();
            authenticationException.setRootCause(sessionException);
            throw authenticationException;
        }
        return integerBuffer.toString();
    }

    protected Object getNNSP() throws NamingException {
        block2: {
            if (this.nnsp != null) break block2;
            try {
                Session session = this.getHostServerSession();
                Class<?> clazz = Class.forName("com.novell.service.qms.naming.ReferenceFactoryImpl");
                ReferenceFactory referenceFactory = (ReferenceFactory)clazz.newInstance();
                Hashtable hashtable = this.environment.getEnvironment();
                hashtable.put("java.naming.provider.url", this.getServerName());
                hashtable.put("com.novell.service.qms.naming.queueID", this.getResourceID());
                hashtable.put("java.naming.session", session);
                Reference reference = referenceFactory.createReference(hashtable);
                this.nnsp = NamingManager.getObjectInstance(reference, null, null, hashtable);
            }
            catch (Exception exception) {}
        }
        return this.nnsp;
    }
}

