/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming.net;

import com.novell.service.jncp.NSIException;
import com.novell.service.nds.NdsReplicaPointer;
import com.novell.service.nds.naming.NdsNamingExceptionFactory;
import com.novell.service.nds.naming.net.NetAttributeValueEnumerator;
import com.novell.service.nds.naming.net.NetEnvironment;
import com.novell.service.nds.naming.net.NetReplicaDirContext;
import com.novell.service.nds.net.NetAttributeValueFactory;
import java.util.NoSuchElementException;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public final class NetReplicaBindingEnumerator
implements NamingEnumeration {
    protected NetAttributeValueEnumerator replicaRing;
    private NetEnvironment netEnv;
    private String partnName;
    private static NdsNamingExceptionFactory exceptionFactory = new NdsNamingExceptionFactory();

    public NetReplicaBindingEnumerator(NetEnvironment netEnvironment, String string) throws NamingException {
        try {
            this.replicaRing = new NetAttributeValueEnumerator(netEnvironment.getService(), string, "Replica");
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
        this.partnName = string;
        this.netEnv = netEnvironment;
    }

    public boolean hasMoreElements() {
        return this.replicaRing.hasMoreElements();
    }

    public Object nextElement() throws NoSuchElementException {
        NdsReplicaPointer ndsReplicaPointer = null;
        try {
            ndsReplicaPointer = (NdsReplicaPointer)NetAttributeValueFactory.createValue(16, (byte[])this.replicaRing.nextElement(), null, null, this.partnName, "Replica");
        }
        catch (NSIException nSIException) {
            throw new NoSuchElementException(nSIException.getMessage());
        }
        Binding binding = null;
        try {
            binding = new Binding(ndsReplicaPointer.getServerName(), new NetReplicaDirContext(ndsReplicaPointer.getServerName(), this.partnName, this.netEnv));
        }
        catch (NamingException namingException) {
            throw new NoSuchElementException(namingException.getMessage());
        }
        return binding;
    }

    public boolean hasMore() {
        return this.hasMoreElements();
    }

    public Object next() throws NamingException {
        return this.nextElement();
    }

    public void close() throws NamingException {
        this.replicaRing.closeIteration();
    }
}

