/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming.net;

import com.novell.java.lang.IntegerBuffer;
import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetBuffer;
import com.novell.service.jncpv2.net.NetIterationHandle;
import com.novell.service.jncpv2.net.NetPartitionExtInfo;
import com.novell.service.jncpv2.net.NetService;
import com.novell.service.nds.NdsTimestamp;
import com.novell.service.nds.naming.net.NetReplicaInfo;
import com.novell.service.session.SessionException;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class NetReplicaInfoEnumerator
implements Enumeration {
    private String serverName;
    private StringBuffer serverRead;
    private NetService service;
    private NetIterationHandle iterationHandle;
    private IntegerBuffer partCount;
    private NetBuffer partInfo;
    private boolean moreInfo;
    private boolean extInfo;

    protected NetReplicaInfoEnumerator(NetService netService, String string) throws NSIException {
        this.service = netService;
        this.serverName = string;
        this.iterationHandle = new NetIterationHandle(netService, 3);
        this.partInfo = new NetBuffer(netService);
        this.partCount = new IntegerBuffer(0);
        this.moreInfo = true;
        IntegerBuffer integerBuffer = new IntegerBuffer(0);
        IntegerBuffer integerBuffer2 = new IntegerBuffer(0);
        IntegerBuffer integerBuffer3 = new IntegerBuffer(0);
        IntegerBuffer integerBuffer4 = new IntegerBuffer(0);
        try {
            netService.getNWNetVersion(integerBuffer, integerBuffer2, integerBuffer3, integerBuffer4);
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
        this.extInfo = integerBuffer.intValue() >= 5 && integerBuffer2.intValue() >= 2;
    }

    private void getPartInfo() throws NSIException {
        if (!this.moreInfo) {
            return;
        }
        try {
            if (this.extInfo) {
                int n = 460;
                this.service.listPartitionsExtInfo(this.iterationHandle, this.serverName, n, this.partInfo.getHandle());
            } else {
                this.service.listPartitions(this.iterationHandle, this.serverName, this.partInfo.getHandle());
            }
            this.serverRead = new StringBuffer();
            this.service.getServerName(this.partInfo.getHandle(), this.serverRead, this.partCount);
            this.moreInfo = this.iterationHandle.moreIterations();
            return;
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public boolean hasMoreElements() {
        try {
            if (this.partCount.intValue() == 0) {
                this.getPartInfo();
            }
        }
        catch (NSIException nSIException) {
            this.partCount.setValue(0);
        }
        return this.partCount.intValue() != 0;
    }

    public Object nextElement() throws NoSuchElementException {
        try {
            if (this.partCount.intValue() == 0) {
                this.getPartInfo();
            }
        }
        catch (NSIException nSIException) {
            throw new NoSuchElementException(nSIException.getMessage());
        }
        if (this.partCount.intValue() == 0) {
            throw new NoSuchElementException();
        }
        IntegerBuffer integerBuffer = null;
        IntegerBuffer integerBuffer2 = null;
        StringBuffer stringBuffer = null;
        IntegerBuffer integerBuffer3 = null;
        NdsTimestamp ndsTimestamp = null;
        try {
            if (this.extInfo) {
                IntegerBuffer integerBuffer4 = new IntegerBuffer(0);
                IntegerBuffer integerBuffer5 = new IntegerBuffer(0);
                this.service.getPartitionExtInfoPtr(this.partInfo.getHandle(), integerBuffer4, integerBuffer5);
                NetPartitionExtInfo netPartitionExtInfo = new NetPartitionExtInfo();
                this.service.getPartitionExtInfo(integerBuffer4.intValue(), integerBuffer5.intValue(), 64, null, netPartitionExtInfo);
                stringBuffer = new StringBuffer((String)netPartitionExtInfo.getValue());
                this.service.getPartitionExtInfo(integerBuffer4.intValue(), integerBuffer5.intValue(), 128, null, netPartitionExtInfo);
                integerBuffer = (IntegerBuffer)netPartitionExtInfo.getValue();
                this.service.getPartitionExtInfo(integerBuffer4.intValue(), integerBuffer5.intValue(), 4, null, netPartitionExtInfo);
                integerBuffer2 = (IntegerBuffer)netPartitionExtInfo.getValue();
                this.service.getPartitionExtInfo(integerBuffer4.intValue(), integerBuffer5.intValue(), 256, null, netPartitionExtInfo);
                integerBuffer3 = (IntegerBuffer)netPartitionExtInfo.getValue();
                this.service.getPartitionExtInfo(integerBuffer4.intValue(), integerBuffer5.intValue(), 8, null, netPartitionExtInfo);
                ndsTimestamp = (NdsTimestamp)netPartitionExtInfo.getValue();
            } else {
                integerBuffer = new IntegerBuffer(0);
                stringBuffer = new StringBuffer();
                this.service.getPartitionInfo(this.partInfo.getHandle(), stringBuffer, integerBuffer);
                integerBuffer2 = new IntegerBuffer((integerBuffer.intValue() & 0xFFFF0000) >> 16);
                integerBuffer.setValue(integerBuffer.intValue() & 0xFFFF);
                integerBuffer3 = new IntegerBuffer(0);
                ndsTimestamp = new NdsTimestamp(0L, 0, 0);
            }
            this.partCount.setValue(this.partCount.intValue() - 1);
            return new NetReplicaInfo(this.serverName, this.serverRead.toString(), integerBuffer.intValue(), integerBuffer2.intValue(), stringBuffer.toString(), integerBuffer3.intValue() != 0, ndsTimestamp);
        }
        catch (NSIException nSIException) {
            throw new NoSuchElementException(nSIException.getMessage());
        }
        catch (SessionException sessionException) {
            throw new NoSuchElementException(sessionException.getMessage());
        }
    }
}

