/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming.net;

import com.novell.java.io.EndianInputStream;
import java.io.IOException;

public class NetReplicaSyncInfo {
    protected int statusFlags;
    protected int lastSyncTime;
    protected int replicaNumber;
    protected int errorCode;
    protected String serverName;
    protected String entryName;
    protected int lastAttemptedSyncTime;

    public NetReplicaSyncInfo(byte[] byArray) throws IOException {
        EndianInputStream endianInputStream = new EndianInputStream(byArray);
        int n = endianInputStream.readLoHiInt();
        endianInputStream.readLoHiInt();
        this.statusFlags = endianInputStream.readLoHiInt();
        this.lastSyncTime = endianInputStream.readLoHiInt();
        this.replicaNumber = endianInputStream.readLoHiInt();
        this.errorCode = endianInputStream.readLoHiInt();
        n = endianInputStream.readLoHiInt();
        if (n > 0) {
            this.serverName = endianInputStream.readLoHiChars();
        }
        endianInputStream.align32();
        n = endianInputStream.readLoHiInt();
        if (n > 0) {
            this.entryName = endianInputStream.readLoHiChars();
        }
        endianInputStream.align32();
        this.lastAttemptedSyncTime = this.lastSyncTime;
    }

    public int getStatusFlags() {
        return this.statusFlags;
    }

    public int getLastSyncTime() {
        return this.lastSyncTime;
    }

    public int getReplicaNumber() {
        return this.replicaNumber;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public int getLastAttemptedSyncTime() {
        return this.lastAttemptedSyncTime;
    }

    public void setLastSyncTime(int n) {
        this.lastSyncTime = n;
    }

    public void setReplicaNumber(int n) {
        this.replicaNumber = n;
    }
}

