/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming.net;

import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetBuffer;
import com.novell.service.jncpv2.net.NetIterationHandle;
import com.novell.service.jncpv2.net.NetService;
import com.novell.service.nds.NdsAttributeValue;
import com.novell.service.nds.NdsClassName;
import com.novell.service.nds.NdsDistinguishedName;
import com.novell.service.nds.NdsInteger;
import com.novell.service.nds.ldap.LdapAttributeValueFactory;
import com.novell.service.nds.naming.NdsNamingEnumeratorWrappable;
import com.novell.service.nds.naming.NdsNamingExceptionFactory;
import com.novell.service.nds.naming.net.NetContextFactory;
import com.novell.service.nds.naming.net.NetEnvironment;
import com.novell.service.nds.naming.net.NetFilter;
import com.novell.service.nds.naming.net.SearchObject;
import com.novell.service.nds.net.NetAttributeValue;
import com.novell.service.nds.net.NetAttributeValueFactory;
import com.novell.service.session.SessionException;
import com.novell.service.toolkit.jcl.NWInteger;
import com.novell.utility.naming.spi.ContextFactory;
import java.io.StreamTokenizer;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.InvalidSearchFilterException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

class NetSearchEnumerator
implements NamingEnumeration,
NdsNamingEnumeratorWrappable {
    private String objectName;
    private NetEnvironment environment;
    private NetService service;
    private DirContext schemaContext;
    private NetBuffer objectInfo;
    private NetBuffer filterBuffer;
    private NetBuffer attrNames;
    private NetFilter ndsFilter;
    private Object[] filterArgs;
    private NetIterationHandle iterationHandle;
    private int scope = 1;
    private boolean retObj = false;
    private boolean searchAliases = true;
    private boolean allAttrs;
    private int countObjectsToSearch;
    private NWInteger countObjectsSearched;
    private int entriesLeft;
    private int parmIdx;
    private StreamTokenizer rfc;
    private StringTokenizer st;
    private ContextFactory factory = new NetContextFactory();
    private static NdsNamingExceptionFactory exceptionFactory = new NdsNamingExceptionFactory();
    private long countLimit;
    private boolean sized;
    private int objectCount;
    private SearchObject nextSearchObject;

    public NetSearchEnumerator(String string, NetEnvironment netEnvironment, Attributes attributes, String[] stringArray) throws NamingException {
        this.objectName = string;
        this.environment = (NetEnvironment)netEnvironment.clone();
        this.service = netEnvironment.getService();
        try {
            int n;
            this.iterationHandle = new NetIterationHandle(this.service, 6);
            this.countObjectsSearched = new NWInteger();
            this.objectInfo = new NetBuffer(this.service, netEnvironment.getBatchSize());
            this.filterBuffer = new NetBuffer(this.service, 28, netEnvironment.getBatchSize());
            this.ndsFilter = new NetFilter(this.service);
            if (stringArray == null) {
                this.allAttrs = true;
            } else if (stringArray.length == 0) {
                this.allAttrs = false;
            } else {
                this.allAttrs = false;
                this.attrNames = new NetBuffer(this.service, 6, netEnvironment.getBatchSize());
                n = 0;
                while (n < stringArray.length) {
                    this.attrNames.putAttributeName(stringArray[n]);
                    ++n;
                }
            }
            if (attributes != null && attributes.size() > 0) {
                n = 1;
                NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
                while (namingEnumeration.hasMoreElements()) {
                    Attribute attribute = namingEnumeration.next();
                    if (attribute.size() > 0) {
                        boolean bl = true;
                        if (n == 0) {
                            this.ndsFilter.addFilterToken(2);
                        }
                        NamingEnumeration<?> namingEnumeration2 = attribute.getAll();
                        while (namingEnumeration2.hasMoreElements()) {
                            NdsAttributeValue ndsAttributeValue = (NdsAttributeValue)namingEnumeration2.nextElement();
                            NetAttributeValue netAttributeValue = ndsAttributeValue instanceof NetAttributeValue ? (NetAttributeValue)ndsAttributeValue : NetAttributeValueFactory.createValue(ndsAttributeValue);
                            if (!bl) {
                                this.ndsFilter.addFilterToken(2);
                            }
                            this.ndsFilter.addFilterToken(14, attribute.getID(), netAttributeValue.getNdsSyntaxId());
                            this.ndsFilter.addFilterToken(7);
                            this.ndsFilter.addFilterToken(6, netAttributeValue.toByte(), netAttributeValue.getNdsSyntaxId());
                            bl = false;
                        }
                        n = 0;
                        continue;
                    }
                    throw new InvalidAttributeValueException();
                }
            } else {
                this.ndsFilter.addFilterToken(17);
                this.ndsFilter.addFilterToken(14, "*", 20);
            }
            this.ndsFilter.addFilterToken(0);
            this.ndsFilter.putFilter(this.filterBuffer);
            this.nextSearchObject = this.getFirstSearchObject();
            return;
        }
        catch (Exception exception) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(exception);
            throw namingException;
        }
    }

    public NetSearchEnumerator(String string, DirContext dirContext, NetEnvironment netEnvironment, String string2, Object[] objectArray, SearchControls searchControls) throws NamingException {
        this.objectName = string;
        this.environment = (NetEnvironment)netEnvironment.clone();
        this.service = netEnvironment.getService();
        this.schemaContext = dirContext;
        if (searchControls == null) {
            searchControls = new SearchControls();
        }
        try {
            this.iterationHandle = new NetIterationHandle(this.service, 6);
            this.countObjectsSearched = new NWInteger();
            this.filterArgs = objectArray;
            this.objectInfo = new NetBuffer(this.service, netEnvironment.getBatchSize());
            this.countLimit = searchControls.getCountLimit();
            this.sized = this.countLimit != 0L;
            this.searchAliases = searchControls.getDerefLinkFlag();
            String[] stringArray = searchControls.getReturningAttributes();
            if (stringArray == null) {
                this.allAttrs = true;
            } else if (stringArray.length == 0) {
                this.allAttrs = false;
            } else {
                this.allAttrs = false;
                this.attrNames = new NetBuffer(this.service, 6, netEnvironment.getBatchSize());
                int n = 0;
                while (n < stringArray.length) {
                    this.attrNames.putAttributeName(stringArray[n]);
                    ++n;
                }
            }
            this.scope = searchControls.getSearchScope();
            this.scope = this.scope == 0 ? 0 : (this.scope == 1 ? 1 : (this.scope == 2 ? 2 : this.scope));
            this.retObj = searchControls.getReturningObjFlag();
            if (string2.charAt(0) != '(') {
                string2 = "(" + string2 + ")";
            }
            this.st = new StringTokenizer(string2, "()=", true);
            this.filterBuffer = new NetBuffer(this.service, 28, netEnvironment.getBatchSize());
            this.ndsFilter = new NetFilter(this.service);
            this.parseFilter();
            this.ndsFilter.addFilterToken(0);
            this.ndsFilter.putFilter(this.filterBuffer);
            this.nextSearchObject = this.getFirstSearchObject();
            return;
        }
        catch (Exception exception) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(exception);
            throw namingException;
        }
    }

    private void parseFilter() throws InvalidSearchFilterException, NamingException {
        if (!this.st.nextToken().equals("(")) {
            throw new InvalidSearchFilterException();
        }
        this.parseFilterComp();
    }

    private void parseFilterComp() throws InvalidSearchFilterException, NamingException {
        try {
            String string = this.st.nextToken().trim();
            int n = -1;
            if (string.equals("&")) {
                this.parseFilterList(2);
                return;
            }
            if (string.equals("|")) {
                this.parseFilterList(1);
                return;
            }
            if (string.equals("!")) {
                this.ndsFilter.addFilterToken(3);
                this.parseFilter();
                if (!this.st.nextToken().equals(")")) {
                    throw new InvalidSearchFilterException();
                }
            } else {
                int n2;
                Object object;
                Object object2;
                Object object3;
                if (string.equalsIgnoreCase("name")) {
                    n = 1;
                } else if (string.equalsIgnoreCase("baseclass")) {
                    n = 20;
                } else {
                    object3 = this.schemaContext.getAttributes(String.valueOf(string) + ".SC=Attributes");
                    Attribute attribute = object3.get("Syntax ID");
                    object2 = attribute.getAll();
                    object = (NdsInteger)object2.nextElement();
                    n = ((NdsInteger)object).intValue();
                }
                object3 = this.st.nextToken("><~=()").trim();
                object2 = null;
                if (((String)object3).equals(">")) {
                    if (!this.st.nextToken().equals("=")) {
                        throw new InvalidSearchFilterException();
                    }
                    n2 = 8;
                    object2 = this.parseRfc1778Value(n, this.st.nextToken().trim());
                } else if (((String)object3).equals("<")) {
                    if (!this.st.nextToken().equals("=")) {
                        throw new InvalidSearchFilterException();
                    }
                    n2 = 9;
                    object2 = this.parseRfc1778Value(n, this.st.nextToken().trim());
                } else if (((String)object3).equals("~")) {
                    if (!this.st.nextToken().equals("=")) {
                        throw new InvalidSearchFilterException();
                    }
                    n2 = 10;
                    object2 = this.parseRfc1778Value(n, this.st.nextToken().trim());
                } else if (((String)object3).equals("=")) {
                    object = this.st.nextToken().trim();
                    if (((String)object).equals("*")) {
                        n2 = 15;
                    } else {
                        n2 = 7;
                        object2 = this.parseRfc1778Value(n, (String)object);
                    }
                } else {
                    throw new InvalidSearchFilterException();
                }
                if (!this.st.nextToken().equals(")")) {
                    throw new InvalidSearchFilterException();
                }
                if (string.equalsIgnoreCase("name")) {
                    this.ndsFilter.addFilterToken(16);
                    if (n2 == 15) {
                        this.ndsFilter.addFilterToken(14, "*", n);
                        return;
                    }
                    this.ndsFilter.addFilterToken(14, ((NdsDistinguishedName)object2).getDistinguishedName(), n);
                    return;
                }
                if (string.equalsIgnoreCase("baseclass")) {
                    this.ndsFilter.addFilterToken(17);
                    if (n2 == 15) {
                        this.ndsFilter.addFilterToken(14, "*", n);
                        return;
                    }
                    this.ndsFilter.addFilterToken(14, ((NdsClassName)object2).getClassName(), n);
                    return;
                }
                if (n2 == 15) {
                    this.ndsFilter.addFilterToken(15);
                    this.ndsFilter.addFilterToken(14, string, n);
                    return;
                }
                this.ndsFilter.addFilterToken(14, string, n);
                this.ndsFilter.addFilterToken(n2);
                this.ndsFilter.addFilterToken(6, object2.toByte(), n);
            }
            return;
        }
        catch (Exception exception) {
            try {
                this.ndsFilter.addFilterToken(3);
                this.ndsFilter.addFilterToken(15);
                this.ndsFilter.addFilterToken(14, "Object Class", 20);
                return;
            }
            catch (Exception exception2) {
                throw new NamingException();
            }
        }
    }

    private void parseFilterList(int n) throws InvalidSearchFilterException, NamingException {
        boolean bl = false;
        try {
            this.ndsFilter.addFilterToken(4);
            while (this.st.nextToken().trim().equals("(")) {
                if (bl) {
                    this.ndsFilter.addFilterToken(n);
                }
                this.parseFilterComp();
                bl = true;
            }
            this.ndsFilter.addFilterToken(5);
            return;
        }
        catch (Exception exception) {
            throw new NamingException();
        }
    }

    private static int hexchar2int(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String unescapeFilterValue(String string) throws NamingException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        char c = '\u0000';
        int n = 0;
        while (n < string.length()) {
            char c2 = string.charAt(n);
            if (bl) {
                int n2 = NetSearchEnumerator.hexchar2int(c2);
                if (n2 < 0) {
                    if (!bl2) throw new InvalidSearchFilterException("invalid escape sequence: " + string);
                    bl = false;
                    stringBuffer.append(c2);
                } else if (bl2) {
                    c = (char)(n2 << 4);
                    bl2 = false;
                } else {
                    c = (char)(c | (char)n2);
                    stringBuffer.append(c);
                    bl = false;
                }
            } else if (c2 != '\\') {
                stringBuffer.append(c2);
                bl = false;
            } else {
                bl = true;
                bl2 = true;
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private NetAttributeValue parseRfc1778Value(int n, String string) throws InvalidSearchFilterException, NamingException {
        NdsAttributeValue ndsAttributeValue = null;
        NetAttributeValue netAttributeValue = null;
        try {
            if (string.charAt(0) == '{') {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "{}");
                String string2 = stringTokenizer.nextToken();
                try {
                    int n2 = Integer.parseInt(string2);
                    ndsAttributeValue = (NdsAttributeValue)this.filterArgs[n2];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    InvalidSearchFilterException invalidSearchFilterException = new InvalidSearchFilterException();
                    invalidSearchFilterException.setRootCause(arrayIndexOutOfBoundsException);
                    throw invalidSearchFilterException;
                }
                catch (NumberFormatException numberFormatException) {
                    InvalidSearchFilterException invalidSearchFilterException = new InvalidSearchFilterException();
                    invalidSearchFilterException.setRootCause(numberFormatException);
                    throw invalidSearchFilterException;
                }
            } else {
                String string3 = this.unescapeFilterValue(string);
                ndsAttributeValue = LdapAttributeValueFactory.createValue(n, string3);
            }
            netAttributeValue = ndsAttributeValue instanceof NetAttributeValue ? (NetAttributeValue)ndsAttributeValue : NetAttributeValueFactory.createValue(ndsAttributeValue);
        }
        catch (Exception exception) {
            throw new NamingException();
        }
        return netAttributeValue;
    }

    public boolean hasMoreElements() {
        if (this.sized && this.countLimit <= 0L) {
            return false;
        }
        return this.nextSearchObject != null;
    }

    public boolean hasMore() throws NamingException {
        return this.hasMoreElements();
    }

    private int updateObjectInfo() throws NSIException {
        try {
            int n;
            do {
                this.service.search(this.objectName, this.scope, this.searchAliases, this.filterBuffer.getHandle(), 1, this.allAttrs, this.attrNames != null ? this.attrNames.getHandle() : 0, this.iterationHandle, this.countObjectsToSearch, this.countObjectsSearched, this.objectInfo.getHandle());
            } while ((n = this.objectInfo.getObjectCount()) == 0 && this.iterationHandle.moreIterations());
            return n;
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    private SearchObject getFirstSearchObject() throws NamingException, NSIException {
        this.objectCount = this.updateObjectInfo();
        if (this.objectCount == 0) {
            return null;
        }
        --this.objectCount;
        return new SearchObject(this.objectInfo, this.environment);
    }

    private SearchObject getNextSearchObject() throws NamingException, NSIException {
        while (this.objectCount == 0) {
            if (!this.iterationHandle.moreIterations()) {
                return null;
            }
            this.objectCount = this.updateObjectInfo();
        }
        --this.objectCount;
        return new SearchObject(this.objectInfo, this.environment);
    }

    public Object nextElement() {
        return this.next();
    }

    public Object next() {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        try {
            Context context = null;
            SearchObject searchObject = this.nextSearchObject;
            this.nextSearchObject = this.getNextSearchObject();
            while (searchObject.equalsApproximate(this.nextSearchObject)) {
                Attributes attributes = this.nextSearchObject.getAttributes();
                searchObject.mergeAttributes(attributes);
                this.nextSearchObject = this.getNextSearchObject();
            }
            if (this.retObj) {
                context = this.factory.getContextInstance(searchObject.getName(), searchObject.getNdsObjectInfo(), this.environment);
            }
            if (this.sized) {
                --this.countLimit;
            }
            return new SearchResult(searchObject.getName(), searchObject.getNdsObjectInfo().getBaseClass(), context, searchObject.getAttributes(), false);
        }
        catch (NSIException nSIException) {
            throw new NoSuchElementException();
        }
        catch (NamingException namingException) {
            throw new NoSuchElementException();
        }
    }

    public void close() throws NamingException {
        try {
            this.iterationHandle.closeIteration();
            return;
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
    }
}

