/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming.net;

import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetService;
import com.novell.service.nds.NdsNCPServer;
import com.novell.service.nds.NdsObjectInfo;
import com.novell.service.nds.naming.NdsName;
import com.novell.service.nds.naming.net.NetDirContext;
import com.novell.service.nds.naming.net.NetEnvironment;
import com.novell.service.nds.naming.net.NetReplicaEnumerator;
import com.novell.service.session.Session;
import com.novell.service.session.SessionException;
import com.novell.service.session.SessionManager;
import com.novell.utility.naming.spi.ReferenceFactory;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;

public class NetServerDirContext
extends NetDirContext
implements NdsNCPServer {
    protected Object nnsp;

    protected NetServerDirContext(String string, NdsObjectInfo ndsObjectInfo, NetEnvironment netEnvironment) throws NamingException {
        super(string, ndsObjectInfo, netEnvironment);
    }

    public void reloadDS() throws NSIException {
        try {
            this.getServerService().reloadDS(this.distinguishedName);
            return;
        }
        catch (NamingException namingException) {
            throw new NSIException();
        }
        catch (SessionException sessionException) {
            throw new NSIException();
        }
    }

    public Enumeration listPartitions() throws NSIException {
        return new NetReplicaEnumerator(this.distinguishedName, this.environment);
    }

    public Date getUTCTime() throws NSIException {
        try {
            Date date = new Date();
            int n = this.getServerService().getFileServerUTCTime();
            date.setTime((long)n * 1000L);
            return date;
        }
        catch (NamingException namingException) {
            throw new NSIException();
        }
        catch (SessionException sessionException) {
            throw new NSIException();
        }
    }

    protected Object getNNSP() throws NamingException {
        block2: {
            if (this.nnsp != null) break block2;
            try {
                Session session = this.getServerSession();
                Class<?> clazz = Class.forName("com.novell.service.server.ReferenceFactoryImpl");
                ReferenceFactory referenceFactory = (ReferenceFactory)clazz.newInstance();
                Hashtable hashtable = this.environment.getEnvironment();
                hashtable.put("java.naming.provider.url", this.getServerName());
                hashtable.put("java.naming.session", session);
                Reference reference = referenceFactory.createReference(hashtable);
                this.nnsp = NamingManager.getObjectInstance(reference, null, null, hashtable);
            }
            catch (Exception exception) {}
        }
        return this.nnsp;
    }

    private String getServerName() throws NamingException {
        NdsName ndsName = (NdsName)this.nameParser.parse(this.distinguishedName);
        return ndsName.getTypelessName().get(ndsName.size() - 1);
    }

    private NetService getServerService() throws NamingException, SessionException {
        Session session = this.getServerSession();
        return (NetService)session.getService("com.novell.service.jncpv2.net.BasicNetService.1039844522");
    }

    private Session getServerSession() throws NamingException, SessionException {
        SessionManager sessionManager = this.environment.getSessionManager();
        Session session = sessionManager.findSession(this.getTreeName());
        return session.getSession(this.distinguishedName);
    }
}

