/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming.net;

import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetService;
import com.novell.service.nds.naming.NdsNamingExceptionFactory;
import com.novell.service.nds.naming.NdsPartitionNameParser;
import com.novell.service.nds.naming.net.NetEnvironment;
import com.novell.service.nds.naming.net.NetReplicaNameClassEnumerator;
import com.novell.service.session.SessionException;
import com.novell.utility.naming.Environment;
import com.novell.utility.naming.spi.ContextFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;

public final class PartitionContextFactory
implements ContextFactory {
    private static NameParser parser;
    private static Properties netContexts;
    private static NdsNamingExceptionFactory exceptionFactory;

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        NetEnvironment netEnvironment = new NetEnvironment(hashtable);
        if (object instanceof String) {
            return this.getContextInstance((String)object, netEnvironment);
        }
        if (object instanceof CompoundName) {
            return this.getContextInstance(object.toString(), netEnvironment);
        }
        return null;
    }

    public Context getContextInstance(String string, Environment environment) throws NamingException {
        NetEnvironment netEnvironment = this.getEnvironmentInstance(environment);
        String string2 = this.getBaseClass(string, netEnvironment);
        return this.getContextInstance(string, string2, netEnvironment);
    }

    public Context getContextInstance(String string, Object object, Environment environment) throws NamingException {
        NetEnvironment netEnvironment = this.getEnvironmentInstance(environment);
        try {
            Class[] classArray = new Class[2];
            Object[] objectArray = new Object[2];
            Class<?> clazz = Class.forName(this.getClassName((String)object));
            classArray[0] = Class.forName("javax.naming.Name");
            classArray[1] = Class.forName("com.novell.service.nds.naming.net.NetEnvironment");
            Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
            objectArray[0] = parser.parse(string);
            objectArray[1] = netEnvironment;
            return (Context)constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(classNotFoundException);
            throw namingException;
        }
        catch (SecurityException securityException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(securityException);
            throw namingException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(noSuchMethodException);
            throw namingException;
        }
        catch (InstantiationException instantiationException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(instantiationException);
            throw namingException;
        }
        catch (IllegalAccessException illegalAccessException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(illegalAccessException);
            throw namingException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(illegalArgumentException);
            throw namingException;
        }
        catch (InvocationTargetException invocationTargetException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(invocationTargetException);
            throw namingException;
        }
    }

    public Context getContextInstance(Object object) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public String getClassName(Object object) {
        return netContexts.getProperty((String)object);
    }

    private String getBaseClass(String string, NetEnvironment netEnvironment) throws NamingException {
        Name name = parser.parse(string);
        switch (name.size()) {
            case 0: {
                return "Partition Root";
            }
            case 1: {
                if (this.partitionExists(string, netEnvironment.getService())) {
                    return "Partition";
                }
                throw new NameNotFoundException();
            }
            case 2: {
                if (this.replicaExists(name.get(1), name.get(0), netEnvironment)) {
                    return "Replica";
                }
                throw new NameNotFoundException();
            }
        }
        throw new NameNotFoundException();
    }

    private boolean partitionExists(String string, NetService netService) throws NamingException {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            netService.getPartitionRoot(string, stringBuffer);
            return string.equalsIgnoreCase(new String(stringBuffer));
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
        catch (SessionException sessionException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(sessionException);
            throw namingException;
        }
    }

    private boolean replicaExists(String string, String string2, NetEnvironment netEnvironment) throws NamingException {
        NetReplicaNameClassEnumerator netReplicaNameClassEnumerator = null;
        netReplicaNameClassEnumerator = new NetReplicaNameClassEnumerator(netEnvironment, string2);
        while (netReplicaNameClassEnumerator.hasMore()) {
            NameClassPair nameClassPair = (NameClassPair)netReplicaNameClassEnumerator.next();
            if (!string.equals(nameClassPair.getName())) continue;
            return true;
        }
        return false;
    }

    private NetEnvironment getEnvironmentInstance(Environment environment) throws NamingException {
        if (environment instanceof NetEnvironment) {
            return (NetEnvironment)environment;
        }
        return new NetEnvironment(environment);
    }

    static {
        exceptionFactory = new NdsNamingExceptionFactory();
        parser = new NdsPartitionNameParser();
        netContexts = new Properties();
        ((Hashtable)netContexts).put("Partition Root", "com.novell.service.nds.naming.net.NetPartitionRootContext");
        ((Hashtable)netContexts).put("Partition", "com.novell.service.nds.naming.net.NetPartitionDirContext");
        ((Hashtable)netContexts).put("Replica", "com.novell.service.nds.naming.net.NetReplicaDirContext");
    }
}

