/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.qms;

import java.util.Date;
import java.util.GregorianCalendar;

public class NWQueueJob {
    private int clientStation = 0;
    private int clientTask = 0;
    private int clientID = 0;
    private int targetServerID = -1;
    private Date targetExecutionTime;
    private Date jobEntryTime = new Date();
    private int jobNumber = 0;
    private int jobType = 0;
    private int jobPosition = 0;
    private int jobControlFlags = 0;
    private byte[] jobFileName;
    private int jobFileHandle = 0;
    private int servicingServerStation = 0;
    private int servicingServerTask = 0;
    private int servicingServerID;
    private String jobDescription;
    private byte[] clientRecordArea;

    public NWQueueJob() {
        this.targetExecutionTime = new Date(this.jobEntryTime.getTime());
        this.jobFileName = new byte[14];
        this.jobDescription = new String();
        this.clientRecordArea = new byte[152];
    }

    public void setClientStation(int n) {
        this.clientStation = n;
    }

    public void setClientTask(int n) {
        this.clientTask = n;
    }

    public void setClientID(int n) {
        this.clientID = n;
    }

    public void setTargetServerID(int n) {
        this.targetServerID = n;
    }

    public void setTargetExecutionTime(byte[] byArray) {
        if (byArray[0] == -1 && byArray[1] == -1 && byArray[2] == -1 && byArray[3] == -1 && byArray[4] == -1 && byArray[5] == -1) {
            this.targetExecutionTime.setTime(this.jobEntryTime.getTime());
            return;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar((byArray[0] & 0xFF) + 1900, byArray[1] - 1, byArray[2], byArray[3], byArray[4], byArray[5]);
        this.targetExecutionTime = gregorianCalendar.getTime();
    }

    public void setTargetExecutionTime(Date date) {
        this.targetExecutionTime = date;
    }

    public void setJobEntryTime(byte[] byArray) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar((byArray[0] & 0xFF) + 1900, byArray[1] - 1, byArray[2], byArray[3], byArray[4], byArray[5]);
        this.jobEntryTime = gregorianCalendar.getTime();
    }

    public void setJobEntryTime(Date date) {
        this.jobEntryTime = date;
    }

    public void setJobNumber(int n) {
        this.jobNumber = n;
    }

    public void setJobType(int n) {
        this.jobType = n;
    }

    public void setJobPosition(int n) {
        this.jobPosition = n;
    }

    public void setJobControlFlags(int n) {
        this.jobControlFlags = n;
    }

    public void setJobFileName(byte[] byArray) {
        int n = byArray.length < this.jobFileName.length ? byArray.length : this.jobFileName.length;
        System.arraycopy(byArray, 0, this.jobFileName, 0, n);
    }

    public void setJobFileHandle(int n) {
        this.jobFileHandle = n;
    }

    public void setServicingServerStation(int n) {
        this.servicingServerStation = n;
    }

    public void setServicingServerTask(int n) {
        this.servicingServerTask = n;
    }

    public void setServicingServerID(int n) {
        this.servicingServerID = n;
    }

    public void setJobDescription(String string) {
        if (string.length() > 50) {
            this.jobDescription = string.substring(0, 50);
            return;
        }
        this.jobDescription = new String(string);
    }

    public void setClientRecordArea(byte[] byArray) {
        int n = byArray.length < this.clientRecordArea.length ? byArray.length : this.clientRecordArea.length;
        System.arraycopy(byArray, 0, this.clientRecordArea, 0, n);
    }

    public int getClientStation() {
        return this.clientStation;
    }

    public int getClientTask() {
        return this.clientTask;
    }

    public int getClientID() {
        return this.clientID;
    }

    public int getTargetServerID() {
        return this.targetServerID;
    }

    public byte[] getTargetExecutionTimeBytes() {
        byte[] byArray = new byte[]{-1, -1, -1, -1, -1, -1};
        if (!this.targetExecutionTime.equals(this.jobEntryTime)) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(this.targetExecutionTime);
            byArray[0] = (byte)(gregorianCalendar.get(1) - 1900);
            byArray[1] = (byte)(gregorianCalendar.get(2) + 1);
            byArray[2] = (byte)gregorianCalendar.get(5);
            byArray[3] = (byte)gregorianCalendar.get(11);
            byArray[4] = (byte)gregorianCalendar.get(12);
            byArray[5] = (byte)gregorianCalendar.get(13);
        }
        return byArray;
    }

    public Date getTargetExecutionTime() {
        return new Date(this.targetExecutionTime.getTime());
    }

    public byte[] getJobEntryTimeBytes() {
        byte[] byArray = new byte[]{-1, -1, -1, -1, -1, -1};
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(this.jobEntryTime);
        byArray[0] = (byte)(gregorianCalendar.get(1) - 1900);
        byArray[1] = (byte)(gregorianCalendar.get(2) + 1);
        byArray[2] = (byte)gregorianCalendar.get(5);
        byArray[3] = (byte)gregorianCalendar.get(11);
        byArray[4] = (byte)gregorianCalendar.get(12);
        byArray[5] = (byte)gregorianCalendar.get(13);
        return byArray;
    }

    public Date getJobEntryTime() {
        return new Date(this.jobEntryTime.getTime());
    }

    public int getJobNumber() {
        return this.jobNumber;
    }

    public int getJobType() {
        return this.jobType;
    }

    public int getJobPosition() {
        return this.jobPosition;
    }

    public int getJobControlFlags() {
        return this.jobControlFlags;
    }

    public byte[] getJobFileName() {
        byte[] byArray = new byte[this.jobFileName.length];
        System.arraycopy(this.jobFileName, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public int getJobFileHandle() {
        return this.jobFileHandle;
    }

    public int getServicingServerStation() {
        return this.servicingServerStation;
    }

    public int getServicingServerTask() {
        return this.servicingServerTask;
    }

    public int getServicingServerID() {
        return this.servicingServerID;
    }

    public String getJobDescription() {
        return new String(this.jobDescription);
    }

    public byte[] getClientRecordArea() {
        byte[] byArray = new byte[this.clientRecordArea.length];
        System.arraycopy(this.clientRecordArea, 0, byArray, 0, byArray.length);
        return byArray;
    }
}

