/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.security;

import com.novell.java.security.Identity;
import com.novell.java.security.IdentityScope;
import com.novell.java.security.KeyManagementException;
import com.novell.service.security.BinderyIdentityScope;
import com.novell.service.security.BinderyPasswordIdentity;
import com.novell.service.security.PasswordIdentity;
import com.novell.service.security.PasswordIdentityFactory;
import com.novell.service.security.XplatIdentity;

public class BinderyIdentity
extends XplatIdentity
implements PasswordIdentityFactory {
    private int connection;

    public BinderyIdentity(String string) {
        super(string);
    }

    public BinderyIdentity(String string, String string2) throws KeyManagementException {
        super(string, new BinderyIdentityScope(string2));
    }

    public BinderyIdentity(String string, IdentityScope identityScope) throws KeyManagementException {
        super(string, identityScope);
    }

    public BinderyIdentity(Identity identity) throws KeyManagementException {
        super(identity);
        if (identity instanceof BinderyIdentity) {
            this.setConnectionHandle(((BinderyIdentity)identity).getConnectionHandle());
        }
    }

    public String getAdministrativeDomain() {
        return BinderyIdentityScope.ADMINISTRATIVE_DOMAIN_NAME;
    }

    public String getUsername() {
        return BinderyIdentity.getUsername(this);
    }

    public String getUserDomain() {
        return BinderyIdentity.getUserDomain(this);
    }

    public void setConnectionHandle(int n) {
        this.connection = n;
    }

    public int getConnectionHandle() {
        return this.connection;
    }

    public PasswordIdentity getPasswordIdentityInstance() {
        try {
            return new BinderyPasswordIdentity(this);
        }
        catch (KeyManagementException keyManagementException) {
            return null;
        }
    }

    static String getUsername(Identity identity) {
        IdentityScope identityScope = identity.getScope();
        if (identityScope == null) {
            return "";
        }
        IdentityScope identityScope2 = identityScope.getScope();
        if (identityScope2 == null) {
            String string = identityScope.getName();
            if (string.equalsIgnoreCase(BinderyIdentityScope.ADMINISTRATIVE_DOMAIN_NAME)) {
                return "";
            }
            return identity.getName();
        }
        IdentityScope identityScope3 = identityScope2.getScope();
        if (identityScope3 == null) {
            String string = identityScope2.getName();
            if (identityScope.getName().length() == 0 || string.equalsIgnoreCase(BinderyIdentityScope.ADMINISTRATIVE_DOMAIN_NAME)) {
                return identity.getName();
            }
            return String.valueOf(identity.getName()) + "." + identityScope.getName();
        }
        return String.valueOf(identity.getName()) + "." + BinderyIdentity.getUsername(identityScope);
    }

    static String getUserDomain(Identity identity) {
        IdentityScope identityScope = identity.getScope();
        if (identityScope == null) {
            String string = identity.getName();
            if (string.equalsIgnoreCase(BinderyIdentityScope.ADMINISTRATIVE_DOMAIN_NAME)) {
                return "";
            }
            return string;
        }
        IdentityScope identityScope2 = identityScope.getScope();
        if (identityScope2 == null) {
            String string = identityScope.getName();
            if (string.equalsIgnoreCase(BinderyIdentityScope.ADMINISTRATIVE_DOMAIN_NAME)) {
                return identity.getName();
            }
            return string;
        }
        return BinderyIdentity.getUserDomain(identityScope);
    }
}

