/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.security.protocols;

import com.novell.java.security.Authenticator;
import com.novell.java.security.Identity;
import com.novell.java.security.LoginCancelledException;
import com.novell.java.security.LoginException;
import com.novell.service.jncp.NSIException;
import com.novell.service.security.BinderyIdentity;
import com.novell.service.security.BinderyIdentityScope;
import com.novell.service.security.NdsIdentity;
import com.novell.service.security.NdsIdentityScope;
import com.novell.service.security.XplatIdentity;
import com.novell.service.security.protocols.BasicUserInterface;
import com.novell.service.security.protocols.BinderyLoginPanel;
import com.novell.service.security.protocols.NdsLoginPanel;
import com.novell.service.security.protocols.XplatProtocolProxy;
import com.novell.service.security.protocols.nls.I2L;
import com.novell.service.session.AlreadyAuthenticatedException;
import com.novell.service.session.SessionException;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JFrame;

class LoginUserInterface
extends BasicUserInterface {
    public LoginUserInterface(Identity identity, JFrame jFrame) {
        super(identity, jFrame, I2L.getString("LOGIN_DIALOG_TITLE"));
    }

    void tabPanels(Identity identity) {
        if (identity instanceof NdsIdentity) {
            this.tabPane.addTab(I2L.getString("NDS_NAME"), null, new NdsLoginPanel(identity, this));
            this.helpId = "loginnds";
            return;
        }
        if (identity instanceof BinderyIdentity) {
            this.tabPane.addTab(I2L.getString("BINDERY_NAME"), null, new BinderyLoginPanel(identity, this));
            this.helpId = "loginbindery";
        }
    }

    void okayPressed() {
        this.removeDialog = true;
        try {
            try {
                XplatProtocolProxy.performLogin(this.identity, this.getName(), this.getDomain(), this.getPassword(), this.currentThread);
            }
            catch (NSIException nSIException) {
                int n = nSIException.getCCode();
                switch (n) {
                    case 34960: 
                    case 35327: {
                        this.alreadyAuthenticated();
                        break;
                    }
                    case 34969: 
                    case 35195: {
                        this.alreadyAuthenticated();
                        break;
                    }
                    default: {
                        this.isReady = false;
                        this.exception = new LoginException(nSIException);
                        break;
                    }
                }
            }
            catch (AlreadyAuthenticatedException alreadyAuthenticatedException) {
                this.alreadyAuthenticated();
            }
            catch (SessionException sessionException) {
                this.isReady = false;
                this.exception = new LoginException(sessionException);
            }
            catch (Exception exception) {
                this.isReady = false;
                this.exception = new LoginException(exception);
            }
            Object var2_5 = null;
            if (this.removeDialog) {
                this.dispose();
            }
            return;
        }
        catch (Throwable throwable) {
            block12: {
                Object var2_6 = null;
                if (!this.removeDialog) break block12;
                this.dispose();
            }
            throw throwable;
        }
    }

    void cancelPressed() {
        this.isReady = false;
        this.exception = new LoginCancelledException();
        this.dispose();
    }

    void logoutAndLogin() {
        try {
            XplatProtocolProxy.performLogout(this.identity, this.getName(), this.getDomain(), this.currentThread);
            this.isReady = true;
            this.okayPressed();
            return;
        }
        catch (Exception exception) {
            this.isReady = false;
            this.exception = new LoginException(exception);
            this.removeDialog = true;
            return;
        }
    }

    private static String substString(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (n >= 0) {
            string = String.valueOf(string.substring(0, n)) + string3 + string.substring(n + string2.length());
        }
        return string;
    }

    void alreadyAuthenticated() {
        Object object;
        this.isReady = false;
        this.exception = null;
        this.removeDialog = false;
        Point point = this.getLocation();
        Dimension dimension = this.getPreferredSize();
        point.x += dimension.width / 2;
        point.y += dimension.height / 2;
        String string = "";
        String string2 = this.getDomain();
        String string3 = this.getName();
        String string4 = "";
        if (this.identity instanceof NdsIdentity) {
            string4 = NdsIdentityScope.ADMINISTRATIVE_DOMAIN_NAME;
        } else if (this.identity instanceof BinderyIdentity) {
            string4 = BinderyIdentityScope.ADMINISTRATIVE_DOMAIN_NAME;
        }
        try {
            object = Authenticator.getIdentities();
            int n = 0;
            while (n < ((Identity[])object).length) {
                if (((XplatIdentity)object[n]).getUserDomain().equals(string2) && ((XplatIdentity)object[n]).getAdministrativeDomain().equals(string4)) {
                    string = object[n].getName();
                    break;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object = I2L.getString("PREVIOUSLY_AUTHENTICATED");
        object = LoginUserInterface.substString((String)object, "$t", string2);
        object = LoginUserInterface.substString((String)object, "$n", string3);
        object = LoginUserInterface.substString((String)object, "$c", string);
        1 var8_10 = new 1(this, this, this.frame, I2L.getString("PREVIOUSLY_AUTHENTICATED_TITLE"), (String)object, point);
        var8_10.pack();
        var8_10.show();
    }

    private final class 1
    extends BasicUserInterface.ErrorOkCancelDialog {
        void okayPressed() {
            ((LoginUserInterface)this.dialog).logoutAndLogin();
        }

        void cancelPressed() {
            this.dispose();
        }

        /* synthetic */ 1(LoginUserInterface loginUserInterface, LoginUserInterface loginUserInterface2, JFrame jFrame, String string, String string2, Point point) {
            super(loginUserInterface2, jFrame, string, string2, point);
        }
    }
}

