/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.session;

import com.novell.java.lang.HasRootCause;
import com.novell.java.security.Authenticator;
import com.novell.service.session.InvalidStateException;
import com.novell.service.session.Session;
import com.novell.service.session.SessionAttrNotFoundException;
import com.novell.service.session.SessionAttrs;
import com.novell.service.session.SessionEnumerator;
import com.novell.service.session.SessionEnv;
import com.novell.service.session.SessionException;
import com.novell.service.session.SessionManager;
import com.novell.service.session.spi.SessionManagerService;
import com.novell.service.session.spi.SessionManagerServiceImpl;
import com.novell.service.session.util.DefaultProperties;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;

public class SessionManagerFactory {
    private static final boolean DEBUG = false;
    private static final boolean S_DEBUG = false;
    private static final boolean WHO_CALLED_DEBUG = false;
    private static final boolean METHOD_TRACE_DEBUG = false;
    public static final int SCOPE = 0;
    public static final int PRIVATE_SCOPE = 0x10000000;
    public static final int NO_SCAN_SCOPE = 0x20000000;
    public static final int SHARED_SCAN_SCOPE = 0;
    public static final int SHARED_NO_SCAN_SCOPE = 0x20000000;
    public static final int PRIVATE_SCAN_SCOPE = 0x10000000;
    public static final int PRIVATE_NO_SCAN_SCOPE = 0x30000000;
    private static SessionManager sessionManagerSingletonInstance;
    private static SessionManagerService sessionManagerService;

    private SessionManagerFactory() {
    }

    private static synchronized SessionManagerService getSessionManagerService() throws SessionException {
        try {
            if (sessionManagerService == null) {
                sessionManagerService = SessionManagerServiceImpl.getInstance();
            }
        }
        catch (Exception exception) {
            throw new SessionException("Unable to obtain SessionManagerService", exception);
        }
        return sessionManagerService;
    }

    private static synchronized SessionManager getSingletonSM(SessionEnv sessionEnv, int n) throws SessionException {
        if (sessionManagerSingletonInstance != null && !sessionManagerSingletonInstance.isValid()) {
            sessionManagerSingletonInstance = null;
        }
        if (sessionManagerSingletonInstance == null) {
            sessionManagerSingletonInstance = SessionManagerFactory.getSessionManagerService().getSessionManager(sessionEnv, n);
        }
        return sessionManagerSingletonInstance;
    }

    private static synchronized SessionManager getPrivateSM(SessionEnv sessionEnv, int n) throws SessionException {
        return SessionManagerFactory.getSessionManagerService().getSessionManager(sessionEnv, n);
    }

    private static synchronized SessionManager getSessionManager(SessionEnv sessionEnv, int n) throws SessionException {
        if ((0x10000000 & n) == 0) {
            return SessionManagerFactory.getSingletonSM(sessionEnv, n);
        }
        return SessionManagerFactory.getPrivateSM(sessionEnv, n);
    }

    public static SessionManager getSessionManager(SessionEnv sessionEnv) throws SessionException {
        Boolean bl;
        int n = 0;
        if (System.getProperty("os.name").startsWith("NetWare")) {
            n |= 0x20000000;
        }
        if ((bl = (Boolean)sessionEnv.get("com.novell.service.session.PrivateScope")) != null && bl.booleanValue()) {
            n |= 0x10000000;
        }
        return SessionManagerFactory.getSessionManager(sessionEnv, n);
    }

    public static SessionManager getPrivate(SessionEnv sessionEnv) throws SessionException {
        int n = 0x10000000;
        if (System.getProperty("os.name").startsWith("NetWare")) {
            n |= 0x20000000;
        }
        return SessionManagerFactory.getSessionManager(sessionEnv, n);
    }

    public static void main(String[] stringArray) {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        boolean bl = false;
        boolean bl2 = true;
        DefaultProperties defaultProperties = SessionManagerFactory.readProperties();
        SessionManagerFactory.writeProperties(defaultProperties);
        string = defaultProperties.getProperty("domain.name");
        string2 = defaultProperties.getProperty("user.name");
        string3 = defaultProperties.getProperty("user.password");
        string4 = defaultProperties.getProperty("domain.name.existing");
        string5 = defaultProperties.getProperty("com.novell.service.session.spi.InitialSessionFactory");
        bl2 = new Boolean(defaultProperties.getProperty("com.novell.service.session.spi.SessionManagerServiceDaemon"));
        bl = new Boolean(defaultProperties.getProperty("authenticator.use"));
        if (stringArray.length > 0) {
            if (stringArray.length < 4) {
                System.out.println("SMF: parameters: domain user password existing_domain");
                return;
            }
            string = stringArray[0];
            string2 = stringArray[1];
            string4 = stringArray[3];
        }
        try {
            Session session;
            Session session2;
            SessionEnv sessionEnv = new SessionEnv();
            sessionEnv.put("com.novell.service.session.spi.InitialSessionFactory", string5);
            sessionEnv.put("com.novell.service.session.spi.SessionManagerServiceDaemon", new Boolean(bl2));
            SessionManager sessionManager = SessionManagerFactory.getSessionManager(sessionEnv);
            System.out.println("SMF: Find existing sessions...");
            SessionAttrs sessionAttrs = new SessionAttrs();
            SessionEnumerator sessionEnumerator = sessionManager.search(sessionAttrs);
            while (sessionEnumerator.hasMoreElements()) {
                session2 = sessionEnumerator.next();
                SessionManagerFactory.printSession("Found", session2);
            }
            System.out.println("SMF: Adding existing" + string4 + "...");
            session2 = sessionManager.getSession(string4);
            if (session2.getDomainName().equals(string4)) {
                System.out.println("MATCHED");
            } else {
                System.out.println("NOT MATCHED");
            }
            System.out.println("SMF: Adding " + string + "...");
            Session session3 = sessionManager.getSession(string);
            SessionManagerFactory.printSession("Added", session3);
            System.out.println("SMF: Find sessions after add...");
            sessionEnumerator = sessionManager.search(sessionAttrs);
            while (sessionEnumerator.hasMoreElements()) {
                session = sessionEnumerator.next();
                SessionManagerFactory.printSession("Found", session);
            }
            if (string2.length() > 0) {
                System.out.println("SMF: Authenticating...");
                Authenticator.login(session3.createIdentity(string2));
            }
            System.out.println("SMF: Find sessions after authenticate...");
            sessionEnumerator = sessionManager.search(sessionAttrs);
            while (sessionEnumerator.hasMoreElements()) {
                session = sessionEnumerator.next();
                SessionManagerFactory.printSession("Found", session);
            }
            System.out.println("SMF: Closing " + string + "...");
            try {
                session3.close();
            }
            catch (InvalidStateException invalidStateException) {
                System.out.println("SMF: Session is invalid");
            }
            System.out.println("SMF: Find sessions after close...");
            sessionEnumerator = sessionManager.search(sessionAttrs);
            while (sessionEnumerator.hasMoreElements()) {
                session = sessionEnumerator.next();
                SessionManagerFactory.printSession("Found", session);
            }
            System.out.println("SMF: Running garbage collector...");
            System.gc();
            System.out.println("SMF: Fifth scan...");
            sessionEnumerator = sessionManager.search(sessionAttrs);
            while (sessionEnumerator.hasMoreElements()) {
                session = sessionEnumerator.next();
                SessionManagerFactory.printSession("Found", session);
            }
            System.out.println("SMF: Done");
        }
        catch (Exception exception) {
            SessionManagerFactory.dumpException(exception);
        }
        System.out.println("SMF: TEST COMPLETE!");
    }

    private static void printSession(String string, Session session) {
        String[] stringArray = new String[]{"DOMAIN_NAME", "SESSION_STATE", "SESSION_PROVIDER", "IS_AUTHENTICATED_STATE", "SESSION_TYPE"};
        try {
            SessionAttrs sessionAttrs = session.getAttributes(stringArray);
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            String string6 = "";
            try {
                string2 = (String)sessionAttrs.getValue(stringArray[0]);
            }
            catch (SessionAttrNotFoundException sessionAttrNotFoundException) {
                string2 = "???";
            }
            try {
                string3 = (String)sessionAttrs.getValue(stringArray[1]);
            }
            catch (SessionAttrNotFoundException sessionAttrNotFoundException) {
                string3 = "???";
            }
            try {
                string4 = (String)sessionAttrs.getValue(stringArray[2]);
            }
            catch (SessionAttrNotFoundException sessionAttrNotFoundException) {
                string4 = "???";
            }
            try {
                string5 = (Boolean)sessionAttrs.getValue(stringArray[3]) != false ? "AUTH" : "NOT AUTH";
            }
            catch (SessionAttrNotFoundException sessionAttrNotFoundException) {
                string5 = "???";
            }
            try {
                string6 = (String)sessionAttrs.getValue(stringArray[4]);
            }
            catch (SessionAttrNotFoundException sessionAttrNotFoundException) {
                string6 = "???";
            }
            System.out.println("SMF: " + string + " : " + string2 + " : " + string6 + " : " + string4 + " : " + string5);
            return;
        }
        catch (Exception exception) {
            SessionManagerFactory.dumpException(exception);
            return;
        }
    }

    private static void dumpException(Throwable throwable) {
        System.out.println("\nSMF: Exception...");
        throwable.printStackTrace();
        while (throwable != null) {
            if ((throwable = throwable instanceof HasRootCause ? ((HasRootCause)((Object)throwable)).getRootCause() : null) == null) continue;
            System.out.println("\nSMF: Root cause...");
            throwable.printStackTrace();
        }
    }

    private static void writeProperties(DefaultProperties defaultProperties) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream("test.properties");
            defaultProperties.save(fileOutputStream, "Test properties");
            fileOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private static DefaultProperties readProperties() {
        DefaultProperties defaultProperties = new DefaultProperties();
        ((Hashtable)defaultProperties).put("domain.name", "API-410");
        ((Hashtable)defaultProperties).put("user.name", "admin.novell");
        ((Hashtable)defaultProperties).put("domain.name.existing", "NOVELL_INC");
        ((Hashtable)defaultProperties).put("authenticator.use", "false");
        ((Hashtable)defaultProperties).put("com.novell.service.session.spi.InitialSessionFactory", "com.novell.service.session.nds.NDSInitialSessionFactory:com.novell.service.session.bindery.BinderyInitialSessionFactory");
        ((Hashtable)defaultProperties).put("com.novell.service.session.spi.SessionManagerServiceDaemon", "true");
        DefaultProperties defaultProperties2 = new DefaultProperties(defaultProperties);
        try {
            FileInputStream fileInputStream = new FileInputStream("test.properties");
            defaultProperties2.load(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {}
        return defaultProperties2;
    }
}

