/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.session.spi;

import com.novell.service.session.SessionException;
import com.novell.service.session.spi.SessionImpl;
import java.util.Enumeration;
import java.util.Vector;

public class Children {
    private static final boolean ROBUST = true;
    Vector children;
    Vector childrenNames;

    public Children(int n, int n2) {
        this.children = new Vector(n, n2);
        this.childrenNames = new Vector(n, n2);
    }

    public Children(int n) {
        this(n, 1);
    }

    public Children() {
        this(0, 1);
    }

    public final void addChild(SessionImpl sessionImpl) throws SessionException {
        this.addChild(sessionImpl, sessionImpl.getDomainName());
    }

    public final void addChild(SessionImpl sessionImpl, String string) throws SessionException {
        this.checkIntegrity();
        this.children.addElement(sessionImpl);
        this.childrenNames.addElement(string);
    }

    public boolean contains(SessionImpl sessionImpl) throws SessionException {
        return this.children.contains(sessionImpl);
    }

    public boolean contains(String string) throws SessionException {
        this.checkIntegrity();
        return this.childrenNames.contains(string);
    }

    public final void copySessionsInto(Object[] objectArray) {
        this.children.copyInto(objectArray);
    }

    public final void copyNamesInto(Object[] objectArray) {
        this.childrenNames.copyInto(objectArray);
    }

    public final SessionImpl sessionAt(int n) throws SessionException {
        return (SessionImpl)this.children.elementAt(n);
    }

    public final String nameAt(int n) throws SessionException {
        this.checkIntegrity();
        return (String)this.childrenNames.elementAt(n);
    }

    public final Enumeration sessions() throws SessionException {
        return this.children.elements();
    }

    public final Enumeration names() throws SessionException {
        this.checkIntegrity();
        return this.childrenNames.elements();
    }

    public final void ensureCapacity(int n) throws SessionException {
        this.checkIntegrity();
        this.children.ensureCapacity(n);
        this.childrenNames.ensureCapacity(n);
    }

    public final SessionImpl firstSession() throws SessionException {
        return (SessionImpl)this.children.firstElement();
    }

    public final String firstName() throws SessionException {
        this.checkIntegrity();
        return (String)this.childrenNames.firstElement();
    }

    public final int indexOf(SessionImpl sessionImpl) throws SessionException {
        return this.children.indexOf(sessionImpl);
    }

    public final int indexOf(String string) throws SessionException {
        this.checkIntegrity();
        return this.childrenNames.indexOf(string);
    }

    public final int indexOf(SessionImpl sessionImpl, int n) throws SessionException {
        return this.children.indexOf(sessionImpl, n);
    }

    public final int indexOf(String string, int n) throws SessionException {
        this.checkIntegrity();
        return this.childrenNames.indexOf(string, n);
    }

    public final void insertSessionAt(SessionImpl sessionImpl, String string, int n) throws SessionException {
        this.checkIntegrity();
        this.children.insertElementAt(sessionImpl, n);
        this.childrenNames.insertElementAt(string, n);
    }

    public final boolean isEmpty() {
        return this.children.isEmpty();
    }

    public final SessionImpl lastSession() throws SessionException {
        return (SessionImpl)this.children.lastElement();
    }

    public final String lastName() throws SessionException {
        this.checkIntegrity();
        return (String)this.childrenNames.lastElement();
    }

    public final int lastIndexOf(SessionImpl sessionImpl, int n) {
        return this.children.lastIndexOf(sessionImpl, n);
    }

    public final int lastIndexOf(String string, int n) throws SessionException {
        this.checkIntegrity();
        return this.childrenNames.lastIndexOf(string, n);
    }

    public final void removeAllChildren() throws SessionException {
        this.children.removeAllElements();
        this.childrenNames.removeAllElements();
    }

    public final boolean removeChild(SessionImpl sessionImpl) throws SessionException {
        int n = this.indexOf(sessionImpl);
        if (n == -1) {
            return false;
        }
        this.removeChildAt(n);
        return true;
    }

    public final boolean removeChild(String string) throws SessionException {
        this.checkIntegrity();
        int n = this.indexOf(string);
        if (n == -1) {
            return false;
        }
        this.removeChildAt(n);
        return true;
    }

    public final void removeChildAt(int n) throws SessionException {
        this.checkIntegrity();
        this.children.removeElementAt(n);
        this.childrenNames.removeElementAt(n);
    }

    public final void setChildAt(SessionImpl sessionImpl, int n) {
        this.children.setElementAt(sessionImpl, n);
    }

    public final void setChildAt(String string, int n) throws SessionException {
        this.checkIntegrity();
        this.childrenNames.setElementAt(string, n);
    }

    public final void setSize(int n) throws SessionException {
        this.checkIntegrity();
        this.children.setSize(n);
        this.childrenNames.setSize(n);
    }

    public final String toString() {
        return String.valueOf(this.children.toString()) + " : " + this.childrenNames.toString();
    }

    public final void trimToSize() throws SessionException {
        this.checkIntegrity();
        this.children.trimToSize();
        this.childrenNames.trimToSize();
    }

    public final int size() throws SessionException {
        return this.children.size();
    }

    public final void checkIntegrity() throws SessionException {
        if (this.children.size() != this.childrenNames.size()) {
            this.rebuild();
            if (this.children.size() != this.childrenNames.size()) {
                throw new SessionException("Children elements mismatched");
            }
        }
    }

    public final void rebuild() throws SessionException {
        this.childrenNames.removeAllElements();
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            SessionImpl sessionImpl = (SessionImpl)enumeration.nextElement();
            this.childrenNames.addElement(sessionImpl.getDomainName());
        }
    }

    public final SessionImpl get(String string) throws SessionException {
        this.checkIntegrity();
        SessionImpl sessionImpl = null;
        int n = this.indexOf(string);
        if (n != -1) {
            sessionImpl = this.sessionAt(n);
        }
        return sessionImpl;
    }

    public final String get(SessionImpl sessionImpl) throws SessionException {
        this.checkIntegrity();
        String string = null;
        int n = this.indexOf(sessionImpl);
        if (n != -1) {
            string = this.nameAt(n);
        }
        return string;
    }
}

