/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.session.spi;

import com.novell.java.security.Identity;
import com.novell.service.session.InvalidSessionException;
import com.novell.service.session.Session;
import com.novell.service.session.SessionAttrs;
import com.novell.service.session.SessionEnumerator;
import com.novell.service.session.SessionEnv;
import com.novell.service.session.SessionException;
import com.novell.service.session.SessionService;
import com.novell.service.session.spi.SessionImpl;
import com.novell.service.session.spi.SessionState;

public class InvalidSessionState
extends SessionState {
    private static final boolean DEBUG = false;
    private static final boolean MAKE_INVALID_DEBUG = false;
    private static final boolean S_DEBUG = false;
    private static final boolean ERROR_ON_DEPRECATED = false;
    private static InvalidSessionState singletonInstance;
    private static final String INVALID = "Session no longer valid";
    private Throwable reason;

    private InvalidSessionState() throws SessionException {
        super(null);
        this.setReason(new SessionException("State not fully initialized"));
    }

    public InvalidSessionState(SessionImpl sessionImpl, Throwable throwable) throws SessionException {
        super(sessionImpl);
        SessionException sessionException = throwable == null ? new SessionException("Session invalidated") : new SessionException("Session invalidated", throwable);
        this.setReason(sessionException);
        this.attachedSession.setState(this);
    }

    public static InvalidSessionState getInstance() throws SessionException {
        if (singletonInstance == null) {
            singletonInstance = new InvalidSessionState();
        }
        return singletonInstance;
    }

    public void close() throws SessionException {
    }

    public Session getSession(String string, SessionEnv sessionEnv) throws SessionException {
        throw this.getInvalidException();
    }

    public Session getSessionTop(String string, SessionEnv sessionEnv) throws SessionException {
        throw this.getInvalidException();
    }

    public SessionAttrs getAttributes() throws SessionException {
        throw this.getInvalidException();
    }

    public SessionAttrs getAttributes(String[] stringArray) throws SessionException {
        throw this.getInvalidException();
    }

    public SessionEnumerator search(SessionAttrs sessionAttrs) throws SessionException {
        throw this.getInvalidException();
    }

    public String getDomainName() throws SessionException {
        throw this.getInvalidException();
    }

    public SessionEnumerator getChildren() throws SessionException {
        throw this.getInvalidException();
    }

    public void invalidate(Throwable throwable) throws SessionException {
        throw this.getInvalidException();
    }

    public void validateLinks() throws SessionException {
        throw this.getInvalidException();
    }

    public boolean isValid() {
        return false;
    }

    public String getName() throws SessionException {
        throw this.getInvalidException();
    }

    public void authenticate(String string) throws SessionException {
        throw this.getInvalidException();
    }

    public void authenticate() throws SessionException {
        throw this.getInvalidException();
    }

    public void unauthenticate() throws SessionException {
        throw this.getInvalidException();
    }

    public boolean isAuthenticated() throws SessionException {
        throw this.getInvalidException();
    }

    public SessionService getService(String string) throws SessionException {
        throw this.getInvalidException();
    }

    public Identity createIdentity(String string) throws SessionException {
        throw this.getInvalidException();
    }

    public void setReason(Throwable throwable) {
        this.reason = throwable;
    }

    protected Throwable getReason() {
        return this.reason;
    }

    public static SessionException makeInvalid(SessionImpl sessionImpl, Throwable throwable) throws SessionException {
        if (throwable == null) {
            throw new NullPointerException("rootException");
        }
        sessionImpl.invalidate(throwable);
        InvalidSessionState invalidSessionState = (InvalidSessionState)sessionImpl.getState();
        invalidSessionState.setReason(throwable);
        return new InvalidSessionException("Session no longer valid: " + sessionImpl.domainName, throwable);
    }

    public Session findSession(String string) throws SessionException {
        throw this.getInvalidException();
    }

    public Session findSessionTop(String string) throws SessionException {
        throw this.getInvalidException();
    }

    public SessionException getInvalidException() throws SessionException {
        return new InvalidSessionException(INVALID, this.getReason());
    }
}

