/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.session.spi;

import com.novell.java.security.Identity;
import com.novell.java.util.VectorEnumerator;
import com.novell.service.session.InvalidSessionException;
import com.novell.service.session.InvalidStateException;
import com.novell.service.session.Session;
import com.novell.service.session.SessionAttrEnumerator;
import com.novell.service.session.SessionAttrs;
import com.novell.service.session.SessionEnumerator;
import com.novell.service.session.SessionEnv;
import com.novell.service.session.SessionException;
import com.novell.service.session.SessionService;
import com.novell.service.session.UnknownKeyException;
import com.novell.service.session.spi.InvalidSessionState;
import com.novell.service.session.spi.SessionImpl;
import com.novell.service.session.spi.SessionManagerImpl;
import java.io.Serializable;
import java.rmi.server.UID;
import java.util.Vector;

public abstract class SessionState
implements Session {
    private static final boolean DEBUG = false;
    private static final boolean FINALIZER_DEBUG = false;
    private static final boolean I_DEBUG = false;
    private static final boolean S_DEBUG = false;
    private static final boolean JVMUID_DEBUG = false;
    private static final boolean CLOSE_DEBUG = false;
    private static final boolean CREATION_DEBUG = false;
    private static final boolean SERVICE_DEBUG = false;
    private static final boolean FIND_DEBUG = false;
    private static final boolean ERROR_ON_DEPRECATED = false;
    protected SessionImpl attachedSession;
    protected SessionManagerImpl sessionManager;
    protected UID uid;
    protected String userName;

    public SessionState(SessionImpl sessionImpl) throws SessionException {
        this.attachedSession = sessionImpl;
        if (sessionImpl == null) {
            this.sessionManager = null;
            return;
        }
        Session session = sessionImpl;
        while (session.hasParent()) {
            session = session.getParent();
        }
        this.sessionManager = (SessionManagerImpl)session;
    }

    public String getDomainName() throws SessionException {
        return this.attachedSession.getDomainName();
    }

    public SessionEnv getEnvironment() throws SessionException {
        return this.attachedSession.getEnvironment();
    }

    public SessionEnv getEffectiveEnvironment() throws SessionException {
        return this.attachedSession.getEffectiveEnvironment();
    }

    public SessionEnv setEnvironment(SessionEnv sessionEnv) throws SessionException {
        return this.attachedSession.setEnvironment((SessionEnv)sessionEnv.clone());
    }

    public SessionAttrs getAttributes() throws SessionException {
        SessionAttrs sessionAttrs = new SessionAttrs();
        String[] stringArray = new String[]{"DOMAIN_NAME", "SESSION_STATE", "IS_REAL", "USER_NAME"};
        sessionAttrs.modify(this.getStateAttrs(stringArray));
        return sessionAttrs;
    }

    public SessionAttrs getAttributes(String[] stringArray) throws SessionException {
        SessionAttrs sessionAttrs = this.getStateAttrs(stringArray);
        return sessionAttrs;
    }

    private SessionAttrs getStateAttrs(String[] stringArray) throws SessionException {
        SessionAttrs sessionAttrs = new SessionAttrs();
        int n = 0;
        while (n < stringArray.length) {
            if ("DOMAIN_NAME".equals(stringArray[n])) {
                sessionAttrs.add("DOMAIN_NAME", this.getDomainName());
            }
            if ("SESSION_STATE".equals(stringArray[n])) {
                sessionAttrs.add("SESSION_STATE", this.getClass().getName());
            }
            if ("IS_REAL".equals(stringArray[n])) {
                sessionAttrs.add("IS_REAL", new Boolean(true));
            }
            try {
                if ("USER_NAME".equals(stringArray[n])) {
                    sessionAttrs.modify("USER_NAME", this.getName());
                }
            }
            catch (SessionException sessionException) {
                // empty catch block
            }
            ++n;
        }
        return sessionAttrs;
    }

    public void validateLinks() throws SessionException {
        this.validateChildren();
        SessionEnumerator sessionEnumerator = this.getChildren();
        while (sessionEnumerator.hasMoreElements()) {
            Session session = sessionEnumerator.next();
            try {
                session.validateLinks();
            }
            catch (InvalidSessionException invalidSessionException) {
                // empty catch block
            }
        }
    }

    public boolean isValid() {
        return true;
    }

    public SessionEnumerator getChildren() throws SessionException {
        return this.attachedSession.getChildren();
    }

    public Session getParent() {
        return this.attachedSession.getParent();
    }

    public Session getSession(String string) throws SessionException {
        Session session = this.getSession(string, new SessionEnv());
        return session;
    }

    public Session getSessionTop(String string) throws SessionException {
        return this.getSessionTop(string, new SessionEnv());
    }

    public Session getSessionTop(String string, SessionEnv sessionEnv) throws SessionException {
        return this.getParent().getSessionTop(string, sessionEnv);
    }

    public void close() throws SessionException {
        int n = this.attachedSession.children.size();
        Object[] objectArray = new Session[n];
        this.attachedSession.children.copySessionsInto(objectArray);
        int n2 = 0;
        while (n2 < n) {
            try {
                Object object = objectArray[n2];
                object.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        this.releaseResources();
        this.attachedSession.invalidateSelf(null);
    }

    protected void releaseResources() throws SessionException {
    }

    public SessionEnumerator search(SessionAttrs sessionAttrs) throws SessionException {
        Serializable serializable;
        this.validateChildren();
        Vector<Session> vector = new Vector<Session>();
        String[] stringArray = new String[sessionAttrs.count()];
        int n = 0;
        SessionAttrEnumerator sessionAttrEnumerator = sessionAttrs.getAttributes();
        while (sessionAttrEnumerator.hasMoreElements()) {
            stringArray[n++] = sessionAttrEnumerator.next().getSessionAttrId();
        }
        SessionEnumerator sessionEnumerator = this.getChildren();
        while (sessionEnumerator.hasMoreElements()) {
            Session session = sessionEnumerator.next();
            serializable = session.getAttributes(stringArray);
            if (((SessionAttrs)serializable).matchesSubset(sessionAttrs)) {
                vector.addElement(session);
            }
            try {
                if (!session.hasChildren()) continue;
                SessionEnumerator sessionEnumerator2 = session.search(sessionAttrs);
                while (sessionEnumerator2.hasMoreElements()) {
                    vector.addElement(sessionEnumerator2.next());
                }
            }
            catch (Exception exception) {}
        }
        serializable = new SessionEnumerator(new VectorEnumerator(vector));
        return serializable;
    }

    protected void validateChildren() throws SessionException {
    }

    public void invalidate(Throwable throwable) throws SessionException {
        this.attachedSession.invalidate(throwable);
    }

    public SessionService getService(String string) throws SessionException {
        throw new UnknownKeyException(String.valueOf(string) + ": " + this.attachedSession);
    }

    public UID getUID() {
        return this.attachedSession.getUID();
    }

    public boolean hasParent() {
        return this.attachedSession.hasParent();
    }

    public boolean hasChildren() {
        return this.attachedSession.hasChildren();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SessionState$");
        stringBuffer.append(":" + this.getClass().toString());
        return stringBuffer.toString();
    }

    public String getName() throws SessionException {
        throw new InvalidStateException("Not authenticatable");
    }

    public void authenticate(String string) throws SessionException {
        throw new InvalidStateException("Not authenticatable");
    }

    public void authenticate() throws SessionException {
        throw new InvalidStateException("Not authenticatable");
    }

    public void unauthenticate() throws SessionException {
        throw new InvalidStateException("Not authenticatable");
    }

    public boolean isAuthenticated() throws SessionException {
        return false;
    }

    public Identity createIdentity(String string) throws SessionException {
        throw new InvalidStateException("Not authenticatable");
    }

    protected Session getChild(String string) throws SessionException {
        return this.attachedSession.getChild(string);
    }

    public Session findSession(String string) throws SessionException {
        Session session = null;
        session = this.attachedSession.getChild(string);
        if (session == null) {
            SessionEnumerator sessionEnumerator = this.getChildren();
            while (sessionEnumerator.hasMoreElements() && session == null) {
                Session session2 = sessionEnumerator.next();
                session = session2.findSession(string);
            }
        }
        return session;
    }

    public Session findSessionTop(String string) throws SessionException {
        return this.getParent().findSessionTop(string);
    }

    public SessionException getInvalidException() throws SessionException {
        return InvalidSessionState.makeInvalid(this.attachedSession, new SessionException("Unexpected exception: getInvalidException() called on VALID state"));
    }

    public abstract Session getSession(String var1, SessionEnv var2) throws SessionException;
}

