/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.session.util;

import com.novell.java.lang.HasRootCause;
import com.novell.java.lang.HasRootCauses;
import com.novell.service.session.SessionRuntimeException;
import com.novell.service.session.util.DebugStackTraceException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import javax.naming.NamingException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Debug {
    private static boolean append;
    private static boolean assert;
    private static int callDepth;
    private static boolean caller;
    private static boolean debug;
    private static boolean exitOnAssert;
    private static boolean fixTimeZone;
    private static String outputFile;
    private static boolean outputAutoFlush;
    private static boolean outputToFile;
    private static boolean prefixEachLine;
    private static boolean printHeader;
    private static boolean quiet;
    private static boolean synchOutput;
    private static boolean systemTimer;
    private static boolean threads;
    private static boolean traceInstructions;
    private static boolean traceMethods;
    private static int truncate;
    private static PrintStream oriout;
    private static PrintStream orierr;
    private static String className;
    private static final String header = ":::990823a:::";
    private static PrintWriter output;
    private static PrintWriter outputAlways;
    private static final String padding = "   ";
    private static long startTimeMillis;
    private static long lastElapsed;
    private static long lastDelta;
    private static final boolean forceDEBUG = false;

    public static synchronized void setAppend(boolean bl) {
        append = bl;
    }

    public static synchronized void setAssert(boolean bl) {
        assert = bl;
        Debug.setExitOnAssert(exitOnAssert);
    }

    public static synchronized void setCallDepth(int n) {
        callDepth = n;
    }

    public static synchronized void setCaller(boolean bl) {
        caller = bl;
        Debug.setCallDepth(callDepth);
    }

    public static synchronized void setDebug(boolean bl) {
        debug = bl;
        if (bl) {
            Debug.setOutputToFile(outputToFile);
            Debug.setFixTimeZone(fixTimeZone);
            Debug.setAssert(assert);
            Debug.setTraceInstructions(traceInstructions);
            Debug.setTraceMethods(traceMethods);
            String string = "---New debug session: " + new GregorianCalendar().getTime().toString() + "(" + header + ")";
            Debug.printlnOnly(string, output);
            Debug.dumpDebugProperties();
        }
    }

    public static synchronized void setExitOnAssert(boolean bl) {
        exitOnAssert = bl;
    }

    public static synchronized void setFixTimeZone(boolean bl) {
        fixTimeZone = bl;
        if (bl) {
            TimeZone.setDefault(TimeZone.getTimeZone("MST"));
        }
    }

    public static synchronized void setOutputFile(String string) {
        outputFile = string;
    }

    public static synchronized void setOutputAutoFlush(boolean bl) {
        outputAutoFlush = bl;
    }

    public static synchronized void setOutputToFile(boolean bl) {
        Debug.setAppend(append);
        Debug.setQuiet(quiet);
        Debug.setSystemTimer(systemTimer);
        Debug.setThreads(threads);
        Debug.setCaller(caller);
        Debug.setPrefixEachLine(prefixEachLine);
        Debug.setPrintHeader(printHeader);
        Debug.setOutputFile(outputFile);
        Debug.setOutputAutoFlush(outputAutoFlush);
        outputToFile = bl;
        try {
            OutputStream outputStream = bl ? new FileOutputStream(outputFile, append) : System.out;
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            output = new PrintWriter((Writer)outputStreamWriter, outputAutoFlush);
            return;
        }
        catch (IOException iOException) {
            throw new SessionRuntimeException("Problem - exception", iOException);
        }
    }

    public static synchronized void setPrefixEachLine(boolean bl) {
        prefixEachLine = bl;
    }

    public static synchronized void setPrintHeader(boolean bl) {
        printHeader = bl;
    }

    public static synchronized void setQuiet(boolean bl) {
        quiet = bl;
    }

    public static synchronized void setSystemTimer(boolean bl) {
        systemTimer = bl;
    }

    public static synchronized void setThreads(boolean bl) {
        threads = bl;
    }

    public static synchronized void setTraceInstructions(boolean bl) {
        traceInstructions = bl;
    }

    public static synchronized void setTraceMethods(boolean bl) {
        traceMethods = bl;
    }

    public static synchronized void setTruncate(int n) {
        truncate = n;
    }

    public static synchronized boolean getAppend() {
        return append;
    }

    public static synchronized boolean getAssert() {
        return assert;
    }

    public static synchronized int getCallDepth() {
        return callDepth;
    }

    public static synchronized boolean getCaller() {
        return caller;
    }

    public static synchronized boolean getDebug() {
        return debug;
    }

    public static synchronized boolean getExitOnAssert() {
        return exitOnAssert;
    }

    public static synchronized boolean getFixTimeZone() {
        return fixTimeZone;
    }

    public static synchronized String getOutputFile() {
        return outputFile;
    }

    public static synchronized boolean getOutputAutoFlush() {
        return outputAutoFlush;
    }

    public static synchronized boolean getOutputToFile() {
        return outputToFile;
    }

    public static synchronized boolean getPrefixEachLine() {
        return prefixEachLine;
    }

    public static synchronized boolean getPrintHeader() {
        return printHeader;
    }

    public static synchronized boolean getQuiet() {
        return quiet;
    }

    public static synchronized boolean getSystemTimer() {
        return systemTimer;
    }

    public static synchronized boolean getThreads() {
        return threads;
    }

    public static synchronized boolean getTraceInstructions() {
        return traceInstructions;
    }

    public static synchronized boolean getTraceMethods() {
        return traceMethods;
    }

    public static synchronized int getTruncate() {
        return truncate;
    }

    public static synchronized void dumpDebugProperties() {
        if (debug) {
            Properties properties = Debug.getDebugProperties();
            properties.list(output);
        }
    }

    public static synchronized void initFromSystemProperties() {
        try {
            if (!debug) {
                debug = new Boolean(System.getProperty(String.valueOf(className) + ".debug", "false"));
                return;
            }
        }
        catch (SecurityException securityException) {
            System.out.println("Exception reading system properties: " + securityException);
        }
    }

    public static synchronized Properties getDebugProperties() {
        Properties properties = new Properties();
        ((Hashtable)properties).put("append", new Boolean(append).toString());
        ((Hashtable)properties).put("assert", new Boolean(assert).toString());
        ((Hashtable)properties).put("callDepth", new Integer(callDepth).toString());
        ((Hashtable)properties).put("caller", new Boolean(caller).toString());
        ((Hashtable)properties).put("debug", new Boolean(debug).toString());
        ((Hashtable)properties).put("exitOnAssert", new Boolean(exitOnAssert).toString());
        ((Hashtable)properties).put("fixTimeZone", new Boolean(fixTimeZone).toString());
        ((Hashtable)properties).put("outputAutoFlush", new Boolean(outputAutoFlush).toString());
        ((Hashtable)properties).put("outputToFile", new Boolean(outputToFile).toString());
        ((Hashtable)properties).put("outputFile", outputFile);
        ((Hashtable)properties).put("prefixEachLine", new Boolean(prefixEachLine).toString());
        ((Hashtable)properties).put("printHeader", new Boolean(printHeader).toString());
        ((Hashtable)properties).put("quiet", new Boolean(quiet).toString());
        ((Hashtable)properties).put("systemTimer", new Boolean(systemTimer).toString());
        ((Hashtable)properties).put("threads", new Boolean(threads).toString());
        ((Hashtable)properties).put("traceInstructions", new Boolean(traceInstructions).toString());
        ((Hashtable)properties).put("traceMethods", new Boolean(traceMethods).toString());
        ((Hashtable)properties).put("truncate", new Integer(truncate).toString());
        return properties;
    }

    public static synchronized void writeDebugProperties(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            Properties properties = Debug.getDebugProperties();
            properties.save(fileOutputStream, "Debug properties");
            fileOutputStream.flush();
            fileOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static synchronized void readDebugProperties(String string) {
        try {
            Properties properties = new Properties(Debug.getDebugProperties());
            FileInputStream fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
            fileInputStream.close();
            append = new Boolean(properties.getProperty("append"));
            assert = new Boolean(properties.getProperty("assert"));
            callDepth = new Integer(properties.getProperty("callDepth"));
            caller = new Boolean(properties.getProperty("caller"));
            debug = new Boolean(properties.getProperty("debug"));
            exitOnAssert = new Boolean(properties.getProperty("exitOnAssert"));
            fixTimeZone = new Boolean(properties.getProperty("fixTimeZone"));
            outputAutoFlush = new Boolean(properties.getProperty("outputAutoFlush"));
            outputToFile = new Boolean(properties.getProperty("outputToFile"));
            outputFile = properties.getProperty("outputFile");
            prefixEachLine = new Boolean(properties.getProperty("prefixEachLine"));
            printHeader = new Boolean(properties.getProperty("printHeader"));
            quiet = new Boolean(properties.getProperty("quiet"));
            systemTimer = new Boolean(properties.getProperty("systemTimer"));
            threads = new Boolean(properties.getProperty("threads"));
            traceInstructions = new Boolean(properties.getProperty("traceInstructions"));
            traceMethods = new Boolean(properties.getProperty("traceMethods"));
            truncate = new Integer(properties.getProperty("truncate"));
            Debug.setDebug(debug);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static synchronized void assert(boolean bl, String string) {
        if (assert && !bl) {
            Debug.printlnOnly("ASSERT FAILURE: " + string);
            if (exitOnAssert) {
                Thread.dumpStack();
                System.exit(-1);
            }
        }
    }

    public static synchronized void traceOff() {
        if (traceInstructions) {
            Runtime.getRuntime().traceInstructions(false);
        }
        if (traceMethods) {
            Runtime.getRuntime().traceMethodCalls(false);
        }
    }

    public static synchronized void traceOn() {
        if (traceInstructions) {
            Runtime.getRuntime().traceInstructions(true);
        }
        if (traceMethods) {
            Runtime.getRuntime().traceMethodCalls(true);
        }
    }

    public static synchronized void traceInstructions(boolean bl) {
        traceInstructions = bl;
        Runtime.getRuntime().traceInstructions(traceInstructions);
    }

    public static synchronized void traceMethods(boolean bl) {
        traceMethods = bl;
        Runtime.getRuntime().traceMethodCalls(traceMethods);
    }

    public static synchronized boolean traceInstructionsOn() {
        return traceInstructions;
    }

    public static synchronized boolean traceMethodsOn() {
        return traceMethods;
    }

    public static synchronized void dumpParents(Class clazz) {
        if (debug) {
            Debug.dumpParents(clazz, padding);
        }
    }

    public static synchronized void dumpParents(Class clazz, int n) {
        if (debug) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(" ");
                ++n2;
            }
            Debug.dumpParents(clazz, stringBuffer.toString());
        }
    }

    public static synchronized void dumpParents(Class clazz, String string) {
        if (debug) {
            Class<?>[] classArray = clazz.getClasses();
            int n = 0;
            while (n < classArray.length) {
                Class<?> clazz2 = classArray[n];
                Debug.printlnOnly(String.valueOf(string) + clazz2.getName());
                Debug.dumpParents(clazz2, String.valueOf(string) + padding);
                ++n;
            }
        }
    }

    public static synchronized void dumpMembers(Class clazz) {
        if (debug) {
            Debug.dumpMembers(clazz, padding);
        }
    }

    public static synchronized void dumpMembers(Class clazz, int n) {
        if (debug) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(" ");
                ++n2;
            }
            Debug.dumpMembers(clazz, stringBuffer.toString());
        }
    }

    public static synchronized void dumpMembers(Class clazz, String string) {
        if (debug) {
            Class<?>[] classArray = clazz.getDeclaredClasses();
            int n = 0;
            while (n < classArray.length) {
                Class<?> clazz2 = classArray[n];
                Debug.printlnOnly(String.valueOf(string) + clazz2.getName());
                Debug.dumpMembers(clazz2, String.valueOf(string) + padding);
                ++n;
            }
        }
    }

    public static synchronized void ignoreException(Throwable throwable) {
        Debug.ignoreException("", throwable);
    }

    public static synchronized void ignoreException(String string, Throwable throwable) {
        if (debug) {
            if (quiet) {
                Debug.ignoreExceptionQuietly(string, throwable);
                return;
            }
            Debug.println("IGNORING EXCEPTION: " + string + ":");
            Debug.dumpException(throwable);
        }
    }

    public static synchronized void ignoreExceptionQuietly(Throwable throwable) {
        Debug.ignoreExceptionQuietly("", throwable);
    }

    public static synchronized void ignoreExceptionQuietly(String string, Throwable throwable) {
        if (debug) {
            Debug.printlnOnly("IGNORING EXCEPTION:" + string + ":");
            Debug.printlnOnly(throwable.toString());
        }
    }

    public static synchronized void printlnBeep(String string) {
        Debug.printlnOnly("\u0007" + string);
    }

    public static synchronized void dumpExceptionAlways(Throwable throwable) {
        Debug.dumpExceptionAlways(throwable, outputAlways);
    }

    public static synchronized void dumpExceptionAlways(Throwable throwable, PrintWriter printWriter) {
        Debug.dumpException(throwable, printWriter, padding, true);
    }

    public static synchronized void dumpException(Throwable throwable) {
        Debug.dumpException(throwable, output);
    }

    public static synchronized void dumpException(Throwable throwable, PrintWriter printWriter) {
        if (debug) {
            Debug.printlnOnly("", printWriter, debug);
            Debug.printlnOnly("---EXCEPTION...", printWriter, debug);
            Debug.dumpException(throwable, printWriter, padding, debug);
        }
    }

    public static synchronized void dumpException(Throwable throwable, PrintWriter printWriter, String string, boolean bl) {
        if (bl) {
            Debug.printStackTrace(string, throwable, printWriter, bl);
            while (throwable != null) {
                if (throwable instanceof HasRootCauses) {
                    Enumeration enumeration = ((HasRootCauses)((Object)throwable)).getRootCauses();
                    if (enumeration.hasMoreElements()) {
                        Debug.printlnOnly(String.valueOf(string) + "Root causes...", printWriter, bl);
                    }
                    while (enumeration.hasMoreElements()) {
                        Debug.dumpException((Throwable)enumeration.nextElement(), printWriter, String.valueOf(string) + padding, bl);
                    }
                }
                if ((throwable = throwable instanceof HasRootCause ? ((HasRootCause)((Object)throwable)).getRootCause() : (throwable instanceof NamingException ? ((NamingException)throwable).getRootCause() : (throwable instanceof RemoteException ? ((RemoteException)throwable).detail : null))) == null) continue;
                Debug.printlnOnly(String.valueOf(string) + "Root cause...", printWriter, bl);
                Debug.printStackTrace(String.valueOf(string) + padding, throwable, printWriter, bl);
            }
            printWriter.flush();
        }
    }

    public static synchronized void printStackTrace(String string, Throwable throwable, PrintWriter printWriter, boolean bl) {
        if (bl) {
            try {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter2 = new PrintWriter((Writer)stringWriter, outputAutoFlush);
                throwable.printStackTrace(printWriter2);
                StringReader stringReader = new StringReader(stringWriter.getBuffer().toString());
                BufferedReader bufferedReader = new BufferedReader(stringReader);
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    Debug.printlnOnly(String.valueOf(string) + string2, printWriter, bl);
                    string2 = bufferedReader.readLine();
                }
                return;
            }
            catch (Throwable throwable2) {
                Debug.ignoreException("Debug.dumpExceptionCaller(" + throwable + "): ", throwable2);
                return;
            }
        }
    }

    public static synchronized void printCaller() {
        Debug.printCaller(callDepth);
    }

    public static synchronized void printCaller(int n) {
        Debug.printCaller(n, output, debug);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized void printCaller(int n, PrintWriter printWriter, boolean bl) {
        if (!bl) return;
        try {
            if (n < 0) {
                n = Integer.MAX_VALUE;
            }
            Vector vector = Debug.getCallerReader();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                if (n <= 0) {
                    return;
                }
                String string = (String)enumeration.nextElement();
                Debug.printlnOnly(string, printWriter, bl);
                --n;
            }
            return;
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    public static synchronized String getCallerLine() {
        Vector vector = Debug.getCallerReader();
        String string = null;
        try {
            string = (String)vector.firstElement();
            if (truncate != 0) {
                int n;
                int n2 = string.indexOf(40);
                n2 = string.lastIndexOf(46, n2);
                int n3 = 0;
                int n4 = truncate;
                do {
                    n = n3 + 1;
                    n3 = string.indexOf(46, n);
                } while (n < n2 && --n4 > 0 && n3 != -1);
                string = string.substring(n);
            } else {
                string = string.substring(4);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            Debug.ignoreException("Debug.getCallerLine(): ", noSuchElementException);
        }
        return string;
    }

    public static synchronized Vector getCallerReader() {
        Vector<String> vector = new Vector<String>();
        try {
            String string;
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter((Writer)stringWriter, outputAutoFlush);
            DebugStackTraceException debugStackTraceException = new DebugStackTraceException();
            debugStackTraceException.fillInStackTrace();
            debugStackTraceException.printStackTrace(printWriter);
            StringReader stringReader = new StringReader(stringWriter.getBuffer().toString());
            BufferedReader bufferedReader = new BufferedReader(stringReader);
            while ((string = bufferedReader.readLine()).indexOf("getCallerReader") == -1) {
            }
            while ((string = bufferedReader.readLine()).indexOf(className) != -1) {
            }
            do {
                vector.addElement(string);
            } while ((string = bufferedReader.readLine()) != null);
        }
        catch (Throwable throwable) {
            Debug.ignoreException("Debug.getCallerReader(): ", throwable);
        }
        return vector;
    }

    public static synchronized void dumpExceptionCaller(Throwable throwable) {
        Debug.dumpExceptionCaller(throwable, 3);
    }

    public static synchronized void dumpExceptionCaller(Throwable throwable, int n) {
        Debug.printlnOnly("Caller: ");
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter((Writer)stringWriter, outputAutoFlush);
            throwable.printStackTrace(printWriter);
            StringReader stringReader = new StringReader(stringWriter.getBuffer().toString());
            BufferedReader bufferedReader = new BufferedReader(stringReader);
            bufferedReader.readLine();
            int n2 = 0;
            while (n2 < n) {
                Debug.printlnOnly(bufferedReader.readLine());
                ++n2;
            }
            return;
        }
        catch (Throwable throwable2) {
            Debug.ignoreException("Debug.dumpExceptionCaller(" + throwable + "): ", throwable2);
            return;
        }
    }

    public static synchronized void dumpThreads() {
        if (debug) {
            Debug.printlnOnly("Current threads:");
            ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
            while (threadGroup.getParent() != null) {
                threadGroup = threadGroup.getParent();
            }
            Thread[] threadArray = new Thread[threadGroup.activeCount()];
            int n = threadGroup.enumerate(threadArray, true);
            int n2 = 0;
            while (n2 < n) {
                Thread thread = threadArray[n2];
                Debug.printlnOnly(padding + thread.getName());
                ++n2;
            }
        }
    }

    public static synchronized String getShortThreadID() {
        String string = "0x" + Integer.toHexString(Thread.currentThread().hashCode());
        return string;
    }

    public static synchronized void print(String string) {
        if (debug) {
            Debug.printlnOnly(string);
        }
    }

    public static synchronized void printlnOnly(String string) {
        if (debug) {
            Debug.printlnOnly(string, output);
        }
    }

    public static void printlnOnly(String string, PrintWriter printWriter) {
        Debug.printlnOnly(string, printWriter, debug);
    }

    public static void printlnOnly(String string, PrintWriter printWriter, boolean bl) {
        if (bl) {
            if (prefixEachLine) {
                string = Debug.buildMsg(string);
            }
            printWriter.println(string);
        }
    }

    public static synchronized void println(String string) {
        if (debug) {
            Debug.println(string, output);
        }
    }

    public static void println(String string, PrintWriter printWriter) {
        Debug.println(string, printWriter, debug);
    }

    public static void updateTimers() {
        long l;
        long l2 = System.currentTimeMillis();
        long l3 = l2 - startTimeMillis;
        if (l3 < 0L) {
            l3 += Long.MAX_VALUE;
        }
        if ((l = l3 - lastElapsed) < 0L) {
            l += Long.MAX_VALUE;
        }
        lastElapsed = l3;
        lastDelta = l;
    }

    public static String buildMsg(String string) {
        if (systemTimer) {
            string = "(e:" + Long.toString(lastElapsed) + ", d:" + Long.toString(lastDelta) + ") " + string;
        }
        if (threads) {
            string = String.valueOf(Thread.currentThread().getName()) + ": " + string;
        }
        if (printHeader && null != header) {
            string = header + string;
        }
        return string;
    }

    public static void println(String string, PrintWriter printWriter, boolean bl) {
        if (bl) {
            Debug.updateTimers();
            if (!prefixEachLine) {
                string = Debug.buildMsg(string);
            }
            if (caller) {
                Debug.printlnOnly(string, printWriter, bl);
                Debug.printCaller(callDepth, printWriter, bl);
            } else {
                Debug.printlnOnly(String.valueOf(Debug.getCallerLine()) + ": " + string, printWriter, bl);
            }
            if (synchOutput) {
                System.err.println(string);
            }
        }
    }

    public static void printAlways(String string) {
        Debug.printlnOnly(string, output, debug);
    }

    public static void printAlways(String string, PrintWriter printWriter) {
        Debug.printlnOnly(string, printWriter, true);
    }

    public static void begin() {
    }

    public static void end() {
    }

    static {
        callDepth = 30;
        outputFile = "debug.out";
        outputAutoFlush = true;
        prefixEachLine = true;
        synchOutput = true;
        oriout = System.out;
        orierr = System.err;
        className = "com.novell.service.session.util.Debug";
        startTimeMillis = System.currentTimeMillis();
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(System.out);
            outputAlways = new PrintWriter((Writer)outputStreamWriter, outputAutoFlush);
            Debug.initFromSystemProperties();
            if (debug) {
                Debug.readDebugProperties("debug.properties");
                Debug.setDebug(debug);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new ExceptionInInitializerError(throwable);
        }
    }
}

