/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.session.xplat;

import com.novell.service.toolkit.jcl.NWLong;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.StringTokenizer;

public class Address
implements Serializable {
    private static final boolean DEBUG = false;
    private static final boolean S_DEBUG = false;
    private static boolean NT_PORT_KLUDGE = true;
    private int type;
    private byte[] address;
    public static final int TYPE_NONE = 0;
    public static final int TYPE_IPX = 1;
    public static final int TYPE_DDP = 3;
    public static final int TYPE_ASP = 4;
    public static final int TYPE_UDP = 8;
    public static final int TYPE_TCP = 9;
    public static final int TYPE_UDP6 = 10;
    public static final int TYPE_TCP6 = 11;
    public static final int TYPE_WILD = 32768;

    public Address(int n, byte[] byArray) {
        this.setAddress(n, byArray);
    }

    public Address(InetAddress inetAddress) {
        this.setAddress(inetAddress);
    }

    public Address(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " =");
        int n = 32768;
        byte[] byArray = new byte[]{};
        if (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n2 = 10;
            if (string2.equals("ipx")) {
                n = 1;
                n2 = 16;
            } else if (string2.equals("ddp")) {
                n = 3;
            } else if (string2.equals("asp")) {
                n = 4;
            } else if (string2.equals("udp")) {
                n = 8;
            } else if (string2.equals("tcp")) {
                n = 9;
            } else if (string2.equals("udp6")) {
                n = 10;
            } else if (string2.equals("tcp6")) {
                n = 11;
            }
            byArray = new byte[stringTokenizer.countTokens()];
            int n3 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                byArray[n3++] = (byte)Short.parseShort(stringTokenizer.nextToken(), n2);
            }
        }
        this.setAddress(n, byArray);
    }

    public synchronized byte[] getAddress() {
        if (this.address == null) {
            return null;
        }
        byte[] byArray = new byte[this.address.length];
        int n = 0;
        while (n < this.address.length) {
            byArray[n] = this.address[n];
            ++n;
        }
        return byArray;
    }

    public synchronized int getType() {
        return this.type;
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized void setAddress(int n, byte[] byArray) {
        block6: {
            block7: {
                this.type = n;
                if (byArray != null) break block7;
                if (this.type == 1) {
                    this.address = new byte[12];
                    break block6;
                } else if (this.type == 9) {
                    this.address = new byte[6];
                    break block6;
                } else {
                    if (this.type != 8) {
                        this.address = null;
                        return;
                    }
                    this.address = new byte[6];
                }
                break block6;
            }
            this.address = new byte[byArray.length];
        }
        int n2 = 0;
        while (n2 < byArray.length) {
            this.address[n2] = byArray[n2];
            ++n2;
        }
    }

    public synchronized void setAddress(InetAddress inetAddress) {
        if (inetAddress == null) {
            throw new NullPointerException("newAddress");
        }
        this.type = 8;
        byte[] byArray = inetAddress.getAddress();
        if (NT_PORT_KLUDGE) {
            this.address[0] = byArray[4];
            this.address[1] = byArray[5];
            this.address[2] = byArray[0];
            this.address[3] = byArray[1];
            this.address[4] = byArray[2];
            this.address[5] = byArray[3];
            return;
        }
        this.address = byArray;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.type == 1) {
            stringBuffer.append("IPX = ");
            if (this.address != null) {
                int n = 0;
                while (n < this.address.length) {
                    long l = NWLong.byteToLong(this.address[n]);
                    stringBuffer.append(this.padWithZero(Long.toString(l, 16), 2));
                    if (n == 3 || n == 9) {
                        stringBuffer.append(':');
                    }
                    ++n;
                }
            }
        } else {
            int n = 10;
            switch (this.type) {
                case 3: {
                    stringBuffer.append("DDP ");
                    break;
                }
                case 4: {
                    stringBuffer.append("ASP ");
                    break;
                }
                case 8: {
                    stringBuffer.append("UDP ");
                    break;
                }
                case 9: {
                    stringBuffer.append("TCP ");
                    break;
                }
                case 10: {
                    stringBuffer.append("UDP6 ");
                    break;
                }
                case 11: {
                    stringBuffer.append("TCP6 ");
                    break;
                }
                default: {
                    stringBuffer.append("UNKNOWN(" + Integer.toString(this.type) + ") ");
                    n = 16;
                }
            }
            if (this.address != null) {
                int n2 = 0;
                while (n2 < this.address.length) {
                    long l = NWLong.byteToLong(this.address[n2]);
                    if (n2 > 0) {
                        stringBuffer.append('.');
                    }
                    stringBuffer.append(Long.toString(l, n));
                    ++n2;
                }
            } else {
                stringBuffer.append("(null)");
            }
        }
        return new String(stringBuffer);
    }

    private String padWithZero(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n - string.length()) {
            stringBuffer.append('0');
            ++n2;
        }
        stringBuffer.append(string);
        return new String(stringBuffer);
    }
}

