/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.session.xplat;

import com.novell.service.session.SessionAttrs;
import com.novell.service.session.SessionException;
import com.novell.service.session.util.Debug;
import com.novell.service.session.xplat.Address;
import com.novell.service.session.xplat.DomainName;
import com.novell.service.session.xplat.Natives;
import com.novell.service.session.xplat.Version;
import com.novell.service.session.xplat.XplatUtil;
import java.io.Serializable;
import java.rmi.server.UID;

public class Connection
implements Serializable {
    private static final boolean DEBUG = false;
    public static boolean DEBUG_FORCE_LOGIN;
    private static final boolean FINALIZER_DEBUG = false;
    private static final boolean I_DEBUG = false;
    private static final boolean S_DEBUG = false;
    private static final boolean JVMUID_DEBUG = false;
    private static final boolean OTHER_DEBUG = false;
    private static final boolean CACHE_DEBUG = false;
    private static final boolean ERROR_ON_DEPRECATED = false;
    private static final String INVALID = "Connection no longer valid";
    protected int reference;
    protected int handle;
    protected boolean isValid = false;
    protected UID uid;
    protected String server;
    protected String tree;
    protected int owner = 0;
    protected int hashCode = -1;
    protected Throwable reason;
    protected Throwable ownerTrace;
    private XplatUtil xplatUtil;
    private boolean forceLicense = false;

    protected void finalize() throws Throwable {
        super.finalize();
        this.xplatUtil.close(this);
    }

    private Connection() throws SessionException {
    }

    protected Connection(int n, int n2, int n3, XplatUtil xplatUtil) throws SessionException {
        this(n, n2, null, null, n3, xplatUtil);
    }

    protected Connection(int n, int n2, String string, String string2, int n3, XplatUtil xplatUtil) throws SessionException {
        this.xplatUtil = xplatUtil;
        this.hashCode = n;
        this.reference = n;
        this.handle = n2;
        if (Natives.isNetWareNLM()) {
            if (DEBUG_FORCE_LOGIN) {
                Debug.println("Connection: " + this);
            }
            if (n2 <= 131072 && n2 >= 65536) {
                this.forceLicense = true;
            }
            if (DEBUG_FORCE_LOGIN) {
                Debug.println("Force = " + this.forceLicense);
            }
        }
        this.setOwner(n3);
        this.server = string;
        this.tree = DomainName.strip(string2);
        this.isValid = true;
        this.reason = null;
    }

    public boolean equals(Object object) {
        return this.xplatUtil.equals(this, (Connection)object);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean forceLicense() {
        return this.forceLicense;
    }

    public void setServer(String string) {
        this.xplatUtil.setServer(this, string);
    }

    public void setTree(String string) {
        this.xplatUtil.setTree(this, string);
    }

    public void checkOwner(int n) throws SessionException {
        this.xplatUtil.checkOwner(this, n);
    }

    public void setOwner(int n) {
        this.xplatUtil.setOwner(this, n);
    }

    public int getOwner() {
        return this.xplatUtil.getOwner(this);
    }

    public String getServer() throws SessionException {
        return this.xplatUtil.getServer(this);
    }

    public String getTree() throws SessionException {
        return this.xplatUtil.getTree(this);
    }

    public String toString() {
        return this.xplatUtil.toString(this);
    }

    public int getReference() throws SessionException {
        return this.xplatUtil.getReference(this);
    }

    public int getHandle() throws SessionException {
        return this.xplatUtil.getHandle(this);
    }

    public void setReason(Throwable throwable) {
        this.xplatUtil.setReason(this, throwable);
    }

    public Throwable getReason() {
        return this.xplatUtil.getReason(this);
    }

    public void keep() throws SessionException {
        this.xplatUtil.keep(this);
    }

    public boolean isValid() {
        return this.xplatUtil.isValid(this);
    }

    public Object getInfo(int n) throws SessionException {
        return this.xplatUtil.getInfo(this, n);
    }

    public int getInfoValue(int n) throws SessionException {
        return this.xplatUtil.getInfoValue(this, n);
    }

    public String getInfoString(int n) throws SessionException {
        return this.xplatUtil.getInfoString(this, n);
    }

    public Address getInfoAddress() throws SessionException {
        return this.xplatUtil.getInfoAddress(this);
    }

    public Address getInfoAddress(int n) throws SessionException {
        return this.xplatUtil.getInfoAddress(this, n);
    }

    public Version getInfoVersion(int n) throws SessionException {
        return this.xplatUtil.getInfoVersion(this, n);
    }

    public void close() throws SessionException {
        this.xplatUtil.close(this);
    }

    public void closeRef() throws SessionException {
        this.xplatUtil.closeRef(this);
    }

    public void login(String string, String string2) throws SessionException {
        this.xplatUtil.login(this, string, string2);
    }

    public void logout() throws SessionException {
        this.xplatUtil.logout(this);
    }

    public String getUserName() throws SessionException {
        return this.xplatUtil.getUserName(this);
    }

    public SessionAttrs getAttributes() throws SessionException {
        return this.xplatUtil.getAttributes(this);
    }

    public SessionAttrs getAttributes(String[] stringArray) throws SessionException {
        return this.xplatUtil.getAttributes(this, stringArray);
    }

    public void changePassword(String string, String string2, String string3) throws SessionException {
        this.xplatUtil.changePassword(this, string, string2, string3);
    }

    public void setPassword(String string, int n, String string2) throws SessionException {
        this.xplatUtil.setPassword(this, string, n, string2);
    }

    public void verifyPassword(String string, int n, String string2) throws SessionException {
        this.xplatUtil.verifyPassword(this, string, n, string2);
    }

    public XplatUtil getUtil() {
        return this.xplatUtil;
    }
}

