/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.session.xplat;

import com.novell.service.jncp.NSIException;
import com.novell.service.security.NdsIdentity;
import com.novell.service.session.InvalidStateException;
import com.novell.service.session.SessionAttrs;
import com.novell.service.session.SessionEnv;
import com.novell.service.session.SessionException;
import com.novell.service.session.xplat.Connection;
import com.novell.service.session.xplat.DomainName;
import com.novell.service.session.xplat.NativeContext;
import com.novell.service.session.xplat.NativeContextDuplicate;
import com.novell.service.session.xplat.Natives;
import com.novell.service.session.xplat.XplatUtil;
import java.io.Serializable;
import java.rmi.server.UID;

public class NDSContext
implements Serializable {
    private static final boolean DEBUG = false;
    private static final boolean FINALIZER_DEBUG = false;
    private static final boolean I_DEBUG = false;
    private static final boolean S_DEBUG = false;
    private static final boolean JVMUID_DEBUG = false;
    private static final boolean PASSWORD_DEBUG = false;
    private static final boolean ERROR_ON_DEPRECATED = false;
    private boolean NLM_KLUDGE_CAN_AUTH = true;
    public NativeContext nativeContext;
    protected boolean hasHandle = false;
    protected UID uid;
    private Throwable reason;
    private XplatUtil xplatUtil;
    private SessionEnv environment;
    private String treeName;

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public NDSContext(NativeContext nativeContext, SessionEnv sessionEnv, XplatUtil xplatUtil) throws SessionException {
        this(nativeContext, sessionEnv, null, xplatUtil);
    }

    public NDSContext(NativeContext nativeContext, SessionEnv sessionEnv, String string, XplatUtil xplatUtil) throws SessionException {
        this.xplatUtil = xplatUtil;
        this.setNativeHandle(nativeContext);
        this.environment = sessionEnv;
        this.treeName = string;
        this.setReason(new SessionException("Context not fully initialized"));
    }

    public SessionEnv getEnvironment() {
        return this.environment;
    }

    public String getTreeNameIfSet() {
        return this.treeName;
    }

    public String getTreeName() throws SessionException {
        if (this.treeName == null) {
            String string = (String)this.getInfo(11);
            this.treeName = DomainName.strip(string);
        }
        return this.treeName;
    }

    public String toString() {
        StringBuffer stringBuffer;
        block5: {
            stringBuffer = new StringBuffer();
            stringBuffer.append("Context$");
            if (this.isValid()) {
                stringBuffer.append(this.nativeContext);
            } else {
                stringBuffer.append(":C=invalid");
            }
            if (!(this.nativeContext instanceof NativeContextDuplicate)) break block5;
            try {
                Connection connection = this.getConnectionIfAvail();
                if (connection != null) {
                    stringBuffer.append(":" + connection.toString());
                }
            }
            catch (SessionException sessionException) {}
        }
        return stringBuffer.toString();
    }

    public NativeContext getNativeHandle() throws SessionException {
        if (this.isValid()) {
            return this.nativeContext;
        }
        throw new InvalidStateException("Context invalid", this.getReason());
    }

    public void setNativeHandle(NativeContext nativeContext) throws SessionException {
        if (this.isValid()) {
            throw new InvalidStateException("Has handle");
        }
        this.nativeContext = nativeContext;
        this.hasHandle = true;
    }

    public int getHandle() throws SessionException {
        if (this.isValid()) {
            return this.nativeContext.contextHandle;
        }
        throw new InvalidStateException("Context invalid", this.getReason());
    }

    public Connection getConnection() throws SessionException {
        if (!this.isValid()) {
            throw new InvalidStateException("Context invalid", this.getReason());
        }
        boolean bl = false;
        Connection connection = null;
        int n = (Integer)this.xplatUtil.getContextInfo(this, 1);
        if ((n & 0x80) == 0) {
            bl = true;
        }
        if (bl) {
            Exception exception = null;
            try {
                connection = this.getConnectionIfAvail();
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            if (connection == null) {
                try {
                    connection = this.xplatUtil.getConnectionByTreeName(this.environment, this.getTreeName(), 2);
                    int n2 = this.xplatUtil.getInfoValue(connection, 3);
                    try {
                        int n3 = Natives.openConnection(n2);
                        this.xplatUtil.setContextInfo(this, 8, new Integer(n3));
                    }
                    catch (NSIException nSIException) {
                        this.xplatUtil.close(connection);
                        this.xplatUtil.setReason(connection, nSIException);
                    }
                }
                catch (Exception exception3) {}
            }
            if (connection == null) {
                throw this.xplatUtil.generateContextFailure(this, new SessionException("Lost all connections to tree"));
            }
        } else {
            try {
                connection = this.getConnectionIfAvail();
            }
            catch (Exception exception) {
                throw this.xplatUtil.generateContextFailure(this, exception);
            }
        }
        return connection;
    }

    public Connection getConnectionIfAvail() throws SessionException {
        if (this.isValid()) {
            return this.xplatUtil.getConnectionIfAvail(this);
        }
        throw new InvalidStateException("Context invalid", this.getReason());
    }

    public boolean isValid() {
        return this.hasHandle;
    }

    public Object getInfo(int n) throws SessionException {
        return this.xplatUtil.getContextInfo(this, n);
    }

    public void setInfo(int n, Object object) throws SessionException {
        this.xplatUtil.setContextInfo(this, n, object);
    }

    public void close() throws SessionException {
        try {
            NDSContext nDSContext = this;
            synchronized (nDSContext) {
                if (this.isValid()) {
                    this.hasHandle = false;
                    this.nativeContext.close();
                }
            }
            Object var2_2 = null;
            this.setReason(new SessionException("Context closed"));
            return;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.setReason(new SessionException("Context closed"));
            throw throwable;
        }
    }

    public void login(String string, String string2, boolean bl) throws SessionException {
        this.xplatUtil.loginContext(this, this.manipulateNDSName(string), string2, bl);
    }

    public void loginNAS(NdsIdentity ndsIdentity, String string, String string2, boolean bl) throws SessionException {
        this.xplatUtil.loginContextNAS(this, ndsIdentity, this.manipulateNDSName(string), string2, bl);
    }

    public void loginAsService(String string) throws SessionException {
        this.xplatUtil.loginAsServiceContext(this, this.manipulateNDSName(string));
    }

    public void logout() throws SessionException {
        this.xplatUtil.logoutContext(this);
    }

    public void logoutNAS(NdsIdentity ndsIdentity) throws SessionException {
        this.xplatUtil.logoutContextNAS(this, ndsIdentity);
    }

    public boolean isAuthenticated() throws SessionException {
        boolean bl = false;
        bl = this.NLM_KLUDGE_CAN_AUTH ? this.xplatUtil.specialIsDSAuthenticated(this) : this.xplatUtil.canDSAuthenticate(this);
        return bl;
    }

    public SessionAttrs getAttributes() throws SessionException {
        String[] stringArray = new String[6];
        int n = 0;
        stringArray[n++] = "DCK_CONFIDENCE";
        stringArray[n++] = "DCK_NAME_CONTEXT";
        stringArray[n++] = "DCK_TRANSPORT_TYPE";
        stringArray[n++] = "DCK_REFERRAL_SCOPE";
        stringArray[n++] = "DCK_LAST_CONNECTION";
        stringArray[n++] = "DCK_TREE_NAME";
        SessionAttrs sessionAttrs = this.getAttributes(stringArray);
        return sessionAttrs;
    }

    public SessionAttrs getAttributes(String[] stringArray) throws SessionException {
        SessionAttrs sessionAttrs = new SessionAttrs();
        int n = 0;
        while (n < stringArray.length) {
            int n2 = Natives.contextIntForAttr(stringArray[n]);
            try {
                switch (n2) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 8: 
                    case 11: {
                        Object object = this.getInfo(n2);
                        sessionAttrs.add(stringArray[n], object);
                        break;
                    }
                    default: {
                        Object object = null;
                        break;
                    }
                }
            }
            catch (NSIException nSIException) {
                // empty catch block
            }
            ++n;
        }
        return sessionAttrs;
    }

    public void authenticate() throws SessionException {
        this.authenticate(this.getConnection());
    }

    public void authenticate(Connection connection) throws SessionException {
        this.xplatUtil.authenticateConn(this, connection);
    }

    public NDSContext duplicate() throws SessionException {
        return this.xplatUtil.duplicateContext(this);
    }

    public NDSContext duplicate(SessionEnv sessionEnv, Connection connection) throws SessionException {
        return this.xplatUtil.duplicateContext(this, sessionEnv, connection);
    }

    public String getName() throws SessionException {
        return this.xplatUtil.getContextName(this);
    }

    public void changePassword(String string, String string2, String string3, boolean bl) throws SessionException {
        this.xplatUtil.changePasswordContext(this, this.manipulateNDSName(string), string2, string3, bl);
    }

    public void setPassword(String string, String string2, boolean bl) throws SessionException {
        this.xplatUtil.setPasswordContext(this, string, string2, bl);
    }

    public void verifyPassword(String string, String string2, boolean bl) throws SessionException {
        this.xplatUtil.verifyPasswordContext(this, string, string2, bl);
    }

    public void ping() throws SessionException {
        this.xplatUtil.contextPing(this);
    }

    private String manipulateNDSName(String string) {
        if (string.length() == 0) {
            string = new String("[root]");
        } else if (string.charAt(0) == '.') {
            string = string.substring(1);
        }
        return string;
    }

    protected void setReason(Throwable throwable) {
        this.reason = throwable;
    }

    protected Throwable getReason() {
        return this.reason;
    }

    public Integer getDSNLMBuild() throws SessionException {
        return this.xplatUtil.getDSNLMBuild(this);
    }

    public Integer getDSServerRootDepth() throws SessionException {
        return this.xplatUtil.getDSServerRootDepth(this);
    }

    public Boolean isMasterReplica() throws SessionException {
        return this.xplatUtil.isMasterReplica(this);
    }

    public String getServerDN() throws SessionException {
        return this.xplatUtil.getServerDN(this);
    }
}

