/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.session.xplat;

import com.novell.service.jncp.ClientException;
import com.novell.service.jncp.NSIException;
import com.novell.service.jncp.ServerRequesterException;
import com.novell.service.security.NdsIdentity;
import com.novell.service.session.InvalidDomainNameException;
import com.novell.service.session.InvalidStateException;
import com.novell.service.session.InvalidUserNameException;
import com.novell.service.session.SessionAttrs;
import com.novell.service.session.SessionEnv;
import com.novell.service.session.SessionException;
import com.novell.service.session.SessionRuntimeException;
import com.novell.service.session.spi.SessionManagerImpl;
import com.novell.service.session.util.Debug;
import com.novell.service.session.util.TwoWayHashtable;
import com.novell.service.session.xplat.Address;
import com.novell.service.session.xplat.Connection;
import com.novell.service.session.xplat.ConnectionEnumerator;
import com.novell.service.session.xplat.ConnectionSearchEnumerator;
import com.novell.service.session.xplat.Connections;
import com.novell.service.session.xplat.DomainName;
import com.novell.service.session.xplat.NDSContext;
import com.novell.service.session.xplat.NativeContext;
import com.novell.service.session.xplat.NativeContextDuplicate;
import com.novell.service.session.xplat.NativeContextMaster;
import com.novell.service.session.xplat.NativeContexts;
import com.novell.service.session.xplat.Natives;
import com.novell.service.session.xplat.NotConnectionOwnerException;
import com.novell.service.session.xplat.ServerTreeMismatchException;
import com.novell.service.session.xplat.Version;
import com.novell.service.toolkit.jcl.NWLong;
import com.novell.service.toolkit.jcl.NWVersion;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;

public class XplatUtil {
    private static final boolean DEBUG = false;
    private static final boolean FINALIZER_DEBUG = false;
    private static final boolean ENTRY_DEBUG = false;
    private static final boolean EXIT_DEBUG = false;
    private static final boolean OPEN_CLOSE_CONN_DEBUG = false;
    private static final boolean I_DEBUG = false;
    private static final boolean S_DEBUG = false;
    private static final boolean CACHE_DEBUG = false;
    private static final boolean JVMUID_DEBUG = false;
    private static final boolean OTHER_DEBUG = false;
    private static final boolean ERROR_ON_DEPRECATED = false;
    private static final String INVALID_CONNECTION = "Connection no longer valid";
    private static final String INVALID_CONTEXT = "Context no longer valid";
    private static boolean NLM_KLUDGE_NO_TREE_FROM_REF = true;
    private static boolean NLM_KLUDGE_NO_USER_FROM_REF = true;
    private static boolean NT_KLUDGE = true;
    private static boolean NLM_KLUDGE_BADTREE = true;
    private static boolean NLM_KLUDGE_BADSERVER = true;
    private static boolean C32_KLUDGE_FORCE_CLOSED = true;
    static boolean CREATE_CONTEXT_CHECK_TREE = true;
    static boolean CREATE_CONTEXT_GIVE_CONN = true;
    static boolean CREATE_CONTEXT_PUT_CACHE;
    private static XplatUtil singletonInstance;
    private static Hashtable privateInstances;
    private static TwoWayHashtable connInfo;
    private static TwoWayHashtable contextInfo;
    private Connections connectionCache = new Connections();
    public NativeContexts nativeContexts;
    public int scope;

    protected void finalize() throws Throwable {
        this.shutDown();
        super.finalize();
    }

    protected void classFinalize() throws Throwable {
    }

    private XplatUtil(int n) throws SessionException {
        this.scope = n;
        this.nativeContexts = new NativeContexts();
        this.connectionCache = new Connections();
    }

    public static XplatUtil getInstance(SessionManagerImpl sessionManagerImpl) {
        int n = sessionManagerImpl.getScope();
        if ((n & 0x10000000) == 0) {
            return XplatUtil.getPublicInstance(sessionManagerImpl);
        }
        return XplatUtil.getPrivateInstance(sessionManagerImpl);
    }

    public static XplatUtil getPublicInstance(SessionManagerImpl sessionManagerImpl) {
        if (singletonInstance == null) {
            try {
                singletonInstance = new XplatUtil(sessionManagerImpl.getScope());
                singletonInstance.getConnectionDefault();
            }
            catch (SessionException sessionException) {
                throw new SessionRuntimeException("Caught exception", sessionException);
            }
        }
        return singletonInstance;
    }

    public static XplatUtil getPrivateInstance(SessionManagerImpl sessionManagerImpl) {
        XplatUtil xplatUtil;
        Hashtable hashtable = privateInstances;
        synchronized (hashtable) {
            xplatUtil = (XplatUtil)privateInstances.get(sessionManagerImpl.getUID());
            if (xplatUtil == null) {
                try {
                    xplatUtil = new XplatUtil(sessionManagerImpl.getScope());
                    privateInstances.put(sessionManagerImpl.getUID(), xplatUtil);
                    xplatUtil.getConnectionDefault();
                }
                catch (SessionException sessionException) {
                    throw new SessionRuntimeException("Caught exception", sessionException);
                }
            }
        }
        return xplatUtil;
    }

    public static void freePrivateInstance(SessionManagerImpl sessionManagerImpl) {
        Hashtable hashtable = privateInstances;
        synchronized (hashtable) {
            privateInstances.remove(sessionManagerImpl.getUID());
            return;
        }
    }

    public void shutDown() {
        Object object;
        int n;
        Enumeration enumeration;
        Object[] objectArray;
        int n2;
        try {
            n2 = this.nativeContexts.size();
            objectArray = new NativeContext[n2];
            enumeration = this.nativeContexts.nativeContexts();
            n = 0;
            while (enumeration.hasMoreElements()) {
                objectArray[n++] = (NativeContext)enumeration.nextElement();
            }
            n = 0;
            while (n < n2) {
                object = objectArray[n];
                try {
                    ((NativeContext)object).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            n2 = this.connectionCache.size();
            objectArray = new Connection[n2];
            enumeration = this.connectionCache.elements();
            n = 0;
            while (enumeration.hasMoreElements()) {
                objectArray[n++] = (Connection)enumeration.nextElement();
            }
            n = 0;
            while (n < n2) {
                object = objectArray[n];
                try {
                    this.close((Connection)object);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n;
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public boolean equals(Connection connection, Connection connection2) {
        return connection.reference == connection2.reference;
    }

    public void setServer(Connection connection, String string) {
        connection.server = string;
    }

    public void setTree(Connection connection, String string) {
        connection.tree = DomainName.strip(string);
    }

    public void checkOwner(Connection connection, int n) throws SessionException {
        try {
            int n2 = Natives.getConnInfoLong(connection.handle, connection.reference, 1);
            if (n2 == 2) {
                this.setOwner(connection, 2);
                return;
            }
            if (n2 == 1) {
                this.setOwner(connection, 1);
                return;
            }
            if (connection.owner == 0) {
                if (n == 2) {
                    int n3 = Natives.getConnInfoLong(connection.handle, connection.reference, 8);
                    if (n3 == 1) {
                        this.setOwner(connection, n);
                        return;
                    }
                } else {
                    this.setOwner(connection, n);
                }
                return;
            }
        }
        catch (SessionException sessionException) {
            throw this.invalidate(connection, sessionException);
        }
    }

    public void setOwner(Connection connection, int n) {
        connection.owner = n;
        connection.ownerTrace = new SessionException("Connection ownership trace");
    }

    public int getOwner(Connection connection) {
        return connection.owner;
    }

    public String getServer(Connection connection) throws SessionException {
        if (connection.server == null) {
            try {
                if (connection.server == null) {
                    connection.server = Natives.getConnInfoString(connection.handle, connection.reference, 7);
                    if (connection.server == null) {
                        throw new SessionException("Unable to obtain server name from reference: " + connection.reference);
                    }
                }
            }
            catch (SessionException sessionException) {
                throw this.invalidate(connection, sessionException);
            }
        }
        return connection.server;
    }

    public String getTree(Connection connection) throws SessionException {
        if (connection.tree == null) {
            try {
                if (connection.tree == null) {
                    this.setTree(connection, Natives.getConnInfoString(connection.handle, connection.reference, 4));
                    if (connection.tree == null) {
                        if (this.getInfoValue(connection, 8) == 1) {
                            throw new SessionException("Unable to obtain tree name from reference: " + connection.reference);
                        }
                        connection.tree = "";
                    }
                }
            }
            catch (SessionException sessionException) {
                throw this.invalidate(connection, sessionException);
            }
        }
        return connection.tree;
    }

    public String toString(Connection connection) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Connection$");
        if (connection.isValid) {
            stringBuffer.append(":H=0x" + Integer.toHexString(connection.handle));
            stringBuffer.append(":R=0x" + Integer.toHexString(connection.reference));
            stringBuffer.append(":O=" + Natives.getOwnerString(connection.owner));
            if (connection.server != null) {
                stringBuffer.append(":server=" + connection.server);
            }
            if (connection.tree != null) {
                stringBuffer.append(":tree=" + connection.tree);
            }
        } else {
            stringBuffer.append(":R=invalid");
        }
        return stringBuffer.toString();
    }

    public int getReference(Connection connection) throws SessionException {
        if (!connection.isValid) {
            throw new InvalidStateException(INVALID_CONNECTION, this.getReason(connection));
        }
        return connection.reference;
    }

    public int getHandle(Connection connection) throws SessionException {
        if (!connection.isValid) {
            throw new InvalidStateException(INVALID_CONNECTION, this.getReason(connection));
        }
        return connection.handle;
    }

    public void setReason(Connection connection, Throwable throwable) {
        connection.reason = throwable;
    }

    public Throwable getReason(Connection connection) {
        return connection.reason;
    }

    public SessionException invalidate(Connection connection, Throwable throwable) throws SessionException {
        if (connection.isValid) {
            try {
                this.close(connection);
            }
            catch (Exception exception) {}
            SessionException sessionException = new SessionException("Connection (Tree:" + connection.tree + " Server:" + connection.server + ") invalidated - (" + throwable + ")", throwable);
            this.setReason(connection, sessionException);
        }
        return new InvalidStateException(INVALID_CONNECTION, this.getReason(connection));
    }

    public void keep(Connection connection) throws SessionException {
        try {
            Natives.keep(connection.handle);
            return;
        }
        catch (SessionException sessionException) {
            throw this.invalidate(connection, sessionException);
        }
    }

    public boolean isValid(Connection connection) {
        return connection.isValid;
    }

    public Object getInfo(Connection connection, int n) throws SessionException {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return new Integer(this.getInfoValue(connection, n));
            }
            case 4: 
            case 7: {
                return this.getInfoString(connection, n);
            }
            case 12: {
                return this.getInfoVersion(connection, n);
            }
            case 65281: {
                return this.getInfoAddress(connection, n);
            }
        }
        throw new SessionException("infoLevel invalid: 0x" + Integer.toHexString(n));
    }

    public int getInfoValue(Connection connection, int n) throws SessionException {
        int n2;
        try {
            n2 = Natives.getConnInfoLong(connection.handle, connection.reference, n);
        }
        catch (Exception exception) {
            throw this.invalidate(connection, exception);
        }
        return n2;
    }

    public String getInfoString(Connection connection, int n) throws SessionException {
        String string = "";
        switch (n) {
            case 7: {
                string = this.getServer(connection);
                break;
            }
            case 4: {
                string = this.getTree(connection);
                break;
            }
            default: {
                try {
                    string = Natives.getConnInfoString(connection.handle, connection.reference, n);
                    break;
                }
                catch (SessionException sessionException) {
                    throw this.invalidate(connection, sessionException);
                }
            }
        }
        return string;
    }

    public Address getInfoAddress(Connection connection) throws SessionException {
        return this.getInfoAddress(connection, 0);
    }

    public Address getInfoAddress(Connection connection, int n) throws SessionException {
        try {
            return Natives.getConnInfoAddress(connection.handle, connection.reference, n);
        }
        catch (SessionException sessionException) {
            throw this.invalidate(connection, sessionException);
        }
    }

    public Version getInfoVersion(Connection connection, int n) throws SessionException {
        try {
            return Natives.getConnInfoVersion(connection.handle, connection.reference, n);
        }
        catch (SessionException sessionException) {
            throw this.invalidate(connection, sessionException);
        }
    }

    public void close(Connection connection) throws SessionException {
        Connection connection2 = connection;
        synchronized (connection2) {
            block5: {
                try {
                    if (!connection.isValid) break block5;
                    connection.reason = new SessionException("Connection closed");
                    this.removeConnection(connection);
                    Natives.closeConnection(connection.handle);
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    connection.isValid = false;
                    throw throwable;
                }
            }
            Object var5_3 = null;
            connection.isValid = false;
            return;
        }
    }

    public void closeRef(Connection connection) throws SessionException {
        block2: {
            try {
                if (!connection.isValid) break block2;
                connection.reason = new SessionException("Connection reference closed");
                this.removeConnection(connection);
                Natives.closeRef(connection.reference);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                connection.isValid = false;
                throw throwable;
            }
        }
        Object var3_2 = null;
        connection.isValid = false;
    }

    public void login(Connection connection, String string, String string2) throws SessionException {
        try {
            if (string == null) {
                throw new NullPointerException(string);
            }
            Natives.loginConnection(connection.handle, string, string2);
            return;
        }
        catch (InvalidUserNameException invalidUserNameException) {
            throw invalidUserNameException;
        }
        catch (SessionException sessionException) {
            throw this.invalidate(connection, sessionException);
        }
    }

    public void logout(Connection connection) throws SessionException {
        try {
            Natives.logoutConnection(connection.handle);
            return;
        }
        catch (SessionException sessionException) {
            throw this.invalidate(connection, sessionException);
        }
    }

    public String getUserName(Connection connection) throws SessionException {
        Integer n = new Integer(this.getInfoValue(connection, 6));
        try {
            if (n != null && n != 0) {
                return Natives.getUserName(connection.handle, n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public SessionAttrs getAttributes(Connection connection) throws SessionException {
        String[] stringArray = new String[]{"CONN_AUTHENT_STATE", "CONN_BROADCAST_STATE", "CONN_REFERENCE", "CONN_TREE_NAME", "CONN_NUMBER", "CONN_USER_ID", "CONN_SERVER_NAME", "CONN_NDS_STATE", "CONN_MAX_PACKET_SIZE", "CONN_LICENSE_STATE", "CONN_DISTANCE", "CONN_SERVER_VERSION", "CONN_SERVER_ADDRESS"};
        SessionAttrs sessionAttrs = this.getAttributes(connection, stringArray);
        return sessionAttrs;
    }

    public SessionAttrs getAttributes(Connection connection, String[] stringArray) throws SessionException {
        try {
            SessionAttrs sessionAttrs = new SessionAttrs();
            int n = 0;
            while (n < stringArray.length) {
                int n2 = Natives.connIntForAttr(stringArray[n]);
                try {
                    Object object;
                    switch (n2) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 5: 
                        case 6: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: {
                            object = new Integer(this.getInfoValue(connection, n2));
                            break;
                        }
                        case 4: 
                        case 7: {
                            object = this.getInfoString(connection, n2);
                            break;
                        }
                        case 65281: {
                            object = this.getInfoAddress(connection);
                            break;
                        }
                        case 12: {
                            object = this.getInfoVersion(connection, n2);
                            break;
                        }
                        default: {
                            object = null;
                        }
                    }
                    if (object != null) {
                        sessionAttrs.add(stringArray[n], object);
                    }
                }
                catch (NSIException nSIException) {
                    // empty catch block
                }
                ++n;
            }
            return sessionAttrs;
        }
        catch (SessionException sessionException) {
            throw this.invalidate(connection, sessionException);
        }
    }

    public void changePassword(Connection connection, String string, String string2, String string3) throws SessionException {
        try {
            Natives.changePasswordConnection(connection.handle, string, string2, string3);
            return;
        }
        catch (SessionException sessionException) {
            throw this.invalidate(connection, sessionException);
        }
    }

    public void setPassword(Connection connection, String string, int n, String string2) throws SessionException {
        try {
            Natives.setPasswordConnection(connection.handle, string, n, string2);
            return;
        }
        catch (SessionException sessionException) {
            throw this.invalidate(connection, sessionException);
        }
    }

    public void verifyPassword(Connection connection, String string, int n, String string2) throws SessionException {
        try {
            Natives.verifyPasswordConnection(connection.handle, string, n, string2);
            return;
        }
        catch (SessionException sessionException) {
            throw this.invalidate(connection, sessionException);
        }
    }

    private ConnectionEnumerator enumerateCachedConnectionsWithLock() throws SessionException {
        return new ConnectionEnumerator(this.getCachedConnectionsWithLock());
    }

    private Connections getCachedConnectionsWithLock() throws SessionException {
        return this.connectionCache;
    }

    private void updateConnectionCache() throws SessionException {
        if ((this.scope & 0x20000000) == 0) {
            int n;
            Object object;
            Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
            RequesterConnectionSearchEnumerator requesterConnectionSearchEnumerator = this.enumerateRequesterInfo(0, 0);
            while (requesterConnectionSearchEnumerator.hasMoreElements()) {
                try {
                    object = requesterConnectionSearchEnumerator.next();
                    if (!this.connectionCache.containsKey((Integer)object)) {
                        int n2 = (Integer)object;
                        n = Natives.openConnection(n2);
                        this.addConnection(n2, n, 0);
                    }
                    hashtable.put(object, object);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            object = this.connectionCache.elements();
            while (((ConnectionEnumerator)object).hasMoreElements()) {
                Connection connection = ((ConnectionEnumerator)object).next();
                n = 0;
                n = this.getReference(connection);
                Integer n3 = new Integer(n);
                if (hashtable.containsKey(n3)) {
                    hashtable.remove(n3);
                    continue;
                }
                try {
                    this.removeConnection(connection);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void removeConnection(Connection connection) throws SessionException {
        Connection connection2 = connection;
        synchronized (connection2) {
            this.connectionCache.remove(connection);
            return;
        }
    }

    private Connection addConnection(int n, int n2, int n3) throws SessionException {
        Connection connection = null;
        connection = new Connection(n, n2, n3, this);
        this.connectionCache.put(connection);
        return connection;
    }

    public ConnectionEnumerator enumerateBinderyConnections() throws SessionException {
        return this.getBinderyConnections().elements();
    }

    public Connections getBinderyConnections() throws SessionException {
        Connections connections = new Connections();
        this.updateConnectionCache();
        ConnectionEnumerator connectionEnumerator = this.enumerateCachedConnectionsWithLock();
        while (connectionEnumerator.hasMoreElements()) {
            Connection connection = connectionEnumerator.next();
            try {
                this.checkOwner(connection, 1);
                if (this.getOwner(connection) != 1) continue;
                connections.put(connection);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return connections;
    }

    public ConnectionEnumerator enumerateTreeConnections(String string) throws SessionException {
        return this.getTreeConnections(string).elements();
    }

    public Connections getTreeConnections(String string) throws SessionException {
        Connections connections = new Connections();
        this.updateConnectionCache();
        ConnectionEnumerator connectionEnumerator = this.enumerateCachedConnectionsWithLock();
        while (connectionEnumerator.hasMoreElements()) {
            Connection connection = connectionEnumerator.next();
            try {
                String string2;
                this.checkOwner(connection, 2);
                if (this.getOwner(connection) != 2 || !(string2 = this.getTree(connection)).equals(string)) continue;
                connections.put(connection);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return connections;
    }

    public Enumeration enumerateTrees() throws SessionException {
        return this.getTrees().elements();
    }

    public Hashtable getTrees() throws SessionException {
        String string;
        Object object;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        this.updateConnectionCache();
        SessionAttrs sessionAttrs = new SessionAttrs();
        sessionAttrs.add("CONN_NDS_STATE", new Integer(1));
        ConnectionSearchEnumerator connectionSearchEnumerator = new ConnectionSearchEnumerator(sessionAttrs, this.connectionCache);
        while (connectionSearchEnumerator.hasMoreElements()) {
            try {
                object = connectionSearchEnumerator.next();
                string = this.getTree((Connection)object);
                if (hashtable.contains(string)) continue;
                hashtable.put(string, string);
            }
            catch (SessionException sessionException) {
                // empty catch block
            }
        }
        object = this.nativeContexts.trees();
        while (object.hasMoreElements()) {
            string = (String)object.nextElement();
            if (hashtable.contains(string)) continue;
            hashtable.put(string, string);
        }
        return hashtable;
    }

    private int getLookupHandle(SessionEnv sessionEnv) throws SessionException {
        String string = null;
        Object object = sessionEnv.get("com.novell.service.session.xplat.LookupDomain");
        if (object != null) {
            string = (String)object;
        }
        return this.getHandleFromName(string);
    }

    private int getHandleFromName(String string) throws SessionException {
        int n = -1;
        if (string != null) {
            this.updateConnectionCache();
            SessionAttrs sessionAttrs = new SessionAttrs();
            sessionAttrs.add("CONN_SERVER_NAME", string);
            ConnectionSearchEnumerator connectionSearchEnumerator = new ConnectionSearchEnumerator(sessionAttrs, this.connectionCache);
            if (connectionSearchEnumerator.hasMoreElements()) {
                Connection connection = null;
                try {
                    connection = connectionSearchEnumerator.next();
                    n = Natives.getConnInfoLong(0, this.getReference(connection), 7);
                }
                catch (SessionException sessionException) {
                    throw this.invalidate(connection, sessionException);
                }
            }
        }
        return n;
    }

    public Connection getConnectionFromHandle(int n, int n2) throws SessionException {
        int n3 = Natives.getConnInfoLong(n, 0, 3);
        Connection connection = this.connectionCache.get(n3);
        if (connection == null) {
            int n4 = Natives.openConnection(n3);
            connection = this.addConnection(n3, n4, n2);
        }
        return connection;
    }

    public RequesterConnectionSearchEnumerator enumerateRequesterInfo(int n, String string) throws SessionException {
        return new RequesterConnectionSearchEnumerator(n, string);
    }

    public RequesterConnectionSearchEnumerator enumerateRequesterInfo(int n, int n2) throws SessionException {
        return new RequesterConnectionSearchEnumerator(n, n2);
    }

    public RequesterConnectionSearchEnumerator enumerateRequesterInfo(int n, Version version) throws SessionException {
        new NWVersion(version.majorVersion, version.minorVersion, version.revision);
        return new RequesterConnectionSearchEnumerator(n, version);
    }

    private String getString(Object object) {
        if (object instanceof Integer) {
            int n = (Integer)object;
            return "0x" + Integer.toHexString(n) + "(" + n + ")";
        }
        if (object instanceof Version) {
            Version version = (Version)object;
            return String.valueOf(Long.toString(version.majorVersion)) + "." + Long.toString(version.minorVersion) + "." + Long.toString(version.revision);
        }
        return object.toString();
    }

    protected String getOwnerString(int n) {
        switch (n) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "BINDERY";
            }
            case 2: {
                return "NDS";
            }
        }
        return "UNKNOWN";
    }

    public Connection getConnectionDefault() throws SessionException {
        Connection connection = null;
        this.updateConnectionCache();
        connection = this.findConnectionDefault();
        if (connection == null) {
            connection = this.openConnectionDefault();
        }
        return connection;
    }

    private Connection findConnectionDefault() throws SessionException {
        Connection connection = null;
        try {
            ConnectionEnumerator connectionEnumerator = this.enumerateCachedConnectionsWithLock();
            if (connectionEnumerator.hasMoreElements()) {
                connection = connectionEnumerator.next();
            }
        }
        catch (Exception exception) {
            throw new SessionRuntimeException("Unable to obtain default connection", exception);
        }
        return connection;
    }

    private Connection openConnectionDefault() throws SessionException {
        Connection connection = null;
        try {
            int n = Natives.openConnection();
            int n2 = Natives.getConnectionReference(n);
            connection = this.addConnection(n2, n, 0);
        }
        catch (Exception exception) {
            throw new SessionRuntimeException("Unable to obtain default connection", exception);
        }
        return connection;
    }

    public Connection getConnectionByName(SessionEnv sessionEnv, String string, int n) throws SessionException {
        Connection connection = null;
        this.updateConnectionCache();
        connection = this.findConnectionByName(sessionEnv, string, n);
        if (connection == null) {
            connection = this.openConnectionByName(sessionEnv, string, n);
        }
        return connection;
    }

    private Connection findConnectionByName(SessionEnv sessionEnv, String string, int n) throws SessionException {
        Connection connection = null;
        try {
            SessionAttrs sessionAttrs = new SessionAttrs();
            sessionAttrs.add("CONN_SERVER_NAME", string);
            ConnectionSearchEnumerator connectionSearchEnumerator = new ConnectionSearchEnumerator(sessionAttrs, this.connectionCache);
            if (connectionSearchEnumerator.hasMoreElements()) {
                connection = connectionSearchEnumerator.next();
                if (this.getOwner(connection) == 0) {
                    this.setOwner(connection, n);
                }
                if (this.getOwner(connection) != n) {
                    throw new NotConnectionOwnerException(this.toString(connection), connection.ownerTrace);
                }
            }
        }
        catch (Exception exception) {
            throw new InvalidDomainNameException(string, exception);
        }
        return connection;
    }

    private Connection openConnectionByName(SessionEnv sessionEnv, String string, int n) throws SessionException {
        Connection connection = null;
        int n2 = 2;
        int n3 = 1;
        try {
            int n4 = Natives.openConnection((Address)sessionEnv.get("com.novell.service.session.xplat.DomainAddress"), this.getLookupHandle(sessionEnv), string, n2, n3);
            int n5 = Natives.getConnectionReference(n4);
            connection = this.addConnection(n5, n4, n);
        }
        catch (Exception exception) {
            throw new InvalidDomainNameException(string, exception);
        }
        return connection;
    }

    public Connection getConnectionByName(SessionEnv sessionEnv, String string, String string2, int n) throws SessionException {
        Connection connection = null;
        this.updateConnectionCache();
        connection = this.findConnectionByName(sessionEnv, string, string2, n);
        if (connection == null) {
            connection = this.openConnectionByName(sessionEnv, string, string2, n);
        }
        return connection;
    }

    public Connection findConnectionByName(SessionEnv sessionEnv, String string, String string2, int n) throws SessionException {
        Connection connection = null;
        string = DomainName.strip(string);
        try {
            SessionAttrs sessionAttrs = new SessionAttrs();
            sessionAttrs.add("CONN_SERVER_NAME", string2);
            ConnectionSearchEnumerator connectionSearchEnumerator = new ConnectionSearchEnumerator(sessionAttrs, this.connectionCache);
            if (connectionSearchEnumerator.hasMoreElements()) {
                connection = connectionSearchEnumerator.next();
                if (this.getOwner(connection) == 0) {
                    this.setOwner(connection, n);
                }
                if (this.getOwner(connection) != n) {
                    throw new NotConnectionOwnerException(this.toString(connection), connection.ownerTrace);
                }
                String string3 = this.getTree(connection);
                if (!string3.equals(string)) {
                    throw new ServerTreeMismatchException(string2, string, string3);
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new InvalidDomainNameException(string2, noSuchElementException);
        }
        return connection;
    }

    private Connection openConnectionByName(SessionEnv sessionEnv, String string, String string2, int n) throws SessionException {
        Connection connection = null;
        int n2 = 2;
        int n3 = 1;
        string = DomainName.strip(string);
        try {
            int n4 = Natives.openConnection((Address)sessionEnv.get("com.novell.service.session.xplat.DomainAddress"), this.getLookupHandle(sessionEnv), string2, n2, n3);
            String string3 = Natives.getConnInfoString(n4, 0, 4);
            if (!string3.equals(string)) {
                if (C32_KLUDGE_FORCE_CLOSED) {
                    Natives.closeRefByHandle(n4);
                } else {
                    Natives.closeConnection(n4);
                }
                throw new ServerTreeMismatchException(string2, string, string3);
            }
            int n5 = Natives.getConnectionReference(n4);
            connection = this.addConnection(n5, n4, n);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new InvalidDomainNameException(string2, noSuchElementException);
        }
        return connection;
    }

    public Connection getConnectionByName(String string, NDSContext nDSContext, String string2, int n) throws SessionException {
        Connection connection = null;
        this.updateConnectionCache();
        connection = this.findConnectionByName(string, nDSContext, string2, n);
        if (connection == null) {
            connection = this.openConnectionByName(string, nDSContext, string2, n);
        }
        return connection;
    }

    public Connection findConnectionByName(String string, NDSContext nDSContext, String string2, int n) throws SessionException {
        Object object;
        Object object2;
        Connection connection = null;
        String string3 = DomainName.stripQualifiers(string2);
        try {
            object2 = new SessionAttrs();
            ((SessionAttrs)object2).add("CONN_SERVER_NAME", string3);
            object = new ConnectionSearchEnumerator((SessionAttrs)object2, this.connectionCache);
            if (((ConnectionSearchEnumerator)object).hasMoreElements()) {
                connection = ((ConnectionEnumerator)object).next();
                if (this.getOwner(connection) == 0) {
                    this.setOwner(connection, n);
                }
                if (this.getOwner(connection) != n) {
                    throw new NotConnectionOwnerException(this.toString(connection), connection.ownerTrace);
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new InvalidDomainNameException(string2, noSuchElementException);
        }
        if (connection != null) {
            String string4;
            object2 = Natives.getServerDN(nDSContext.nativeContext, connection.handle);
            object = DomainName.stripTypes(string2);
            if (!((String)object).equalsIgnoreCase(string4 = DomainName.stripTypes((String)object2))) {
                throw new InvalidDomainNameException(String.valueOf(string2) + " (" + (String)object + " != " + string4 + ")");
            }
        }
        return connection;
    }

    private Connection openConnectionByName(String string, NDSContext nDSContext, String string2, int n) throws SessionException {
        Connection connection = null;
        try {
            int n2 = Natives.openConnection(nDSContext.getNativeHandle(), string2);
            String string3 = Natives.getConnInfoString(n2, 0, 4);
            if (!string3.equals(string)) {
                if (C32_KLUDGE_FORCE_CLOSED) {
                    Natives.closeRefByHandle(n2);
                } else {
                    Natives.closeConnection(n2);
                }
                throw new ServerTreeMismatchException(string2, string, string3);
            }
            int n3 = Natives.getConnectionReference(n2);
            connection = this.addConnection(n3, n2, n);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new InvalidDomainNameException(string2, noSuchElementException);
        }
        return connection;
    }

    public Connection getConnectionByTreeName(SessionEnv sessionEnv, String string, int n) throws SessionException {
        Connection connection = null;
        this.updateConnectionCache();
        connection = this.findConnectionByTreeName(sessionEnv, string, n);
        if (connection == null) {
            connection = this.openConnectionByTreeName(sessionEnv, string, n);
        }
        return connection;
    }

    public Connection findConnectionByTreeName(SessionEnv sessionEnv, String string, int n) throws SessionException {
        Connection connection = null;
        string = DomainName.strip(string);
        try {
            SessionAttrs sessionAttrs = new SessionAttrs();
            sessionAttrs.add("CONN_TREE_NAME", string);
            ConnectionSearchEnumerator connectionSearchEnumerator = new ConnectionSearchEnumerator(sessionAttrs, this.connectionCache);
            while (connectionSearchEnumerator.hasMoreElements()) {
                connection = connectionSearchEnumerator.next();
                if (this.getOwner(connection) == 0) {
                    this.setOwner(connection, n);
                }
                if (this.getOwner(connection) == n) break;
            }
            if (connection != null && this.getOwner(connection) != n) {
                throw new NotConnectionOwnerException(this.toString(connection), connection.ownerTrace);
            }
        }
        catch (Exception exception) {
            throw new InvalidDomainNameException(string, exception);
        }
        return connection;
    }

    private Connection openConnectionByTreeName(SessionEnv sessionEnv, String string, int n) throws SessionException {
        Connection connection = null;
        int n2 = 8;
        int n3 = 1;
        string = DomainName.strip(string);
        try {
            int n4 = Natives.openConnection((Address)sessionEnv.get("com.novell.service.session.xplat.DomainAddress"), this.getLookupHandle(sessionEnv), string, n2, n3);
            int n5 = Natives.getConnectionReference(n4);
            connection = this.addConnection(n5, n4, n);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new InvalidDomainNameException(string, noSuchElementException);
        }
        return connection;
    }

    public NDSContext createContext(SessionEnv sessionEnv, String string) throws SessionException {
        NativeContextMaster nativeContextMaster = null;
        boolean bl = true;
        int n = -1;
        string = DomainName.strip(string);
        if (CREATE_CONTEXT_CHECK_TREE) {
            this.updateConnectionCache();
        }
        try {
            if (CREATE_CONTEXT_CHECK_TREE) {
                Connection connection = this.findConnectionByTreeName(sessionEnv, string, 2);
                if (connection != null) {
                    try {
                        n = Natives.openConnection(this.getReference(connection));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (n == -1) {
                    n = Natives.openConnection((Address)sessionEnv.get("com.novell.service.session.xplat.DomainAddress"), this.getLookupHandle(sessionEnv), string, 8, 1);
                    bl = false;
                }
            }
            nativeContextMaster = Natives.createNativeContext(string);
            this.nativeContexts.put(nativeContextMaster);
            int n2 = (Integer)Natives.getContextInfo(nativeContextMaster, 1);
            n2 &= 0xFFFFFFFD;
            n2 |= 4;
            Natives.setContextInfo(nativeContextMaster, 1, new Integer(n2 &= 0xFFFFFFEF));
            if (Natives.NLM_KLUDGE_INVALID_CACHE) {
                Natives.setContextInfo(nativeContextMaster, 15, new Integer(0));
            }
            Natives.setContextInfo(nativeContextMaster, 11, string);
            Natives.setContextInfo(nativeContextMaster, 3, "[Root]");
            try {
                if (CREATE_CONTEXT_GIVE_CONN) {
                    Natives.setContextInfo(nativeContextMaster, 8, new Integer(n));
                    if (CREATE_CONTEXT_PUT_CACHE) {
                        int n3 = Natives.getConnectionReference(n);
                        this.addConnection(n3, Natives.openConnection(n3), 2);
                    }
                } else {
                    Natives.contextPing(nativeContextMaster);
                }
            }
            catch (NSIException nSIException) {
                nativeContextMaster.close();
                if (CREATE_CONTEXT_CHECK_TREE && n != -1) {
                    if (bl) {
                        Natives.closeConnection(n);
                    } else {
                        Natives.closeRef(Natives.getConnectionReference(n));
                    }
                }
                throw nSIException;
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (SessionException sessionException) {
            throw sessionException;
        }
        NDSContext nDSContext = new NDSContext(nativeContextMaster, sessionEnv, string, this);
        return nDSContext;
    }

    public Connection getConnectionIfAvail(NDSContext nDSContext) throws SessionException {
        Integer n = (Integer)this.getContextInfo(nDSContext, 8);
        Connection connection = null;
        try {
            connection = this.getConnectionFromHandle(n, 2);
        }
        catch (NSIException nSIException) {
            int n2 = nSIException.getCCode();
            if (n2 > 35072 && n2 < 35096 || n2 >= 34816 && n2 <= 35071) {
                throw nSIException;
            }
            this.generateContextFailure(nDSContext, nSIException);
        }
        return connection;
    }

    public NDSContext duplicateContext(NDSContext nDSContext) throws SessionException {
        NativeContextDuplicate nativeContextDuplicate = Natives.duplicateNativeContext(nDSContext.getNativeHandle());
        return new NDSContext(nativeContextDuplicate, nDSContext.getEnvironment(), this);
    }

    public synchronized NDSContext duplicateContext(NDSContext nDSContext, SessionEnv sessionEnv, Connection connection) throws SessionException {
        int n;
        NativeContextDuplicate nativeContextDuplicate = null;
        try {
            nativeContextDuplicate = Natives.duplicateNativeContext(nDSContext.getNativeHandle());
        }
        catch (NSIException nSIException) {
            n = nSIException.getCCode();
            if (n > 35072 && n < 35096 || n >= 34816 && n <= 35071) {
                int n2 = Natives.openConnection(this.getReference(connection));
                Natives.setContextInfo(nDSContext.getNativeHandle(), 8, new Integer(n2));
                nativeContextDuplicate = Natives.duplicateNativeContext(nDSContext.getNativeHandle());
            }
            throw nSIException;
        }
        int n3 = (Integer)Natives.getContextInfo(nativeContextDuplicate, 1);
        Natives.setContextInfo(nativeContextDuplicate, 1, new Integer(n3 |= 0x80));
        n = Natives.openConnection(this.getReference(connection));
        Natives.setContextInfo(nativeContextDuplicate, 8, new Integer(n));
        NDSContext nDSContext2 = new NDSContext(nativeContextDuplicate, sessionEnv, null, this);
        return nDSContext2;
    }

    public void freeContext(NDSContext nDSContext) throws SessionException {
        try {
            Natives.freeNativeContext(nDSContext.nativeContext);
            return;
        }
        catch (ServerRequesterException serverRequesterException) {
            this.generateContextFailure(nDSContext, serverRequesterException);
            return;
        }
        catch (ClientException clientException) {
            switch (clientException.getCCode()) {
                case 34850: {
                    this.generateContextFailure(nDSContext, clientException);
                }
            }
            throw clientException;
        }
    }

    public Object getContextInfo(NDSContext nDSContext, int n) throws SessionException {
        try {
            return Natives.getContextInfo(nDSContext.nativeContext, n);
        }
        catch (ServerRequesterException serverRequesterException) {
            throw this.generateContextFailure(nDSContext, serverRequesterException);
        }
        catch (ClientException clientException) {
            switch (clientException.getCCode()) {
                case 34850: {
                    throw this.generateContextFailure(nDSContext, clientException);
                }
            }
            throw clientException;
        }
    }

    public void setContextInfo(NDSContext nDSContext, int n, Object object) throws SessionException {
        try {
            Natives.setContextInfo(nDSContext.nativeContext, n, object);
            return;
        }
        catch (ServerRequesterException serverRequesterException) {
            throw this.generateContextFailure(nDSContext, serverRequesterException);
        }
        catch (ClientException clientException) {
            switch (clientException.getCCode()) {
                case 34850: {
                    throw this.generateContextFailure(nDSContext, clientException);
                }
            }
            throw clientException;
        }
    }

    public void loginContext(NDSContext nDSContext, String string, String string2, boolean bl) throws SessionException {
        try {
            Natives.loginContext(nDSContext.nativeContext, string, string2, bl);
            return;
        }
        catch (ServerRequesterException serverRequesterException) {
            throw this.generateContextFailure(nDSContext, serverRequesterException);
        }
        catch (ClientException clientException) {
            switch (clientException.getCCode()) {
                case 34850: {
                    throw this.generateContextFailure(nDSContext, clientException);
                }
            }
            throw clientException;
        }
    }

    public void loginContextNAS(NDSContext nDSContext, NdsIdentity ndsIdentity, String string, String string2, boolean bl) throws SessionException {
        try {
            Natives.loginContextNAS(nDSContext.nativeContext, ndsIdentity, string, string2, bl);
            return;
        }
        catch (ServerRequesterException serverRequesterException) {
            throw this.generateContextFailure(nDSContext, serverRequesterException);
        }
        catch (ClientException clientException) {
            switch (clientException.getCCode()) {
                case 34850: {
                    throw this.generateContextFailure(nDSContext, clientException);
                }
            }
            throw clientException;
        }
    }

    public void loginAsServiceContext(NDSContext nDSContext, String string) throws SessionException {
        try {
            Natives.loginAsServiceContext(nDSContext.nativeContext, string);
            return;
        }
        catch (ServerRequesterException serverRequesterException) {
            throw this.generateContextFailure(nDSContext, serverRequesterException);
        }
        catch (ClientException clientException) {
            switch (clientException.getCCode()) {
                case 34850: {
                    throw this.generateContextFailure(nDSContext, clientException);
                }
            }
            throw clientException;
        }
    }

    public void logoutContext(NDSContext nDSContext) throws SessionException {
        try {
            Natives.logoutContext(nDSContext.nativeContext);
            return;
        }
        catch (ServerRequesterException serverRequesterException) {
            throw this.generateContextFailure(nDSContext, serverRequesterException);
        }
        catch (ClientException clientException) {
            switch (clientException.getCCode()) {
                case 34850: {
                    throw this.generateContextFailure(nDSContext, clientException);
                }
            }
            throw clientException;
        }
    }

    public void logoutContextNAS(NDSContext nDSContext, NdsIdentity ndsIdentity) throws SessionException {
        try {
            Natives.logoutContextNAS(nDSContext.nativeContext, ndsIdentity);
            return;
        }
        catch (ServerRequesterException serverRequesterException) {
            throw this.generateContextFailure(nDSContext, serverRequesterException);
        }
        catch (ClientException clientException) {
            switch (clientException.getCCode()) {
                case 34850: {
                    throw this.generateContextFailure(nDSContext, clientException);
                }
            }
            throw clientException;
        }
    }

    public void authenticateConn(NDSContext nDSContext, Connection connection) throws SessionException {
        try {
            Natives.authenticateConn(nDSContext.nativeContext, connection.handle);
            return;
        }
        catch (ServerRequesterException serverRequesterException) {
            throw this.generateConnectionFailure(connection, serverRequesterException);
        }
        catch (ClientException clientException) {
            switch (clientException.getCCode()) {
                case 34850: {
                    throw this.generateConnectionFailure(connection, clientException);
                }
            }
            throw clientException;
        }
    }

    public void unauthenticateConn(NDSContext nDSContext, Connection connection) throws SessionException {
        this.close(connection);
    }

    public boolean canDSAuthenticate(NDSContext nDSContext) throws SessionException {
        try {
            return Natives.canDSAuthenticate(nDSContext.nativeContext);
        }
        catch (ServerRequesterException serverRequesterException) {
            throw this.generateContextFailure(nDSContext, serverRequesterException);
        }
        catch (ClientException clientException) {
            switch (clientException.getCCode()) {
                case 34850: {
                    throw this.generateContextFailure(nDSContext, clientException);
                }
            }
            throw clientException;
        }
    }

    public boolean specialIsDSAuthenticated(NDSContext nDSContext) throws SessionException {
        try {
            return Natives.specialIsDSAuthenticated(nDSContext.nativeContext);
        }
        catch (ServerRequesterException serverRequesterException) {
            throw this.generateContextFailure(nDSContext, serverRequesterException);
        }
        catch (ClientException clientException) {
            switch (clientException.getCCode()) {
                case 34850: {
                    throw this.generateContextFailure(nDSContext, clientException);
                }
            }
            throw clientException;
        }
    }

    public String getContextName(NDSContext nDSContext) throws SessionException {
        try {
            return Natives.getContextName(nDSContext.nativeContext);
        }
        catch (ServerRequesterException serverRequesterException) {
            throw this.generateContextFailure(nDSContext, serverRequesterException);
        }
        catch (ClientException clientException) {
            switch (clientException.getCCode()) {
                case 34850: {
                    throw this.generateContextFailure(nDSContext, clientException);
                }
            }
            throw clientException;
        }
    }

    public void changePasswordContext(NDSContext nDSContext, String string, String string2, String string3, boolean bl) throws SessionException {
        try {
            Natives.changePasswordContext(nDSContext.nativeContext, string, string2, string3, bl);
            return;
        }
        catch (ServerRequesterException serverRequesterException) {
            throw this.generateContextFailure(nDSContext, serverRequesterException);
        }
        catch (ClientException clientException) {
            switch (clientException.getCCode()) {
                case 34850: {
                    throw this.generateContextFailure(nDSContext, clientException);
                }
            }
            throw clientException;
        }
    }

    public void setPasswordContext(NDSContext nDSContext, String string, String string2, boolean bl) throws SessionException {
        try {
            Natives.setPasswordContext(nDSContext.nativeContext, string, string2, bl);
            return;
        }
        catch (ServerRequesterException serverRequesterException) {
            throw this.generateContextFailure(nDSContext, serverRequesterException);
        }
        catch (ClientException clientException) {
            switch (clientException.getCCode()) {
                case 34850: {
                    throw this.generateContextFailure(nDSContext, clientException);
                }
            }
            throw clientException;
        }
    }

    public void verifyPasswordContext(NDSContext nDSContext, String string, String string2, boolean bl) throws SessionException {
        try {
            Natives.verifyPasswordContext(nDSContext.nativeContext, string, string2, bl);
            return;
        }
        catch (ServerRequesterException serverRequesterException) {
            throw this.generateContextFailure(nDSContext, serverRequesterException);
        }
        catch (ClientException clientException) {
            switch (clientException.getCCode()) {
                case 34850: {
                    throw this.generateContextFailure(nDSContext, clientException);
                }
            }
            throw clientException;
        }
    }

    public void contextPing(NDSContext nDSContext) throws SessionException {
        try {
            Natives.contextPing(nDSContext.nativeContext);
            return;
        }
        catch (ServerRequesterException serverRequesterException) {
            throw this.generateContextFailure(nDSContext, serverRequesterException);
        }
        catch (ClientException clientException) {
            switch (clientException.getCCode()) {
                case 34850: {
                    throw this.generateContextFailure(nDSContext, clientException);
                }
            }
            throw clientException;
        }
    }

    public Integer getDSNLMBuild(NDSContext nDSContext) throws SessionException {
        try {
            return Natives.getDSNLMBuild(nDSContext.getConnection().handle);
        }
        catch (ServerRequesterException serverRequesterException) {
            throw this.generateContextFailure(nDSContext, serverRequesterException);
        }
        catch (ClientException clientException) {
            switch (clientException.getCCode()) {
                case 34850: {
                    throw this.generateContextFailure(nDSContext, clientException);
                }
            }
            throw clientException;
        }
    }

    public Integer getDSServerRootDepth(NDSContext nDSContext) throws SessionException {
        try {
            return Natives.getDSServerRootDepth(nDSContext.getConnection().handle);
        }
        catch (ServerRequesterException serverRequesterException) {
            throw this.generateContextFailure(nDSContext, serverRequesterException);
        }
        catch (ClientException clientException) {
            switch (clientException.getCCode()) {
                case 34850: {
                    throw this.generateContextFailure(nDSContext, clientException);
                }
            }
            throw clientException;
        }
    }

    public Boolean isMasterReplica(NDSContext nDSContext) throws SessionException {
        try {
            return Natives.isMasterReplica(nDSContext.getConnection().handle);
        }
        catch (ServerRequesterException serverRequesterException) {
            throw this.generateContextFailure(nDSContext, serverRequesterException);
        }
        catch (ClientException clientException) {
            switch (clientException.getCCode()) {
                case 34850: {
                    throw this.generateContextFailure(nDSContext, clientException);
                }
            }
            throw clientException;
        }
    }

    public String getServerDN(NDSContext nDSContext) throws SessionException {
        try {
            return Natives.getServerDN(nDSContext.nativeContext, nDSContext.getConnection().handle);
        }
        catch (ServerRequesterException serverRequesterException) {
            throw this.generateContextFailure(nDSContext, serverRequesterException);
        }
        catch (ClientException clientException) {
            switch (clientException.getCCode()) {
                case 34850: {
                    throw this.generateContextFailure(nDSContext, clientException);
                }
            }
            throw clientException;
        }
    }

    protected InvalidStateException generateContextFailure(NDSContext nDSContext, Exception exception) {
        try {
            nDSContext.close();
        }
        catch (SessionException sessionException) {
            // empty catch block
        }
        nDSContext.setReason(exception);
        return new InvalidStateException("Context no longer valid(Tree:" + nDSContext.getTreeNameIfSet() + ")" + " - (" + exception + ")", exception);
    }

    private InvalidStateException generateConnectionFailure(Connection connection, Exception exception) {
        try {
            this.close(connection);
        }
        catch (SessionException sessionException) {
            // empty catch block
        }
        this.setReason(connection, exception);
        return new InvalidStateException("Connection no longer valid- (" + exception + ")", exception);
    }

    static /* synthetic */ boolean access$0() {
        return false;
    }

    static {
        singletonInstance = null;
        privateInstances = new Hashtable();
        connInfo = null;
        contextInfo = null;
        System.runFinalizersOnExit((boolean)true);
        if (Boolean.getBoolean("com.novell.service.session.util.Debug")) {
            Debug.getDebug();
        }
    }

    public class RequesterConnectionSearchEnumerator
    implements Enumeration {
        private int scanType;
        private String scanString;
        private int scanMode;
        private int lookAhead = -1;
        private boolean firstScan = true;
        private int scanValue;
        private NWVersion scanVersion;
        private int scanLevel;
        private NWLong scanIterator;

        protected RequesterConnectionSearchEnumerator(int n, String string) throws SessionException {
            XplatUtil.this = XplatUtil.this;
            this.scanString = string;
            this.scanType = 0;
            this.scanLevel = n;
            this.scanMode = 1;
            this.scanIterator = new NWLong(0);
            if (XplatUtil.access$0()) {
                Debug.println("RequesterConnectionSearchEnumerator.<init>(): Start scan...");
            }
            this.nextElement();
            this.firstScan = false;
        }

        protected RequesterConnectionSearchEnumerator(int n, Version version) throws SessionException {
            XplatUtil.this = XplatUtil.this;
            this.scanVersion = new NWVersion(version.majorVersion, version.minorVersion, version.revision);
            this.scanType = 2;
            this.scanLevel = n;
            this.scanMode = 1;
            this.scanIterator = new NWLong(0);
            this.nextElement();
            this.firstScan = false;
        }

        protected RequesterConnectionSearchEnumerator(int n, int n2) throws SessionException {
            XplatUtil.this = XplatUtil.this;
            this.scanValue = n2;
            this.scanType = 1;
            this.scanLevel = n;
            this.scanMode = 1;
            this.scanIterator = new NWLong(0);
            this.nextElement();
            this.firstScan = false;
        }

        private int doScanWork() throws SessionException {
            if (this.lookAhead == -1 && !this.firstScan) {
                throw new NoSuchElementException();
            }
            int n = this.lookAhead;
            this.lookAhead = -1;
            int n2 = -1;
            switch (this.scanType) {
                case 0: {
                    n2 = Natives.scanConnInfoString(this.scanIterator, this.scanLevel, this.scanString, this.scanMode);
                    break;
                }
                case 1: {
                    n2 = Natives.scanConnInfoLong(this.scanIterator, this.scanLevel, this.scanValue, this.scanMode);
                    break;
                }
                case 2: {
                    n2 = Natives.scanConnInfoVersion(this.scanIterator, this.scanLevel, this.scanVersion, this.scanMode);
                    break;
                }
                default: {
                    throw new SessionException("Invalid scan type: " + this.scanType);
                }
            }
            this.lookAhead = n2;
            return n;
        }

        public boolean hasMoreElements() {
            return this.lookAhead != -1;
        }

        public Object nextElement() throws NoSuchElementException {
            int n = -1;
            try {
                n = this.doScanWork();
            }
            catch (SessionException sessionException) {
                throw new NoSuchElementException(sessionException.toString());
            }
            if (XplatUtil.access$0()) {
                Debug.println("RequesterConnectionSearchEnumerator.nextElement(): Scan found: 0x" + Integer.toHexString(n));
            }
            return new Integer(n);
        }

        public Integer next() throws NoSuchElementException {
            return (Integer)this.nextElement();
        }

        public Integer[] next(int n) {
            Integer[] integerArray = new Integer[n];
            int n2 = 0;
            while (n2 < n) {
                integerArray[n2] = this.next();
                ++n2;
            }
            return integerArray;
        }
    }
}

