/*
 * Decompiled with CFR 0.152.
 */
package com.novell.utility.naming;

import com.novell.service.session.Session;
import com.novell.service.session.SessionException;
import com.novell.service.session.SessionManager;
import com.novell.service.session.SessionService;
import java.io.Serializable;
import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;

public abstract class Environment
implements Cloneable,
Serializable {
    public static final String INITIAL_CONTEXT_FACTORY = "java.naming.factory.initial";
    public static final String OBJECT_FACTORIES = "java.naming.factory.object";
    public static final String URL_PKG_PREFIXES = "java.naming.factory.url.pkgs";
    public static final String PROVIDER_URL = "java.naming.provider.url";
    public static final String DNS_URL = "java.naming.dns.url";
    public static final String AUTHORITATIVE = "java.naming.authoritative";
    public static final String BATCHSIZE = "java.naming.batchsize";
    public static final String REFERRAL = "java.naming.referral";
    public static final String SECURITY_PROTOCOL = "java.naming.security.protocol";
    public static final String SECURITY_AUTHENTICATION = "java.naming.security.authentication";
    public static final String SECURITY_PRINCIPAL = "java.naming.security.principal";
    public static final String SECURITY_CREDENTIALS = "java.naming.security.credentials";
    public static final String LANGUAGE = "java.naming.language";
    public static final String SESSION_OBJECT = "java.naming.session";
    public static final String SESSION_MANAGER_OBJECT = "java.naming.session.manager";
    public static final String NCP_PROTOCOL = "ncp";
    public static final String LDAP_PROTOCOL = "ldap";
    public static final String RMI_PROTOCOL = "rmi";
    public static final String IIOP_PROTOCOL = "iiop";
    public static final String TRANSPORT_PROTOCOL = "com.novell.service.naming.transport.protocol";
    public static final String FS_INITIAL_CONTEXT_FACTORY = "com.novell.service.file.nw.naming.FileSystemInitialContextFactory";
    public static final String NW_INITIAL_CONTEXT_FACTORY = "com.novell.service.nw.NetWareInitialContextFactory";
    public static final String SERVER_INITIAL_CONTEXT_FACTORY = "com.novell.service.server.ServerInitialContextFactory";
    public static final String NDS_INITIAL_CONTEXT_FACTORY = "com.novell.service.nds.naming.NdsInitialContextFactory";
    public static final String QMS_INITIAL_CONTEXT_FACTORY = "com.novell.service.qms.naming.QueueInitialContextFactory";
    protected Hashtable environment;
    private boolean shared;
    protected Session session;

    public Environment(Hashtable hashtable) {
        this.shared = false;
        this.environment = (Hashtable)hashtable.clone();
    }

    public Environment(Environment environment) throws NamingException {
        this.shared = true;
        environment.setShared();
        this.environment = environment.getEnvironment(false);
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        this.copyWhenShared();
        return this.environment.put(string, object);
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        this.copyWhenShared();
        return this.environment.remove(string);
    }

    public Hashtable getEnvironment(boolean bl) throws NamingException {
        if (bl) {
            return (Hashtable)this.environment.clone();
        }
        return this.environment;
    }

    public Object clone() {
        try {
            Environment environment = (Environment)super.clone();
            environment.environment = this.environment;
            environment.setShared();
            this.setShared();
            environment.session = this.session;
            return environment;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public final synchronized void setShared() {
        this.shared = true;
    }

    private final synchronized void copyWhenShared() {
        if (this.shared) {
            this.environment = (Hashtable)this.environment.clone();
            this.shared = false;
        }
    }

    public abstract Session getSession() throws NamingException;

    public SessionService getService(String string) throws NamingException {
        try {
            return this.getSession().getService(string);
        }
        catch (SessionException sessionException) {
            AuthenticationException authenticationException = new AuthenticationException();
            authenticationException.setRootCause(sessionException);
            throw authenticationException;
        }
    }

    public SessionManager getSessionManager() throws NamingException {
        return (SessionManager)this.environment.get(SESSION_MANAGER_OBJECT);
    }

    public String getProviderURL() throws NamingException {
        String string = (String)this.environment.get(PROVIDER_URL);
        if (string != null) {
            return string;
        }
        throw new NamingException();
    }

    public String getTransportProtocol() {
        String string = (String)this.environment.get(TRANSPORT_PROTOCOL);
        if (string == null) {
            return NCP_PROTOCOL;
        }
        return string.toLowerCase();
    }
}

