/*
 * Decompiled with CFR 0.152.
 */
package com.novell.utility.naming;

import java.net.MalformedURLException;
import javax.naming.NamingException;

public class URLParser {
    private String url;
    private String scheme;
    private String user;
    private String password;
    private String host;
    private int port;
    private String path;

    public URLParser(String string) throws NamingException {
        this.setURL(string);
    }

    public void setURL(String string) throws NamingException {
        try {
            this.url = string;
            this.parse();
            return;
        }
        catch (MalformedURLException malformedURLException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(malformedURLException);
            throw namingException;
        }
    }

    public String getURL() {
        return this.url;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    private void parse() throws MalformedURLException {
        int n = 0;
        if (this.url == null || this.url.equals("")) {
            this.setDefaults();
            return;
        }
        int n2 = this.url.indexOf("://");
        if (n2 < 0) {
            this.scheme = null;
        } else {
            this.scheme = this.url.substring(0, n2);
            n = n2 + 3;
        }
        String string = this.url.substring(n);
        int n3 = string.indexOf(47);
        if (n3 < 0) {
            this.path = null;
        } else {
            this.path = string.substring(n3 + 1);
            string = string.substring(0, n3);
        }
        n3 = string.indexOf(58);
        if (n3 < 0) {
            this.host = string;
            this.port = 0;
            return;
        }
        this.host = string.substring(0, n3);
        try {
            this.port = Integer.parseInt(string.substring(n3 + 1));
            return;
        }
        catch (NumberFormatException numberFormatException) {
            throw new MalformedURLException(numberFormatException.getMessage());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        if (this.scheme != null) {
            stringBuffer.append("scheme: " + this.scheme + '\n');
            stringBuffer2.append(this.scheme);
            stringBuffer2.append("://");
        }
        if (this.user != null) {
            stringBuffer.append("user: " + this.user + '\n');
            stringBuffer2.append(this.user);
        }
        if (this.password != null) {
            stringBuffer.append("password: " + this.password + '\n');
            stringBuffer2.append(':');
            stringBuffer2.append(this.password);
        }
        if (this.user != null || this.password != null) {
            stringBuffer2.append('@');
        }
        if (this.host != null) {
            stringBuffer.append("host: " + this.host + '\n');
            stringBuffer2.append(this.host);
        }
        if (this.port != 0) {
            stringBuffer.append("port: " + this.port + '\n');
            stringBuffer2.append(':');
            stringBuffer2.append(this.port);
        }
        if (this.path != null) {
            stringBuffer.append("path: " + this.path + '\n');
            stringBuffer2.append('/');
            stringBuffer2.append(this.path);
        }
        return String.valueOf(stringBuffer2.toString()) + '\n' + stringBuffer.toString();
    }

    private void setDefaults() {
        this.url = null;
        this.scheme = null;
        this.user = null;
        this.password = null;
        this.host = null;
        this.port = 0;
        this.path = null;
    }
}

