/*
 * Decompiled with CFR 0.152.
 */
package com.novell.utility.naming.directory;

import java.lang.reflect.Array;
import java.util.NoSuchElementException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;

public class SingleValueAttribute
implements Attribute {
    protected String attrID;
    protected Object value;
    protected boolean hasValue;

    public Object clone() {
        if (this.hasValue) {
            return new SingleValueAttribute(this.attrID, this.value);
        }
        return new SingleValueAttribute(this.attrID);
    }

    public boolean equals(Object object) {
        Attribute attribute;
        if (object != null && object instanceof Attribute && this.attrID.equals((attribute = (Attribute)object).getID()) && this.size() == attribute.size()) {
            try {
                if (this.value != ((Attribute)object).get()) {
                    return false;
                }
            }
            catch (NamingException namingException) {
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = this.attrID.hashCode();
        if (this.value != null) {
            if (this.value.getClass().isArray()) {
                int n2 = Array.getLength(this.value);
                int n3 = 0;
                while (n3 < n2) {
                    Object object = Array.get(this.value, n3);
                    if (object != null) {
                        n += object.hashCode();
                    }
                    ++n3;
                }
            } else {
                n += this.value.hashCode();
            }
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(this.attrID) + ": ");
        if (!this.hasValue) {
            stringBuffer.append("No value");
        } else {
            stringBuffer.append(this.value);
        }
        return stringBuffer.toString();
    }

    public SingleValueAttribute(String string) {
        this.attrID = string;
        this.hasValue = false;
        this.value = null;
    }

    public SingleValueAttribute(String string, Object object) {
        this.attrID = string;
        this.hasValue = true;
        this.value = object;
    }

    public NamingEnumeration getAll() throws NamingException {
        return new ValuesEnumImpl();
    }

    public Object get() throws NamingException {
        if (!this.hasValue) {
            throw new NoSuchElementException("Attribute " + this.getID() + " has no value");
        }
        return this.value;
    }

    public int size() {
        if (this.hasValue) {
            return 1;
        }
        return 0;
    }

    public String getID() {
        return this.attrID;
    }

    public boolean contains(Object object) {
        if (this.hasValue) {
            if (object == null) {
                return this.value == null;
            }
            if (this.value == null) {
                return false;
            }
            return this.value.equals(object);
        }
        return false;
    }

    public boolean add(Object object) {
        if (this.contains(object)) {
            return false;
        }
        this.value = object;
        return true;
    }

    public boolean remove(Object object) {
        if (this.contains(object)) {
            this.hasValue = false;
            this.value = null;
            return true;
        }
        return false;
    }

    public void clear() {
        this.hasValue = false;
        this.value = null;
    }

    public DirContext getAttributeSyntaxDefinition() throws NamingException {
        throw new OperationNotSupportedException("attribute syntax");
    }

    public DirContext getAttributeDefinition() throws NamingException {
        throw new OperationNotSupportedException("attribute definition");
    }

    public boolean isOrdered() {
        return false;
    }

    public Object get(int n) throws NamingException {
        throw new IndexOutOfBoundsException();
    }

    public Object remove(int n) {
        throw new IndexOutOfBoundsException();
    }

    public void add(int n, Object object) {
        throw new IndexOutOfBoundsException();
    }

    public Object set(int n, Object object) {
        throw new IndexOutOfBoundsException();
    }

    class ValuesEnumImpl
    implements NamingEnumeration {
        boolean hasMore = true;

        public boolean hasMoreElements() {
            return this.hasMore;
        }

        public Object nextElement() {
            this.hasMore = false;
            return SingleValueAttribute.this.value;
        }

        public Object next() throws NamingException {
            this.hasMore = false;
            return SingleValueAttribute.this.value;
        }

        public boolean hasMore() throws NamingException {
            return this.hasMore;
        }

        public void close() throws NamingException {
        }

        ValuesEnumImpl() {
            SingleValueAttribute.this = SingleValueAttribute.this;
        }
    }
}

