/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jk.common;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jk.common.MsgAjp;
import org.apache.jk.core.Msg;
import org.apache.jk.core.MsgContext;
import org.apache.tomcat.util.buf.ByteChunk;

public class JkInputStream
extends InputStream {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$jk$common$JkInputStream == null ? (class$org$apache$jk$common$JkInputStream = JkInputStream.class$("org.apache.jk.common.JkInputStream")) : class$org$apache$jk$common$JkInputStream));
    Msg bodyMsg = new MsgAjp();
    MsgContext mc;
    int contentLength;
    int available;
    boolean closed = false;
    public static final int MAX_PACKET_SIZE = 8192;
    public static final int H_SIZE = 4;
    public static final int MAX_READ_SIZE = 8186;
    public static final byte JK_AJP13_GET_BODY_CHUNK = 6;
    byte[] bodyBuff = new byte[9000];
    int blen;
    int pos;
    boolean end_of_stream = false;
    static /* synthetic */ Class class$org$apache$jk$common$JkInputStream;

    public int available() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("available(): " + this.blen + " " + this.pos));
        }
        return this.blen - this.pos;
    }

    public void close() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"cloae() ");
        }
        this.closed = true;
    }

    public void mark(int readLimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public void reset() throws IOException {
        throw new IOException("reset() not supported");
    }

    public int read() throws IOException {
        if (this.contentLength == -1) {
            return this.doRead1();
        }
        if (this.available <= 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"doRead() nothing available");
            }
            return -1;
        }
        --this.available;
        return this.doRead1();
    }

    public int read(byte[] b) throws IOException {
        int rd = this.read(b, 0, b.length);
        if (log.isDebugEnabled()) {
            log.debug((Object)("read(" + b + ")=" + rd + " / " + b.length));
        }
        return rd;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int rd = -1;
        if (this.contentLength == -1) {
            rd = this.doRead1(b, off, len);
            return rd;
        }
        if (this.available <= 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"doRead() nothing available");
            }
            return -1;
        }
        rd = this.doRead1(b, off, len);
        this.available -= rd;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Read: " + new String(b, off, len)));
        }
        return rd;
    }

    public long skip(long n) throws IOException {
        if (n > Integer.MAX_VALUE) {
            throw new IOException("can't skip than many:  " + n);
        }
        byte[] b = new byte[(int)n];
        return this.read(b, 0, b.length);
    }

    private int doRead1() throws IOException {
        if (this.pos >= this.blen && !this.refillReadBuffer()) {
            return -1;
        }
        int i = this.bodyBuff[this.pos++] & 0xFF;
        if (log.isDebugEnabled()) {
            log.debug((Object)("doRead1 " + (char)i));
        }
        return i;
    }

    public int doRead1(byte[] b, int off, int len) throws IOException {
        if (this.pos >= this.blen && !this.refillReadBuffer()) {
            return -1;
        }
        if (this.pos + len <= this.blen) {
            System.arraycopy(this.bodyBuff, this.pos, b, off, len);
            if (log.isDebugEnabled()) {
                log.debug((Object)("doRead1: " + this.pos + " " + len + " " + this.blen));
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Data: \n" + new String(b, off, len)));
            }
            this.pos += len;
            return len;
        }
        int toCopy = len;
        while (toCopy > 0) {
            int bytesRemaining = this.blen - this.pos;
            if (bytesRemaining < 0) {
                bytesRemaining = 0;
            }
            int c = bytesRemaining < toCopy ? bytesRemaining : toCopy;
            System.arraycopy(this.bodyBuff, this.pos, b, off, c);
            if (log.isDebugEnabled()) {
                log.debug((Object)("doRead2: " + this.pos + " " + len + " " + this.blen + " " + c));
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Data: \n" + new String(b, off, len < this.blen - 1 ? len : this.blen - 1)));
            }
            off += c;
            this.pos += c;
            if ((toCopy -= c) <= 0 || this.refillReadBuffer()) continue;
            break;
        }
        return len - toCopy;
    }

    public void setContentLength(int i) {
        this.contentLength = i;
        this.available = i;
    }

    public void setMsgContext(MsgContext mc) {
        this.mc = mc;
    }

    public void recycle() {
        this.available = 0;
        this.blen = 0;
        this.pos = 0;
        this.closed = false;
        this.end_of_stream = false;
        this.contentLength = -1;
    }

    public int doRead(ByteChunk responseChunk) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doRead " + this.pos + " " + this.blen + " " + this.available + " " + this.end_of_stream + " " + responseChunk.getOffset() + " " + responseChunk.getLength()));
        }
        if (this.end_of_stream) {
            return -1;
        }
        if (this.blen == this.pos && !this.refillReadBuffer()) {
            return -1;
        }
        responseChunk.setBytes(this.bodyBuff, this.pos, this.blen);
        this.pos = this.blen;
        return this.blen;
    }

    public boolean receive() throws IOException {
        this.mc.setType(10);
        this.bodyMsg.reset();
        int err = this.mc.getSource().receive(this.bodyMsg, this.mc);
        if (log.isDebugEnabled()) {
            log.info((Object)("Receiving: getting request body chunk " + err + " " + this.bodyMsg.getLen()));
        }
        if (err < 0) {
            throw new IOException();
        }
        this.pos = 0;
        this.blen = 0;
        if (this.bodyMsg.getLen() == 0) {
            return false;
        }
        this.blen = this.bodyMsg.peekInt();
        if (this.blen == 0) {
            return false;
        }
        if (this.blen > this.bodyBuff.length) {
            this.bodyMsg.dump("Body");
        }
        if (log.isTraceEnabled()) {
            this.bodyMsg.dump("Body buffer");
        }
        int cpl = this.bodyMsg.getBytes(this.bodyBuff);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Copy into body buffer2 " + this.bodyBuff + " " + cpl + " " + this.blen));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Data:\n" + new String(this.bodyBuff, 0, cpl)));
        }
        return this.blen > 0;
    }

    private boolean refillReadBuffer() throws IOException {
        if (this.end_of_stream) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"refillReadBuffer: end of stream ");
            }
            return false;
        }
        this.bodyMsg.reset();
        this.bodyMsg.appendByte(6);
        this.bodyMsg.appendInt(8186);
        if (log.isDebugEnabled()) {
            log.debug((Object)("refillReadBuffer " + Thread.currentThread()));
        }
        this.mc.setType(11);
        this.mc.getSource().send(this.bodyMsg, this.mc);
        boolean moreData = this.receive();
        if (!moreData) {
            this.end_of_stream = true;
        }
        return moreData;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

