/*
 * Decompiled with CFR 0.152.
 */
package novell.jclient;

import novell.jclient.JCAddress;
import novell.jclient.JCESpec;
import novell.jclient.JCEntryIterator;
import novell.jclient.JCEntryIteratorSortKey;
import novell.jclient.JCEntryVList;
import novell.jclient.JCException;
import novell.jclient.JCInt;
import novell.jclient.JCLong;
import novell.jclient.JCNetworkAddress;
import novell.jclient.JCPingInfo;
import novell.jclient.JCReferral;
import novell.jclient.JCResolveNameConstraint;
import novell.jclient.JCSearchFilter;
import novell.jclient.JCStringESpec;
import novell.jclient.JClient;

public class JCContext {
    public static final int CONTEXT_CORE_FLAG_SET = 0;
    public static final int CONTEXT_EXT_FLAG_SET = 1;
    public static final int CONTEXT_SEC_FLAG_SET = 2;
    public static final int CONTEXT_DSA = 1;
    public static final int CONTEXT_PRIVATE_CONNECTIONS = 2;
    public static final int CONTEXT_UNICODE_STRINGS = 4;
    public static final int CONTEXT_REMOTE_TREE_WALK = 8;
    public static final int CONTEXT_EXHAUST_REPLICAS = 16;
    public static final int CONTEXT_EXHAUST_SAP = 32;
    public static final int CONTEXT_NO_SAP_ADDRESS = 64;
    public static final int CONTEXT_TYPED_NAMES = 128;
    public static final int CONTEXT_ESCAPE_STRINGS = 256;
    public static final int CONTEXT_DS_CRC32 = 512;
    public static final int CONTEXT_LOCAL_CONTEXT = 1024;
    public static final int CONTEXT_REQ_TUNED_NAMES = 2048;
    public static final int CONTEXT_SAS_APPLICATION = 4096;
    public static final int CONTEXT_CTX_IGNORE_CONNECT_ERR = 8192;
    public static final int CONTEXT_CTX_NO_CONNECT = 16384;
    public static final int CONTEXT_DELETED_INFO = 32768;
    public static final int CONTEXT_FORCE_LOCAL = 65536;
    public static final int CONTEXT_ESPEC = 131072;
    public static final int CONTEXT_NO_OPERATIONAL_ATTRS = 524288;
    public static final int CONTEXT_LOCAL_LOGIN = 0x200000;
    public static final int CONTEXT_CTX_DUPLICATE_TO = 0x400000;
    public static final int CONTEXT_ALLOW_SPARSE = 0x800000;
    public static final int CONTEXT_CREATE_FORWARD_REFS = 0x1000000;
    public static final int CONTEXT_INCLUDE_DELETED_ENTRIES = 0x2000000;
    public static final int CONTEXT_INCLUDE_DELETED_VALUES = 0x4000000;
    public static final int CONTEXT_SIMPLE_PASSWORD = 0x8000000;
    public static final int CONTEXT_RETURN_ALL_VALUES = 0x10000000;
    public static final int CONTEXT_STATIC_VALUES = 0x20000000;
    public static final int CONTEXT_INCLUDE_SYSTEM_ENTRIES = 1;
    public static final int CONTEXT_HONOR_DELIMS = 2;
    public static final int CONTEXT_ALL_LDAP_OPER_ATTRS = 4;
    public static final int CONTEXT_ALL_LDAP_USER_ATTRS = 8;
    public static final int CONTEXT_SEC_RETURN_CONNECTION = 1;
    public static final int CONTEXT_SEC_DONT_DISCOVER = 2;
    public static final int CONTEXT_SEC_PWD_TYPE_UTF8 = 4;
    public static final int CONTEXT_SEC_PWD_TYPE_ZSTRING = 8;
    public static final int CONTEXT_SEC_PWD_TYPE_IGNORE = 16;
    public static final int CONTEXT_SEC_SPM_AVAILABLE = 32;
    public static final int CONTEXT_SECURE_NCPCONN = 64;
    public static final int CONTEXT_SEC_NMAS_AVAILABLE = 256;
    public static final int CONTEXT_SSL_NONE = 0;
    public static final int CONTEXT_SSL_FILE_PEM = 2;
    public static final int RESOLVE_ENTRY_ID = 1;
    public static final int RESOLVE_READABLE = 2;
    public static final int RESOLVE_WRITABLE = 4;
    public static final int RESOLVE_MASTER = 8;
    public static final int RESOLVE_CREATE_ID = 16;
    public static final int RESOLVE_WALK_TREE = 32;
    public static final int RESOLVE_DEREFERENCE_ALIASES = 64;
    public static final int RESOLVE_OLD402_CREATE_ID = 512;
    public static final int RESOLVE_EXHAUST_REPLICAS = 1024;
    public static final int RESOLVE_PREFER_REFERRALS = 8192;
    public static final int RESOLVE_PREFER_ONLY_REFERRALS = 16384;
    public static final int RESOLVE_NO_HIDDEN = 32768;
    public static final int RESOLVE_NO_SECURE = 65536;
    public static final int RESOLVE_CACHE_ONLY = 131072;
    public static final int RESOLVE_SPARSE_WRITE = 65536;
    public static final int RESOLVE_SPARSE_READ = 131072;
    public static final int RESOLVE_DEFAULT = 66;
    private volatile transient int epoch;
    private volatile transient int handle;
    public static final int NAMEFORM_STANDARD_DN = 0;
    public static final int NAMEFORM_PARTIAL_TUNE = 1;
    public static final int NAMEFORM_TUNED_NAME = 3;
    public static final long PING_DEPTH = 2L;
    public static final long PING_BUILD_NUMBER = 4L;
    public static final long PING_FLAGS = 8L;
    public static final long PING_VERIFICATION_FLAGS = 16L;
    public static final long PING_LETTER_VERSION = 32L;
    public static final long PING_LICENSE_FLAGS = 256L;
    public static final long PING_DS_TIME = 512L;
    public static final long PING_OS_VERSION = 64L;
    public static final long PING_SAP_NAME = 65536L;
    public static final long PING_TREE_NAME = 131072L;
    public static final long PING_OS_NAME = 262144L;
    public static final long PING_HARDWARE_NAME = 524288L;
    public static final long PING_VENDOR_NAME = 0x100000L;

    public JCContext() {
        JClient.initialize();
        JCInt jCInt = new JCInt(-1);
        JCInt jCInt2 = new JCInt(0);
        try {
            this.createContext(jCInt, jCInt2);
        }
        catch (JCException jCException) {
            // empty catch block
        }
        this.handle = jCInt.intValue();
        this.epoch = jCInt2.intValue();
    }

    public JCContext(int n, String string, String string2) {
        this();
        try {
            if (n != 0) {
                this.setFlags(n, 0);
            }
            this.setBaseDN(string, string2);
        }
        catch (JCException jCException) {
            // empty catch block
        }
    }

    private JCContext(int n, int n2) {
        JClient.initialize();
        this.handle = n;
        this.epoch = n2;
    }

    public String toString() {
        return "Context=" + this.handle + ", epoch=" + this.epoch;
    }

    public void free() {
        if (this.handle != -1) {
            try {
                this.freeContext();
            }
            catch (JCException jCException) {
                // empty catch block
            }
        }
        this.epoch = 0;
        this.handle = -1;
    }

    public native void login() throws JCException;

    public native void login(String var1) throws JCException;

    public native void loginAsServer() throws JCException;

    public native void logout() throws JCException;

    public native void authenticate() throws JCException;

    public native void authenticate(byte[] var1) throws JCException;

    public JCContext duplicate() throws JCException {
        JCInt jCInt = new JCInt(-1);
        JCInt jCInt2 = new JCInt(0);
        this.duplicateContext(jCInt, jCInt2);
        return new JCContext(jCInt.intValue(), jCInt2.intValue());
    }

    public JCContext duplicate(long l) throws JCException {
        JCInt jCInt = new JCInt(-1);
        JCInt jCInt2 = new JCInt(0);
        this.duplicateContext(jCInt, jCInt2, l);
        return new JCContext(jCInt.intValue(), jCInt2.intValue());
    }

    public native void duplicateIdentity(JCContext var1) throws JCException;

    public int getFlags() throws JCException {
        return this.getContextFlags();
    }

    public int getFlagSetFlags(int n) throws JCException {
        return this.getContextFlagSetFlags(n);
    }

    public int getDClientContextHandle() {
        return this.handle;
    }

    public void setFlags(int n, int n2) throws JCException {
        this.setContextFlags(n, n2);
    }

    public void setFlagSetFlags(int n, int n2, int n3) throws JCException {
        this.setContextFlagSetFlags(n, n2, n3);
    }

    public native void resolve(int var1, StringBuffer var2) throws JCException;

    public void resolve(int n, String string) throws JCException {
        StringBuffer stringBuffer = new StringBuffer(string);
        this.resolve(n, stringBuffer);
    }

    public native void resolve(JCResolveNameConstraint var1, JCESpec var2) throws JCException;

    public void resolve(JCResolveNameConstraint jCResolveNameConstraint, StringBuffer stringBuffer) throws JCException {
        this.resolve(jCResolveNameConstraint, stringBuffer.toString());
    }

    public void resolve(JCResolveNameConstraint jCResolveNameConstraint, String string) throws JCException {
        String[] stringArray = this.getBaseDN();
        JCStringESpec jCStringESpec = new JCStringESpec(stringArray[1], string);
        this.resolve(jCResolveNameConstraint, jCStringESpec);
    }

    public void resolveName(int n, StringBuffer stringBuffer) throws JCException {
        this.resolve(n, stringBuffer);
    }

    public void resolveName(int n, String string) throws JCException {
        StringBuffer stringBuffer = new StringBuffer(string);
        this.resolve(n, stringBuffer);
    }

    public native String resolvePattern(int var1, StringBuffer var2) throws JCException;

    public String resolvePattern(int n, String string) throws JCException {
        StringBuffer stringBuffer = new StringBuffer(string);
        return this.resolvePattern(n, stringBuffer);
    }

    public native void getBaseDN(StringBuffer var1, StringBuffer var2) throws JCException;

    public String[] getBaseDN() throws JCException {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        String[] stringArray = new String[2];
        this.getBaseDN(stringBuffer, stringBuffer2);
        stringArray[0] = new String(stringBuffer);
        stringArray[1] = new String(stringBuffer2);
        return stringArray;
    }

    public native void setBaseDN(StringBuffer var1, StringBuffer var2) throws JCException;

    public void setBaseDN(String string, String string2) throws JCException {
        StringBuffer stringBuffer = null;
        StringBuffer stringBuffer2 = null;
        if (string != null) {
            stringBuffer = new StringBuffer(string);
        }
        if (string2 != null) {
            stringBuffer2 = new StringBuffer(string2);
        }
        this.setBaseDN(stringBuffer, stringBuffer2);
    }

    private native void createContext(JCInt var1, JCInt var2) throws JCException;

    private native void freeContext() throws JCException;

    private native void duplicateContext(JCInt var1, JCInt var2) throws JCException;

    private native void duplicateContext(JCInt var1, JCInt var2, long var3) throws JCException;

    private native int getContextFlags() throws JCException;

    private native void setContextFlags(int var1, int var2) throws JCException;

    private native int getContextFlagSetFlags(int var1) throws JCException;

    private native void setContextFlagSetFlags(int var1, int var2, int var3) throws JCException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            super.finalize();
            this.free();
        }
        finally {
            JClient.cleanup();
        }
    }

    public native void connect(long var1, JCNetworkAddress var3) throws JCException;

    public native void connect(long var1, JCReferral var3) throws JCException;

    public native void connect(StringBuffer var1) throws JCException;

    public void connect(String string) throws JCException {
        StringBuffer stringBuffer = new StringBuffer(string);
        this.connect(stringBuffer);
    }

    public native long getEntryID() throws JCException;

    public native void setEntryID(long var1) throws JCException;

    public native int getNameForm() throws JCException;

    public native void setNameForm(int var1) throws JCException;

    public native String getCompatInfo(JCLong var1) throws JCException;

    public native int getIdentity() throws JCException;

    public native void setIdentity(int var1) throws JCException;

    public native void getInfo(JCInt var1, JCInt var2) throws JCException;

    public native void getIterationInfo(long var1, JCLong var3, JCLong var4) throws JCException;

    public native void setIterationInfo(long var1, long var3, long var5) throws JCException;

    public void setIterationInfo(JCContext jCContext, long l, JCLong jCLong, JCLong jCLong2) throws JCException {
        this.setIterationInfo(l, jCLong.longValue(), jCLong2.longValue());
    }

    public native void getLocale(JCInt var1, JCInt var2, StringBuffer var3, StringBuffer var4) throws JCException;

    public native void setLocale(int var1, int var2, String var3, String var4) throws JCException;

    public void setLocale(JCInt jCInt, JCInt jCInt2, StringBuffer stringBuffer, StringBuffer stringBuffer2) throws JCException {
        this.setLocale(jCInt.intValue(), jCInt2.intValue(), stringBuffer.toString(), stringBuffer2.toString());
    }

    public native long getStreamSize() throws JCException;

    public native String localizeDN(String var1) throws JCException;

    public native String standardizeDN(String var1, String var2) throws JCException;

    public native void sasLogin(int var1) throws JCException;

    public native JCNetworkAddress getConnectedAddress() throws JCException;

    public native void licenseConnection() throws JCException;

    public native void unlicenseConnection() throws JCException;

    public native boolean checkConsoleOperator(String var1);

    public native void changePassword(String var1, String var2) throws JCException;

    public native void generateKeyPair(String var1) throws JCException;

    public native String getIdentityName() throws JCException;

    public native long getEffectivePrivileges(String var1, String var2) throws JCException;

    public native byte[] getPublicKey() throws JCException;

    public native void setPublicKey(byte[] var1) throws JCException;

    public native boolean verifyPassword(String var1);

    public native String getServerName() throws JCException;

    public native JCReferral getServerReferral() throws JCException;

    public native void closeIteration(long var1, long var3) throws JCException;

    public native String getConnectionDN(int var1) throws JCException;

    public native void setReplicaPointer(int var1, int var2, JCReferral var3, long var4) throws JCException;

    public native JCAddress[] getAddressesOfEntry(JCResolveNameConstraint var1, JCESpec var2, JCInt var3) throws JCException;

    public JCAddress[] getAddressesOfEntry(int n, JCESpec jCESpec, JCInt jCInt) throws JCException {
        JCResolveNameConstraint jCResolveNameConstraint = new JCResolveNameConstraint(n, 0, null, null);
        return this.getAddressesOfEntry(jCResolveNameConstraint, jCESpec, jCInt);
    }

    public native void nameToID(int var1, StringBuffer var2) throws JCException;

    public void nameToID(int n, String string) throws JCException {
        StringBuffer stringBuffer = new StringBuffer(string);
        this.nameToID(n, stringBuffer);
    }

    public native JCPingInfo ping() throws JCException;

    public native JCPingInfo ping(long var1) throws JCException;

    public JCEntryIterator createIterator(int n) throws JCException {
        return this.createIterator(null, null, n);
    }

    public JCEntryIterator createIterator(String[] stringArray) throws JCException {
        return this.createIterator(stringArray, null);
    }

    public JCEntryIterator createIterator(String[] stringArray, int n) throws JCException {
        return this.createIterator(stringArray, null, n);
    }

    public JCEntryIterator createIterator(String[] stringArray, String[] stringArray2) throws JCException {
        return new JCEntryVList(this, stringArray, stringArray2, 2, null);
    }

    public JCEntryIterator createIterator(String[] stringArray, String[] stringArray2, int n) throws JCException {
        return this.createIterator(stringArray, stringArray2, n, null);
    }

    public JCEntryIterator createIterator(String[] stringArray, String[] stringArray2, int n, JCEntryIteratorSortKey jCEntryIteratorSortKey) throws JCException {
        return new JCEntryVList(this, stringArray, stringArray2, n, jCEntryIteratorSortKey);
    }

    public JCEntryIterator createIterator(JCSearchFilter jCSearchFilter) throws JCException {
        return this.createIterator(jCSearchFilter, null);
    }

    public JCEntryIterator createIterator(JCSearchFilter jCSearchFilter, JCEntryIteratorSortKey jCEntryIteratorSortKey) throws JCException {
        return new JCEntryVList(this, jCSearchFilter, jCEntryIteratorSortKey);
    }

    public native void setLocal(int var1) throws JCException;

    public native void addAddressToBAC(JCNetworkAddress var1) throws JCException;

    public native void removeAddressFromBAC(JCNetworkAddress var1) throws JCException;

    public native void addReferralToBAC(JCReferral var1) throws JCException;

    public native void removeReferralFromBAC(JCReferral var1) throws JCException;

    public native void clearAddressConns(JCNetworkAddress var1) throws JCException;

    public native void clearReferralConns(JCReferral var1) throws JCException;

    public native void setSecurityInfo(int var1, String var2) throws JCException;

    public native int getSecurityInfo(JCInt var1, byte[] var2) throws JCException;

    static {
        JClient.loadLibrary();
    }
}

