/*
 * Decompiled with CFR 0.152.
 */
package novell.jclient;

import novell.jclient.JCAclValue;
import novell.jclient.JCAttributeDef;
import novell.jclient.JCClassDef;
import novell.jclient.JCConstants;
import novell.jclient.JCContext;
import novell.jclient.JCEntry;
import novell.jclient.JCEntryData;
import novell.jclient.JCEntryInfo;
import novell.jclient.JCEntryInfoCB;
import novell.jclient.JCException;
import novell.jclient.JCExceptionReference;
import novell.jclient.JCInt;
import novell.jclient.JCListContainableClassesCB;
import novell.jclient.JCListDirsCB;
import novell.jclient.JCListEnumerator;
import novell.jclient.JCListFilter;
import novell.jclient.JCLong;
import novell.jclient.JCNetworkAddress;
import novell.jclient.JCPartitionInfo;
import novell.jclient.JCPartitionListCB;
import novell.jclient.JCReadAttributeDefCB;
import novell.jclient.JCReadCB;
import novell.jclient.JCReadClassDefCB;
import novell.jclient.JCReadFilter;
import novell.jclient.JCReadReferenceCB;
import novell.jclient.JCReferenceFilter;
import novell.jclient.JCSearchContextCB;
import novell.jclient.JCSearchFilter;
import novell.jclient.JCSearchReferralCB;
import novell.jclient.JCTimestamp;
import novell.jclient.JCValue;

public final class JClient
implements JCConstants {
    static final String CLIENT_LIB_NAME = new String("JClient");
    static final String NETWARE_LIB_NAME = new String("jclnt");
    static final int NDS_REQUEST = 1;
    static final int NCP_REQUEST = 2;
    public static final int ENTRY_INFO_OUTPUT_FIELDS = 1;
    public static final int ENTRY_INFO_ENTRY_ID = 2;
    public static final int ENTRY_INFO_ENTRY_FLAGS = 4;
    public static final int ENTRY_INFO_SUBORDINATE_COUNT = 8;
    public static final int ENTRY_INFO_MODIFICATION_TIME = 16;
    public static final int ENTRY_INFO_MODIFICATION_TIMESTAMP = 32;
    public static final int ENTRY_INFO_CREATION_TIMESTAMP = 64;
    public static final int ENTRY_INFO_PARTITION_ROOT_ID = 128;
    public static final int ENTRY_INFO_PARENT_ID = 256;
    public static final int ENTRY_INFO_REVISION_COUNT = 512;
    public static final int ENTRY_INFO_REPLICA_TYPE = 1024;
    public static final int ENTRY_INFO_BASE_CLASS = 2048;
    public static final int ENTRY_INFO_ENTRY_RDN = 4096;
    public static final int ENTRY_INFO_ENTRY_DN = 8192;
    public static final int ENTRY_INFO_PARTITION_ROOT_DN = 16384;
    public static final int ENTRY_INFO_PARENT_DN = 32768;
    public static final int ENTRY_INFO_PURGE_TIME = 65536;
    public static final int ENTRY_INFO_DEREFERENCED_BASE_CLASS = 131072;
    public static final int ENTRY_INFO_REPLICA_NUMBER = 262144;
    public static final int ENTRY_INFO_REPLICA_STATE = 524288;
    public static final int ENTRY_INFO_FEDERATION_BOUNDARY = 0x100000;
    public static final int ENTRY_INFO_SCHEMA_BOUNDARY = 0x200000;
    public static final int ENTRY_FLAG_ALIAS_ENTRY = 1;
    public static final int ENTRY_FLAG_PARTITION_ROOT = 2;
    public static final int ENTRY_FLAG_CONTAINER_ENTRY = 4;
    public static final int ENTRY_FLAG_CONTAINER_ALIAS = 8;
    public static final int ENTRY_FLAG_MATCHES_LIST_FILTER = 16;
    public static final int ENTRY_FLAG_REFERENCE_ENTRY = 32;
    public static final int ENTRY_FLAG_40X_REFERENCE_ENTRY = 64;
    public static final int ENTRY_FLAG_BACKLINKED = 128;
    public static final int ENTRY_FLAG_NEW_ENTRY = 256;
    public static final int ENTRY_FLAG_TEMPORARY_REFERENCE = 512;
    public static final int ENTRY_FLAG_AUDITED = 1024;
    public static final int ENTRY_FLAG_ENTRY_NOT_PRESENT = 2048;
    public static final int ENTRY_FLAG_ENTRY_VERIFY_CTS = 4096;
    public static final int ENTRY_FLAG_ENTRY_DAMAGED = 8192;
    public static final int REPLICA_TYPE_MASTER = 0;
    public static final int REPLICA_TYPE_SECONDARY = 1;
    public static final int REPLICA_TYPE_READONLY = 2;
    public static final int REPLICA_TYPE_SUBREF = 3;
    public static final int REPLICA_STATE_ON = 0;
    public static final int REPLICA_STATE_NEW_REPLICA = 1;
    public static final int REPLICA_STATE_DYING_REPLICA = 2;
    public static final int REPLICA_STATE_LOCKED = 3;
    public static final int REPLICA_STATE_CRT_0 = 4;
    public static final int REPLICA_STATE_CRT_1 = 5;
    public static final int REPLICA_STATE_TRANSITION_ON = 6;
    public static final int REPLICA_STATE_DEAD_REPLICA = 7;
    public static final int REPLICA_STATE_BEGIN_ADD = 8;
    public static final int REPLICA_STATE_RO_START = 9;
    public static final int REPLICA_STATE_RO_DONE = 10;
    public static final int REPLICA_STATE_MASTER_START = 11;
    public static final int REPLICA_STATE_MASTER_DONE = 12;
    public static final int REPLICA_STATE_FEDERATED = 13;
    public static final int REPLICA_STATE_SS_0 = 48;
    public static final int REPLICA_STATE_SS_1 = 49;
    public static final int REPLICA_STATE_JS_0 = 64;
    public static final int REPLICA_STATE_JS_1 = 65;
    public static final int REPLICA_STATE_JS_2 = 66;
    public static final int REPLICA_STATE_MS_0 = 80;
    public static final int REPLICA_STATE_MS_1 = 81;
    public static final int REPLICA_STATE_COUNT = 82;
    public static final long PARTITION_FLAG_ENSURE_SERVERS_UP = 1L;
    public static final int SEARCH_SCOPE_ENTRY = 0;
    public static final int SEARCH_SCOPE_SUBORDINATES = 1;
    public static final int SEARCH_SCOPE_SUBTREE = 2;
    public static final int SEARCH_SCOPE_PARTITION = 3;
    public static final int SEARCH_EXP_ITEM = 0;
    public static final int SEARCH_EXP_OR = 1;
    public static final int SEARCH_EXP_AND = 2;
    public static final int SEARCH_EXP_NOT = 3;
    public static final int ATTR_INFO_ATTRIBUTE_NAMES = 0;
    public static final int ATTR_INFO_ATTRIBUTE_VALUES = 1;
    public static final int ATTR_INFO_EFFECTIVE_PRIVILEGES = 2;
    public static final int ATTR_INFO_VALUE_INFO = 3;
    public static final int ATTR_INFO_ABBREVIATED_VALUE = 4;
    public static final int ATTR_INFO_EXPANDED_CLASS = 8;
    public static final long INFOTYPE_ATTR_DEF_NAMES = 0L;
    public static final long INFOTYPE_ATTR_DEFS = 1L;
    public static final long INFOTYPE_BASE_ATTR_DEFS = 2L;
    public static final long INFOTYPE_CLASS_DEF_NAMES = 0L;
    public static final long INFOTYPE_CLASS_DEFS = 1L;
    public static final long INFOTYPE_EXPANDED_CLASS_DEFS = 2L;
    public static final long INFOTYPE_INFO_CLASS_DEFS = 3L;
    public static final long INFOTYPE_FULL_CLASS_DEFS = 4L;
    public static final long INFOTYPE_BASE_CLASS_DEFS = 5L;
    public static final int MAX_RDN_CHARS = 128;
    public static final int MAX_DN_CHARS = 256;
    public static final int MAX_SCHEMA_NAME_CHARS = 32;
    public static final int MAX_TREE_NAME_CHARS = 32;
    public static final int MAX_SAP_NAME_CHARS = 47;
    public static final int MAX_RDN_BYTES = 258;
    public static final int MAX_DN_BYTES = 514;
    public static final int MAX_SCHEMA_NAME_BYTES = 66;
    public static final int MAX_ASN1_NAME = 32;
    public static final int MAX_VALUE = 64512;
    public static final int MAX_VALUES_IN_RDN = 64;
    public static final int MAX_RDNS_IN_DN = 129;
    public static final int MAX_TUNED_NAME_SIZE = 3106;
    public static final int STREAM_MODE_READ = 1;
    public static final int STREAM_MODE_WRITE = 2;
    public static final int REFERRAL_TYPE_ALIAS = 0;
    public static final int REFERRAL_TYPE_PARTITION = 1;
    public static final int ENTRY_AND_REFERRALS_TRUNCATED = 1;
    public static final int ENTRY_AND_REFERRALS_FILTERED_BY_TYPE = 2;
    public static final int ENTRY_AND_REFERRALS_FILTERED_BY_AVAILABILITY = 4;
    public static final int ENTRY_AND_REFERRALS_FILTERED_BY_TRANSPORT = 8;
    public static final int ENTRY_AND_REFERRALS_FILTERED_BY_VERSION = 16;
    public static final int ENTRY_AND_REFERRALS_ALIAS_DEREFERENCED = 32;
    public static final int ENTRY_AND_REFERRALS_ENTRY_IS_LOCAL = 64;
    public static final int NETADDRESS_TYPE_NONE = -1;
    public static final int NETADDRESS_TYPE_IPX = 0;
    public static final int NETADDRESS_TYPE_IP = 1;
    public static final int NETADDRESS_TYPE_SDLC = 2;
    public static final int NETADDRESS_TYPE_TOKENRING = 3;
    public static final int NETADDRESS_TYPE_OSI = 4;
    public static final int NETADDRESS_TYPE_APPLETALK = 5;
    public static final int NETADDRESS_TYPE_NETBEUI = 6;
    public static final int NETADDRESS_TYPE_SOCKADDR = 7;
    public static final int NETADDRESS_TYPE_UDP = 8;
    public static final int NETADDRESS_TYPE_TCP = 9;
    public static final int NETADDRESS_TYPE_UDP6 = 10;
    public static final int NETADDRESS_TYPE_TCP6 = 11;
    public static final int NETADDRESS_TYPE_INTERNAL = 12;
    public static final int NETADDRESS_TYPE_URL = 13;
    static final int NETADDRESS_TYPE_COUNT = 14;
    static Object initCountGate = new Object();
    static int initCount = 0;
    public static final long NETADDRESS_PORT_IPX = 1105L;
    public static final long NETADDRESS_PORT_UDP = 524L;
    public static final long NETADDRESS_PORT_TCP = 524L;
    public static final long CONNECTION_FLAG_FORCE_NEW = 1L;
    public static final long CONNECTION_FLAG_SET_IDENTITY = 2L;
    public static final long CONNECTION_FLAG_IGNORE_ADDR_CACHE = 4L;
    public static final int REMOVE_OLD_NAME_VALUES = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() {
        Object object = initCountGate;
        synchronized (object) {
            if (initCount == 0) {
                JClient.initializeDclient();
            }
            ++initCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanup() {
        Object object = initCountGate;
        synchronized (object) {
            if (--initCount == 0) {
                JClient.terminateDclient();
            } else if (initCount < 0) {
                initCount = 0;
                throw new RuntimeException("cleanup called without matching initialize()");
            }
        }
    }

    private static native void initializeDclient();

    private static native void terminateDclient();

    static void loadLibrary() {
    }

    static native int request(JCContext var0, int var1, int var2, int var3, byte[] var4, int var5, byte[] var6) throws JCException, OutOfMemoryError;

    public static int ndsRequest(JCContext jCContext, int n, int n2, byte[] byArray, int n3, byte[] byArray2) throws JCException, OutOfMemoryError {
        return JClient.request(jCContext, 1, n, n2, byArray, n3, byArray2);
    }

    public static int ncpRequest(JCContext jCContext, int n, int n2, byte[] byArray, int n3, byte[] byArray2) throws JCException, OutOfMemoryError {
        return JClient.request(jCContext, 2, n, n2, byArray, n3, byArray2);
    }

    public static native int getNCPExtension(JCContext var0, String var1) throws JCException, OutOfMemoryError;

    public static native int sendNCPExtension(JCContext var0, int var1, int var2, byte[] var3, byte[] var4) throws JCException, OutOfMemoryError;

    public static native JCEntryInfo getEntryInfo(JCContext var0, int var1) throws JCException, OutOfMemoryError, ClassFormatError, ClassCircularityError, NoClassDefFoundError, NoSuchMethodError;

    public static native String[] listDirectories(JCContext var0, String var1) throws JCException;

    public static native void listDirectories(JCContext var0, String var1, JCListDirsCB var2) throws JCException;

    public static native void listToCB(JCContext var0, JCListFilter var1, int var2, JCEntryInfoCB var3) throws JCException, OutOfMemoryError, ClassFormatError, ClassCircularityError, NoClassDefFoundError, NoSuchMethodError;

    static native int listToJCListEnumerator(JCContext var0, JCListFilter var1, int var2, JCListEnumerator var3) throws JCException, OutOfMemoryError, ClassFormatError, ClassCircularityError, NoClassDefFoundError, NoSuchMethodError;

    public static native JCNetworkAddress getDefaultAddress() throws JCException;

    public static native int[] getTransportTypes() throws JCException;

    public static native void setDefaultAddress(JCNetworkAddress var0) throws JCException;

    public static native long openStream(JCContext var0, String var1, int var2) throws JCException, OutOfMemoryError;

    public static native void closeStream(JCContext var0) throws JCException;

    public static native long readStream(JCContext var0, long var1, long var3, byte[] var5) throws JCException, NoSuchFieldError, ExceptionInInitializerError, OutOfMemoryError, ArrayIndexOutOfBoundsException;

    public static native long writeStream(JCContext var0, long var1, long var3, byte[] var5) throws JCException;

    public static native void searchToCB(JCContext var0, JCSearchFilter var1, JCEntryInfoCB var2, JCReadCB var3, JCSearchContextCB var4) throws JCException, NoSuchFieldError, NoSuchMethodError, ExceptionInInitializerError, OutOfMemoryError;

    public static native long searchFromPartition(JCContext var0, JCSearchFilter var1, JCEntryInfoCB var2, JCReadCB var3, JCSearchReferralCB var4) throws JCException, NoSuchFieldError, NoSuchMethodError, ExceptionInInitializerError, OutOfMemoryError;

    public static native boolean compareAttribute(JCContext var0, JCValue var1) throws JCException;

    public static native void createEntry(JCContext var0, String var1, JCValue[] var2) throws JCException;

    public static native void mergeEntries(JCContext var0, JCTimestamp var1, long var2) throws JCException;

    public static native void modifyEntry(JCContext var0, JCValue[] var1) throws JCException;

    public static native void modifyRDN(JCContext var0, String var1, boolean var2) throws JCException;

    public static native void moveEntry(JCContext var0, JCContext var1, long var2, String var4) throws JCException;

    public static native void mutateEntry(JCContext var0, boolean var1, String var2) throws JCException;

    public static native void readEntry(JCContext var0, long var1, JCReadFilter var3, JCEntry var4) throws JCException;

    public static native void readEntry(JCContext var0, long var1, JCReadFilter var3, JCReadCB var4) throws JCException;

    public static native JCValue[] readEntry(JCContext var0, long var1, JCReadFilter var3) throws JCException;

    public static native JCValue[] readEntry(JCContext var0, long var1, JCReadFilter var3, JCExceptionReference var4);

    public static native void removeAttribute(JCContext var0, String var1) throws JCException;

    public static native void removeEntry(JCContext var0) throws JCException;

    public static native void resendEntry(JCContext var0) throws JCException;

    public static native void addOptionalsToClass(JCContext var0, String var1, String[] var2) throws JCException;

    public static native void defineAttribute(JCContext var0, String var1, JCAttributeDef var2) throws JCException;

    public static native void defineClass(JCContext var0, String var1, JCClassDef var2) throws JCException;

    public static native String[] listContainableClasses(JCContext var0) throws JCException;

    public static native void listContainableClasses(JCContext var0, JCListContainableClassesCB var1) throws JCException;

    public static native void modifyClass(JCContext var0, String var1, String[] var2, String[] var3, JCAclValue[] var4, JCAclValue[] var5) throws JCException;

    public static native void modifyClassDefinition(JCContext var0, String var1, long var2, byte[] var4, String[] var5, String[] var6, String[] var7, String[] var8, String[] var9, String[] var10, JCAclValue[] var11, JCAclValue[] var12) throws JCException;

    public static native void modifyAttributeDefinition(JCContext var0, String var1, long var2, long var4, int var6, byte[] var7, long var8, long var10, long var12) throws JCException;

    public static native void newSchemaEpoch(JCContext var0) throws JCException;

    public static native void readAttributeDef(JCContext var0, String var1, JCInt var2, JCLong var3, JCLong var4, JCLong var5) throws JCException;

    public static native JCAttributeDef[] readAttributeDef(JCContext var0, long var1, String[] var3) throws JCException;

    public static native void readAttributeDef(JCContext var0, long var1, String[] var3, JCReadAttributeDefCB var4) throws JCException;

    public static native JCClassDef[] readClassDef(JCContext var0, long var1, String[] var3) throws JCException;

    public static native void readClassDef(JCContext var0, long var1, String[] var3, JCReadClassDefCB var4) throws JCException;

    public static native void undefineAttribute(JCContext var0, String var1) throws JCException;

    public static void removeAttributeDefinition(JCContext jCContext, String string) throws JCException {
        JClient.undefineAttribute(jCContext, string);
    }

    public static native void undefineClass(JCContext var0, String var1) throws JCException;

    public static void removeClass(JCContext jCContext, String string) throws JCException {
        JClient.undefineClass(jCContext, string);
    }

    public static native void abortPartitionOperation(JCContext var0, long var1) throws JCException;

    public static native void addReplica(JCContext var0, long var1, String var3, int var4) throws JCException;

    public static native void removeReplica(JCContext var0, long var1, String var3) throws JCException;

    public static native void changeReplicaType(JCContext var0, long var1, String var3, int var4) throws JCException;

    public static native void createOrphanPartition(JCContext var0, String var1) throws JCException;

    public static native void removeOrphanPartition(JCContext var0) throws JCException;

    public static native void joinPartitions(JCContext var0, long var1) throws JCException;

    public static native long getPartitionEntryCount(JCContext var0) throws JCException;

    public static native JCPartitionInfo getPartitionInfo(JCContext var0, String var1) throws JCException;

    public static native JCPartitionInfo[] listPartitions(JCContext var0, long var1, String var3) throws JCException;

    public static native void listPartitions(JCContext var0, long var1, JCPartitionListCB var3) throws JCException;

    public static native void receiveAllUpdates(JCContext var0, String var1) throws JCException;

    public static native void repairTimeStamps(JCContext var0, long var1) throws JCException;

    public static native void requestPartitionSync(JCContext var0, long var1) throws JCException;

    public static native void requestSchemaSync(JCContext var0, long var1) throws JCException;

    public static native void sendAllUpdates(JCContext var0) throws JCException;

    public static native void splitPartition(JCContext var0, long var1) throws JCException;

    public static native JCEntryData[] readReference(JCContext var0, JCReferenceFilter var1) throws JCException;

    public static native void readReference(JCContext var0, JCReferenceFilter var1, JCReadReferenceCB var2) throws JCException;

    static native int wireGetReferralCount(byte[] var0);

    static native JCNetworkAddress[] wireDecomposeReferral(byte[] var0);

    static native byte[] wireComposeReferral(JCNetworkAddress[] var0);

    public static String jclientLevels() {
        JCInt jCInt = new JCInt();
        JCInt jCInt2 = new JCInt();
        JCInt jCInt3 = new JCInt();
        try {
            JClient.getDClientVersions(jCInt, jCInt2, jCInt3);
        }
        catch (JCException jCException) {
            // empty catch block
        }
        return "JClient Revision: 1.6.1281\nDClient Revision: " + jCInt.intValue() + "." + jCInt2.intValue() + "." + jCInt3.intValue();
    }

    public static boolean isSound() {
        JCInt jCInt = new JCInt();
        JCInt jCInt2 = new JCInt();
        JCInt jCInt3 = new JCInt();
        boolean bl = false;
        try {
            JClient.getDClientVersions(jCInt, jCInt2, jCInt3);
            if (jCInt.intValue() == 1 && jCInt2.intValue() >= 6) {
                bl = true;
            }
        }
        catch (JCException jCException) {
            // empty catch block
        }
        return bl;
    }

    private static native void getDClientVersions(JCInt var0, JCInt var1, JCInt var2) throws JCException;

    private static void printCopyright() {
        JCInt jCInt = new JCInt();
        JCInt jCInt2 = new JCInt();
        JCInt jCInt3 = new JCInt();
        try {
            JClient.getDClientVersions(jCInt, jCInt2, jCInt3);
        }
        catch (JCException jCException) {
            // empty catch block
        }
        System.out.println("Novell JClient 1.6.1281-" + jCInt.intValue() + "." + jCInt2.intValue() + "." + jCInt3.intValue() + ".  Copyright 1999 Novell Inc. All Rights Reserved.");
    }

    static {
        String string = System.getProperty("novell.jclient.libraryName");
        if (string == null || string.length() == 0) {
            string = System.getProperty("os.name").toLowerCase().indexOf("netware") != -1 ? NETWARE_LIB_NAME : CLIENT_LIB_NAME;
        }
        try {
            System.loadLibrary(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(unsatisfiedLinkError);
            throw unsatisfiedLinkError;
        }
        if (!JClient.isSound()) {
            System.err.println("Incompatible JClient/DClient package\n" + JClient.jclientLevels());
            throw new VerifyError("Incompatible JClient/DClient package\n" + JClient.jclientLevels());
        }
        System.runFinalizersOnExit((boolean)true);
        JClient.printCopyright();
    }
}

