/*
 * Decompiled with CFR 0.152.
 */
package novell.jclient;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import novell.jclient.JCContext;
import novell.jclient.JCException;
import novell.jclient.JClient;
import novell.jclient.NWFile;

public class NWFileInputStream
extends InputStream {
    public static final int CLOSED_FILE_HANDLE = -1;
    public static final long CLOSED_FILE_POSITION = -1L;
    public static final int EOF = -1;
    private JCContext context;
    private int hFile;
    private long position;

    public NWFileInputStream(JCContext jCContext, int n) {
        JClient.initialize();
        this.context = jCContext;
        this.hFile = n;
        this.position = 0L;
    }

    public NWFileInputStream(JCContext jCContext, File file) throws NoSuchMethodError {
        JClient.initialize();
        this.context = jCContext;
        this.hFile = -1;
        this.position = -1L;
        throw new NoSuchMethodError("NWFileInputStream.NWFileInputStream( JCContext context, java.io.File file ): Method not implemented");
    }

    public NWFileInputStream(JCContext jCContext, String string) throws FileNotFoundException, SecurityException {
        JClient.initialize();
        try {
            this.context = jCContext;
            this.hFile = NWFile.open(jCContext, string, (byte)1, (short)0, 0, (short)1);
            this.position = 0L;
        }
        catch (JCException jCException) {
            switch (jCException.getErrorCode()) {
                case -144: {
                    throw new SecurityException("NWFileInputStream.NWFileInputStream( JCContext context, String filespec ): " + jCException);
                }
            }
            throw new FileNotFoundException("NWFileInputStream.NWFileInputStream( JCContext context, String filespec ): " + jCException);
        }
    }

    public int available() throws IOException {
        try {
            return NWFile.getSize(this.context, this.hFile);
        }
        catch (JCException jCException) {
            throw new IOException("NWFileInputStream.available(): " + jCException);
        }
    }

    public void close() throws IOException {
        try {
            NWFile.close(this.context, this.hFile);
        }
        catch (JCException jCException) {
            throw new IOException("NWFileInputStream.close(): " + jCException);
        }
        this.hFile = -1;
        this.position = -1L;
    }

    public int getFileHandle() {
        return this.hFile;
    }

    public long getPosition() {
        return this.position;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        try {
            if (NWFile.read(this.context, this.hFile, this.position, byArray, byArray.length) == 1) {
                ++this.position;
                return byArray[0];
            }
            return -1;
        }
        catch (JCException jCException) {
            throw new IOException("NWFileInputStream.read(): " + jCException);
        }
    }

    public int read(byte[] byArray) throws IOException {
        try {
            int n = NWFile.read(this.context, this.hFile, this.position, byArray, byArray.length);
            if (n != -1) {
                this.position += (long)n;
            }
            return n;
        }
        catch (JCException jCException) {
            throw new IOException("NWFileInputStream.read( byte[] buffer ): " + jCException);
        }
    }

    public byte[] read(int n) throws IOException, IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("NWFileInputStream.read( int length )");
        }
        byte[] byArray = new byte[n];
        try {
            byte[] byArray2;
            int n2 = NWFile.read(this.context, this.hFile, this.position, byArray, byArray.length);
            if (n2 == byArray.length) {
                return byArray;
            }
            if (n2 != -1) {
                byArray2 = new byte[n2];
                System.arraycopy(byArray, 0, byArray2, 0, n2);
            } else {
                byArray2 = new byte[]{};
            }
            return byArray2;
        }
        catch (JCException jCException) {
            throw new IOException("NWFileInputStream.read( int length ): " + jCException);
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException, IllegalArgumentException {
        if (n2 < 0) {
            throw new IllegalArgumentException("NWFileInputStream.read( byte[] buffer, int offset, int length ): length < 0");
        }
        byte[] byArray2 = new byte[n2];
        try {
            int n3 = NWFile.read(this.context, this.hFile, this.position, byArray2, n2);
            if (n3 != -1) {
                System.arraycopy(byArray2, 0, byArray, n, n3);
            }
            return n3;
        }
        catch (JCException jCException) {
            throw new IOException("NWFileInputStream.read( byte[] buffer, int offset, int length ): " + jCException);
        }
    }

    public void setPosition(long l) throws IOException {
        if (this.hFile == -1) {
            throw new IOException("NWFileInputStream.setPosition( long pos ): FILE CLOSED");
        }
        this.position = l;
    }

    public long skip(long l) throws IOException {
        if (l > 0L) {
            long l2;
            try {
                l2 = NWFile.getSize(this.context, this.hFile);
            }
            catch (JCException jCException) {
                throw new IOException("NWFileInputStream.skip( long cBytesToSkip ): " + jCException);
            }
            long l3 = l2 - this.position;
            if (l3 > l) {
                this.position += l;
                return l;
            }
            this.position = l2;
            return l3;
        }
        if (this.position >= l) {
            this.position += l;
            return l;
        }
        long l4 = -this.position;
        this.position = 0L;
        return l4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() {
        try {
            this.close();
        }
        catch (IOException iOException) {
        }
        finally {
            JClient.cleanup();
        }
    }
}

