/*
 * Decompiled with CFR 0.152.
 */
package novell.jclient;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import novell.jclient.JCContext;
import novell.jclient.JCException;
import novell.jclient.JClient;
import novell.jclient.NWFile;

public class NWFileOutputStream
extends OutputStream {
    public static final int FILE_HANDLE_INVALID = -1;
    public static final long FILE_POSITION_INVALID = -1L;
    public static final long FILE_POSITION_END = -2L;
    private JCContext context;
    private int hFile;
    private long position;

    public NWFileOutputStream(JCContext jCContext, int n) throws IOException {
        this.context = jCContext;
        this.hFile = n;
        try {
            this.position = NWFile.getSize(jCContext, n);
        }
        catch (JCException jCException) {
            this.position = 0L;
            throw new IOException("NWFileOutputStream.NWFileOutputStream( JCContext context, int hFile ): " + jCException);
        }
    }

    public NWFileOutputStream(JCContext jCContext, File file) throws NoSuchMethodError {
        this.context = jCContext;
        this.hFile = -1;
        this.position = -1L;
        throw new NoSuchMethodError("NWFileOutputStream.NWFileOutputStream( JCContext context, java.io.File file ): Method not implemented");
    }

    public NWFileOutputStream(JCContext jCContext, String string) throws IOException, SecurityException {
        int n = 1;
        while (true) {
            try {
                this.hFile = NWFile.open(jCContext, string, (byte)n, (short)0, 0, (short)2);
                this.context = jCContext;
                if (n == 1) {
                    this.position = NWFile.getSize(jCContext, this.hFile);
                    break;
                }
                this.position = 0L;
            }
            catch (JCException jCException) {
                switch (jCException.getErrorCode()) {
                    case -144: {
                        throw new SecurityException("NWFileOutputStream.NWFileOutputStream( JCContext context, String filespec ): " + jCException);
                    }
                }
                if (n == 1) {
                    n = 8;
                    continue;
                }
                throw new IOException("NWFileOutputStream.NWFileOutputStream( JCContext context, String filespec ): " + jCException);
            }
            break;
        }
    }

    public int available() throws IOException {
        try {
            return NWFile.getSize(this.context, this.hFile);
        }
        catch (JCException jCException) {
            throw new IOException("NWFileOutputStream.available(): " + jCException);
        }
    }

    public void close() throws IOException {
        try {
            NWFile.close(this.context, this.hFile);
        }
        catch (JCException jCException) {
            throw new IOException("NWFileOutputStream.close: " + jCException);
        }
        this.hFile = -1;
        this.position = -1L;
    }

    public void flush() throws IOException {
        try {
            NWFile.flush(this.context, this.hFile);
        }
        catch (JCException jCException) {
            throw new IOException("NWFileOutputStream.flush: " + jCException);
        }
    }

    public int getFileHandle() {
        return this.hFile;
    }

    public long getPosition() {
        return this.position;
    }

    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        try {
            NWFile.write(this.context, this.hFile, this.position, byArray, 1);
            ++this.position;
        }
        catch (JCException jCException) {
            throw new IOException("NWFileOutputStream.write( int byteToWrite ): " + jCException);
        }
    }

    public void write(byte[] byArray) throws IOException {
        try {
            NWFile.write(this.context, this.hFile, this.position, byArray, byArray.length);
            this.position += (long)byArray.length;
        }
        catch (JCException jCException) {
            throw new IOException("NWFileOutputStream.write( byte[] buffer ): " + jCException);
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        try {
            if (n != 0) {
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, n, byArray2, 0, n2);
                NWFile.write(this.context, this.hFile, this.position, byArray2, n2);
            } else {
                NWFile.write(this.context, this.hFile, this.position, byArray, n2);
            }
            this.position += (long)n2;
        }
        catch (JCException jCException) {
            throw new IOException("NWFileOutputStream.write( byte[] buffer, int offset, int length ): " + jCException);
        }
    }

    public void setPosition(long l) throws IOException {
        if (this.hFile != -1) {
            if (l == -2L) {
                try {
                    this.position = NWFile.getSize(this.context, this.hFile);
                }
                catch (JCException jCException) {
                    throw new IOException("NWFileOutputStream.setPosition( long pos ): " + jCException);
                }
            } else {
                this.position = l;
            }
        } else {
            throw new IOException("NWFileOutputStream.setPosition( long pos ): FILE HANDLE INVALID");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() {
        try {
            this.close();
        }
        catch (IOException iOException) {
        }
        finally {
            JClient.cleanup();
        }
    }
}

