/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.io;

import java.io.IOException;
import java.net.Socket;
import org.apache.catalina.cluster.io.ListenCallback;
import org.apache.catalina.cluster.io.XByteBuffer;

public class Jdk13ObjectReader {
    private Socket socket;
    private ListenCallback callback;
    private XByteBuffer buffer;

    public Jdk13ObjectReader(Socket socket, ListenCallback callback) {
        this.socket = socket;
        this.callback = callback;
        this.buffer = new XByteBuffer();
    }

    public int append(byte[] data, int off, int len) throws IOException {
        boolean result = false;
        this.buffer.append(data, off, len);
        int pkgCnt = 0;
        boolean pkgExists = this.buffer.doesPackageExist();
        while (pkgExists) {
            byte[] b = this.buffer.extractPackage(true);
            this.callback.messageDataReceived(b);
            ++pkgCnt;
            pkgExists = this.buffer.doesPackageExist();
        }
        return pkgCnt;
    }

    public int execute() throws IOException {
        return this.append(new byte[0], 0, 0);
    }

    public int write(byte[] data) throws IOException {
        this.socket.getOutputStream().write(data);
        return 0;
    }
}

