/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.tcp;

import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.apache.catalina.Container;
import org.apache.catalina.Deployer;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.Valve;
import org.apache.catalina.cluster.CatalinaCluster;
import org.apache.catalina.cluster.ClusterDeployer;
import org.apache.catalina.cluster.ClusterManager;
import org.apache.catalina.cluster.ClusterMessage;
import org.apache.catalina.cluster.ClusterReceiver;
import org.apache.catalina.cluster.ClusterSender;
import org.apache.catalina.cluster.Member;
import org.apache.catalina.cluster.MembershipListener;
import org.apache.catalina.cluster.MembershipService;
import org.apache.catalina.cluster.MessageListener;
import org.apache.catalina.cluster.SessionMessage;
import org.apache.catalina.cluster.io.ListenCallback;
import org.apache.catalina.cluster.session.ReplicationStream;
import org.apache.catalina.cluster.session.SimpleTcpReplicationManager;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleTcpCluster
implements CatalinaCluster,
Lifecycle,
MembershipListener,
ListenCallback,
LifecycleListener {
    public static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$tcp$SimpleTcpCluster == null ? (class$org$apache$catalina$cluster$tcp$SimpleTcpCluster = SimpleTcpCluster.class$("org.apache.catalina.cluster.tcp.SimpleTcpCluster")) : class$org$apache$catalina$cluster$tcp$SimpleTcpCluster));
    protected static final String info = "SimpleTcpCluster/1.0";
    protected MembershipService membershipService = null;
    protected boolean expireSessionsOnShutdown = true;
    protected boolean printToScreen = false;
    protected boolean useDirtyFlag = false;
    protected String clusterImpName = "SimpleTcpCluster";
    protected StringManager sm = StringManager.getManager((String)"org.apache.catalina.cluster");
    protected String clusterName = null;
    protected Container container = null;
    protected LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    protected boolean started = false;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected int debug = 0;
    protected HashMap managers = new HashMap();
    private long nrOfMsgsReceived = 0L;
    private long msgSendTime = 0L;
    private long lastChecked = System.currentTimeMillis();
    protected MemberComparator memberComparator = new MemberComparator();
    private String managerClassName = "org.apache.catalina.cluster.session.DeltaManager";
    private ClusterSender clusterSender;
    private ClusterReceiver clusterReceiver;
    private Valve valve;
    private ClusterDeployer clusterDeployer;
    protected Vector clusterListeners = new Vector();
    static /* synthetic */ Class class$org$apache$catalina$cluster$tcp$SimpleTcpCluster;

    public String getInfo() {
        return info;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setContainer(Container container) {
        Container oldContainer = this.container;
        this.container = container;
        this.support.firePropertyChange("container", oldContainer, this.container);
    }

    public Container getContainer() {
        return this.container;
    }

    public void setProtocol(String protocol) {
    }

    public String getProtocol() {
        return null;
    }

    public Member[] getMembers() {
        Member[] members = this.membershipService.getMembers();
        Arrays.sort(members, this.memberComparator);
        return members;
    }

    public Member getLocalMember() {
        return this.membershipService.getLocalMember();
    }

    public synchronized Manager createManager(String name) {
        log.debug((Object)("Creating ClusterManager for context " + name + " using class " + this.getManagerClassName()));
        System.out.println("\n\n\n\nCreating ClusterManager for context " + name + " using class " + this.getManagerClassName() + "\n\n\n\n");
        ClusterManager manager = null;
        try {
            manager = (ClusterManager)this.getClass().getClassLoader().loadClass(this.getManagerClassName()).newInstance();
        }
        catch (Exception x) {
            log.error((Object)"Unable to load class for replication manager", (Throwable)x);
            manager = new SimpleTcpReplicationManager();
        }
        manager.setName(name);
        manager.setCluster(this);
        manager.setDistributable(true);
        manager.setExpireSessionsOnShutdown(this.expireSessionsOnShutdown);
        manager.setUseDirtyFlag(this.useDirtyFlag);
        this.managers.put(name, manager);
        return manager;
    }

    public void removeManager(String name) {
        this.managers.remove(name);
    }

    public Manager getManager(String name) {
        return (Manager)this.managers.get(name);
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(this.sm.getString("cluster.alreadyStarted"));
        }
        log.info((Object)"Cluster is about to start");
        try {
            MethodUtils.invokeMethod((Object)this.getContainer(), (String)"addValve", (Object)this.valve);
            this.clusterReceiver.setIsSenderSynchronized(this.clusterSender.getIsSenderSynchronized());
            this.clusterReceiver.setCatalinaCluster(this);
            this.clusterReceiver.start();
            this.clusterSender.start();
            this.membershipService.setLocalMemberProperties(this.clusterReceiver.getHost(), this.clusterReceiver.getPort());
            this.membershipService.addMembershipListener(this);
            this.membershipService.start();
            try {
                if (this.clusterDeployer != null) {
                    this.clusterDeployer.setCluster(this);
                    Object deployer = MethodUtils.invokeMethod((Object)this.getContainer(), (String)"getDeployer", (Object[])new Object[0], (Class[])new Class[0]);
                    this.clusterDeployer.setDeployer((Deployer)deployer);
                    this.clusterDeployer.start();
                }
            }
            catch (Throwable x) {
                log.fatal((Object)"Unable to retrieve the container deployer. Cluster deployment disabled.", x);
            }
            this.started = true;
        }
        catch (Exception x) {
            log.error((Object)"Unable to start cluster.", (Throwable)x);
            throw new LifecycleException((Throwable)x);
        }
    }

    public void send(ClusterMessage msg, Member dest) {
        try {
            msg.setAddress(this.membershipService.getLocalMember());
            Member destination = dest;
            if (msg instanceof SessionMessage) {
                SessionMessage smsg = (SessionMessage)msg;
                if (destination == null && smsg.getEventType() == 4 && this.membershipService.getMembers().length > 0) {
                    destination = this.membershipService.getMembers()[0];
                }
            }
            msg.setTimestamp(System.currentTimeMillis());
            ByteArrayOutputStream outs = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(outs);
            out.writeObject(msg);
            byte[] data = outs.toByteArray();
            if (destination != null) {
                Member tcpdest = dest;
                if (tcpdest != null && !this.membershipService.getLocalMember().equals(tcpdest)) {
                    this.clusterSender.sendMessage(msg.getUniqueId(), data, tcpdest);
                }
            } else {
                this.clusterSender.sendMessage(msg.getUniqueId(), data);
            }
        }
        catch (Exception x) {
            log.error((Object)"Unable to send message through cluster sender.", (Throwable)x);
        }
    }

    public void send(ClusterMessage msg) {
        this.send(msg, null);
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new IllegalStateException(this.sm.getString("cluster.notStarted"));
        }
        this.membershipService.stop();
        this.membershipService.removeMembershipListener();
        try {
            this.clusterSender.stop();
        }
        catch (Exception x) {
            log.error((Object)"Unable to stop cluster sender.", (Throwable)x);
        }
        try {
            this.clusterReceiver.stop();
            this.clusterReceiver.setCatalinaCluster(null);
        }
        catch (Exception x) {
            log.error((Object)"Unable to stop cluster receiver.", (Throwable)x);
        }
        if (this.clusterDeployer != null) {
            this.clusterDeployer.stop();
        }
        this.started = false;
    }

    public void memberAdded(Member member) {
        try {
            log.info((Object)("Replication member added:" + member));
            this.clusterSender.add(member);
        }
        catch (Exception x) {
            log.error((Object)"Unable to connect to replication system.", (Throwable)x);
        }
    }

    public void memberDisappeared(Member member) {
        log.info((Object)("Received member disappeared:" + member));
        try {
            this.clusterSender.remove(member);
        }
        catch (Exception x) {
            log.error((Object)"Unable remove cluster node from replication system.", (Throwable)x);
        }
    }

    public void setExpireSessionsOnShutdown(boolean expireSessionsOnShutdown) {
        this.expireSessionsOnShutdown = expireSessionsOnShutdown;
    }

    public void setPrintToScreen(boolean printToScreen) {
        this.printToScreen = printToScreen;
    }

    public void setUseDirtyFlag(boolean useDirtyFlag) {
        this.useDirtyFlag = useDirtyFlag;
    }

    public void messageDataReceived(byte[] data) {
        try {
            ReplicationStream stream = new ReplicationStream(new ByteArrayInputStream(data), this.getClass().getClassLoader());
            Object myobj = stream.readObject();
            if (myobj != null && myobj instanceof SessionMessage) {
                SessionMessage msg = (SessionMessage)myobj;
                log.debug((Object)("Assuming clocks are synched: Replication took=" + (System.currentTimeMillis() - msg.getTimestamp()) + " ms."));
                String ctxname = msg.getContextName();
                if (ctxname == null) {
                    Iterator i = this.managers.keySet().iterator();
                    while (i.hasNext()) {
                        String key = (String)i.next();
                        ClusterManager mgr = (ClusterManager)this.managers.get(key);
                        if (mgr != null) {
                            mgr.messageDataReceived(msg);
                            continue;
                        }
                        log.debug((Object)("Context manager doesn't exist:" + key));
                    }
                } else {
                    ClusterManager mgr = (ClusterManager)this.managers.get(ctxname);
                    if (mgr != null) {
                        mgr.messageDataReceived(msg);
                    } else {
                        log.warn((Object)("Context manager doesn't exist:" + ctxname));
                    }
                }
            } else {
                for (int i = 0; i < this.clusterListeners.size(); ++i) {
                    MessageListener listener = (MessageListener)this.clusterListeners.elementAt(i);
                    if (myobj == null || !(myobj instanceof ClusterMessage) || !listener.accept((ClusterMessage)myobj)) continue;
                    listener.messageReceived((ClusterMessage)myobj);
                }
            }
        }
        catch (Exception x) {
            log.error((Object)"Unable to deserialize session message.", (Throwable)x);
        }
    }

    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        log.debug((Object)("\nlifecycleEvent\n\nType" + lifecycleEvent.getType() + "\nData" + lifecycleEvent.getData() + "\n\n\n"));
    }

    public void startContext(String contextPath) throws IOException {
    }

    public void installContext(String contextPath, URL war) {
        log.debug((Object)("\n\n\n\nCluster Install called for context:" + contextPath + "\n\n\n\n"));
    }

    public void stop(String contextPath) throws IOException {
    }

    public Log getLogger() {
        return log;
    }

    private void perfMessageRecvd(long timeSent) {
        ++this.nrOfMsgsReceived;
        this.msgSendTime += System.currentTimeMillis() - timeSent;
        if (System.currentTimeMillis() - this.lastChecked > 5000L) {
            log.debug((Object)("Calc msg send time total=" + this.msgSendTime + "ms num request=" + this.nrOfMsgsReceived + " average per msg=" + this.msgSendTime / this.nrOfMsgsReceived + "ms."));
        }
    }

    public String getManagerClassName() {
        return this.managerClassName;
    }

    public void setManagerClassName(String managerClassName) {
        this.managerClassName = managerClassName;
    }

    public ClusterSender getClusterSender() {
        return this.clusterSender;
    }

    public void setClusterSender(ClusterSender clusterSender) {
        this.clusterSender = clusterSender;
    }

    public ClusterReceiver getClusterReceiver() {
        return this.clusterReceiver;
    }

    public void setClusterReceiver(ClusterReceiver clusterReceiver) {
        this.clusterReceiver = clusterReceiver;
    }

    public MembershipService getMembershipService() {
        return this.membershipService;
    }

    public void setMembershipService(MembershipService membershipService) {
        this.membershipService = membershipService;
    }

    public void addValve(Valve valve) {
        this.valve = valve;
    }

    public void addClusterListener(MessageListener listener) {
        if (!this.clusterListeners.contains(listener)) {
            this.clusterListeners.addElement(listener);
        }
    }

    public void removeClusterListener(MessageListener listener) {
        this.clusterListeners.removeElement(listener);
    }

    public ClusterDeployer getClusterDeployer() {
        return this.clusterDeployer;
    }

    public void setClusterDeployer(ClusterDeployer clusterDeployer) {
        this.clusterDeployer = clusterDeployer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MemberComparator
    implements Comparator {
        private MemberComparator() {
        }

        public int compare(Object o1, Object o2) {
            try {
                return this.compare((Member)o1, (Member)o2);
            }
            catch (ClassCastException x) {
                return 0;
            }
        }

        public int compare(Member m1, Member m2) {
            long result = m2.getMemberAliveTime() - m1.getMemberAliveTime();
            if (result < 0L) {
                return -1;
            }
            if (result == 0L) {
                return 0;
            }
            return 1;
        }
    }
}

