/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.configManager;

import com.novell.emframe.fw.FwUtils;
import com.novell.nps.WebappUtil;
import com.novell.nps.authentication.PortalConnection;
import com.novell.nps.authentication.PortalDirectoryException;
import com.novell.nps.authentication.PortalObjectAttribute;
import com.novell.nps.configManager.AdminAPI;
import com.novell.nps.configManager.ConfigSettings;
import com.novell.nps.configManager.ObjectConfig;
import com.novell.nps.configManager.ObjectConfigRecord;
import com.novell.nps.debug.Debug;
import com.novell.nps.gadgetManager.GadgetManager;
import com.novell.nps.i18n.ResourceFileMap;
import com.novell.nps.sessionManager.PortalSession;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.http.HttpSession;

public class GadgetConfig
implements Cloneable,
Serializable {
    private static final String DT = "GadgetConfig";
    public static final String GADGETID = "GADGETID";
    public static final String GADGETFDN = "GADGETFDN";
    public static final String CATEGORIES_SETTING = "Categories";
    public static final String GADGET_CATEGORIES = "GadgetCategories";
    public static final String SUPPORTS_TABLE_DATA = "SupportsTableData";
    public static final String SUPPORTS_FULL_FRAME = "SupportsFullFrame";
    public static final String ASSIGNABLE_GADGET = "AssignableGadget";
    public static final String SERVICE_NAME = "ServiceName";
    public static final String FALSE = "false";
    public static final String TRUE = "true";
    public static final String SUPPORTS_TABLE_DATA_DEFAULT = "true";
    public static final String SUPPORTS_FULL_FRAME_DEFAULT = "false";
    public static final String ASSIGNABLE_GADGET_DEFAULT = "true";
    private String m_sFDN = null;
    private String m_sGUID = null;
    private String m_sPortalGUID = null;
    private String m_sInstanceClassName = null;
    private String[] m_saInstanceArgs = null;
    private String m_sClassName = null;
    private String[] m_saArgs = null;
    private ConfigSettings m_settings = null;
    private Vector m_vDNList = null;
    private Vector m_vPortalDNList = null;
    private Vector m_vUserDNList = null;
    private Vector m_vTaskDNList = null;
    private String m_sVersion = null;
    private ObjectConfigRecord m_ocrAvail = null;
    private HashMap m_gadgetConfigSettingsCache = new HashMap();
    private ConfigSettings m_gadgetObjectSettings = null;
    private Hashtable m_htCategoryList = null;
    private Vector m_vParentModuleList = null;

    public GadgetConfig(PortalConnection pc, String sGadgetDN, String sPortalGUID) throws PortalDirectoryException {
        Vector vCachedRecords = null;
        this.m_vDNList = new Vector();
        this.m_vTaskDNList = new Vector();
        PortalObjectAttribute poa = null;
        Vector<PortalObjectAttribute> vPOA = new Vector<PortalObjectAttribute>();
        poa = new PortalObjectAttribute("bhObjectGUID", 3, null);
        vPOA.add(poa);
        poa = new PortalObjectAttribute("bhClassName", 1, null);
        vPOA.add(poa);
        poa = new PortalObjectAttribute("bhArguments", 2, null);
        vPOA.add(poa);
        poa = new PortalObjectAttribute("bhInstanceClassName", 1, null);
        vPOA.add(poa);
        poa = new PortalObjectAttribute("bhInstanceArguments", 2, null);
        vPOA.add(poa);
        poa = new PortalObjectAttribute("bhObjectList", 2, null);
        vPOA.add(poa);
        poa = new PortalObjectAttribute("bhTaskList", 2, null);
        vPOA.add(poa);
        poa = new PortalObjectAttribute("cn", 1, null);
        vPOA.add(poa);
        poa = new PortalObjectAttribute("bhVersion", 1, null);
        vPOA.add(poa);
        poa = new PortalObjectAttribute("bhPackageName", 1, null);
        vPOA.add(poa);
        poa = new PortalObjectAttribute("bhParentModuleList", 2, null);
        vPOA.add(poa);
        poa = new PortalObjectAttribute("bhConfig", 4, null);
        vPOA.add(poa);
        pc.readAttributes(sGadgetDN, vPOA);
        String sAttr = null;
        Vector vData = null;
        for (int i = 0; i < vPOA.size(); ++i) {
            poa = (PortalObjectAttribute)vPOA.elementAt(i);
            vData = poa.getData();
            if (vData == null) continue;
            sAttr = poa.getName();
            if (sAttr.equalsIgnoreCase("bhObjectGUID")) {
                if (vData.size() <= 0) continue;
                this.m_sGUID = new String((byte[])vData.elementAt(0));
                continue;
            }
            if (sAttr.equalsIgnoreCase("bhClassName")) {
                if (vData.size() <= 0) continue;
                this.m_sClassName = (String)vData.elementAt(0);
                continue;
            }
            if (sAttr.equalsIgnoreCase("bhArguments")) {
                this.m_saArgs = new String[vData.size()];
                vData.toArray(this.m_saArgs);
                continue;
            }
            if (sAttr.equalsIgnoreCase("bhInstanceClassName")) {
                if (vData.size() <= 0) continue;
                this.m_sInstanceClassName = (String)vData.elementAt(0);
                continue;
            }
            if (sAttr.equalsIgnoreCase("bhInstanceArguments")) {
                this.m_saInstanceArgs = new String[vData.size()];
                vData.toArray(this.m_saInstanceArgs);
                continue;
            }
            if (sAttr.equalsIgnoreCase("bhObjectList")) {
                this.m_vDNList = vData;
                continue;
            }
            if (sAttr.equalsIgnoreCase("bhTaskList")) {
                this.m_vTaskDNList = vData;
                continue;
            }
            if (sAttr.equalsIgnoreCase("bhVersion")) {
                if (vData.size() <= 0) continue;
                this.m_sVersion = (String)vData.elementAt(0);
                continue;
            }
            if (sAttr.equalsIgnoreCase("bhParentModuleList")) {
                this.m_vParentModuleList = vData;
                continue;
            }
            if (!sAttr.equalsIgnoreCase("bhConfig")) continue;
            vCachedRecords = vData;
        }
        if (this.m_sGUID == null) {
            return;
        }
        this.m_sFDN = sGadgetDN;
        this.m_sPortalGUID = sPortalGUID;
        ObjectConfig oc = new ObjectConfig(sPortalGUID, this.m_sFDN, "bhConfig");
        if (vCachedRecords != null) {
            oc.read(vCachedRecords);
        } else {
            oc.read(pc);
        }
        Vector recs = oc.getRecords();
        if (recs != null && !recs.isEmpty()) {
            Enumeration e = recs.elements();
            while (e.hasMoreElements()) {
                ObjectConfigRecord ocr = (ObjectConfigRecord)e.nextElement();
                if (ocr.getType() == 3) {
                    this.m_settings = new ConfigSettings(ocr);
                    this.m_settings.readSettings();
                    continue;
                }
                if (ocr.getType() != 0) continue;
                this.m_gadgetObjectSettings = new ConfigSettings(ocr);
                this.m_gadgetObjectSettings.readSettings();
            }
        }
    }

    public ConfigSettings getConfigSettings() {
        return this.m_settings;
    }

    public void setConfigSettings(ConfigSettings settings) {
        this.m_settings = settings;
    }

    public void setConfigSettings(InputStream is) {
        ObjectConfigRecord ocr = new ObjectConfigRecord(is);
        this.m_settings = new ConfigSettings(ocr);
        this.m_settings.readSettings();
    }

    public ConfigSettings getGadgetObjectSettings() {
        return this.m_gadgetObjectSettings;
    }

    public void setGadgetObjectSettings(ConfigSettings settings) {
        this.m_gadgetObjectSettings = settings;
        this.m_htCategoryList = null;
    }

    public void setGadgetObjectSettings(InputStream is) {
        ObjectConfigRecord ocr = new ObjectConfigRecord(is);
        this.m_gadgetObjectSettings = new ConfigSettings(ocr);
        this.m_gadgetObjectSettings.readSettings();
        this.m_htCategoryList = null;
    }

    public void setAvailableConfigSettingsCache(HashMap gadgetConfigSettingsCache) {
        this.m_gadgetConfigSettingsCache = gadgetConfigSettingsCache;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConfigSettings getAvailableConfigSettings(PortalSession session) {
        ConfigSettings availableSettings = null;
        String sDTDPath = null;
        try {
            StringBuffer sbFile;
            block12: {
                StringBuffer sbPath = new StringBuffer();
                sbPath.append(WebappUtil.getRealPath(GadgetManager.getPublishedResourcePathRelToCX()));
                sbPath.append("/gadgets");
                sbPath.append(File.separator);
                sbPath.append(this.m_sInstanceClassName);
                sbPath.append(File.separator);
                sbPath.append("AvailableSettings.xml");
                String sPath = sbPath.toString();
                sDTDPath = this.getLanguageFile(sPath, session);
                availableSettings = (ConfigSettings)this.m_gadgetConfigSettingsCache.get(sDTDPath);
                if (availableSettings != null) return availableSettings;
                File source = new File(sPath);
                FileInputStream fis = new FileInputStream(source);
                BufferedInputStream bis = new BufferedInputStream(fis);
                byte[] baFile = new byte[(int)source.length()];
                bis.read(baFile);
                bis.close();
                String sFile = new String(baFile, "UTF8");
                sbFile = new StringBuffer(sFile);
                int iDoctype = sFile.indexOf("<!DOCTYPE");
                if (iDoctype != -1) {
                    int iEndDoctype = sFile.indexOf(">", iDoctype);
                    if (iEndDoctype > iDoctype) {
                        sbFile.delete(iDoctype, iEndDoctype + 1);
                    } else {
                        if (Debug.isLoggable(3)) {
                            Debug.log(DT, 3, "Malformed AvailableSettings.xml file for " + this.m_sInstanceClassName);
                        }
                        availableSettings = new ConfigSettings();
                        this.m_gadgetConfigSettingsCache.put(sDTDPath, availableSettings);
                        return availableSettings;
                    }
                }
                if (sDTDPath != null && sDTDPath.length() != 0) {
                    sFile = sbFile.toString();
                    int iXMLHeader = sFile.indexOf("<?xml version");
                    if (iXMLHeader != -1) {
                        int iEndXMLHeader = sFile.indexOf("?>", iXMLHeader);
                        if (iEndXMLHeader > iXMLHeader) {
                            sbFile.insert(iEndXMLHeader + 2, "<!DOCTYPE config SYSTEM \"" + sDTDPath + "\">");
                            sFile = sbFile.toString();
                            break block12;
                        } else {
                            if (Debug.isLoggable(3)) {
                                Debug.log(DT, 3, "Malformed AvailableSettings.xml file for " + this.m_sInstanceClassName);
                            }
                            availableSettings = new ConfigSettings();
                            this.m_gadgetConfigSettingsCache.put(sDTDPath, availableSettings);
                            return availableSettings;
                        }
                    }
                    if (Debug.isLoggable(3)) {
                        Debug.log(DT, 3, "Malformed AvailableSettings.xml file for " + this.m_sInstanceClassName);
                    }
                    availableSettings = new ConfigSettings();
                    this.m_gadgetConfigSettingsCache.put(sDTDPath, availableSettings);
                    return availableSettings;
                }
            }
            StringReader sr = new StringReader(sbFile.toString());
            ObjectConfigRecord ocr = new ObjectConfigRecord(sr);
            ocr.setType(6);
            availableSettings = new ConfigSettings(ocr);
            availableSettings.readSettings();
            sr.close();
            this.m_gadgetConfigSettingsCache.put(sDTDPath, availableSettings);
            return availableSettings;
        }
        catch (IOException e) {
            availableSettings = new ConfigSettings();
            this.m_gadgetConfigSettingsCache.put(sDTDPath, availableSettings);
        }
        return availableSettings;
    }

    public String getLanguageFile(String sPath, PortalSession session) {
        ResourceFileMap rfm = GadgetManager.getGadgetResourceFileMap(this.m_sInstanceClassName);
        if (rfm == null) {
            return null;
        }
        Locale currentLocale = FwUtils.getCurrentLocale((HttpSession)session);
        String sLanguageFile = rfm.getLocalizedPath("AvailableSettings.dtd", session, currentLocale);
        if (sLanguageFile != null && sLanguageFile.length() != 0) {
            StringBuffer sbLanguagePath = new StringBuffer();
            sbLanguagePath.append("file:");
            sbLanguagePath.append(WebappUtil.getRealPath("/"));
            if (sLanguageFile.charAt(0) == '/' || sLanguageFile.charAt(0) == '\\') {
                sbLanguagePath.append(sLanguageFile.substring(1));
            } else {
                sbLanguagePath.append(sLanguageFile);
            }
            return sbLanguagePath.toString();
        }
        return null;
    }

    public void setAvailableConfigDOM(InputStream is) {
        this.m_ocrAvail = new ObjectConfigRecord(is);
    }

    public String getGUID() {
        return this.m_sGUID;
    }

    public void setGUID(String sGUID) {
        this.m_sGUID = sGUID;
    }

    public String getPortalGUID() {
        return this.m_sPortalGUID;
    }

    public void setPortalGUID(String sPortalGUID) {
        this.m_sPortalGUID = sPortalGUID;
    }

    public String getFDN() {
        return this.m_sFDN;
    }

    public void setFDN(String sFDN) {
        this.m_sFDN = sFDN;
    }

    public String getGadgetInstanceClass() {
        return this.m_sInstanceClassName;
    }

    public void setGadgetInstanceClass(String sClass) {
        this.m_sInstanceClassName = sClass;
    }

    public String getGadgetClass() {
        return this.m_sClassName;
    }

    public void setGadgetClass(String sClass) {
        this.m_sClassName = sClass;
    }

    public String[] getGadgetInstanceArgs() {
        return this.m_saInstanceArgs;
    }

    public void setGadgetInstanceArgs(String[] saArgs) {
        this.m_saInstanceArgs = saArgs;
    }

    public Vector getParentModuleList() {
        return this.m_vParentModuleList;
    }

    public void setParentModuleList(Vector vParentModuleList) {
        this.m_vParentModuleList = vParentModuleList;
    }

    public String getGadgetName() {
        String sName = null;
        if (this.m_gadgetObjectSettings != null) {
            sName = this.m_gadgetObjectSettings.getSingleSetting("Name");
        }
        if (sName == null || sName.length() == 0) {
            sName = AdminAPI.getDNFromFDN(this.m_sFDN);
        }
        return sName;
    }

    public void setGadgetName(String sGadgetName) {
        if (this.m_gadgetObjectSettings == null) {
            this.m_gadgetObjectSettings = new ConfigSettings();
        }
        this.m_gadgetObjectSettings.setSetting("Name", sGadgetName);
    }

    public String getGadgetDescription() {
        String sDescription = null;
        if (this.m_gadgetObjectSettings != null) {
            sDescription = this.m_gadgetObjectSettings.getSingleSetting("Description");
        }
        return sDescription;
    }

    public void setGadgetDescription(String sGadgetDescription) {
        if (this.m_gadgetObjectSettings == null) {
            this.m_gadgetObjectSettings = new ConfigSettings();
        }
        this.m_gadgetObjectSettings.setSetting("Description", sGadgetDescription);
    }

    public boolean getSupportsTableData() {
        String sSupport = null;
        boolean bSupport = true;
        if (this.m_gadgetObjectSettings != null) {
            sSupport = this.m_gadgetObjectSettings.getSingleSetting(SUPPORTS_TABLE_DATA, "true");
            bSupport = sSupport == null || !sSupport.equalsIgnoreCase("false");
        }
        return bSupport;
    }

    public void setSupportsTableData(boolean bSupports) {
        if (this.m_gadgetObjectSettings == null) {
            this.m_gadgetObjectSettings = new ConfigSettings();
        }
        if (bSupports) {
            this.m_gadgetObjectSettings.setSetting(SUPPORTS_TABLE_DATA, "true");
        } else {
            this.m_gadgetObjectSettings.setSetting(SUPPORTS_TABLE_DATA, "false");
        }
    }

    public boolean getSupportsFullFrame() {
        String sSupport = null;
        boolean bSupport = true;
        if (this.m_gadgetObjectSettings != null) {
            sSupport = this.m_gadgetObjectSettings.getSingleSetting(SUPPORTS_FULL_FRAME, "false");
            bSupport = sSupport == null || !sSupport.equalsIgnoreCase("false");
        }
        return bSupport;
    }

    public void setSupportsFullFrame(boolean bSupports) {
        if (this.m_gadgetObjectSettings == null) {
            this.m_gadgetObjectSettings = new ConfigSettings();
        }
        if (bSupports) {
            this.m_gadgetObjectSettings.setSetting(SUPPORTS_FULL_FRAME, "true");
        } else {
            this.m_gadgetObjectSettings.setSetting(SUPPORTS_FULL_FRAME, "false");
        }
    }

    public boolean getIsAssignable() {
        String sAssignable = null;
        boolean bAssignable = true;
        if (this.m_gadgetObjectSettings != null) {
            sAssignable = this.m_gadgetObjectSettings.getSingleSetting(ASSIGNABLE_GADGET, "true");
            bAssignable = sAssignable == null || !sAssignable.equalsIgnoreCase("false");
        }
        return bAssignable;
    }

    public void setIsAssignable(boolean bAssignable) {
        if (this.m_gadgetObjectSettings == null) {
            this.m_gadgetObjectSettings = new ConfigSettings();
        }
        if (bAssignable) {
            this.m_gadgetObjectSettings.setSetting(ASSIGNABLE_GADGET, "true");
        } else {
            this.m_gadgetObjectSettings.setSetting(ASSIGNABLE_GADGET, "false");
        }
    }

    public String getServiceName() {
        String sServiceName = null;
        if (this.m_gadgetObjectSettings != null) {
            sServiceName = this.m_gadgetObjectSettings.getSingleSetting(SERVICE_NAME);
        }
        if (sServiceName == null || sServiceName.length() == 0) {
            sServiceName = this.getGUID();
        }
        return sServiceName;
    }

    public void setServiceName(String sServiceName) {
        if (this.m_gadgetObjectSettings == null) {
            this.m_gadgetObjectSettings = new ConfigSettings();
        }
        this.m_gadgetObjectSettings.setSetting(SERVICE_NAME, sServiceName);
    }

    public String[] getGadgetArgs() {
        return this.m_saArgs;
    }

    public void setGadgetArgs(String[] saArgs) {
        this.m_saArgs = saArgs;
    }

    public String getVersion() {
        return this.m_sVersion;
    }

    public void setVersion(String sVersion) {
        this.m_sVersion = sVersion;
    }

    public Vector getCategoryList() {
        String[] saList;
        Vector<String> vRet = new Vector<String>();
        if (this.m_gadgetObjectSettings != null && (saList = this.m_gadgetObjectSettings.getSetting(CATEGORIES_SETTING)) != null) {
            for (int i = 0; i < saList.length; ++i) {
                vRet.add(saList[i]);
            }
        }
        return vRet;
    }

    public boolean isCategoryMatch(Vector vCategories) {
        boolean bRet;
        block7: {
            block8: {
                block6: {
                    bRet = false;
                    if (this.m_htCategoryList == null) {
                        String sTemp = null;
                        Hashtable<String, String> htCategoryList = new Hashtable<String, String>();
                        String[] saList = null;
                        if (this.m_gadgetObjectSettings != null) {
                            saList = this.m_gadgetObjectSettings.getSetting(CATEGORIES_SETTING);
                        }
                        if (saList != null) {
                            for (int i = 0; i < saList.length; ++i) {
                                sTemp = saList[i];
                                htCategoryList.put(sTemp, sTemp);
                            }
                        }
                        this.m_htCategoryList = htCategoryList;
                    }
                    if (vCategories != null) break block6;
                    bRet = true;
                    break block7;
                }
                if (vCategories.size() != 0) break block8;
                if (this.m_htCategoryList != null && this.m_htCategoryList.size() != 0) break block7;
                bRet = true;
                break block7;
            }
            if (this.m_htCategoryList != null && this.m_htCategoryList.size() > 0) {
                bRet = true;
                for (int i = 0; i < vCategories.size(); ++i) {
                    if (this.m_htCategoryList.get((String)vCategories.elementAt(i)) != null) continue;
                    bRet = false;
                    break;
                }
            }
        }
        return bRet;
    }

    public void writeGadgetParameters(PortalConnection pc) throws PortalDirectoryException {
        String[] saTemp;
        pc.writeStringAttribute(this.m_sFDN, "bhClassName", this.m_sClassName);
        pc.writeMultiStringAttribute(this.m_sFDN, "bhArguments", this.m_saArgs, true);
        pc.writeStringAttribute(this.m_sFDN, "bhInstanceClassName", this.m_sInstanceClassName);
        pc.writeMultiStringAttribute(this.m_sFDN, "bhInstanceArguments", this.m_saInstanceArgs, true);
        pc.writeStringAttribute(this.m_sFDN, "bhVersion", this.m_sVersion);
        if (this.m_vParentModuleList != null) {
            saTemp = new String[this.m_vParentModuleList.size()];
            this.m_vParentModuleList.toArray(saTemp);
            pc.writeMultiStringAttribute(this.m_sFDN, "bhParentModuleList", saTemp, true);
        }
        if (this.m_vTaskDNList != null) {
            saTemp = new String[this.m_vTaskDNList.size()];
            this.m_vTaskDNList.toArray(saTemp);
            pc.writeMultiStringAttribute(this.m_sFDN, "bhTaskList", saTemp, true);
        }
    }

    public void writeConfigSettings(PortalConnection pc) throws PortalDirectoryException {
        if (this.m_settings == null) {
            return;
        }
        ObjectConfigRecord ocr = new ObjectConfigRecord(this.m_settings);
        ocr.setGadgetID(0);
        ocr.setObjectGUID(this.m_sGUID);
        ocr.setPCO(this.m_sPortalGUID);
        ocr.setSchemeID(0);
        ocr.setType(3);
        ocr.convertDOMtoXML();
        ObjectConfig oc = new ObjectConfig(this.m_sGUID, this.m_sFDN, "bhConfig");
        oc.writeRecord(pc, ocr);
    }

    public void writeGadgetObjectSettings(PortalConnection pc) throws PortalDirectoryException {
        if (this.m_gadgetObjectSettings == null) {
            return;
        }
        ObjectConfigRecord ocr = new ObjectConfigRecord(this.m_gadgetObjectSettings);
        ocr.setGadgetID(0);
        ocr.setObjectGUID(this.m_sGUID);
        ocr.setPCO(this.m_sPortalGUID);
        ocr.setSchemeID(0);
        ocr.setType(0);
        ocr.convertDOMtoXML();
        ObjectConfig oc = new ObjectConfig(this.m_sPortalGUID, this.m_sFDN, "bhConfig");
        oc.writeRecord(pc, ocr);
    }

    public void deleteConfigSettings(PortalConnection pc) {
        if (this.m_ocrAvail == null) {
            return;
        }
        if (!this.m_ocrAvail.isValid()) {
            return;
        }
        this.m_ocrAvail.setGadgetID(0);
        this.m_ocrAvail.setObjectGUID(this.m_sGUID);
        this.m_ocrAvail.setPCO(this.m_sPortalGUID);
        this.m_ocrAvail.setSchemeID(0);
        this.m_ocrAvail.setType(6);
        ObjectConfig oc = new ObjectConfig(this.m_sGUID, this.m_sFDN, "bhConfig");
        try {
            oc.deleteRecord(pc, this.m_ocrAvail);
        }
        catch (PortalDirectoryException portalDirectoryException) {
            // empty catch block
        }
    }

    public void writeAvailableConfigDOM(PortalConnection pc) throws PortalDirectoryException {
        if (this.m_ocrAvail == null) {
            return;
        }
        if (!this.m_ocrAvail.isValid()) {
            return;
        }
        this.m_ocrAvail.setGadgetID(0);
        this.m_ocrAvail.setObjectGUID(this.m_sGUID);
        this.m_ocrAvail.setPCO(this.m_sPortalGUID);
        this.m_ocrAvail.setSchemeID(0);
        this.m_ocrAvail.setType(6);
        this.m_ocrAvail.convertDOMtoXML();
        ObjectConfig oc = new ObjectConfig(this.m_sGUID, this.m_sFDN, "bhConfig");
        oc.writeRecord(pc, this.m_ocrAvail);
    }

    public Vector getDNList() {
        return this.m_vDNList;
    }

    public void setDNList(Vector vDNList) {
        this.m_vDNList = vDNList;
    }

    public Vector getTaskDNList() {
        return this.m_vTaskDNList;
    }

    public void setTaskDNList(Vector vTaskDNList) {
        this.m_vTaskDNList = vTaskDNList;
    }

    public Vector getPortalDNList(PortalConnection pc) {
        if (this.m_vPortalDNList == null) {
            this.fillPortalUserLists(pc);
        }
        return this.m_vPortalDNList;
    }

    public void setPortalDNList(Vector vPortalDNList) {
        this.m_vPortalDNList = vPortalDNList;
    }

    public Vector getUserDNList(PortalConnection pc) {
        if (this.m_vUserDNList == null) {
            this.fillPortalUserLists(pc);
        }
        return this.m_vUserDNList;
    }

    public void setUserDNList(Vector vUserDNList) {
        this.m_vUserDNList = vUserDNList;
    }

    private void fillPortalUserLists(PortalConnection pc) {
        String sDN = null;
        this.m_vPortalDNList = new Vector();
        this.m_vUserDNList = new Vector();
        for (int i = 0; i < this.m_vDNList.size(); ++i) {
            boolean bFound;
            sDN = (String)this.m_vDNList.elementAt(i);
            try {
                bFound = pc.verifyObjectClass(sDN, "bhPortal");
            }
            catch (PortalDirectoryException e) {
                bFound = false;
            }
            if (bFound) {
                this.m_vPortalDNList.addElement(sDN);
                continue;
            }
            this.m_vUserDNList.addElement(sDN);
        }
    }

    public static String getDirectoryClass() {
        return "bhGadget";
    }
}

