/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.configManager;

import com.novell.nps.authentication.PortalConnection;
import com.novell.nps.authentication.PortalDirectoryException;
import com.novell.nps.configManager.AdminAPI;
import com.novell.nps.configManager.ConfigData;
import com.novell.nps.configManager.ConfigManager;
import com.novell.nps.configManager.ConfigSettings;
import com.novell.nps.configManager.GadgetAssignment;
import com.novell.nps.configManager.ObjectConfig;
import com.novell.nps.configManager.ObjectConfigRecord;
import com.novell.nps.configManager.Scheme;
import com.novell.nps.configManager.Setting;
import com.novell.nps.configManager.SettingValue;
import com.novell.nps.debug.Debug;
import com.novell.nps.sessionManager.PortalSession;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;

public class Inheritance
implements Cloneable,
Serializable {
    private static final String DT = "Inheritance";
    public static final int REC_TYPE_OC = 0;
    public static final int REC_TYPE_OS = 1;
    public static final int REC_TYPE_BA = 2;
    public static final int REC_TYPE_GC = 3;
    public static final int REC_TYPE_OSOV = 5;
    public static final int REC_TYPE_AGC = 6;
    public static final int REC_TYPE_DCF = 7;
    public static final int REC_TYPE_TREE_HISTORY = 9;
    public static final int REC_TYPE_FAVORITES = 10;
    public static final int REC_TYPE_PRIMARY_VIEW_ID = 11;
    public static final int REC_TYPE_PS = 12;
    public static final String READ_PARENT_SCHEMES = "Read Parent Schemes";
    public static final int DEFAULT_READ_PARENT_SCHEMES = 1;
    public static final String PAGE_ELEMENT = "Page";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String ACTUAL_NAME_ATTRIBUTE = "actualname";
    public static final String ID_ATTRIBUTE = "id";
    public static final String UNIQUE_ID_ATTRIBUTE = "uid";
    public static final String PRIORITY_ATTRIBUTE = "priority";
    public static final String USER_ADDED_ATTRIBUTE = "useradded";
    private Vector m_objectSchemes = null;
    private Scheme m_brandingScheme = null;
    private Vector m_vBrandingSchemes = null;
    private String m_szObject = null;
    private ConfigData m_directoryConfig = null;
    private Vector m_schemeOverrides = null;
    private Vector m_gadgetConfigOverrides = new Vector();
    private long m_lastChanged = 0L;
    private long m_lastRead = 0L;
    private long m_lServicesTimestamp = 0L;
    private int m_iRecordCount = 0;
    private int m_iDataSize = 0;
    private ObjectConfig m_ocCache = null;
    private boolean m_bIsValid = true;
    private Hashtable m_htObjectGUIDs = null;
    private Scheme m_defaultScheme = null;
    private Vector m_vServices = null;
    private HashMap m_hmAllAssignments = null;
    private Object m_hmAllAssignmentsSync = new Object();

    public Vector getObjectSchemes() {
        return this.m_objectSchemes;
    }

    public void setObjectSchemes(Vector OS) {
        this.m_objectSchemes = OS;
    }

    public Vector getGadgetConfigOverrides() {
        return this.m_gadgetConfigOverrides;
    }

    public void setGadgetConfigOverrides(Vector CDOV) {
        this.m_gadgetConfigOverrides = CDOV;
    }

    public void addObjectSchemes(PortalSession session, Vector vOS) {
        this.addObjectSchemes(session, vOS, null);
    }

    public void addObjectSchemes(PortalSession session, Vector vOS, String sUserFilterString) {
        String sSchemeUserFilterString = null;
        if (vOS != null) {
            Scheme tempScheme = null;
            Enumeration e = vOS.elements();
            while (e.hasMoreElements()) {
                tempScheme = (Scheme)e.nextElement();
                sSchemeUserFilterString = tempScheme.getUserFilterString();
                if (!(sUserFilterString != null && sUserFilterString.length() != 0 || sSchemeUserFilterString != null && sSchemeUserFilterString.length() != 0)) {
                    if (this.bIsSchemePresent(this.m_objectSchemes, tempScheme)) continue;
                    if (this.m_objectSchemes == null) {
                        this.m_objectSchemes = new Vector();
                    }
                    this.m_objectSchemes.add(tempScheme);
                    continue;
                }
                if (sUserFilterString == null || !sUserFilterString.equalsIgnoreCase(sSchemeUserFilterString) || this.bIsSchemePresent(this.m_objectSchemes, tempScheme)) continue;
                if (this.m_objectSchemes == null) {
                    this.m_objectSchemes = new Vector();
                }
                this.m_objectSchemes.add(tempScheme);
            }
        }
    }

    public Scheme getBrandingAreaScheme() {
        if (this.m_brandingScheme == null && this.m_vBrandingSchemes != null) {
            Scheme lowScheme = null;
            int iPriorityBA = Integer.MAX_VALUE;
            int iCount = this.m_vBrandingSchemes.size();
            for (int i = 0; i < iCount; ++i) {
                Scheme tempScheme = (Scheme)this.m_vBrandingSchemes.elementAt(i);
                ConfigData cd = tempScheme.getSettings();
                int iTemp = cd.getSingleIntSetting("Scheme Priority", 0);
                if (iTemp >= iPriorityBA) continue;
                lowScheme = tempScheme;
                iPriorityBA = iTemp;
            }
            this.m_brandingScheme = lowScheme;
        }
        return this.m_brandingScheme;
    }

    private Scheme getExactDefaultScheme() {
        Scheme baScheme = this.getBrandingAreaScheme();
        if (baScheme != null) {
            String defaultObjectScheme = null;
            String[] defaultObjectSchemePath = null;
            ConfigData baSettings = baScheme.getSettings();
            String[] saIADefaultObjectScheme = baSettings.getSetting("Default Scheme");
            if (saIADefaultObjectScheme != null && saIADefaultObjectScheme.length != 0) {
                if (saIADefaultObjectScheme.length == 1) {
                    defaultObjectScheme = saIADefaultObjectScheme[0];
                } else {
                    defaultObjectScheme = saIADefaultObjectScheme[saIADefaultObjectScheme.length - 1];
                    defaultObjectSchemePath = new String[saIADefaultObjectScheme.length - 1];
                    for (int i = 0; i < saIADefaultObjectScheme.length - 1; ++i) {
                        defaultObjectSchemePath[i] = saIADefaultObjectScheme[i];
                    }
                }
                if (this.m_objectSchemes != null && this.m_objectSchemes.size() != 0) {
                    Scheme tempScheme = null;
                    Enumeration e = this.m_objectSchemes.elements();
                    while (e.hasMoreElements()) {
                        String schemeName;
                        tempScheme = (Scheme)e.nextElement();
                        ConfigData schemeSettings = tempScheme.getSettings();
                        if (defaultObjectScheme == null || (schemeName = schemeSettings.getSingleSetting("Name")) == null || defaultObjectScheme.compareToIgnoreCase(schemeName) != 0) continue;
                        String[] saSchemePath = schemeSettings.getSetting("Path");
                        if (defaultObjectSchemePath == null && saSchemePath == null) {
                            return tempScheme;
                        }
                        if (defaultObjectSchemePath == null || saSchemePath == null || defaultObjectSchemePath.length != saSchemePath.length) continue;
                        boolean bPathDifferent = false;
                        for (int j = 0; j < defaultObjectSchemePath.length; ++j) {
                            if (defaultObjectSchemePath[j].equals(saSchemePath[j])) continue;
                            bPathDifferent = true;
                            break;
                        }
                        if (bPathDifferent) continue;
                        return tempScheme;
                    }
                }
            }
        }
        return null;
    }

    public Scheme getDefaultScheme() {
        if (this.m_defaultScheme != null) {
            return this.m_defaultScheme;
        }
        Scheme tempScheme = this.getExactDefaultScheme();
        if (tempScheme != null) {
            this.m_defaultScheme = tempScheme;
            return this.m_defaultScheme;
        }
        if (this.m_objectSchemes != null && this.m_objectSchemes.size() != 0) {
            int iLowestPriority = Integer.MAX_VALUE;
            int iAbsoluteLowestPriority = Integer.MAX_VALUE;
            int iPriority = 0;
            Scheme absoluteLowestPriorityScheme = null;
            String[] saPath = null;
            Enumeration e = this.m_objectSchemes.elements();
            while (e.hasMoreElements()) {
                tempScheme = (Scheme)e.nextElement();
                ConfigData schemeSettings = tempScheme.getSettings();
                iPriority = schemeSettings.getSingleIntSetting("Scheme Priority", 0);
                if (absoluteLowestPriorityScheme == null || iPriority < iAbsoluteLowestPriority) {
                    absoluteLowestPriorityScheme = tempScheme;
                    iAbsoluteLowestPriority = iPriority;
                }
                if ((saPath = schemeSettings.getSetting("Path")) != null && saPath.length != 0 || this.m_defaultScheme != null && iPriority >= iLowestPriority) continue;
                this.m_defaultScheme = tempScheme;
                iLowestPriority = iPriority;
            }
            if (this.m_defaultScheme == null) {
                this.m_defaultScheme = absoluteLowestPriorityScheme;
            }
        }
        return this.m_defaultScheme;
    }

    public void setDefaultScheme(Scheme defaultScheme) {
        this.m_defaultScheme = defaultScheme;
    }

    public Vector getBrandingAreaSchemes() {
        return this.m_vBrandingSchemes;
    }

    public void setDefaultBrandingAreaScheme(Scheme BAS) {
        if (BAS == null) {
            this.m_brandingScheme = null;
            return;
        }
        if (this.m_vBrandingSchemes != null && this.m_vBrandingSchemes.size() != 0) {
            Scheme tempScheme = null;
            Enumeration e = this.m_vBrandingSchemes.elements();
            while (e.hasMoreElements()) {
                tempScheme = (Scheme)e.nextElement();
                if (!tempScheme.getObjectID().equalsIgnoreCase(BAS.getObjectID()) || tempScheme.getSchemeID() != BAS.getSchemeID()) continue;
                this.m_brandingScheme = tempScheme;
                return;
            }
        }
    }

    private void setBrandingAreaSchemes(Vector vBAS) {
        this.m_vBrandingSchemes = new Vector();
        this.addBrandingAreaSchemes(vBAS);
    }

    private void addBrandingAreaSchemes(Vector vBAS) {
        this.addBrandingAreaSchemes(vBAS, null);
    }

    private void addBrandingAreaSchemes(Vector vBAS, String sUserFilter) {
        String sSchmFilter = null;
        if (vBAS != null) {
            Scheme tempScheme = null;
            Enumeration e = vBAS.elements();
            while (e.hasMoreElements()) {
                tempScheme = (Scheme)e.nextElement();
                sSchmFilter = tempScheme.getUserFilterString();
                if (this.bIsSchemePresent(this.m_vBrandingSchemes, tempScheme)) continue;
                this.addBrandingAreaScheme(tempScheme, sUserFilter);
            }
        }
    }

    void addBrandingAreaScheme(Scheme BAS, String sUserFilter) {
        if (BAS != null) {
            String sSchmFilter = BAS.getUserFilterString();
            if ((sUserFilter == null || sUserFilter.length() == 0) && (sSchmFilter == null || sSchmFilter.length() == 0) || sUserFilter.equalsIgnoreCase(sSchmFilter)) {
                this.m_brandingScheme = null;
                if (this.m_vBrandingSchemes == null) {
                    this.m_vBrandingSchemes = new Vector();
                }
                this.m_vBrandingSchemes.add(BAS);
            }
        }
    }

    public Vector getSchemeOverrides() {
        return this.m_schemeOverrides;
    }

    public void setSchemeOverrides(Vector OSOV) {
        this.m_schemeOverrides = OSOV;
    }

    public ConfigData getDirectoryConfig() {
        return this.m_directoryConfig;
    }

    public void setDirectoryConfig(ConfigData directoryConfig) {
        this.m_directoryConfig = directoryConfig;
    }

    public void addDirectoryConfig(ConfigData newDirectoryConfig) {
        if (this.m_directoryConfig == null) {
            this.m_directoryConfig = newDirectoryConfig;
        } else {
            this.m_directoryConfig.mergeConfig(newDirectoryConfig, false, false);
        }
    }

    public String getBaseDirectoryObject() {
        return this.m_szObject;
    }

    public void setBaseDirectoryObject(String szObject) {
        this.m_szObject = szObject;
    }

    public Hashtable getObjectGUIDs() {
        return this.m_htObjectGUIDs;
    }

    public void setObjectGUIDs(Hashtable htObjectGUIDs) {
        this.m_htObjectGUIDs = htObjectGUIDs;
    }

    public void addObjectGUIDs(Hashtable htObjectGUIDs) {
        String sGUID = null;
        if (htObjectGUIDs != null) {
            Enumeration e = htObjectGUIDs.elements();
            while (e.hasMoreElements()) {
                sGUID = (String)e.nextElement();
                if (this.m_htObjectGUIDs == null) {
                    this.m_htObjectGUIDs = new Hashtable();
                }
                this.m_htObjectGUIDs.put(sGUID, sGUID);
            }
        }
    }

    public void readObjectConfig(PortalConnection pc, String sPCOid, boolean bReadROAttribute) {
        ObjectConfig oc;
        block2: {
            String sUseAttr = null;
            sUseAttr = bReadROAttribute ? "bhConfig" : "bhConfigRW";
            oc = new ObjectConfig(sPCOid, this.m_szObject, sUseAttr);
            try {
                oc.read(pc);
            }
            catch (PortalDirectoryException e) {
                this.m_bIsValid = false;
                if (!Debug.isLoggable(1)) break block2;
                Debug.log("Inheritance::oc.read", 1, e);
            }
        }
        this.m_ocCache = oc;
        this.m_iRecordCount = oc.getRecordCount();
        this.m_iDataSize = oc.getTotalSize();
    }

    public void readAll(PortalConnection pc, String sPCOid, boolean bReadSchemes, boolean bReadLayoutConfig, boolean bReadROAttribute) {
        String sObjectGUID;
        ObjectConfig oc;
        block3: {
            oc = null;
            if (this.m_ocCache == null) {
                this.readObjectConfig(pc, sPCOid, bReadROAttribute);
            }
            oc = this.m_ocCache;
            this.m_ocCache = null;
            sObjectGUID = null;
            try {
                sObjectGUID = pc.getObjectGUID(this.m_szObject);
            }
            catch (PortalDirectoryException e) {
                this.m_bIsValid = false;
                bReadSchemes = false;
                if (!Debug.isLoggable(1)) break block3;
                Debug.log("Inheritance::getObjectGUID", 1, e);
            }
        }
        this.readAll(sPCOid, sObjectGUID, oc, bReadSchemes, bReadLayoutConfig, bReadROAttribute);
    }

    public void readAll(String sPCOid, String sObjectGUID, ObjectConfig oc, boolean bReadSchemes, boolean bReadLayoutConfig, boolean bReadROAttribute) {
        Vector directoryConfigRecord;
        Scheme tempOS = null;
        ObjectConfigRecord ocr = null;
        GadgetAssignment tempGA = null;
        this.emptyAll();
        if (sObjectGUID == null) {
            this.m_bIsValid = false;
            bReadSchemes = false;
        }
        if (bReadSchemes) {
            Vector gadgetConfigRecord;
            Vector objectSchemeOverrideRecords;
            Vector brandingAreaSchemeRecord;
            Vector objectSchemeRecords = oc.getRecords(1);
            if (objectSchemeRecords != null && !objectSchemeRecords.isEmpty()) {
                Enumeration e = objectSchemeRecords.elements();
                while (e.hasMoreElements()) {
                    tempOS = new Scheme();
                    ocr = (ObjectConfigRecord)e.nextElement();
                    tempOS.setData(ocr);
                    tempOS.setFDN(this.m_szObject);
                    tempOS.setPortalID(ocr.getPCO());
                    tempOS.setObjectID(ocr.getObjectGUID());
                    tempOS.setSchemeID(ocr.getSchemeID());
                    tempOS.setSchemeType(ocr.getType());
                    if (sPCOid == null) {
                        if (this.m_objectSchemes == null) {
                            this.m_objectSchemes = new Vector();
                        }
                        this.m_objectSchemes.addElement(tempOS);
                        continue;
                    }
                    if (sObjectGUID != null && sObjectGUID.equalsIgnoreCase(ocr.getObjectGUID())) {
                        if (this.m_objectSchemes == null) {
                            this.m_objectSchemes = new Vector();
                        }
                        this.m_objectSchemes.addElement(tempOS);
                        continue;
                    }
                    if (this.m_schemeOverrides == null) {
                        this.m_schemeOverrides = new Vector();
                    }
                    this.m_schemeOverrides.addElement(tempOS);
                }
            }
            if ((brandingAreaSchemeRecord = oc.getRecords(2)) != null && !brandingAreaSchemeRecord.isEmpty()) {
                Enumeration e;
                if (sPCOid == null) {
                    if (this.m_objectSchemes == null) {
                        this.m_objectSchemes = new Vector();
                    }
                    e = brandingAreaSchemeRecord.elements();
                    while (e.hasMoreElements()) {
                        tempOS = new Scheme();
                        ocr = (ObjectConfigRecord)e.nextElement();
                        tempOS.setData(ocr);
                        tempOS.setFDN(this.m_szObject);
                        tempOS.setPortalID(ocr.getPCO());
                        tempOS.setObjectID(ocr.getObjectGUID());
                        tempOS.setSchemeID(ocr.getSchemeID());
                        tempOS.setSchemeType(ocr.getType());
                        this.m_objectSchemes.addElement(tempOS);
                    }
                } else {
                    if (this.m_vBrandingSchemes == null) {
                        this.m_vBrandingSchemes = new Vector();
                    }
                    e = brandingAreaSchemeRecord.elements();
                    while (e.hasMoreElements()) {
                        tempOS = new Scheme();
                        ocr = (ObjectConfigRecord)e.nextElement();
                        tempOS.setData(ocr);
                        tempOS.setFDN(this.m_szObject);
                        tempOS.setPortalID(ocr.getPCO());
                        tempOS.setObjectID(ocr.getObjectGUID());
                        tempOS.setSchemeID(ocr.getSchemeID());
                        tempOS.setSchemeType(ocr.getType());
                        this.m_vBrandingSchemes.addElement(tempOS);
                    }
                }
            }
            if ((objectSchemeOverrideRecords = oc.getRecords(5)) != null && !objectSchemeOverrideRecords.isEmpty()) {
                if (this.m_schemeOverrides == null) {
                    this.m_schemeOverrides = new Vector();
                }
                Enumeration e = objectSchemeOverrideRecords.elements();
                while (e.hasMoreElements()) {
                    tempOS = new Scheme();
                    ocr = (ObjectConfigRecord)e.nextElement();
                    tempOS.setData(ocr);
                    tempOS.setFDN(this.m_szObject);
                    tempOS.setPortalID(ocr.getPCO());
                    tempOS.setObjectID(ocr.getObjectGUID());
                    tempOS.setSchemeID(ocr.getSchemeID());
                    tempOS.setSchemeType(ocr.getType());
                    this.m_schemeOverrides.addElement(tempOS);
                }
            }
            if ((gadgetConfigRecord = oc.getRecords(3)) != null && !gadgetConfigRecord.isEmpty()) {
                ConfigSettings tempGadgetConfig = null;
                ocr = null;
                Enumeration e = gadgetConfigRecord.elements();
                while (e.hasMoreElements()) {
                    Enumeration gae;
                    Vector assignments;
                    Enumeration ose;
                    ocr = (ObjectConfigRecord)e.nextElement();
                    tempGadgetConfig = new ConfigSettings(ocr);
                    tempGadgetConfig.readSettings();
                    boolean bFound = false;
                    if (bReadROAttribute && this.m_vBrandingSchemes != null) {
                        ose = this.m_vBrandingSchemes.elements();
                        while (ose.hasMoreElements()) {
                            tempOS = (Scheme)ose.nextElement();
                            if ((long)ocr.getSchemeID() != tempOS.getSchemeID()) continue;
                            assignments = tempOS.getGadgetAssignments();
                            gae = assignments.elements();
                            while (gae.hasMoreElements()) {
                                tempGA = (GadgetAssignment)gae.nextElement();
                                if ((long)ocr.getGadgetID() != tempGA.getGadgetAssignmentID()) continue;
                                tempGA.setGadgetConfig(tempGadgetConfig);
                                bFound = true;
                                break;
                            }
                            if (!bFound) continue;
                            break;
                        }
                    }
                    if (!bFound && bReadROAttribute && this.m_objectSchemes != null) {
                        ose = this.m_objectSchemes.elements();
                        while (ose.hasMoreElements()) {
                            tempOS = (Scheme)ose.nextElement();
                            if ((long)ocr.getSchemeID() != tempOS.getSchemeID()) continue;
                            assignments = tempOS.getGadgetAssignments();
                            gae = assignments.elements();
                            while (gae.hasMoreElements()) {
                                tempGA = (GadgetAssignment)gae.nextElement();
                                if ((long)ocr.getGadgetID() != tempGA.getGadgetAssignmentID()) continue;
                                tempGA.setGadgetConfig(tempGadgetConfig);
                                bFound = true;
                                break;
                            }
                            if (!bFound) continue;
                            break;
                        }
                    }
                    if (!bFound && bReadROAttribute && this.m_schemeOverrides != null) {
                        Enumeration osove = this.m_schemeOverrides.elements();
                        while (osove.hasMoreElements()) {
                            tempOS = (Scheme)osove.nextElement();
                            if ((long)ocr.getSchemeID() != tempOS.getSchemeID()) continue;
                            assignments = tempOS.getGadgetAssignments();
                            gae = assignments.elements();
                            while (gae.hasMoreElements()) {
                                tempGA = (GadgetAssignment)gae.nextElement();
                                if ((long)ocr.getGadgetID() != tempGA.getGadgetAssignmentID()) continue;
                                tempGA.setGadgetConfig(tempGadgetConfig);
                                bFound = true;
                                break;
                            }
                            if (!bFound) continue;
                            break;
                        }
                    }
                    if (bFound) continue;
                    this.m_gadgetConfigOverrides.add(ocr);
                }
            }
        }
        if ((directoryConfigRecord = oc.getRecords(7)) != null && !directoryConfigRecord.isEmpty()) {
            ocr = (ObjectConfigRecord)directoryConfigRecord.firstElement();
            this.m_directoryConfig = new ConfigSettings(ocr, null);
            this.m_directoryConfig.readSettings();
        }
        this.setLastReadTime(System.currentTimeMillis());
    }

    public void overrideObjectSchemes(Vector schemeOverrides, boolean bUserRW) {
        if (this.m_objectSchemes == null || schemeOverrides == null || schemeOverrides.size() == 0) {
            return;
        }
        Vector vAllAssigned = this.getGadgetAssignmentsAndServices();
        HashMap hmAllAssigned = AdminAPI.getAssignmentsHashMap(vAllAssigned);
        Enumeration e = schemeOverrides.elements();
        Scheme tempScheme = null;
        while (e.hasMoreElements()) {
            tempScheme = (Scheme)e.nextElement();
            Enumeration ose = this.m_objectSchemes.elements();
            Scheme existingScheme = null;
            while (ose.hasMoreElements()) {
                existingScheme = (Scheme)ose.nextElement();
                if (tempScheme.getSchemeID() != existingScheme.getSchemeID() || !tempScheme.getObjectID().equals(existingScheme.getObjectID())) continue;
                ConfigData esSettings = existingScheme.getSettings();
                ConfigData newSettings = tempScheme.getSettings();
                if (bUserRW) {
                    newSettings.markAllSettingsOverwriteable();
                }
                esSettings.mergeConfig(newSettings, false, false);
                existingScheme.setSettings(esSettings);
                if (tempScheme.getGadgetAssignments() == null) continue;
                Enumeration tempse = tempScheme.getGadgetAssignments().elements();
                GadgetAssignment tempga = null;
                GadgetAssignment existingga = null;
                block2: while (tempse.hasMoreElements()) {
                    boolean bFound = false;
                    tempga = (GadgetAssignment)tempse.nextElement();
                    Vector<GadgetAssignment> vExistingGA = existingScheme.getGadgetAssignments();
                    if (vExistingGA != null) {
                        Enumeration existingse = vExistingGA.elements();
                        while (existingse.hasMoreElements()) {
                            existingga = (GadgetAssignment)existingse.nextElement();
                            if (existingga.getGadgetAssignmentID() != tempga.getGadgetAssignmentID()) continue;
                            bFound = true;
                            if (!existingga.isAssignmentOverwriteable()) break;
                            if (tempga.getLocation() != null) {
                                existingga.setLocation(tempga.getLocation());
                            }
                            if (tempga.getColumn() != null) {
                                existingga.setColumn(tempga.getColumn());
                            }
                            if (tempga.getPriority() != null) {
                                existingga.setPriority(tempga.getPriority());
                            }
                            existingga.setMinimized(tempga.getMinimized());
                            break;
                        }
                    }
                    if (bFound || (!bUserRW || !esSettings.getSingleSetting("Users Can Add Gadgets", "false").equalsIgnoreCase("true")) && bUserRW) continue;
                    if (bUserRW) {
                        GadgetAssignment assignedGA = null;
                        if (tempga.getParentAssignmentID() != null) {
                            assignedGA = (GadgetAssignment)hmAllAssigned.get(tempga.getParentAssignmentID());
                            if (assignedGA == null) continue;
                            tempga.setGadgetAddedByUser(true);
                            ConfigData cd = assignedGA.getGadgetConfig();
                            if (cd != null) {
                                tempga.setGadgetConfig(cd.copy());
                            }
                            if ((cd = assignedGA.getCustomAssignmentConfig()) != null) {
                                tempga.setCustomAssignmentConfig(cd.copy());
                            }
                            if (vExistingGA == null) {
                                vExistingGA = new Vector();
                            }
                            vExistingGA.addElement(tempga);
                            existingScheme.setGadgetAssignments(vExistingGA);
                            continue;
                        }
                        Enumeration eAll = vAllAssigned.elements();
                        while (eAll.hasMoreElements()) {
                            assignedGA = (GadgetAssignment)eAll.nextElement();
                            if (assignedGA.getGadgetDN() == null || !assignedGA.getGadgetDN().equalsIgnoreCase(tempga.getGadgetDN())) continue;
                            tempga.setGadgetAddedByUser(true);
                            if (vExistingGA == null) {
                                vExistingGA = new Vector();
                            }
                            vExistingGA.addElement(tempga);
                            existingScheme.setGadgetAssignments(vExistingGA);
                            continue block2;
                        }
                        continue;
                    }
                    if (vExistingGA == null) {
                        vExistingGA = new Vector<GadgetAssignment>();
                    }
                    vExistingGA.addElement(tempga);
                    existingScheme.setGadgetAssignments(vExistingGA);
                }
            }
        }
    }

    public void overrideGadgetConfig(Vector gadgetConfigOverrides, boolean bMakeOverwriteable, PortalSession session) {
        if (this.m_objectSchemes == null) {
            return;
        }
        Enumeration e = gadgetConfigOverrides.elements();
        ObjectConfigRecord ocr = null;
        block0: while (e.hasMoreElements()) {
            Vector vAllAssignments;
            ocr = (ObjectConfigRecord)e.nextElement();
            ConfigSettings newConfig = new ConfigSettings(ocr);
            newConfig.readSettings();
            if (bMakeOverwriteable) {
                newConfig.markAllSettingsOverwriteable();
            }
            if ((vAllAssignments = this.getAllGadgetAssignments()) == null || vAllAssignments.size() == 0) continue;
            Enumeration eAllAssignments = vAllAssignments.elements();
            Scheme existingScheme = null;
            GadgetAssignment existingga = null;
            while (eAllAssignments.hasMoreElements()) {
                Collection co;
                existingga = (GadgetAssignment)eAllAssignments.nextElement();
                existingScheme = existingga.getScheme();
                if ((long)ocr.getSchemeID() != existingScheme.getSchemeID() || !ocr.getObjectGUID().equals(existingScheme.getObjectID()) || (long)ocr.getGadgetID() != existingga.getGadgetAssignmentID()) continue;
                if (bMakeOverwriteable && (co = newConfig.getSettingsCollection()) != null) {
                    Setting tempSetting = null;
                    Iterator iter = co.iterator();
                    while (iter.hasNext()) {
                        tempSetting = (Setting)iter.next();
                        tempSetting.parsePortalMacros(session);
                    }
                }
                ConfigData existingConfig = existingga.getGadgetConfig();
                existingConfig.mergeConfig(newConfig, false, false);
                existingga.setGadgetConfig(existingConfig);
                continue block0;
            }
        }
    }

    public Vector getGadgetAssignments() {
        Vector gadgetAssignments = new Vector();
        Scheme tempOS = null;
        if (this.m_objectSchemes == null) {
            return null;
        }
        Enumeration e = this.m_objectSchemes.elements();
        while (e.hasMoreElements()) {
            tempOS = (Scheme)e.nextElement();
            gadgetAssignments.addAll(tempOS.getGadgetAssignments());
        }
        return gadgetAssignments;
    }

    public Vector getBrandingGadgetAssignments() {
        Scheme brandingScheme = this.getBrandingAreaScheme();
        if (brandingScheme == null) {
            return null;
        }
        return brandingScheme.getGadgetAssignments();
    }

    public Vector getAllGadgetAssignments() {
        Vector vAllGadgetAssignments = new Vector();
        if (this.m_vServices != null && this.m_vServices.size() != 0) {
            vAllGadgetAssignments.addAll(this.m_vServices);
        }
        return vAllGadgetAssignments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getAllGadgetAssignmentsHashMap(PortalSession session) {
        if (this.m_hmAllAssignments != null) {
            return this.m_hmAllAssignments;
        }
        Object object = this.m_hmAllAssignmentsSync;
        synchronized (object) {
            if (this.m_hmAllAssignments != null) {
                return this.m_hmAllAssignments;
            }
            Vector vAllAssignments = this.getAllGadgetAssignments();
            this.m_hmAllAssignments = new HashMap();
            GadgetAssignment tempSchemeGA = null;
            if (vAllAssignments != null && vAllAssignments.size() != 0) {
                Enumeration eAssignments = vAllAssignments.elements();
                while (eAssignments.hasMoreElements()) {
                    tempSchemeGA = (GadgetAssignment)eAssignments.nextElement();
                    this.m_hmAllAssignments.put(tempSchemeGA.getServiceName(), tempSchemeGA);
                }
            }
        }
        return this.m_hmAllAssignments;
    }

    public Vector getGadgetAssignmentsAndServices() {
        Vector vAllGadgetAssignments = new Vector();
        Vector OSGadgetAssignments = this.getGadgetAssignments();
        if (OSGadgetAssignments != null && OSGadgetAssignments.size() != 0) {
            vAllGadgetAssignments.addAll(OSGadgetAssignments);
        }
        if (this.m_vServices != null && this.m_vServices.size() != 0) {
            vAllGadgetAssignments.addAll(this.m_vServices);
        }
        return vAllGadgetAssignments;
    }

    public void emptyAll() {
        this.m_objectSchemes = null;
        this.m_schemeOverrides = null;
        this.m_brandingScheme = null;
        this.m_vBrandingSchemes = null;
        this.m_vServices = null;
        this.m_directoryConfig = null;
        this.m_gadgetConfigOverrides = new Vector();
        this.m_htObjectGUIDs = null;
        this.m_hmAllAssignments = null;
    }

    public long getLastChangedTime() {
        return this.m_lastChanged;
    }

    public void setLastChangedTime(long timestamp) {
        this.m_lastChanged = timestamp;
    }

    public long getLastReadTime() {
        return this.m_lastRead;
    }

    public void setLastReadTime(long timestamp) {
        this.m_lastRead = timestamp;
        this.m_lastChanged = timestamp;
    }

    public long getServicesTimestamp() {
        return this.m_lServicesTimestamp;
    }

    public void setServicesTimestamp(long lServicesTimestamp) {
        this.m_lServicesTimestamp = lServicesTimestamp;
    }

    public static ConfigData getAllAvailableDirectoryConfigSettings(PortalSession session) {
        ConfigSettings cs = new ConfigSettings();
        Setting tempSetting = null;
        Vector<SettingValue> tempVector = null;
        SettingValue tempSV = null;
        ResourceBundle res = ConfigManager.getUserResourceBundle(session);
        tempSetting = new Setting();
        tempSetting.setName(READ_PARENT_SCHEMES);
        tempSetting.setDisplayName(res.getString("Read_parent_schemes_display_name"));
        tempVector = new Vector<SettingValue>();
        tempSV = new SettingValue(String.valueOf(1));
        tempVector.add(tempSV);
        tempSetting.setValues(tempVector);
        tempSetting.setOverwriteable(false);
        tempSetting.setAllowMultipleValues(false);
        tempSetting.setDescription(res.getString("Whether_to_read"));
        tempSetting.setRangeDescription(res.getString("on_BR_off"));
        tempSetting.setMaximumRange(0);
        tempSetting.setMinimumRange(0);
        tempSetting.setType(4);
        tempSetting.setOrder(1);
        cs.setSingleSettingObject(tempSetting);
        return cs;
    }

    public void writeDirectoryConfig(PortalConnection pc, String sObject, String sPCOID) throws PortalDirectoryException {
        String sGUID;
        ObjectConfigRecord ocr;
        block4: {
            ocr = new ObjectConfigRecord((ConfigSettings)this.m_directoryConfig);
            ocr.setGadgetID(0);
            sGUID = null;
            try {
                sGUID = pc.setObjectGUID(sObject);
            }
            catch (PortalDirectoryException e) {
                if (!Debug.isLoggable(1)) break block4;
                Debug.log("Inheritance1603", 1, e);
            }
        }
        ocr.setObjectGUID(sGUID);
        ocr.setPCO(sPCOID);
        ocr.setSchemeID(0);
        ocr.setType(7);
        ocr.convertDOMtoXML();
        ObjectConfig oc = new ObjectConfig(sPCOID, sObject, "bhConfig");
        if (this.m_directoryConfig != null && !this.m_directoryConfig.isEmpty()) {
            oc.writeRecord(pc, ocr);
            pc.addTrustee(sObject, sObject, "bhConfig", 2, false, false);
            pc.addTrustee(sObject, sObject, "bhObjectGUID", 2, false, false);
        } else {
            oc.deleteRecord(pc, ocr);
        }
    }

    public Inheritance copy() {
        Vector<Scheme> newSchemeList;
        Enumeration e;
        Scheme newScheme;
        Scheme oldScheme;
        Inheritance newInheritance = new Inheritance();
        if (this.m_objectSchemes != null) {
            oldScheme = null;
            newScheme = null;
            e = this.m_objectSchemes.elements();
            newSchemeList = new Vector<Scheme>();
            while (e.hasMoreElements()) {
                oldScheme = (Scheme)e.nextElement();
                newScheme = oldScheme.copy();
                newSchemeList.addElement(newScheme);
            }
            newInheritance.setObjectSchemes(newSchemeList);
        }
        if (this.m_vBrandingSchemes != null) {
            oldScheme = null;
            newScheme = null;
            e = this.m_vBrandingSchemes.elements();
            newSchemeList = new Vector();
            while (e.hasMoreElements()) {
                oldScheme = (Scheme)e.nextElement();
                newScheme = oldScheme.copy();
                newSchemeList.addElement(newScheme);
            }
            newInheritance.setBrandingAreaSchemes(newSchemeList);
        }
        if (this.m_vServices != null) {
            GadgetAssignment oldServices = null;
            GadgetAssignment newServices = null;
            e = this.m_vServices.elements();
            Vector<GadgetAssignment> newServiceList = new Vector<GadgetAssignment>();
            while (e.hasMoreElements()) {
                oldServices = (GadgetAssignment)e.nextElement();
                newServices = oldServices.copy();
                newServiceList.addElement(newServices);
            }
            newInheritance.setServices(newServiceList);
        }
        if (this.m_brandingScheme != null) {
            newInheritance.setDefaultBrandingAreaScheme(this.m_brandingScheme.copy());
        }
        if (this.m_szObject != null) {
            newInheritance.setBaseDirectoryObject(this.m_szObject);
        }
        if (this.m_directoryConfig != null) {
            newInheritance.setDirectoryConfig(this.m_directoryConfig.copy());
        }
        if (this.m_schemeOverrides != null) {
            Scheme oldSchemeOV = null;
            Scheme newSchemeOV = null;
            e = this.m_schemeOverrides.elements();
            Vector<Scheme> newSchemeOVList = new Vector<Scheme>();
            while (e.hasMoreElements()) {
                oldSchemeOV = (Scheme)e.nextElement();
                newSchemeOV = oldSchemeOV.copy();
                newSchemeOVList.addElement(newSchemeOV);
            }
            newInheritance.setSchemeOverrides(newSchemeOVList);
        }
        if (this.m_gadgetConfigOverrides != null) {
            newInheritance.setGadgetConfigOverrides(this.m_gadgetConfigOverrides);
        }
        newInheritance.setLastChangedTime(this.m_lastChanged);
        newInheritance.setLastReadTime(this.m_lastRead);
        newInheritance.setServicesTimestamp(this.m_lServicesTimestamp);
        if (this.m_htObjectGUIDs != null) {
            Enumeration e2 = this.m_htObjectGUIDs.elements();
            Hashtable<String, String> newStringList = new Hashtable<String, String>();
            String sGUID = null;
            while (e2.hasMoreElements()) {
                sGUID = (String)e2.nextElement();
                newStringList.put(sGUID, sGUID);
            }
            newInheritance.setObjectGUIDs(newStringList);
        }
        newInheritance.setDefaultScheme(this.m_defaultScheme);
        return newInheritance;
    }

    protected Object clone() throws CloneNotSupportedException {
        return this.copy();
    }

    public int getRecordCount() {
        return this.m_iRecordCount;
    }

    public int getDataSize() {
        return this.m_iDataSize;
    }

    public boolean isValid() {
        return this.m_bIsValid;
    }

    public boolean bIsSchemePresent(Vector vSchemes, Scheme newScheme) {
        if (vSchemes == null || vSchemes.size() == 0) {
            return false;
        }
        Scheme tempScheme = null;
        Enumeration e = vSchemes.elements();
        while (e.hasMoreElements()) {
            tempScheme = (Scheme)e.nextElement();
            if (!tempScheme.getUniqueID().equalsIgnoreCase(newScheme.getUniqueID())) continue;
            return true;
        }
        return false;
    }

    public Vector getServices() {
        return this.m_vServices;
    }

    public void setServices(Vector vServices) {
        this.m_vServices = vServices;
    }

    public void addServices(Vector vServices) {
        if (vServices != null && vServices.size() != 0) {
            if (this.m_vServices == null) {
                this.m_vServices = new Vector();
            }
            this.m_vServices.addAll(vServices);
        }
    }
}

