/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.configManager;

import com.novell.nps.authentication.PortalConnection;
import com.novell.nps.authentication.PortalDirectoryException;
import com.novell.nps.authentication.PortalObjectAttribute;
import com.novell.nps.configManager.AdminAPI;
import com.novell.nps.configManager.ConfigSettings;
import com.novell.nps.configManager.ObjectConfig;
import com.novell.nps.configManager.ObjectConfigRecord;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ModuleConfig
implements Cloneable,
Serializable {
    public static final String GADGETID = "GADGETID";
    public static final String GADGETFDN = "GADGETFDN";
    public static final String CATEGORIES_SETTING = "Categories";
    public static final String MODULE_CATEGORIES = "ModuleCategories";
    public static final String SETTING_ID = "com.novell.nps.configManager.ModuleConfig.componentID";
    public static final String RBS_DISPLAYNAME = "RBS-DisplayName";
    private String m_sFDN = null;
    private String m_sGUID = null;
    private String m_sPortalGUID = null;
    private ConfigSettings m_settings = null;
    private String m_sPortalDN = null;
    private String m_sVersion = null;
    private Vector m_vChildModuleList = null;
    private Vector m_vParentModuleList = null;
    private Vector m_vGadgetList = null;
    private Vector m_vCachedRecords = null;
    private ConfigSettings m_moduleObjectSettings = null;
    private Hashtable m_htCategoryList = null;

    public ModuleConfig() {
    }

    public ModuleConfig(PortalConnection pc, String sModuleDN, String sPortalGUID) throws PortalDirectoryException {
        PortalObjectAttribute poa = null;
        Vector<PortalObjectAttribute> vPOA = new Vector<PortalObjectAttribute>();
        poa = new PortalObjectAttribute("bhObjectGUID", 3, null);
        vPOA.add(poa);
        poa = new PortalObjectAttribute("bhPortalDN", 1, null);
        vPOA.add(poa);
        poa = new PortalObjectAttribute("bhVersion", 1, null);
        vPOA.add(poa);
        poa = new PortalObjectAttribute("bhGadgetList", 2, null);
        vPOA.add(poa);
        poa = new PortalObjectAttribute("bhChildModuleList", 2, null);
        vPOA.add(poa);
        poa = new PortalObjectAttribute("bhParentModuleList", 2, null);
        vPOA.add(poa);
        poa = new PortalObjectAttribute("bhConfig", 4, null);
        vPOA.add(poa);
        pc.readAttributes(sModuleDN, vPOA);
        String sAttr = null;
        Vector vData = null;
        for (int i = 0; i < vPOA.size(); ++i) {
            poa = (PortalObjectAttribute)vPOA.elementAt(i);
            vData = poa.getData();
            if (vData == null) continue;
            sAttr = poa.getName();
            if (sAttr.equalsIgnoreCase("bhObjectGUID")) {
                if (vData.size() <= 0) continue;
                this.m_sGUID = new String((byte[])vData.elementAt(0));
                continue;
            }
            if (sAttr.equalsIgnoreCase("bhPortalDN")) {
                if (vData.size() <= 0) continue;
                this.m_sPortalDN = (String)vData.elementAt(0);
                continue;
            }
            if (sAttr.equalsIgnoreCase("bhVersion")) {
                if (vData.size() <= 0) continue;
                this.m_sVersion = (String)vData.elementAt(0);
                continue;
            }
            if (sAttr.equalsIgnoreCase("bhGadgetList")) {
                this.m_vGadgetList = vData;
                continue;
            }
            if (sAttr.equalsIgnoreCase("bhChildModuleList")) {
                this.m_vChildModuleList = vData;
                continue;
            }
            if (sAttr.equalsIgnoreCase("bhParentModuleList")) {
                this.m_vParentModuleList = vData;
                continue;
            }
            if (!sAttr.equalsIgnoreCase("bhConfig")) continue;
            this.m_vCachedRecords = vData;
        }
        if (this.m_sGUID == null) {
            return;
        }
        this.m_sFDN = sModuleDN;
        this.m_sPortalGUID = sPortalGUID;
        ObjectConfig oc = new ObjectConfig(this.m_sPortalGUID, this.m_sFDN, "bhConfig");
        if (this.m_vCachedRecords != null) {
            oc.read(this.m_vCachedRecords);
        } else {
            oc.read(pc);
        }
        Vector recs = oc.getRecords();
        if (recs != null && !recs.isEmpty()) {
            Enumeration e = recs.elements();
            while (e.hasMoreElements()) {
                ObjectConfigRecord ocr = (ObjectConfigRecord)e.nextElement();
                if (ocr.getType() == 3) {
                    this.m_settings = new ConfigSettings(ocr);
                    this.m_settings.readSettings();
                    continue;
                }
                if (ocr.getType() != 0) continue;
                this.m_moduleObjectSettings = new ConfigSettings(ocr);
                this.m_moduleObjectSettings.readSettings();
            }
        }
    }

    public ConfigSettings getConfigSettings() {
        return this.m_settings;
    }

    public void setConfigSettings(ConfigSettings settings) {
        this.m_settings = settings;
    }

    public void setConfigSettings(InputStream is) {
        ObjectConfigRecord ocr = new ObjectConfigRecord(is);
        this.m_settings = new ConfigSettings(ocr);
        this.m_settings.readSettings();
    }

    public ConfigSettings getModuleObjectSettings() {
        return this.m_moduleObjectSettings;
    }

    public void setModuleObjectSettings(ConfigSettings settings) {
        this.m_moduleObjectSettings = settings;
        this.m_htCategoryList = null;
    }

    public void setModuleObjectSettings(InputStream is) {
        ObjectConfigRecord ocr = new ObjectConfigRecord(is);
        this.m_moduleObjectSettings = new ConfigSettings(ocr);
        this.m_moduleObjectSettings.readSettings();
        this.m_htCategoryList = null;
    }

    public Vector getRegisteredServices() {
        return null;
    }

    public String getGUID() {
        return this.m_sGUID;
    }

    public void setGUID(String sGUID) {
        this.m_sGUID = sGUID;
    }

    public String getPortalGUID() {
        return this.m_sPortalGUID;
    }

    public void setPortalGUID(String sPortalGUID) {
        this.m_sPortalGUID = sPortalGUID;
    }

    public String getFDN() {
        return this.m_sFDN;
    }

    public void setFDN(String sFDN) {
        this.m_sFDN = sFDN;
    }

    public String getID() {
        String sID = null;
        if (this.m_moduleObjectSettings != null) {
            sID = this.m_moduleObjectSettings.getSingleSetting(SETTING_ID);
        }
        return sID;
    }

    public void setID(String sID) {
        if (this.m_moduleObjectSettings == null) {
            this.m_moduleObjectSettings = new ConfigSettings();
        }
        this.m_moduleObjectSettings.setSetting(SETTING_ID, sID);
    }

    public String getName() {
        String sName = null;
        if (this.m_moduleObjectSettings != null) {
            sName = this.m_moduleObjectSettings.getSingleSetting("Name");
        }
        if (sName == null || sName.length() == 0) {
            sName = AdminAPI.getDNFromFDN(this.m_sFDN);
        }
        return sName;
    }

    public void setName(String sName) {
        if (this.m_moduleObjectSettings == null) {
            this.m_moduleObjectSettings = new ConfigSettings();
        }
        this.m_moduleObjectSettings.setSetting("Name", sName);
    }

    public String getDescription() {
        String sDescription = null;
        if (this.m_moduleObjectSettings != null) {
            sDescription = this.m_moduleObjectSettings.getSingleSetting("Description");
        }
        return sDescription;
    }

    public void setDescription(String sDescription) {
        if (this.m_moduleObjectSettings == null) {
            this.m_moduleObjectSettings = new ConfigSettings();
        }
        this.m_moduleObjectSettings.setSetting("Description", sDescription);
    }

    public String getVersion() {
        return this.m_sVersion;
    }

    public void setVersion(String sVersion) {
        this.m_sVersion = sVersion;
    }

    public String getRBSDisplayName() {
        String sRBSDisplayName = null;
        if (this.m_moduleObjectSettings != null) {
            sRBSDisplayName = this.m_moduleObjectSettings.getSingleSetting(RBS_DISPLAYNAME);
        }
        return sRBSDisplayName;
    }

    public void setRBSDisplayName(String sRBSDisplayName) {
        if (this.m_moduleObjectSettings == null) {
            this.m_moduleObjectSettings = new ConfigSettings();
        }
        this.m_moduleObjectSettings.setSetting(RBS_DISPLAYNAME, sRBSDisplayName);
    }
}

