/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.configManager;

import com.novell.nps.authentication.PortalConnection;
import com.novell.nps.authentication.PortalDirectoryException;
import com.novell.nps.configManager.GadgetAssignment;
import com.novell.nps.configManager.Inheritance;
import com.novell.nps.configManager.ObjectConfigRecord;
import com.novell.nps.configManager.Scheme;
import com.novell.nps.debug.Debug;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class ObjectConfig
implements Serializable {
    private static final String DT = "ObjectConfig";
    private String m_sPortalGUID = null;
    private Vector m_vect;
    private String m_sUseAttr = null;
    private String m_sObject = null;

    public ObjectConfig(String sPortalGUID, String sObject, String sUseAttr) {
        this.m_sUseAttr = sUseAttr;
        this.m_sPortalGUID = sPortalGUID;
        this.useObject(sObject);
        this.resetVectors();
    }

    public void resetVectors() {
        this.m_vect = new Vector();
    }

    private void useObject(String sObject) {
        this.m_sObject = sObject;
    }

    public void addRecord(ObjectConfigRecord ocr) {
        this.m_vect.addElement(ocr);
    }

    public void read(PortalConnection pc) throws PortalDirectoryException {
        Vector vValues = pc.readMultiByteArrayAttribute(this.m_sObject, this.m_sUseAttr);
        this.read(vValues);
    }

    public void read(Vector vValues) {
        byte[] baValue = null;
        ObjectConfigRecord ocr = null;
        this.resetVectors();
        Enumeration e = vValues.elements();
        while (e.hasMoreElements()) {
            baValue = (byte[])e.nextElement();
            ocr = new ObjectConfigRecord();
            ocr.read(baValue);
            if (!ocr.isValid()) continue;
            if (this.m_sPortalGUID == null) {
                this.addRecord(ocr);
                continue;
            }
            if (!this.m_sPortalGUID.equals(ocr.getPCO())) continue;
            this.addRecord(ocr);
        }
    }

    public void writeRecord(PortalConnection pc, ObjectConfigRecord ocrAdd) throws PortalDirectoryException {
        boolean bReplace;
        Vector<byte[]> vRecs;
        byte[] baCurValue;
        byte[] baTemp;
        block6: {
            block5: {
                baTemp = null;
                baCurValue = null;
                vRecs = null;
                bReplace = false;
                vRecs = pc.readMultiByteArrayAttribute(this.m_sObject, this.m_sUseAttr);
                if (vRecs != null && vRecs.size() != 0) break block5;
                String sClass = pc.getObjectType(this.m_sObject);
                if (!(sClass == null || sClass.equals("bhPortal") || sClass.equals("bhGadget") || sClass.equals("bhModule"))) {
                    pc.addAuxClass(this.m_sObject, this.m_sUseAttr);
                }
                if (vRecs != null) break block6;
                vRecs = new Vector<byte[]>();
                break block6;
            }
            ObjectConfigRecord ocrDS = null;
            Enumeration e = vRecs.elements();
            while (e.hasMoreElements()) {
                baTemp = (byte[])e.nextElement();
                ocrDS = new ObjectConfigRecord();
                ocrDS.read(baTemp);
                if (!ocrDS.isValid() || !this.compareHeader(ocrAdd, ocrDS)) continue;
                baCurValue = baTemp;
                bReplace = true;
                break;
            }
        }
        baTemp = ocrAdd.write();
        if (bReplace) {
            if (!Arrays.equals(baTemp, baCurValue)) {
                pc.replaceByteArrayAttributeValue(this.m_sObject, this.m_sUseAttr, baCurValue, baTemp);
            }
        } else {
            vRecs = new Vector();
            vRecs.add(baTemp);
            pc.writeMultiByteArrayAttribute(this.m_sObject, this.m_sUseAttr, vRecs, false);
        }
    }

    public void writeRecords(PortalConnection pc, Vector vAddRecs) throws PortalDirectoryException {
        byte[] baTemp = null;
        byte[] baCurValue = null;
        Vector<byte[]> vRecs = null;
        boolean bReplace = false;
        ObjectConfigRecord ocrDS = null;
        ObjectConfigRecord ocrAdd = null;
        vRecs = pc.readMultiByteArrayAttribute(this.m_sObject, this.m_sUseAttr);
        if (vRecs == null || vRecs.size() == 0) {
            String sClass = pc.getObjectType(this.m_sObject);
            if (!(sClass == null || sClass.equals("bhPortal") || sClass.equals("bhGadget") || sClass.equals("bhModule"))) {
                pc.addAuxClass(this.m_sObject, this.m_sUseAttr);
            }
            vRecs = new Vector<byte[]>();
            for (int i = 0; i < vAddRecs.size(); ++i) {
                ocrAdd = (ObjectConfigRecord)vAddRecs.elementAt(i);
                baTemp = ocrAdd.write();
                vRecs.add(baTemp);
            }
            pc.writeMultiByteArrayAttribute(this.m_sObject, this.m_sUseAttr, vRecs, false);
        } else {
            Vector<byte[]> vWriteRecs = null;
            for (int i = 0; i < vAddRecs.size(); ++i) {
                ocrAdd = (ObjectConfigRecord)vAddRecs.elementAt(i);
                bReplace = false;
                ocrDS = null;
                Enumeration e = vRecs.elements();
                while (e.hasMoreElements()) {
                    baTemp = (byte[])e.nextElement();
                    ocrDS = new ObjectConfigRecord();
                    ocrDS.read(baTemp);
                    if (!ocrDS.isValid() || !this.compareHeader(ocrAdd, ocrDS)) continue;
                    baCurValue = baTemp;
                    bReplace = true;
                    break;
                }
                baTemp = ocrAdd.write();
                if (bReplace) {
                    pc.replaceByteArrayAttributeValue(this.m_sObject, this.m_sUseAttr, baCurValue, baTemp);
                    continue;
                }
                vWriteRecs = new Vector<byte[]>();
                vWriteRecs.add(baTemp);
                pc.writeMultiByteArrayAttribute(this.m_sObject, this.m_sUseAttr, vWriteRecs, false);
            }
        }
    }

    public void writePortalRecords(PortalConnection pc) throws PortalDirectoryException {
        ObjectConfigRecord ocr = null;
        this.deletePortalRecords(pc);
        if (this.m_vect != null) {
            String sClass = pc.getObjectType(this.m_sObject);
            if (!(sClass == null || sClass.equals("bhPortal") || sClass.equals("bhGadget") || sClass.equals("bhModule"))) {
                pc.addAuxClass(this.m_sObject, this.m_sUseAttr);
            }
            byte[] baTemp = null;
            Vector<byte[]> vRecs = new Vector<byte[]>();
            Enumeration e = this.m_vect.elements();
            while (e.hasMoreElements()) {
                ocr = (ObjectConfigRecord)e.nextElement();
                baTemp = ocr.write();
                vRecs.add(baTemp);
            }
            if (vRecs.size() > 0) {
                pc.writeMultiByteArrayAttribute(this.m_sObject, this.m_sUseAttr, vRecs, false);
            }
        }
    }

    public void deleteRecord(PortalConnection pc, ObjectConfigRecord ocrDelete) throws PortalDirectoryException {
        byte[] baTemp = null;
        Vector vRecs = null;
        boolean bFound = false;
        vRecs = pc.readMultiByteArrayAttribute(this.m_sObject, this.m_sUseAttr);
        if (vRecs != null && vRecs.size() != 0) {
            ObjectConfigRecord ocrDS = null;
            Enumeration e = vRecs.elements();
            while (e.hasMoreElements()) {
                baTemp = (byte[])e.nextElement();
                ocrDS = new ObjectConfigRecord();
                ocrDS.read(baTemp);
                if (!ocrDS.isValid() || !this.compareHeader(ocrDelete, ocrDS)) continue;
                vRecs.remove(baTemp);
                bFound = true;
                break;
            }
            if (bFound) {
                pc.deleteByteArrayAttributeValue(this.m_sObject, this.m_sUseAttr, baTemp);
            }
        }
    }

    public void deletePortalRecords(PortalConnection pc) throws PortalDirectoryException {
        byte[] baTemp = null;
        Vector vRecs = null;
        boolean bWriteIt = false;
        vRecs = pc.readMultiByteArrayAttribute(this.m_sObject, this.m_sUseAttr);
        if (vRecs != null && vRecs.size() != 0) {
            Vector<byte[]> vDel = new Vector<byte[]>();
            ObjectConfigRecord ocrDS = null;
            Enumeration e = vRecs.elements();
            while (e.hasMoreElements()) {
                baTemp = (byte[])e.nextElement();
                ocrDS = new ObjectConfigRecord();
                ocrDS.read(baTemp);
                if (!ocrDS.isValid()) continue;
                if (this.m_sPortalGUID == null) {
                    vDel.add(baTemp);
                    bWriteIt = true;
                    continue;
                }
                if (!this.m_sPortalGUID.equals(ocrDS.getPCO())) continue;
                vDel.add(baTemp);
                bWriteIt = true;
            }
            if (bWriteIt) {
                e = vDel.elements();
                while (e.hasMoreElements()) {
                    baTemp = (byte[])e.nextElement();
                    vRecs.remove(baTemp);
                }
                pc.writeMultiByteArrayAttribute(this.m_sObject, this.m_sUseAttr, vRecs, true);
            }
        }
    }

    public Vector getRecords() {
        return this.m_vect;
    }

    public int getRecordCount() {
        if (this.m_vect != null) {
            return this.m_vect.size();
        }
        return 0;
    }

    public int getTotalSize() {
        int iSize = 0;
        if (this.m_vect != null) {
            ObjectConfigRecord ocr = null;
            Enumeration e = this.m_vect.elements();
            while (e.hasMoreElements()) {
                ocr = (ObjectConfigRecord)e.nextElement();
                iSize += ocr.hashCode();
            }
        }
        return iSize;
    }

    public Vector getRecords(int iType) {
        Vector<ObjectConfigRecord> vect = new Vector<ObjectConfigRecord>();
        ObjectConfigRecord ocr = null;
        if (this.m_vect != null) {
            Enumeration e = this.m_vect.elements();
            while (e.hasMoreElements()) {
                ocr = (ObjectConfigRecord)e.nextElement();
                if (ocr.getType() != iType) continue;
                vect.addElement(ocr);
            }
        }
        return vect;
    }

    public ObjectConfigRecord getRecord(ObjectConfigRecord ocr) {
        int i;
        for (i = 0; i < this.m_vect.size() && !this.compareHeader(ocr, (ObjectConfigRecord)this.m_vect.get(i)); ++i) {
        }
        if (i < this.m_vect.size()) {
            return (ObjectConfigRecord)this.m_vect.get(i);
        }
        return null;
    }

    public static boolean isEqual(byte[] bPCO1, byte[] bPCO2) {
        boolean bRet = true;
        if (bPCO1.length == bPCO2.length) {
            int len = bPCO1.length;
            for (int i = 0; i < len; ++i) {
                if (bPCO1[i] == bPCO2[i]) continue;
                bRet = false;
                break;
            }
        } else {
            bRet = false;
        }
        return bRet;
    }

    private boolean compareHeader(ObjectConfigRecord ocr1, ObjectConfigRecord ocr2) {
        boolean bRet = false;
        if (ocr1.getType() == ocr2.getType() && ocr1.getSchemeID() == ocr2.getSchemeID() && ocr1.getGadgetID() == ocr2.getGadgetID() && ocr1.getPCO().equals(ocr2.getPCO()) && ocr1.getObjectGUID().equals(ocr2.getObjectGUID())) {
            bRet = true;
        }
        return bRet;
    }

    public static void resolveLinks(PortalConnection pc, String sObject) throws PortalDirectoryException {
        String sTemp = null;
        String sDN = null;
        Scheme schTemp = null;
        GadgetAssignment gaTemp = null;
        Vector vGA = null;
        long lStart = 0L;
        if (Debug.isLoggable(3)) {
            lStart = System.currentTimeMillis();
            Debug.log(DT, 3, "resolveLinks::Start");
        }
        Inheritance inherit = new Inheritance();
        inherit.setBaseDirectoryObject(sObject);
        inherit.readAll(pc, null, true, false, true);
        Vector vSchemes = inherit.getObjectSchemes();
        Vector vBrandingSchemes = inherit.getBrandingAreaSchemes();
        Vector vSchemeOverrides = inherit.getSchemeOverrides();
        if (Debug.isLoggable(3)) {
            StringBuffer sb = new StringBuffer(60);
            sb.append("resolveLinks::Build Inheritance ");
            sb.append(System.currentTimeMillis() - lStart);
            sb.append("ms");
            Debug.log(DT, 3, sb.toString());
            sb.append(System.currentTimeMillis() - lStart);
        }
        if (vSchemes == null) {
            vSchemes = new Vector();
        }
        if (vBrandingSchemes != null) {
            vSchemes.addAll(vBrandingSchemes);
        }
        if (vSchemeOverrides != null) {
            vSchemes.addAll(vSchemeOverrides);
        }
        HashMap<String, String> hmObjectList = new HashMap<String, String>();
        Vector vObjectDNList = pc.readMultiStringAttribute(sObject, "bhObjectList");
        if (vObjectDNList != null) {
            for (int i = 0; i < vObjectDNList.size(); ++i) {
                sTemp = (String)vObjectDNList.elementAt(i);
                hmObjectList.put(sTemp.toLowerCase(), sTemp);
            }
        }
        HashMap hmOrphanList = new HashMap(hmObjectList);
        HashMap hmGoodDNList = new HashMap();
        HashMap hmBadDNList = new HashMap();
        Vector<String> vDNsToAdd = new Vector<String>();
        HashMap<String, String> hmGadgetGUIDList = null;
        Vector<GadgetAssignment> vDeleteGAList = null;
        for (int i = 0; i < vSchemes.size(); ++i) {
            schTemp = (Scheme)vSchemes.elementAt(i);
            boolean bUpdateScheme = false;
            vDeleteGAList = new Vector<GadgetAssignment>();
            vGA = schTemp.getGadgetAssignments();
            if (vGA == null) continue;
            for (int j = 0; j < vGA.size(); ++j) {
                gaTemp = (GadgetAssignment)vGA.elementAt(j);
                sDN = gaTemp.getGadgetDN().toLowerCase();
                sTemp = (String)hmObjectList.get(sDN);
                if (sTemp != null) {
                    hmOrphanList.remove(sDN);
                    continue;
                }
                if (ObjectConfig.isValidGadgetDN(pc, sDN, hmGoodDNList, hmBadDNList)) {
                    vDNsToAdd.add(sDN);
                    continue;
                }
                if (hmGadgetGUIDList == null) {
                    String sGUID = null;
                    hmGadgetGUIDList = new HashMap<String, String>();
                    for (int k = 0; k < vObjectDNList.size(); ++k) {
                        sTemp = (String)vObjectDNList.elementAt(k);
                        sGUID = pc.getObjectGUID(sTemp);
                        if (sGUID == null) continue;
                        hmGadgetGUIDList.put(sGUID, sTemp);
                    }
                }
                if ((sTemp = (String)hmGadgetGUIDList.get(gaTemp.getGadgetID())) != null) {
                    gaTemp.setGadgetDN(sTemp);
                    hmOrphanList.remove(sTemp.toLowerCase());
                    bUpdateScheme = true;
                    continue;
                }
                vDeleteGAList.add(gaTemp);
            }
            for (int k = 0; k < vDeleteGAList.size(); ++k) {
                gaTemp = (GadgetAssignment)vDeleteGAList.elementAt(k);
                if (gaTemp.hasGadgetConfig()) {
                    gaTemp.deleteConfigSettings(pc, schTemp.getPortalID());
                }
                vGA.remove(gaTemp);
                schTemp.setGadgetAssignments(vGA);
                bUpdateScheme = true;
            }
            if (!bUpdateScheme) continue;
            schTemp.writeSchemeSettings(pc, schTemp.getPortalID(), schTemp.getSchemeType());
        }
        if (hmOrphanList.size() > 0) {
            Set s = hmOrphanList.keySet();
            Iterator iter = s.iterator();
            while (iter.hasNext()) {
                sDN = (String)iter.next();
                if (!pc.verifyObjectClass(sDN, "bhGadget")) continue;
                pc.unlinkObjects(sObject, sDN);
            }
        }
        if (Debug.isLoggable(3)) {
            StringBuffer sb = new StringBuffer(60);
            sb.append("resolveLinks::Before AddLinks ");
            sb.append(System.currentTimeMillis() - lStart);
            sb.append("ms");
            Debug.log(DT, 3, sb.toString());
            sb.append(System.currentTimeMillis() - lStart);
        }
        String[] saObjects = new String[vDNsToAdd.size()];
        vDNsToAdd.toArray(saObjects);
        pc.linkObjects(sObject, "bhObjectList", saObjects, "bhObjectList", false);
        if (Debug.isLoggable(3)) {
            StringBuffer sb = new StringBuffer(60);
            sb.append("resolveLinks::End ");
            sb.append(System.currentTimeMillis() - lStart);
            sb.append("ms");
            Debug.log(DT, 3, sb.toString());
            sb.append(System.currentTimeMillis() - lStart);
        }
    }

    private static boolean isValidGadgetDN(PortalConnection pc, String sDN, HashMap hmGoodDNList, HashMap hmBadDNList) {
        boolean bRet = false;
        String sTemp = (String)hmGoodDNList.get(sDN);
        if (sTemp != null) {
            bRet = true;
        } else {
            sTemp = (String)hmBadDNList.get(sDN);
            if (sTemp != null) {
                bRet = false;
            } else {
                if (Debug.isLoggable(3)) {
                    Debug.log(DT, 3, "Look for gadget: " + sDN);
                }
                try {
                    String sGet = pc.getObjectType(sDN);
                    if (sGet == null) {
                        hmBadDNList.put(sDN, sDN);
                        bRet = false;
                    } else {
                        hmGoodDNList.put(sDN, sDN);
                        bRet = true;
                    }
                }
                catch (PortalDirectoryException ex) {
                    hmBadDNList.put(sDN, sDN);
                    bRet = false;
                }
            }
        }
        return bRet;
    }
}

