/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.configManager;

import com.novell.nps.configManager.ConfigData;
import com.novell.nps.configManager.ConfigManager;
import com.novell.nps.configManager.ConfigSettings;
import com.novell.nps.configManager.GadgetAssignment;
import com.novell.nps.configManager.Scheme;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

class PortalServicesUtil {
    private HashMap m_hmRegisteredServices = new HashMap();
    private HashMap m_hmAuthenticatedRegisteredServices = new HashMap();
    private HashMap m_hmManualRegisteredServices = new HashMap();
    private HashMap m_hmManualAuthenticatedRegisteredServices = new HashMap();
    private Vector m_vServiceAssignments = null;
    private Vector m_vAuthenticatedServiceAssignments = null;
    private long m_lServiceAssignmentsTimestamp = 0L;
    private Scheme m_servicesScheme = null;

    PortalServicesUtil() {
    }

    public Scheme getServiceAssignmentsScheme() {
        return null;
    }

    private Scheme createScheme(long lSchemeId) {
        Scheme tempScheme = new Scheme();
        tempScheme.setFDN(ConfigManager.getPCOFDN());
        tempScheme.setObjectID(ConfigManager.getPCOID());
        tempScheme.setPortalID(ConfigManager.getPCOID());
        tempScheme.setSchemeID(lSchemeId);
        tempScheme.setSchemeType(1);
        ConfigSettings cd = new ConfigSettings();
        cd.setSetting("Scheme Type", "3 Column");
        cd.setIntSetting("Scheme Priority", Integer.MAX_VALUE);
        cd.setSetting("ServiceName", tempScheme.getObjectID() + ":" + tempScheme.getSchemeID());
        cd.setSetting("Name", tempScheme.getObjectID() + ":" + tempScheme.getSchemeID());
        tempScheme.setSettings(cd);
        return tempScheme;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupRegisteredServices(HashMap regServices, HashMap hmServices, HashMap hmSchemes, Scheme tempScheme) {
        if (regServices.size() != 0) {
            HashMap hashMap = regServices;
            synchronized (hashMap) {
                Collection co = regServices.values();
                if (co != null) {
                    Iterator iter = co.iterator();
                    GadgetAssignment foundGA = null;
                    while (iter.hasNext()) {
                        GadgetAssignment tempGA = (GadgetAssignment)iter.next();
                        foundGA = (GadgetAssignment)hmServices.get(tempGA.getServiceName());
                        if (foundGA != null && tempGA.getIntPriority() >= foundGA.getIntPriority()) continue;
                        if (hmSchemes != null) {
                            this.setSchemeForService(tempGA, tempScheme, hmSchemes);
                        } else {
                            tempGA.setScheme(tempScheme);
                        }
                        hmServices.put(tempGA.getServiceName(), tempGA);
                    }
                }
            }
        }
    }

    private void addRequiredAssignments(Vector vRequired, HashMap hmServices, Scheme tempScheme) {
        GadgetAssignment requiredGA = null;
        Enumeration eRequired = vRequired.elements();
        while (eRequired.hasMoreElements()) {
            requiredGA = (GadgetAssignment)eRequired.nextElement();
            requiredGA.setScheme(tempScheme);
            String sReqName = requiredGA.getServiceName();
            GadgetAssignment tempGA = (GadgetAssignment)hmServices.get(sReqName);
            if (tempGA != null) {
                requiredGA.setGadgetConfig(tempGA.getGadgetConfig());
                requiredGA.setCustomAssignmentConfig(tempGA.getCustomAssignmentConfig());
            }
            hmServices.put(sReqName, requiredGA);
        }
    }

    public void setSchemeForService(GadgetAssignment tempGA, Scheme tempScheme, HashMap hmSchemes) {
        if (tempGA.getRegistrationKey() == null) {
            tempGA.setScheme(tempScheme);
            Vector<GadgetAssignment> vAssignments = tempScheme.getGadgetAssignments();
            if (vAssignments == null) {
                vAssignments = new Vector<GadgetAssignment>();
            }
            vAssignments.add(tempGA);
            tempScheme.setGadgetAssignments(vAssignments);
        } else {
            Scheme newScheme = (Scheme)hmSchemes.get(tempGA.getRegistrationKey());
            if (newScheme == null) {
                newScheme = new Scheme();
                newScheme.setFDN(ConfigManager.getPCOFDN());
                newScheme.setObjectID(ConfigManager.getPCOID());
                newScheme.setPortalID(ConfigManager.getPCOID());
                newScheme.setSchemeID(tempGA.getRegistrationKey().hashCode());
                newScheme.setSchemeType(1);
                hmSchemes.put(tempGA.getRegistrationKey(), newScheme);
            }
            tempGA.setScheme(newScheme);
            Vector<GadgetAssignment> vAssignments = newScheme.getGadgetAssignments();
            if (vAssignments == null) {
                vAssignments = new Vector<GadgetAssignment>();
            }
            vAssignments.add(tempGA);
            newScheme.setGadgetAssignments(vAssignments);
        }
    }

    public void setServiceAssignmentsScheme(Scheme tempScheme) {
        this.m_servicesScheme = tempScheme;
    }

    private void disallowCopyPrefs(Enumeration eServiceAssignments) {
        while (eServiceAssignments.hasMoreElements()) {
            GadgetAssignment tempGA = (GadgetAssignment)eServiceAssignments.nextElement();
            ConfigData cd = tempGA.getGadgetConfig();
            if (cd == null) {
                cd = new ConfigSettings();
            }
            cd.setSetting("Allow Copying In Preferences", "false");
            tempGA.setGadgetConfig(cd);
        }
    }

    public long getServiceAssignmentsTimestamp() {
        return this.m_lServiceAssignmentsTimestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPublicService(GadgetAssignment tempGA) {
        HashMap hashMap;
        if (tempGA == null) {
            return;
        }
        String sServiceName = tempGA.getServiceName();
        GadgetAssignment registeredGA = null;
        registeredGA = (GadgetAssignment)this.m_hmRegisteredServices.get(sServiceName);
        if (registeredGA == null || tempGA.getIntPriority() < registeredGA.getIntPriority()) {
            hashMap = this.m_hmRegisteredServices;
            synchronized (hashMap) {
                this.m_hmRegisteredServices.put(sServiceName, tempGA);
                this.m_lServiceAssignmentsTimestamp = System.currentTimeMillis();
                this.m_vServiceAssignments = null;
            }
        }
        if ((registeredGA = (GadgetAssignment)this.m_hmManualRegisteredServices.get(sServiceName)) == null || tempGA.getIntPriority() < registeredGA.getIntPriority()) {
            hashMap = this.m_hmManualRegisteredServices;
            synchronized (hashMap) {
                this.m_hmManualRegisteredServices.put(sServiceName, tempGA);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPublicServices(HashMap hmServices) {
        if (hmServices == null || hmServices.size() == 0) {
            return;
        }
        HashMap hmNewPublicServices = null;
        HashMap hashMap = this.m_hmRegisteredServices;
        synchronized (hashMap) {
            hmNewPublicServices = (HashMap)this.m_hmRegisteredServices.clone();
            this.registerServices(hmNewPublicServices, hmServices);
            this.m_hmRegisteredServices.clear();
            this.m_hmRegisteredServices.putAll(hmNewPublicServices);
            HashMap hashMap2 = this.m_hmManualRegisteredServices;
            synchronized (hashMap2) {
                this.m_hmManualRegisteredServices.clear();
                this.m_hmManualRegisteredServices.putAll(hmNewPublicServices);
            }
            this.m_lServiceAssignmentsTimestamp = System.currentTimeMillis();
            this.m_vServiceAssignments = null;
        }
    }

    public void registerServices(HashMap hmCurrentServices, HashMap hmNewServices) {
        String sServiceName = null;
        GadgetAssignment tempGA = null;
        GadgetAssignment registeredGA = null;
        Set set = hmNewServices.keySet();
        if (set != null) {
            Iterator it = set.iterator();
            while (it.hasNext()) {
                sServiceName = (String)it.next();
                tempGA = (GadgetAssignment)hmNewServices.get(sServiceName);
                if (tempGA == null || (registeredGA = (GadgetAssignment)hmCurrentServices.get(sServiceName)) != null && tempGA.getIntPriority() >= registeredGA.getIntPriority()) continue;
                hmCurrentServices.put(sServiceName, tempGA);
            }
        }
    }

    public boolean isPublicServiceRegistered(String sServiceName) {
        if (sServiceName == null) {
            return false;
        }
        GadgetAssignment registeredGA = null;
        registeredGA = (GadgetAssignment)this.m_hmRegisteredServices.get(sServiceName);
        return registeredGA != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRegisteredPublicServices(String sKey) {
        HashMap hashMap = this.m_hmRegisteredServices;
        synchronized (hashMap) {
            this.clearServices(this.m_hmRegisteredServices, sKey);
            HashMap hashMap2 = this.m_hmManualRegisteredServices;
            synchronized (hashMap2) {
                this.m_hmManualRegisteredServices.clear();
                this.m_hmManualRegisteredServices.putAll(this.m_hmRegisteredServices);
            }
            this.m_lServiceAssignmentsTimestamp = System.currentTimeMillis();
            this.m_vServiceAssignments = null;
        }
    }

    public void clearServices(HashMap hmServices, String sKey) {
        Vector<String> vRemove = new Vector<String>();
        String sServiceName = null;
        GadgetAssignment tempGA = null;
        String sRegistrationKey = null;
        Set set = hmServices.keySet();
        if (set != null) {
            Iterator it = set.iterator();
            while (it.hasNext()) {
                sServiceName = (String)it.next();
                tempGA = (GadgetAssignment)hmServices.get(sServiceName);
                if (tempGA == null) continue;
                sRegistrationKey = tempGA.getRegistrationKey();
                if (sKey == null && sRegistrationKey == null) {
                    vRemove.add(sServiceName);
                    continue;
                }
                if (sKey == null || sRegistrationKey == null || !sKey.equalsIgnoreCase(sRegistrationKey)) continue;
                vRemove.add(sServiceName);
            }
            Enumeration e = vRemove.elements();
            while (e.hasMoreElements()) {
                sServiceName = (String)e.nextElement();
                hmServices.remove(sServiceName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRegisteredPublicService(String sServiceName) {
        if (sServiceName == null) {
            return;
        }
        HashMap hashMap = this.m_hmManualRegisteredServices;
        synchronized (hashMap) {
            this.m_hmManualRegisteredServices.remove(sServiceName);
        }
        hashMap = this.m_hmRegisteredServices;
        synchronized (hashMap) {
            this.m_hmRegisteredServices.remove(sServiceName);
            this.m_lServiceAssignmentsTimestamp = System.currentTimeMillis();
            this.m_vServiceAssignments = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reregisterPublicServices(HashMap hmServices, String sKey) {
        HashMap hashMap = this.m_hmRegisteredServices;
        synchronized (hashMap) {
            HashMap hmExistingServices = (HashMap)this.m_hmRegisteredServices.clone();
            this.clearServices(hmExistingServices, sKey);
            this.registerServices(hmExistingServices, hmServices);
            this.m_hmRegisteredServices.clear();
            this.m_hmRegisteredServices.putAll(hmExistingServices);
            HashMap hashMap2 = this.m_hmManualRegisteredServices;
            synchronized (hashMap2) {
                this.m_hmManualRegisteredServices.clear();
                this.m_hmManualRegisteredServices.putAll(hmExistingServices);
            }
            this.m_lServiceAssignmentsTimestamp = System.currentTimeMillis();
            this.m_vServiceAssignments = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAuthenticatedPublicService(GadgetAssignment tempGA) {
        HashMap hashMap;
        if (tempGA == null) {
            return;
        }
        String sServiceName = tempGA.getServiceName();
        GadgetAssignment registeredGA = null;
        registeredGA = (GadgetAssignment)this.m_hmAuthenticatedRegisteredServices.get(sServiceName);
        if (registeredGA == null || tempGA.getIntPriority() < registeredGA.getIntPriority()) {
            hashMap = this.m_hmAuthenticatedRegisteredServices;
            synchronized (hashMap) {
                this.m_hmAuthenticatedRegisteredServices.put(sServiceName, tempGA);
                this.m_lServiceAssignmentsTimestamp = System.currentTimeMillis();
                this.m_vAuthenticatedServiceAssignments = null;
            }
        }
        if ((registeredGA = (GadgetAssignment)this.m_hmManualAuthenticatedRegisteredServices.get(sServiceName)) == null || tempGA.getIntPriority() < registeredGA.getIntPriority()) {
            hashMap = this.m_hmManualAuthenticatedRegisteredServices;
            synchronized (hashMap) {
                this.m_hmManualAuthenticatedRegisteredServices.put(sServiceName, tempGA);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAuthenticatedPublicServices(HashMap hmServices) {
        if (hmServices == null || hmServices.size() == 0) {
            return;
        }
        HashMap hmNewAuthenticatedPublicServices = null;
        HashMap hashMap = this.m_hmAuthenticatedRegisteredServices;
        synchronized (hashMap) {
            hmNewAuthenticatedPublicServices = (HashMap)this.m_hmAuthenticatedRegisteredServices.clone();
            this.m_hmAuthenticatedRegisteredServices.clear();
            this.m_hmAuthenticatedRegisteredServices.putAll(hmNewAuthenticatedPublicServices);
            HashMap hashMap2 = this.m_hmManualAuthenticatedRegisteredServices;
            synchronized (hashMap2) {
                this.m_hmManualAuthenticatedRegisteredServices.clear();
                this.m_hmManualAuthenticatedRegisteredServices.putAll(hmNewAuthenticatedPublicServices);
            }
            this.m_lServiceAssignmentsTimestamp = System.currentTimeMillis();
            this.m_vAuthenticatedServiceAssignments = null;
        }
    }

    public boolean isAuthenticatedPublicServiceRegistered(String sServiceName) {
        if (sServiceName == null) {
            return false;
        }
        GadgetAssignment registeredGA = null;
        registeredGA = (GadgetAssignment)this.m_hmAuthenticatedRegisteredServices.get(sServiceName);
        return registeredGA != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRegisteredAuthenticatedPublicServices(String sKey) {
        HashMap hashMap = this.m_hmAuthenticatedRegisteredServices;
        synchronized (hashMap) {
            this.clearServices(this.m_hmAuthenticatedRegisteredServices, sKey);
            HashMap hashMap2 = this.m_hmManualAuthenticatedRegisteredServices;
            synchronized (hashMap2) {
                this.m_hmManualAuthenticatedRegisteredServices.clear();
                this.m_hmManualAuthenticatedRegisteredServices.putAll(this.m_hmAuthenticatedRegisteredServices);
            }
            this.m_lServiceAssignmentsTimestamp = System.currentTimeMillis();
            this.m_vAuthenticatedServiceAssignments = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRegisteredAuthenticatedPublicService(String sServiceName) {
        if (sServiceName == null) {
            return;
        }
        HashMap hashMap = this.m_hmManualAuthenticatedRegisteredServices;
        synchronized (hashMap) {
            this.m_hmManualAuthenticatedRegisteredServices.remove(sServiceName);
        }
        hashMap = this.m_hmAuthenticatedRegisteredServices;
        synchronized (hashMap) {
            this.m_hmAuthenticatedRegisteredServices.remove(sServiceName);
            this.m_lServiceAssignmentsTimestamp = System.currentTimeMillis();
            this.m_vAuthenticatedServiceAssignments = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reregisterAuthenticatedPublicServices(HashMap hmServices, String sKey) {
        HashMap hashMap = this.m_hmAuthenticatedRegisteredServices;
        synchronized (hashMap) {
            HashMap hmExistingServices = (HashMap)this.m_hmAuthenticatedRegisteredServices.clone();
            this.clearServices(hmExistingServices, sKey);
            this.registerServices(hmExistingServices, hmServices);
            this.m_hmAuthenticatedRegisteredServices.clear();
            this.m_hmAuthenticatedRegisteredServices.putAll(hmExistingServices);
            HashMap hashMap2 = this.m_hmManualAuthenticatedRegisteredServices;
            synchronized (hashMap2) {
                this.m_hmManualAuthenticatedRegisteredServices.clear();
                this.m_hmManualAuthenticatedRegisteredServices.putAll(hmExistingServices);
            }
            this.m_lServiceAssignmentsTimestamp = System.currentTimeMillis();
            this.m_vAuthenticatedServiceAssignments = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readRegisteredServices() {
        HashMap hashMap = this.m_hmRegisteredServices;
        synchronized (hashMap) {
            this.m_hmRegisteredServices.clear();
            this.m_hmRegisteredServices.putAll(this.m_hmManualRegisteredServices);
        }
        hashMap = this.m_hmAuthenticatedRegisteredServices;
        synchronized (hashMap) {
            this.m_hmAuthenticatedRegisteredServices.clear();
            this.m_hmAuthenticatedRegisteredServices.putAll(this.m_hmManualAuthenticatedRegisteredServices);
        }
    }
}

