/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.configManager;

import com.novell.emframe.fw.FwUtils;
import com.novell.nps.configManager.ConfigManager;
import com.novell.nps.sessionManager.PortalSession;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.HttpSession;

public class SettingValue
implements Cloneable,
Serializable {
    private String m_sValue = null;
    private String m_sDisplayValue = null;
    private HashMap m_hmDisplayValues = null;
    private boolean m_bInherited = false;
    private Object m_object = null;

    public SettingValue(String sValue) {
        this.setValue(sValue);
        this.m_sDisplayValue = null;
        this.m_hmDisplayValues = null;
    }

    public SettingValue(String sValue, String sDisplayValue) {
        this.m_sDisplayValue = sDisplayValue;
        this.m_hmDisplayValues = null;
        this.setValue(sValue);
    }

    public SettingValue(String sValue, HashMap hmDisplayValues) {
        this.m_sDisplayValue = null;
        this.m_hmDisplayValues = hmDisplayValues;
        this.setValue(sValue);
    }

    public String getValue() {
        return this.m_sValue;
    }

    public void setValue(String sValue) {
        this.m_sValue = sValue;
    }

    public boolean areDisplayValuesPresent() {
        if (this.m_sDisplayValue != null && this.m_sDisplayValue.length() != 0) {
            return true;
        }
        return this.m_hmDisplayValues != null && this.m_hmDisplayValues.size() != 0;
    }

    public String getDisplayValue(PortalSession session) {
        if (this.m_hmDisplayValues == null || this.m_hmDisplayValues.size() == 0) {
            if (this.m_sDisplayValue != null && this.m_sDisplayValue.length() != 0) {
                return this.m_sDisplayValue;
            }
            return this.m_sValue;
        }
        Locale[] locs = null;
        if (session != null) {
            locs = FwUtils.getLocales((HttpSession)session);
        }
        if (locs == null || locs.length == 0) {
            return this.m_sValue;
        }
        String sDisplayValue = null;
        for (int i = 0; i < locs.length; ++i) {
            sDisplayValue = (String)this.m_hmDisplayValues.get(ConfigManager.getLanguageCode(locs[i]));
            if (sDisplayValue == null || sDisplayValue.length() == 0) continue;
            return sDisplayValue;
        }
        return this.m_sValue;
    }

    public HashMap getDisplayValueMap() {
        return this.m_hmDisplayValues;
    }

    public void setDisplayValue(String sDisplayValue) {
        this.m_sDisplayValue = sDisplayValue;
        this.m_hmDisplayValues = null;
    }

    public void setDisplayValueMap(HashMap hmDisplayValues) {
        this.m_sDisplayValue = null;
        this.m_hmDisplayValues = hmDisplayValues;
    }

    public boolean getInheritedFromParent() {
        return this.m_bInherited;
    }

    public void setInheritedFromParent(boolean bInherited) {
        this.m_bInherited = bInherited;
    }

    public Object getObjectValue() {
        return this.m_object;
    }

    public void setObjectValue(Object newobject) {
        this.m_object = newobject;
    }

    public SettingValue copy() {
        SettingValue newSV = null;
        newSV = this.m_sDisplayValue != null && this.m_sDisplayValue.length() != 0 ? new SettingValue(this.m_sValue, this.m_sDisplayValue) : (this.m_hmDisplayValues != null && this.m_hmDisplayValues.size() != 0 ? new SettingValue(this.m_sValue, this.m_hmDisplayValues) : new SettingValue(this.m_sValue));
        newSV.setInheritedFromParent(this.m_bInherited);
        newSV.setObjectValue(this.m_object);
        return newSV;
    }

    protected Object clone() throws CloneNotSupportedException {
        return this.copy();
    }
}

