/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.event;

import com.novell.nps.event.PortalEvent;
import com.novell.nps.event.PortalEventDispatcher;
import com.novell.nps.event.PortalEventListener;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;

public class PortalEventManager {
    private static Hashtable events = new Hashtable();
    private static LinkedList eventList = new LinkedList();
    private static PortalEventManager thePortalEventManager = new PortalEventManager();
    private static Thread dispatchThread = new PortalEventDispatcher(thePortalEventManager);

    public static LinkedList getEventList() {
        return eventList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void postEvent(PortalEvent portalEvent) {
        if (portalEvent != null) {
            portalEvent.setTimeStamp(System.currentTimeMillis());
            LinkedList linkedList = eventList;
            synchronized (linkedList) {
                eventList.addLast(portalEvent);
                eventList.notify();
            }
        }
    }

    public static void registerEventListener(PortalEventListener eventListener, String portalEventClassName) {
        if (eventListener != null && portalEventClassName != null) {
            HashSet<PortalEventListener> listeners = (HashSet<PortalEventListener>)events.get(portalEventClassName);
            if (listeners == null) {
                listeners = new HashSet<PortalEventListener>();
            }
            listeners.add(eventListener);
            events.put(portalEventClassName, listeners);
        }
    }

    public static void unRegisterEventListener(PortalEventListener eventListener, String portalEventClassName) {
        if (eventListener != null && portalEventClassName != null) {
            HashSet listeners = (HashSet)events.get(portalEventClassName);
            if (listeners != null) {
                listeners.remove(eventListener);
            }
            events.put(portalEventClassName, listeners);
        }
    }

    public static void registerEventListener(PortalEventListener eventListener, String[] portalEventClassNames) {
        if (eventListener != null && portalEventClassNames != null) {
            for (int i = 0; i < portalEventClassNames.length; ++i) {
                PortalEventManager.registerEventListener(eventListener, portalEventClassNames[i]);
            }
        }
    }

    public static void unRegisterEventListener(PortalEventListener eventListener, String[] portalEventClassNames) {
        if (eventListener != null && portalEventClassNames != null) {
            for (int i = 0; i < portalEventClassNames.length; ++i) {
                PortalEventManager.unRegisterEventListener(eventListener, portalEventClassNames[i]);
            }
        }
    }

    public static Hashtable getEvents() {
        return events;
    }

    static {
        dispatchThread.start();
        dispatchThread.setPriority(7);
    }
}

