/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.file;

import com.novell.nps.debug.Debug;
import com.novell.nps.file.LocalFileInputStream;
import com.novell.nps.file.LocalFileOutputStream;
import com.novell.nps.file.NPSFileResource;
import com.novell.nps.file.NPSFileResourceInputStream;
import com.novell.nps.file.NPSFileResourceOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class LocalFileResource
implements NPSFileResource {
    static final String DT = "LocalFileResource";
    static final char separatorChar = '/';
    static final String separator = "/";
    File m_file;
    String m_path;
    String m_resourceBase;
    String m_parent;
    String m_child;

    public LocalFileResource(String resourceBase, String parent, String child, boolean makeDirs) {
        try {
            File base = new File(resourceBase);
            if (makeDirs) {
                base.mkdirs();
            }
            this.m_file = new File(resourceBase + parent + child);
            this.m_resourceBase = resourceBase;
            if (parent != null) {
                this.m_parent = parent;
            } else {
                parent = separator;
            }
            if (child == null) {
                throw new NullPointerException();
            }
            this.m_child = child;
            this.m_path = parent + separator + child;
        }
        catch (Exception ex) {
            Debug.log(DT, ex);
        }
    }

    public LocalFileResource(String resourceBase, String path, boolean makeDirs) {
        try {
            File base = new File(resourceBase);
            if (makeDirs) {
                base.mkdirs();
            }
            this.m_file = path != null && path.length() > 1 ? new File(base, path.substring(1)) : base;
            this.m_resourceBase = resourceBase;
            this.m_path = path != null ? path : separator;
            int index = path.lastIndexOf(47);
            this.m_parent = path.substring(0, index);
            this.m_child = this.m_file.getName();
        }
        catch (Exception ex) {
            Debug.log(DT, ex);
        }
    }

    public LocalFileResource(LocalFileResource parent, String child) {
        this.m_file = new File(parent.getFile(), child);
        this.m_resourceBase = parent.getResourceBase();
        this.m_parent = parent.getPath();
        this.m_child = child;
        this.m_path = this.m_parent + separator + this.m_child;
    }

    public File getFile() {
        return this.m_file;
    }

    public NPSFileResource getChildResource(String path) {
        return new LocalFileResource(this, path);
    }

    public String getName() {
        return this.m_file.getName();
    }

    public String getParent() {
        return this.m_parent;
    }

    public String getPath() {
        return this.m_path;
    }

    public String getCanonicalPath() {
        try {
            return this.m_file.getCanonicalPath();
        }
        catch (IOException e) {
            Debug.log(DT, e);
            return null;
        }
    }

    public boolean exists() {
        return this.m_file.exists();
    }

    public boolean canRead() {
        return this.m_file.canRead();
    }

    public boolean canWrite() {
        return this.m_file.canWrite();
    }

    public boolean isDirectory() {
        return this.m_file.isDirectory();
    }

    public boolean isFile() {
        return this.m_file.isFile();
    }

    public boolean isHidden() {
        return this.m_file.isHidden();
    }

    public long lastModified() {
        return this.m_file.lastModified();
    }

    public String[] list() {
        return this.m_file.list();
    }

    public boolean renameTo(NPSFileResource dest) {
        if (dest instanceof LocalFileResource) {
            File destFile = ((LocalFileResource)dest).getFile();
            return this.m_file.renameTo(destFile);
        }
        return false;
    }

    public boolean delete() {
        return this.m_file.delete();
    }

    public long length() {
        return this.m_file.length();
    }

    public boolean mkdir() {
        return this.m_file.mkdir();
    }

    public boolean mkdirs() {
        return this.m_file.mkdirs();
    }

    public String getResourceBase() {
        return this.m_resourceBase;
    }

    public URL toURL() throws MalformedURLException {
        return this.m_file.toURL();
    }

    public int hashCode() {
        return this.m_file.hashCode();
    }

    public boolean equals(Object obj) {
        return this.m_file.equals(obj);
    }

    public String toString() {
        return this.m_file.toString();
    }

    public NPSFileResourceInputStream getInputStream() throws IOException {
        return new LocalFileInputStream(this);
    }

    public NPSFileResourceOutputStream getOutputStream() throws IOException {
        return new LocalFileOutputStream(this);
    }

    public NPSFileResourceOutputStream getOutputStream(boolean append) throws IOException {
        return new LocalFileOutputStream(this, append);
    }
}

