/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.gadgetManager;

import com.novell.nps.debug.Debug;
import com.novell.nps.gadgetManager.GadgetGetDataThreadList;
import com.novell.nps.gadgetManager.GadgetInfo;
import com.novell.nps.gadgetManager.GadgetInstance;
import com.novell.nps.gadgetManager.GadgetInstanceException;
import com.novell.nps.gadgetManager.GadgetManager;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Document;

public class GadgetGetDataThread
extends Thread {
    private static final String DT = "GadgetGetDataThread";
    private GadgetGetDataThreadList ggdtList;
    private GadgetInfo gadgetInfo;
    private HttpServletRequest httpRequest;
    private boolean gadgetAlreadyLocked = false;
    private StringWriter stringWriter = new StringWriter();
    private Document domTree = null;
    private boolean finished = false;

    public GadgetGetDataThread(GadgetGetDataThreadList ggdtList, GadgetInfo gadgetInfo, HttpServletRequest req) {
        super(gadgetInfo.getGadgetInstance().getGadgetAssignment().getAssignmentName());
        Class[] args;
        this.ggdtList = ggdtList;
        this.gadgetInfo = gadgetInfo;
        this.httpRequest = req;
        Class<?> tClass = Thread.currentThread().getClass();
        Method method = null;
        String methodName = "holdsLock";
        try {
            args = new Class[]{Class.forName("java.lang.Object")};
        }
        catch (ClassNotFoundException e) {
            Debug.log(DT, e);
            return;
        }
        try {
            method = tClass.getMethod(methodName, args);
        }
        catch (Exception e) {
            Debug.log(DT, 2, "Recommend upgrading to JDK1.4");
            this.gadgetAlreadyLocked = true;
            return;
        }
        try {
            Object[] params = new Object[]{gadgetInfo.getGadgetInstance()};
            Boolean bLocked = (Boolean)method.invoke(tClass, params);
            this.gadgetAlreadyLocked = bLocked;
        }
        catch (IllegalAccessException e) {
            Debug.log(DT, e);
            return;
        }
        catch (IllegalArgumentException e) {
            Debug.log(DT, e);
            return;
        }
        catch (InvocationTargetException e) {
            Debug.log(DT, e);
            return;
        }
    }

    public void run() {
        GadgetInstance gadgetInstance = this.gadgetInfo.getGadgetInstance();
        long startTime = System.currentTimeMillis();
        BufferedWriter bw = new BufferedWriter(this.stringWriter);
        try {
            if (this.gadgetAlreadyLocked) {
                GadgetManager.callGetDataNoLock(gadgetInstance, this.httpRequest, bw, this.domTree);
            } else {
                GadgetManager.callGetData(gadgetInstance, this.httpRequest, bw, this.domTree);
            }
        }
        catch (GadgetInstanceException e) {
            Debug.log(DT, 1, e);
        }
        try {
            bw.close();
        }
        catch (IOException e) {
            Debug.log(DT, 1, e);
        }
        this.finished = true;
        long stopTime = System.currentTimeMillis();
        this.gadgetInfo.setLastResponseTime(stopTime - startTime);
        this.ggdtList.changeToReady(this);
    }

    public StringWriter getStringWriter() {
        return this.stringWriter;
    }

    public Document getDomTree() {
        return this.domTree;
    }

    public GadgetInstance getGadgetInstance() {
        return this.gadgetInfo.getGadgetInstance();
    }

    public GadgetInfo getGadgetInfo() {
        return this.gadgetInfo;
    }

    public int getTimeOut() {
        return this.gadgetInfo.getGadgetInstance().getGadgetAssignment().getGadgetConfig().getSingleIntSetting("Gadget Timeout");
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setGadgetGetDataThreadList(GadgetGetDataThreadList ggdThreadList) {
        this.ggdtList = ggdThreadList;
    }

    public void setRequest(HttpServletRequest req) {
        this.httpRequest = req;
    }
}

