/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.gadgetManager;

import com.novell.nps.configManager.ConfigManager;
import com.novell.nps.debug.Debug;
import com.novell.nps.gadgetManager.GadgetGetDataThread;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class GadgetGetDataThreadList {
    private Hashtable waitingSet = new Hashtable();
    private Vector readyList = new Vector();
    private Iterator timedOutList;
    private int currentReadyIndex = 0;
    private int totalThreads = 0;
    private long startTime = System.currentTimeMillis();
    private long timeOut = ConfigManager.getIntPortalSetting("Gadget Timeout", 8000);
    private boolean timedOut = false;
    private boolean forceRead = false;

    public void addWaiting(GadgetGetDataThread ggdThread) {
        long gadgetTimeOut = ggdThread.getTimeOut();
        if (gadgetTimeOut > this.timeOut) {
            this.timeOut = gadgetTimeOut;
        }
        this.waitingSet.put(ggdThread.getName(), ggdThread);
        ++this.totalThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeToReady(GadgetGetDataThread ggdThread) {
        this.waitingSet.remove(ggdThread.getName());
        Vector vector = this.readyList;
        synchronized (vector) {
            this.readyList.addElement(ggdThread);
            this.readyList.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GadgetGetDataThread getNextReady() {
        Vector vector = this.readyList;
        synchronized (vector) {
            if (this.currentReadyIndex >= this.readyList.size()) {
                try {
                    long timeout = this.timeOut - (System.currentTimeMillis() - this.startTime);
                    if (timeout <= 0L) {
                        return null;
                    }
                    this.readyList.wait(timeout);
                    if (this.isTimedOut()) {
                        return null;
                    }
                }
                catch (InterruptedException e) {
                    Debug.log("GadgetGetDataThreadList", 1, e);
                    return null;
                }
            }
            if (this.currentReadyIndex >= this.readyList.size()) {
                return null;
            }
            return (GadgetGetDataThread)this.readyList.elementAt(this.currentReadyIndex++);
        }
    }

    public boolean isFinished() {
        return this.currentReadyIndex >= this.totalThreads || !this.moreReady() && this.isTimedOut();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moreReady() {
        Vector vector = this.readyList;
        synchronized (vector) {
            return this.currentReadyIndex < this.readyList.size();
        }
    }

    public boolean isTimedOut() {
        if (!this.timedOut) {
            boolean bl = this.timedOut = System.currentTimeMillis() - this.startTime > this.timeOut;
        }
        if (this.timedOut && null == this.timedOutList) {
            this.timedOutList = this.waitingSet.values().iterator();
        }
        return this.timedOut;
    }

    public void forceRead(boolean forceRead) {
        this.forceRead = forceRead;
    }

    public boolean hasMoreTimedOut() {
        if (null == this.timedOutList) {
            return false;
        }
        return this.timedOutList.hasNext();
    }

    public GadgetGetDataThread getNextTimedOut() {
        return (GadgetGetDataThread)this.timedOutList.next();
    }
}

