/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.gadgetManager;

import com.novell.nps.gadgetManager.GadgetGetDataThread;
import com.novell.nps.gadgetManager.GadgetInstance;
import java.util.Stack;

public class GadgetInfo {
    private Stack delegatorStack;
    private GadgetInstance gadgetInstance = null;
    private long averageResponseTime = 0L;
    private long lastResponseTime = 0L;
    private long accessCount = 0L;
    private boolean asynchronous = false;
    private boolean timedOut = false;
    private GadgetGetDataThread savedGGDThread;

    public GadgetInfo(GadgetInstance gadgetInstance) {
        this.gadgetInstance = gadgetInstance;
    }

    private GadgetInfo() {
    }

    public GadgetInstance getGadgetInstance() {
        return this.gadgetInstance;
    }

    public long getAverageResponseTime() {
        return this.averageResponseTime;
    }

    public long getLastResponseTime() {
        return this.lastResponseTime;
    }

    public void setLastResponseTime(long responseTime) {
        this.lastResponseTime = responseTime;
        this.averageResponseTime = (this.averageResponseTime * this.accessCount + this.lastResponseTime) / ++this.accessCount;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("GadgetInstanceID: ");
        buffer.append(this.gadgetInstance.getGadgetInstanceID());
        buffer.append("\nLast Response Time (ms): ");
        buffer.append(String.valueOf(this.lastResponseTime));
        buffer.append("\nAverage Response Time (ms): ");
        buffer.append(String.valueOf(this.averageResponseTime));
        return buffer.toString();
    }

    public String getLayoutXMLString() {
        return "";
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public void setTimedOut(boolean timedOut) {
        this.timedOut = timedOut;
    }

    public GadgetGetDataThread getSavedGadgetGetDataThread() {
        return this.savedGGDThread;
    }

    public void saveTimedOutGadgetGetDataThread(GadgetGetDataThread ggdThread) {
        this.savedGGDThread = ggdThread;
    }

    public void delegate(GadgetInstance delegate) {
        if (this.delegatorStack == null) {
            this.delegatorStack = new Stack();
        }
        this.delegatorStack.push(this.gadgetInstance);
        delegate.setParentInstance(this.gadgetInstance.getParentInstance());
        this.gadgetInstance = delegate;
    }
}

