/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.gadgetManager;

import com.novell.emframe.dev.XmlUtils;
import com.novell.nps.debug.Debug;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtil {
    public static final String DT = "XmlUtil";
    public static final String CDATA_START = "<![CDATA[";
    public static final String CDATA_END = "]]>";

    public static void writeTag(String tagName, String tagValue, BufferedWriter bout) throws IOException {
        XmlUtils.writeTag((String)tagName, (String)tagValue, (BufferedWriter)bout);
    }

    public static void writeCDataTag(String tagName, String tagValue, BufferedWriter bout) throws IOException {
        XmlUtils.writeCDataTag((String)tagName, (String)tagValue, (BufferedWriter)bout);
    }

    public static void writeTag(String tagName, Properties tagAttributes, String tagValue, BufferedWriter bout) throws IOException {
        XmlUtils.writeTag((String)tagName, (Properties)tagAttributes, (String)tagValue, (BufferedWriter)bout);
    }

    public static void writeTag(String tagName, Properties tagAttributes, String tagValue, BufferedWriter bout, boolean bCData) throws IOException {
        XmlUtils.writeTag((String)tagName, (Properties)tagAttributes, (String)tagValue, (BufferedWriter)bout, (boolean)bCData);
    }

    public static void writeStartTag(String tagName, BufferedWriter bout) throws IOException {
        XmlUtils.writeStartTag((String)tagName, (BufferedWriter)bout);
    }

    public static void writeStartTag(String tagName, Properties tagAttributes, BufferedWriter bout) throws IOException {
        XmlUtils.writeStartTag((String)tagName, (Properties)tagAttributes, (BufferedWriter)bout);
    }

    public static void writeEndTag(String tagName, BufferedWriter bout) throws IOException {
        XmlUtils.writeEndTag((String)tagName, (BufferedWriter)bout);
    }

    public static void writeTag(String tagName, String tagValue, StringBuffer bout) {
        XmlUtils.writeTag((String)tagName, (String)tagValue, (StringBuffer)bout);
    }

    public static void writeCDataTag(String tagName, String tagValue, StringBuffer bout) {
        XmlUtils.writeCDataTag((String)tagName, (String)tagValue, (StringBuffer)bout);
    }

    public static void writeTag(String tagName, Properties tagAttributes, String tagValue, StringBuffer bout) {
        XmlUtils.writeTag((String)tagName, (Properties)tagAttributes, (String)tagValue, (StringBuffer)bout);
    }

    public static void writeTag(String tagName, Properties tagAttributes, String tagValue, StringBuffer bout, boolean bCData) {
        XmlUtils.writeTag((String)tagName, (Properties)tagAttributes, (String)tagValue, (StringBuffer)bout, (boolean)bCData);
    }

    public static void writeStartTag(String tagName, StringBuffer bout) {
        XmlUtils.writeStartTag((String)tagName, (StringBuffer)bout);
    }

    public static void writeStartTag(String tagName, Properties tagAttributes, StringBuffer bout) {
        XmlUtils.writeStartTag((String)tagName, (Properties)tagAttributes, (StringBuffer)bout);
    }

    public static void writeEndTag(String tagName, StringBuffer bout) {
        XmlUtils.writeEndTag((String)tagName, (StringBuffer)bout);
    }

    public static String domToXML(Document dom, boolean indentXML, boolean bWriteDeclaration) {
        if (dom != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            TransformerFactory tf = TransformerFactory.newInstance();
            try {
                Transformer transformer = tf.newTransformer();
                transformer.setOutputProperty("indent", indentXML ? "yes" : "no");
                transformer.setOutputProperty("omit-xml-declaration", bWriteDeclaration ? "no" : "yes");
                transformer.setOutputProperty("method", "xml");
                DOMSource source = new DOMSource(dom);
                StreamResult result = new StreamResult(baos);
                try {
                    transformer.transform(source, result);
                    return baos.toString("UTF-8");
                }
                catch (TransformerException e) {
                    Debug.log(DT, e);
                    return null;
                }
                catch (UnsupportedEncodingException f) {
                    Debug.log(DT, f);
                    return null;
                }
            }
            catch (TransformerConfigurationException e) {
                Debug.log(DT, e);
                return null;
            }
        }
        return null;
    }

    public static Node findFirstElement(Document dom, String sElementPath) {
        Node retNode = null;
        if (dom != null) {
            retNode = XmlUtil.findNode(dom, sElementPath);
        }
        return retNode;
    }

    public static Node findFirstElement(Node node, String sElementPath) {
        Node retNode = null;
        StringBuffer sb = new StringBuffer(node.getNodeName());
        sb.append("\\");
        sb.append(sElementPath);
        String sPath = sb.toString();
        retNode = XmlUtil.findNode(node, sPath);
        return retNode;
    }

    public static Node findNextElement(Node node) {
        Node retNode = node;
        while (!((retNode = retNode.getNextSibling()) == null || retNode.getNodeType() == 1 && retNode.getNodeName().equals(node.getNodeName()))) {
        }
        return retNode;
    }

    public static String getNodeAttributeValue(Node node, String sAttribute) {
        if (node == null || sAttribute == null || sAttribute.length() == 0) {
            return null;
        }
        String sAttributeValue = null;
        Node attribute = null;
        NamedNodeMap allAttributes = node.getAttributes();
        if (allAttributes != null && allAttributes.getLength() != 0 && (attribute = allAttributes.getNamedItem(sAttribute)) != null) {
            sAttributeValue = attribute.getNodeValue();
        }
        return sAttributeValue;
    }

    public static Hashtable getNodeSettingsTable(Node node) {
        Hashtable<String, Vector<String>> ht = new Hashtable<String, Vector<String>>();
        String sName = null;
        String sValue = null;
        Vector<String> v = null;
        Node child = null;
        Node baby = null;
        NodeList babylist = null;
        NodeList children = node.getChildNodes();
        if (children != null) {
            int len = children.getLength();
            for (int i = 0; i < len; ++i) {
                child = children.item(i);
                if (child.getNodeType() != 1) continue;
                sName = child.getNodeName();
                babylist = child.getChildNodes();
                if (babylist == null || babylist.getLength() <= 0) continue;
                baby = babylist.item(0);
                sValue = baby.getNodeValue();
                if (sName == null || sValue == null) continue;
                v = (Vector<String>)ht.get(sName);
                if (v != null) {
                    v.add(sValue);
                    continue;
                }
                v = new Vector<String>();
                v.add(sValue);
                ht.put(sName, v);
            }
        }
        return ht;
    }

    public static String getNodeValue(Node node, String sValueName) {
        NodeList babylist;
        String sStr = null;
        StringBuffer sb = new StringBuffer(node.getNodeName());
        sb.append("\\");
        sb.append(sValueName);
        String sPath = sb.toString();
        Node child = XmlUtil.findNode(node, sPath);
        Node baby = null;
        if (child != null && (babylist = child.getChildNodes()) != null && babylist.getLength() > 0) {
            baby = babylist.item(0);
            sStr = new String(baby.getNodeValue());
        }
        return sStr;
    }

    public static Vector getNodeValues(Node node, String sValueName) {
        Vector<String> vStr = new Vector<String>();
        StringBuffer sb = new StringBuffer(node.getNodeName());
        sb.append("\\");
        sb.append(sValueName);
        String sPath = sb.toString();
        Node child = XmlUtil.findNode(node, sPath);
        Node baby = null;
        while (child != null) {
            NodeList babylist = child.getChildNodes();
            if (babylist != null && babylist.getLength() > 0) {
                baby = babylist.item(0);
                vStr.addElement(new String(baby.getNodeValue()));
            }
            child = XmlUtil.findNextElement(child);
        }
        return vStr;
    }

    private static Node findNode(Node node, String sPath) {
        Node retNode = null;
        short type = node.getNodeType();
        if (type == 9 ? (retNode = XmlUtil.traverseFind(((Document)node).getDocumentElement(), sPath, 0)) != null : type != 1 || (retNode = XmlUtil.traverseFind(node, sPath, 0)) != null) {
            // empty if block
        }
        return retNode;
    }

    private static Node traverseFind(Node node, String sPath, int indent) {
        Node retNode = null;
        if (node == null) {
            return retNode;
        }
        if (node.getNodeType() == 1) {
            String sElement = null;
            String sRemainder = null;
            int index = sPath.indexOf(92);
            if (index != -1) {
                sElement = sPath.substring(0, index);
                sRemainder = sPath.substring(index + 1, sPath.length());
            } else {
                sElement = new String(sPath);
            }
            if (node.getNodeName().equals(sElement)) {
                if (sRemainder == null) {
                    retNode = node;
                } else {
                    NodeList children = node.getChildNodes();
                    if (children != null) {
                        int len = children.getLength();
                        for (int i = 0; i < len && retNode == null; ++i) {
                            retNode = XmlUtil.traverseFind(children.item(i), sRemainder, indent + 1);
                        }
                    }
                }
            }
        }
        return retNode;
    }

    public static void WriteCloseMyWindowTag(BufferedWriter out) throws IOException {
        XmlUtils.writeTag((String)"com.novell.nps.close-my-window", null, (BufferedWriter)out);
    }

    public static String stripWhiteSpace(String sValue) {
        if (sValue == null || sValue.length() == 0) {
            return sValue;
        }
        try {
            boolean bContinue = true;
            while (bContinue) {
                bContinue = false;
                if (sValue.startsWith("\n")) {
                    sValue = sValue.substring(sValue.indexOf("\n") + 1);
                    bContinue = true;
                    continue;
                }
                if (sValue.startsWith("\r")) {
                    sValue = sValue.substring(sValue.indexOf("\r") + 1);
                    bContinue = true;
                    continue;
                }
                if (!sValue.startsWith(" ")) continue;
                sValue = sValue.substring(sValue.indexOf(" ") + 1);
                bContinue = true;
            }
        }
        catch (Exception e) {
            return null;
        }
        return sValue;
    }
}

