/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.i18n;

import com.novell.nps.WebappUtil;
import com.novell.nps.configManager.ConfigManager;
import com.novell.nps.gadgetManager.GadgetManager;
import com.novell.nps.i18n.ResourceFileMap;

public class GadgetResourceFileMap
extends ResourceFileMap {
    public static final String SPECIFIC_GADGET_RESOURCE_BASE_PATH = "System.SpecificGadgetResourceBasePath";

    private GadgetResourceFileMap() {
        this.populateWithSystem();
    }

    public GadgetResourceFileMap(String gadgetInstanceClassName) {
        super(GadgetResourceFileMap.buildRealPath(gadgetInstanceClassName));
        this.populateWithSystem();
    }

    private static String buildRealPath(String gadgetInstanceClassName) {
        StringBuffer sb = new StringBuffer();
        sb.append(SPECIFIC_GADGET_RESOURCE_BASE_PATH);
        sb.append('.');
        sb.append(gadgetInstanceClassName);
        String specificBasePath = ConfigManager.getPortalSetting(sb.toString());
        if (specificBasePath != null) {
            return specificBasePath;
        }
        sb = new StringBuffer();
        sb.append(GadgetManager.getPublishedResourcePathRelToCX());
        sb.append("/gadgets");
        sb.append("/");
        sb.append(gadgetInstanceClassName);
        return WebappUtil.getRealPath(sb.toString());
    }

    private void populateWithSystem() {
        ResourceFileMap systemRFM = GadgetManager.getSystemResourceFileMap();
        if (systemRFM != null) {
            this.availableLocales.addAll(systemRFM.getAvailableLocales());
            this.availableSkins.addAll(systemRFM.getAvailableSkins());
            this.availableDevices.addAll(systemRFM.getAvailableDevices());
        }
    }
}

