/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.i18n;

import com.novell.emframe.fw.FwUtils;
import com.novell.nps.WebappUtil;
import com.novell.nps.debug.Debug;
import com.novell.nps.gadgetManager.GadgetInstance;
import com.novell.nps.gadgetManager.GadgetManager;
import com.novell.nps.i18n.GadgetResourceFileMap;
import com.novell.nps.i18n.ResourceFileMap;
import com.novell.nps.i18n.SystemResourceFileMap;
import com.novell.nps.sessionManager.PortalSession;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Hashtable;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ResourceFileManager {
    static Hashtable resourceFileMaps = new Hashtable();
    public static final String DT = "ResourceFileManager";
    public static final String SYSTEM_RESOURCE_FILE_MAP = "System.ResourceFileMap";
    public static final String MODULE_RESOURCES_BASE_PATH = "/modules";
    public static final String MODULE_IDENTIFIER_SEPARATOR = "/";

    public static String getModuleResourceFile(HttpServletRequest req, String locatorAndFileName) {
        return ResourceFileManager.getModuleResourceFile((PortalSession)req.getSession(), FwUtils.getCurrentLocale((HttpSession)req.getSession()), locatorAndFileName);
    }

    public static String getModuleResourceFile(PortalSession session, Locale locale, String locatorAndFileName) {
        String localizedFilePath = null;
        if (session != null && locatorAndFileName != null && locale != null) {
            ResourceFileMap rfm;
            int sepIndex = locatorAndFileName.indexOf(MODULE_IDENTIFIER_SEPARATOR);
            if (sepIndex == -1 || sepIndex == locatorAndFileName.length()) {
                return null;
            }
            String locator = locatorAndFileName.substring(0, sepIndex);
            String fileName = locatorAndFileName.substring(sepIndex + 1);
            if (locator != null && fileName != null && (rfm = ResourceFileManager.getResourceFileMap(locator)) != null) {
                localizedFilePath = rfm.getLocalizedPath(fileName, session, locale);
            }
        }
        return localizedFilePath;
    }

    public static void forceRefresh(String identifier) throws FileNotFoundException {
        ResourceFileMap resourceFileMap = (ResourceFileMap)resourceFileMaps.get(identifier);
        if (resourceFileMap == null) {
            File module;
            File modulesParentDirectory = new File(ResourceFileManager.getModulesBasePath());
            if (modulesParentDirectory != null && modulesParentDirectory.isDirectory() && (resourceFileMap = new ResourceFileMap((module = new File(modulesParentDirectory, identifier)).getAbsolutePath())) != null) {
                resourceFileMap.refresh();
                resourceFileMaps.put(identifier, resourceFileMap);
            }
        } else {
            resourceFileMap.refresh();
        }
    }

    public static ResourceFileMap getResourceFileMap(String identifier) {
        return (ResourceFileMap)resourceFileMaps.get(identifier);
    }

    public static ResourceFileMap getGadgetResourceFileMap(GadgetInstance gadgetInstance) {
        ResourceFileMap rfm = null;
        if (gadgetInstance != null) {
            Class<?> gadget = gadgetInstance.getClass();
            rfm = ResourceFileManager.getResourceFileMap(gadget.getName());
        }
        return rfm;
    }

    public static ResourceFileMap getSystemResourceFileMap() {
        return ResourceFileManager.getResourceFileMap(SYSTEM_RESOURCE_FILE_MAP);
    }

    public static void rebuildResourceFileMaps() {
        File[] moduleDirectories;
        File modulesParentDirectory;
        File[] gadgetDirectories;
        File gadgetsParentDirectory;
        Hashtable<String, ResourceFileMap> newResourceFileMaps = new Hashtable<String, ResourceFileMap>();
        SystemResourceFileMap systemResourceFileMap = new SystemResourceFileMap(WebappUtil.getRealPath(GadgetManager.getSystemStyleSheetPath()));
        if (systemResourceFileMap != null) {
            try {
                systemResourceFileMap.refresh();
            }
            catch (FileNotFoundException e) {
                Debug.log(1, DT, "System ResourceFileMap could not be built!  Verify that the system's \"/portal/stylesheets\" directory exists.");
            }
            newResourceFileMaps.put(SYSTEM_RESOURCE_FILE_MAP, systemResourceFileMap);
            resourceFileMaps.put(SYSTEM_RESOURCE_FILE_MAP, systemResourceFileMap);
        }
        if ((gadgetsParentDirectory = new File(ResourceFileManager.getGadgetsBasePath())) != null && gadgetsParentDirectory.isDirectory() && (gadgetDirectories = gadgetsParentDirectory.listFiles()) != null) {
            for (int i = 0; i < gadgetDirectories.length; ++i) {
                String gadgetName;
                GadgetResourceFileMap gadgetRFM;
                File gadgetDirectory = gadgetDirectories[i];
                if (!gadgetDirectory.isDirectory() || (gadgetRFM = new GadgetResourceFileMap(gadgetName = gadgetDirectory.getName())) == null) continue;
                try {
                    gadgetRFM.refresh();
                    newResourceFileMaps.put(gadgetName, gadgetRFM);
                    continue;
                }
                catch (FileNotFoundException e) {
                    Debug.log(DT, 1, e);
                }
            }
        }
        if ((modulesParentDirectory = new File(ResourceFileManager.getModulesBasePath())) != null && modulesParentDirectory.isDirectory() && (moduleDirectories = modulesParentDirectory.listFiles()) != null) {
            for (int i = 0; i < moduleDirectories.length; ++i) {
                File moduleDirectory = moduleDirectories[i];
                if (!moduleDirectory.isDirectory()) continue;
                String moduleName = moduleDirectory.getName();
                ResourceFileMap moduleRFM = new ResourceFileMap(moduleDirectory.getAbsolutePath());
                if (moduleRFM == null) continue;
                try {
                    moduleRFM.refresh();
                    newResourceFileMaps.put(moduleName, moduleRFM);
                    continue;
                }
                catch (FileNotFoundException e) {
                    Debug.log(DT, 1, e);
                }
            }
        }
        resourceFileMaps = newResourceFileMaps;
    }

    public static String getModulesBasePath() {
        StringBuffer sb = new StringBuffer();
        sb.append(GadgetManager.getPublishedResourcePathRelToCX());
        sb.append(MODULE_RESOURCES_BASE_PATH);
        return WebappUtil.getRealPath(sb.toString());
    }

    public static String getGadgetsBasePath() {
        StringBuffer sb = new StringBuffer();
        sb.append(GadgetManager.getPublishedResourcePathRelToCX());
        sb.append("/gadgets");
        return WebappUtil.getRealPath(sb.toString());
    }

    public void init() {
        long startTime = System.currentTimeMillis();
        ResourceFileManager.rebuildResourceFileMaps();
        long endTime = System.currentTimeMillis();
        Debug.log(DT, 3, "Total time to build ResourceFileMaps: " + String.valueOf(endTime - startTime) + "ms");
    }
}

