/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.i18n;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class ResourceFilePath
implements Cloneable {
    private String baseFile = null;
    private String language = "en";
    private String skin = "default";
    private String device = "default";
    private static List countries = Arrays.asList(Locale.getISOCountries());
    private static List languages = Arrays.asList(Locale.getISOLanguages());

    public ResourceFilePath() {
    }

    public ResourceFilePath(String path) {
        if (path != null) {
            path = path.replace('\\', '/');
            this.parseBaseFileAndLang(path);
            this.parseSkin(path);
            this.parseDevice(path);
        }
    }

    public Object clone() {
        ResourceFilePath rfp = new ResourceFilePath();
        rfp.setBaseFile(this.baseFile);
        rfp.setLanguage(this.language);
        rfp.setSkin(this.skin);
        rfp.setDevice(this.device);
        return rfp;
    }

    private void parseBaseFileAndLang(String path) {
        int slashPos = ResourceFilePath.getLastSpecialSlashPos(path);
        String tempFile = null;
        tempFile = slashPos > -1 ? path.substring(slashPos + 1) : path;
        String tempLang = this.parseLanguage(tempFile);
        if (tempLang != null) {
            this.language = tempLang;
        } else {
            this.baseFile = tempFile;
        }
    }

    public static int getLastSpecialSlashPos(String path) {
        int extendedPathSlashPos;
        String extendedPath;
        int deviceEndingSlashPos;
        String remainingString;
        int slashPos;
        String insidePath;
        int lastSlashPos = -1;
        boolean bIsExtendedPath = false;
        int skinsPos = path.indexOf("skins/");
        int devicesPos = path.indexOf("/devices/");
        if (skinsPos > -1 && devicesPos > -1 && skinsPos < devicesPos && (insidePath = path.substring(skinsPos + 6, devicesPos)) != null && (slashPos = insidePath.indexOf(47)) == -1 && (remainingString = path.substring(devicesPos + 9)) != null && (deviceEndingSlashPos = remainingString.indexOf(47)) > -1 && (extendedPath = path.substring(deviceEndingSlashPos + 1)) != null && (extendedPathSlashPos = extendedPath.indexOf(47)) > -1) {
            bIsExtendedPath = true;
            lastSlashPos = devicesPos + 9 + deviceEndingSlashPos;
        }
        if (!bIsExtendedPath) {
            lastSlashPos = path.lastIndexOf(47);
        }
        return lastSlashPos;
    }

    private String parseLanguage(String filename) {
        String langString = null;
        int dotPos = filename.lastIndexOf(46);
        if (dotPos > 3 && filename.charAt(dotPos - 3) == '_') {
            String temp = filename.substring(dotPos - 2, dotPos);
            if (countries.contains(temp)) {
                langString = temp;
                if (dotPos >= 7 && filename.charAt(dotPos - 6) == '_') {
                    temp = filename.substring(dotPos - 5, dotPos - 3);
                    langString = temp + "_" + langString;
                    this.baseFile = filename.substring(0, dotPos - 6) + filename.substring(dotPos);
                } else {
                    this.baseFile = filename.substring(0, dotPos - 3) + filename.substring(dotPos);
                }
            } else if (languages.contains(temp)) {
                langString = temp;
                this.baseFile = filename.substring(0, dotPos - 3) + filename.substring(dotPos);
            }
        }
        return langString;
    }

    private void parseSkin(String path) {
        int nextSlashPos;
        int skinsPos = path.indexOf("skins/");
        if (skinsPos >= 0 && (nextSlashPos = path.indexOf(47, skinsPos + 6)) > 0) {
            this.skin = path.substring(skinsPos + 6, nextSlashPos);
        }
    }

    private void parseDevice(String path) {
        int nextSlashPos;
        int devicesPos = path.indexOf("devices/");
        if (devicesPos > 0 && (nextSlashPos = path.indexOf(47, devicesPos + 8)) > 0) {
            this.device = path.substring(devicesPos + 8, nextSlashPos);
        }
    }

    public String getBaseFile() {
        return this.baseFile;
    }

    public void setBaseFile(String newBaseFile) {
        if (newBaseFile != null) {
            this.baseFile = newBaseFile;
        }
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String newLanguage) {
        if (newLanguage != null) {
            this.language = newLanguage;
        }
    }

    public void setLanguage(Locale newLocale) {
        if (newLocale != null) {
            StringBuffer sb = new StringBuffer();
            String langStr = newLocale.getLanguage();
            String countryStr = newLocale.getCountry();
            if (langStr != null && langStr.length() > 0) {
                sb.append(langStr);
            }
            if (countryStr != null && countryStr.length() > 0) {
                sb.append("_");
                sb.append(countryStr);
            }
            if (sb.length() > 0) {
                this.language = sb.toString();
            }
        }
    }

    public String getSkin() {
        return this.skin;
    }

    public void setSkin(String newSkin) {
        if (newSkin != null) {
            this.skin = newSkin;
        }
    }

    public String getDevice() {
        return this.device;
    }

    public void setDevice(String newDevice) {
        if (newDevice != null) {
            this.device = newDevice;
        }
    }

    public String toHashString() {
        StringBuffer hashString = new StringBuffer();
        hashString.append(this.baseFile);
        hashString.append('+');
        if (this.language != null) {
            hashString.append(this.language);
        } else {
            hashString.append("en");
        }
        hashString.append('+');
        hashString.append(this.skin);
        hashString.append('+');
        hashString.append(this.device);
        return hashString.toString();
    }

    public String getLanguageCode() {
        String lang = "";
        if (this.language != null) {
            String possibleLang = this.language;
            if (this.language.length() > 2) {
                possibleLang = this.language.substring(0, 2);
            }
            if (languages.contains(possibleLang)) {
                lang = possibleLang;
            }
        }
        return lang;
    }

    public String getCountryCode() {
        String country = "";
        if (this.language != null) {
            String possibleCountry = this.language;
            if (this.language.length() > 2) {
                possibleCountry = this.language.substring(3);
            }
            if (countries.contains(possibleCountry)) {
                country = possibleCountry;
            }
        }
        return country;
    }

    public static void main(String[] args) {
        int pass = 0;
        int fail = 0;
        String testString = "skins\\classic1\\devices\\ie5\\myfile.xsl";
        ResourceFilePath rfp = new ResourceFilePath(testString);
        System.out.println("Testing \"" + testString + "\"");
        String baseFile = rfp.getBaseFile();
        String language = rfp.getLanguage();
        String skin = rfp.getSkin();
        String device = rfp.getDevice();
        System.out.print("\tBase File: " + baseFile);
        if (baseFile.equalsIgnoreCase("myfile.xsl")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        System.out.print("\tLanguage: " + language);
        if (language != null && language.equalsIgnoreCase("en")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        System.out.print("\tSkin: " + skin);
        if (skin != null && skin.equalsIgnoreCase("classic1")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        System.out.print("\tDevice: " + device);
        if (device != null && device.equalsIgnoreCase("ie5")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        testString = "skins/i-login/devices/default/myfile_fi_FI.xsl";
        rfp = new ResourceFilePath(testString);
        System.out.println("\nTesting \"" + testString + "\"");
        baseFile = rfp.getBaseFile();
        language = rfp.getLanguage();
        skin = rfp.getSkin();
        device = rfp.getDevice();
        System.out.print("\tBase File: " + baseFile);
        if (baseFile != null && baseFile.equalsIgnoreCase("myfile.xsl")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        System.out.print("\tLanguage: " + language);
        if (language != null && language.equalsIgnoreCase("fi_FI")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        System.out.print("\tSkin: " + skin);
        if (skin != null && skin.equalsIgnoreCase("i-login")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        System.out.print("\tDevice: " + device);
        if (device != null && device.equalsIgnoreCase("default")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        testString = "portal/gadgets/com.novell.nps.gadgets.file.NetworkFileGadgetInstance/skins/default/devices/pocketpc/myfile_lang_fi.xsl";
        rfp = new ResourceFilePath(testString);
        System.out.println("\nTesting \"" + testString + "\"");
        baseFile = rfp.getBaseFile();
        language = rfp.getLanguage();
        skin = rfp.getSkin();
        device = rfp.getDevice();
        System.out.print("\tBase File: " + baseFile);
        if (baseFile != null && baseFile.equalsIgnoreCase("myfile_lang.xsl")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        System.out.print("\tLanguage: " + language);
        if (language != null && language.equalsIgnoreCase("fi")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        System.out.print("\tSkin: " + skin);
        if (skin != null && skin.equalsIgnoreCase("default")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        System.out.print("\tDevice: " + device);
        if (device != null && device.equalsIgnoreCase("pocketpc")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        testString = "portal/gadgets/com.novell.nps.gadgets.file.NetworkFileGadgetInstance/skins/default/devices/pocketpc/myfile_lang_FI.xsl";
        rfp = new ResourceFilePath(testString);
        System.out.println("\nTesting \"" + testString + "\"");
        baseFile = rfp.getBaseFile();
        language = rfp.getLanguage();
        skin = rfp.getSkin();
        device = rfp.getDevice();
        System.out.print("\tBase File: " + baseFile);
        if (baseFile != null && baseFile.equalsIgnoreCase("myfile_lang.xsl")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        System.out.print("\tLanguage: " + language);
        if (language != null && language.equalsIgnoreCase("fi")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        System.out.print("\tSkin: " + skin);
        if (skin != null && skin.equalsIgnoreCase("default")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        System.out.print("\tDevice: " + device);
        if (device != null && device.equalsIgnoreCase("pocketpc")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        testString = "portal/gadgets/com.novell.nps.gadgets.file.NetworkFileGadgetInstance/skins/default/devices/pocketpc/x_de.xsl";
        rfp = new ResourceFilePath(testString);
        System.out.println("\nTesting \"" + testString + "\"");
        baseFile = rfp.getBaseFile();
        language = rfp.getLanguage();
        skin = rfp.getSkin();
        device = rfp.getDevice();
        System.out.print("\tBase File: " + baseFile);
        if (baseFile != null && baseFile.equalsIgnoreCase("x.xsl")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        System.out.print("\tLanguage: " + language);
        if (language != null && language.equalsIgnoreCase("de")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        System.out.print("\tSkin: " + skin);
        if (skin != null && skin.equalsIgnoreCase("default")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        System.out.print("\tDevice: " + device);
        if (device != null && device.equalsIgnoreCase("pocketpc")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        testString = "portal/gadgets/com.novell.nps.gadgets.file.NetworkFileGadgetInstance/skins/default/devices/pocketpc/main_lang_pt_BR.xsl";
        rfp = new ResourceFilePath(testString);
        System.out.println("\nTesting \"" + testString + "\"");
        baseFile = rfp.getBaseFile();
        language = rfp.getLanguage();
        skin = rfp.getSkin();
        device = rfp.getDevice();
        System.out.print("\tBase File: " + baseFile);
        if (baseFile != null && baseFile.equalsIgnoreCase("main_lang.xsl")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        System.out.print("\tLanguage: " + language);
        if (language != null && language.equalsIgnoreCase("pt_BR")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        System.out.print("\tSkin: " + skin);
        if (skin != null && skin.equalsIgnoreCase("default")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        System.out.print("\tDevice: " + device);
        if (device != null && device.equalsIgnoreCase("pocketpc")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        testString = "testing/main_lang_pt_BR.xsl";
        rfp = new ResourceFilePath(testString);
        System.out.println("\nTesting \"" + testString + "\"");
        baseFile = rfp.getBaseFile();
        language = rfp.getLanguage();
        skin = rfp.getSkin();
        device = rfp.getDevice();
        System.out.print("\tBase File: " + baseFile);
        if (baseFile != null && baseFile.equalsIgnoreCase("main_lang.xsl")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        System.out.print("\tLanguage: " + language);
        if (language != null && language.equalsIgnoreCase("pt_BR")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        System.out.print("\tSkin: " + skin);
        if (skin != null && skin.equalsIgnoreCase("default")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        System.out.print("\tDevice: " + device);
        if (device != null && device.equalsIgnoreCase("pocketpc")) {
            ++fail;
            System.out.println("\t\tFailed");
        } else {
            ++pass;
            System.out.println("\t\tPassed");
        }
        testString = "main_lang_pt_BR.xsl";
        rfp = new ResourceFilePath(testString);
        System.out.println("\nTesting \"" + testString + "\"");
        baseFile = rfp.getBaseFile();
        language = rfp.getLanguage();
        skin = rfp.getSkin();
        device = rfp.getDevice();
        System.out.print("\tBase File: " + baseFile);
        if (baseFile != null && baseFile.equalsIgnoreCase("main_lang.xsl")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        System.out.print("\tLanguage: " + language);
        if (language != null && language.equalsIgnoreCase("pt_BR")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        System.out.print("\tSkin: " + skin);
        if (skin != null && skin.equalsIgnoreCase("default")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        System.out.print("\tDevice: " + device);
        if (device != null && device.equalsIgnoreCase("pocketpc")) {
            ++fail;
            System.out.println("\t\tFailed");
        } else {
            ++pass;
            System.out.println("\t\tPassed");
        }
        testString = "skins/i-login/main_lang_pt_BR.xsl";
        rfp = new ResourceFilePath(testString);
        System.out.println("\nTesting \"" + testString + "\"");
        baseFile = rfp.getBaseFile();
        language = rfp.getLanguage();
        skin = rfp.getSkin();
        device = rfp.getDevice();
        System.out.print("\tBase File: " + baseFile);
        if (baseFile != null && baseFile.equalsIgnoreCase("main_lang.xsl")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        System.out.print("\tLanguage: " + language);
        if (language != null && language.equalsIgnoreCase("pt_BR")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        System.out.print("\tSkin: " + skin);
        if (skin != null && skin.equalsIgnoreCase("i-login")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        System.out.print("\tDevice: " + device);
        if (device != null && device.equalsIgnoreCase("pocketpc")) {
            ++fail;
            System.out.println("\t\tFailed");
        } else {
            ++pass;
            System.out.println("\t\tPassed");
        }
        testString = "skins/i-login/devices/main_lang_pt_BR.xsl";
        rfp = new ResourceFilePath(testString);
        System.out.println("\nTesting \"" + testString + "\"");
        baseFile = rfp.getBaseFile();
        language = rfp.getLanguage();
        skin = rfp.getSkin();
        device = rfp.getDevice();
        System.out.print("\tBase File: " + baseFile);
        if (baseFile != null && baseFile.equalsIgnoreCase("main_lang.xsl")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        System.out.print("\tLanguage: " + language);
        if (language != null && language.equalsIgnoreCase("pt_BR")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        System.out.print("\tSkin: " + skin);
        if (skin != null && skin.equalsIgnoreCase("i-login")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        System.out.print("\tDevice: " + device);
        if (device != null && device.equalsIgnoreCase("pocketpc")) {
            ++fail;
            System.out.println("\t\tFailed");
        } else {
            ++pass;
            System.out.println("\t\tPassed");
        }
        testString = "skins\\classic1\\devices\\ie5\\myfile.xsl";
        rfp = new ResourceFilePath(testString);
        System.out.println("Testing \"" + testString + "\"");
        baseFile = rfp.getBaseFile();
        language = rfp.getLanguage();
        skin = rfp.getSkin();
        device = rfp.getDevice();
        System.out.print("\tBase File: " + baseFile);
        if (baseFile != null && baseFile.equalsIgnoreCase("myfile.xsl")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        testString = "skins\\classic1\\devices\\ie5\\OS\\x.gif";
        rfp = new ResourceFilePath(testString);
        System.out.println("Testing \"" + testString + "\"");
        baseFile = rfp.getBaseFile();
        language = rfp.getLanguage();
        skin = rfp.getSkin();
        device = rfp.getDevice();
        System.out.print("\tBase File: " + baseFile);
        if (baseFile != null && baseFile.equalsIgnoreCase("OS/x.gif")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        testString = "skins\\classic1\\devices\\ie5\\some\\very\\long\\special\\extended\\path\\x.gif";
        rfp = new ResourceFilePath(testString);
        System.out.println("Testing \"" + testString + "\"");
        baseFile = rfp.getBaseFile();
        language = rfp.getLanguage();
        skin = rfp.getSkin();
        device = rfp.getDevice();
        System.out.print("\tBase File: " + baseFile);
        if (baseFile != null && baseFile.equalsIgnoreCase("some/very/long/special/extended/path/x.gif")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        testString = "skins\\classic1\\ie5\\some\\very\\long\\special\\extended\\path\\x.gif";
        rfp = new ResourceFilePath(testString);
        System.out.println("Testing \"" + testString + "\"");
        baseFile = rfp.getBaseFile();
        language = rfp.getLanguage();
        skin = rfp.getSkin();
        device = rfp.getDevice();
        System.out.print("\tBase File: " + baseFile);
        if (baseFile != null && baseFile.equalsIgnoreCase("x.gif")) {
            ++pass;
            System.out.println("\t\tPassed");
        } else {
            ++fail;
            System.out.println("\t\tFailed");
        }
        System.out.println("\n\nTotal Number of Tests Performed: " + String.valueOf(pass + fail));
        System.out.println("Passed Tests: " + String.valueOf(pass));
        System.out.println("Failed Tests: " + String.valueOf(fail));
    }
}

