/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.i18n;

import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Properties;

public class ToXliff {
    public static void main(String[] args) {
        String inputPath = null;
        String outputPath = null;
        if (args.length < 1) {
            System.err.println("Syntax:\n\tToXliff <Java Properties Input File> [Optional Output File]");
            System.exit(-1);
        } else if (args.length > 1) {
            outputPath = args[1];
        }
        inputPath = args[0];
        FileInputStream fin = null;
        Properties props = new Properties();
        try {
            fin = new FileInputStream(inputPath);
            props.load(fin);
        }
        catch (FileNotFoundException e) {
            System.err.println("Could not open the specified input file \"" + inputPath + "\".");
            System.exit(-2);
        }
        catch (IOException e) {
            System.err.println("Problems building a java.util.Properties object from the input file \"" + inputPath + "\".");
            System.exit(-2);
        }
        BufferedWriter bout = null;
        if (outputPath != null) {
            try {
                FileOutputStream fout = new FileOutputStream(outputPath);
                bout = new BufferedWriter(new PrintWriter(fout));
            }
            catch (FileNotFoundException e) {
                System.err.println("Could not create the output file \"" + outputPath + "\".");
                System.exit(-3);
            }
        } else {
            bout = new BufferedWriter(new PrintWriter(System.out));
        }
        try {
            ToXliff.toXliff(props, bout);
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    public static void toXliff(Properties props, BufferedWriter bout) throws Exception {
        if (props != null && bout != null) {
            Enumeration<Object> myenum = props.keys();
            while (myenum.hasMoreElements()) {
                String key = (String)myenum.nextElement();
                bout.write("<trans-unit id=\"");
                bout.write(key);
                bout.write("\">\r\n\t<source><![CDATA[");
                bout.write(props.getProperty(key));
                bout.write("]]></source>\r\n</trans-unit>\r\n");
            }
        } else {
            throw new IllegalArgumentException("toXliff() was called with a null parameter.");
        }
        bout.flush();
    }
}

