/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.logging.logBeans;

import com.novell.nps.event.GadgetHitGadgetEvent;
import com.novell.nps.event.GadgetHitSchemeEvent;
import com.novell.nps.event.PortalEvent;
import com.novell.nps.event.PortalEventListener;
import com.novell.nps.event.PortalEventManager;
import com.novell.nps.logging.logBeans.PortalLogBean;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;

public class PortalLoggingLogGadgetHitBean
extends PortalLogBean
implements Serializable {
    private static String m_sFile = "PortalLog.xml";
    private static File m_fLog = null;
    private static PrintWriter m_p = null;
    private static String[] PortalGadgetHitEvents = new String[]{"com.novell.nps.event.GadgetHitGadgetEvent", "com.novell.nps.event.GadgetHitSchemeEvent"};

    public PortalLoggingLogGadgetHitBean() {
        this.init();
    }

    public void shutdown() {
        PortalEventManager.unRegisterEventListener((PortalEventListener)this, PortalGadgetHitEvents);
    }

    public void init() {
        PortalEventManager.registerEventListener((PortalEventListener)this, PortalGadgetHitEvents);
        super.init();
        m_sFile = this.getLogFile();
        m_p = PortalLoggingLogGadgetHitBean.getPrintWriter(m_sFile);
    }

    public void refreshSettings() {
        super.init();
        m_sFile = this.getLogFile();
        m_p = PortalLoggingLogGadgetHitBean.getPrintWriter(m_sFile);
    }

    protected void writeGadgetHitEvent(GadgetHitGadgetEvent gadgetHitEvent) {
        Date dt = new Date();
        Long currentDate = new Long(dt.getTime());
        DateFormat df = DateFormat.getDateTimeInstance(3, 2);
        if (m_p != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("<LogEntry>");
            sb.append("<DateString>");
            sb.append(df.format(dt));
            sb.append("</DateString>");
            sb.append("<DateLong>");
            sb.append(currentDate);
            sb.append("</DateLong>");
            sb.append("<UserName>");
            sb.append(gadgetHitEvent.getUserName());
            sb.append("</UserName>");
            sb.append("<GadgetAssingmentName>");
            sb.append(gadgetHitEvent.getAssignment().getAssignmentName());
            sb.append("</GadgetAssingmentName>");
            sb.append("<GadgetAssingmentDN>");
            sb.append(gadgetHitEvent.getAssignment().getGadgetDN());
            sb.append("</GadgetAssingmentDN>");
            sb.append("<Action>");
            sb.append(gadgetHitEvent.getAction());
            sb.append("</Action>");
            sb.append("<Event>");
            sb.append("GadgetHitEvent");
            sb.append("</Event>");
            sb.append("</LogEntry>");
            PortalLoggingLogGadgetHitBean.writeToPrintWriter(m_p, sb.toString());
            m_p.flush();
        }
    }

    protected void writeSchemaHitEvent(GadgetHitSchemeEvent gadgetHitSchemeEvent) {
        Date dt = new Date();
        Long currentDate = new Long(dt.getTime());
        DateFormat df = DateFormat.getDateTimeInstance(3, 2);
        if (m_p != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("<LogEntry>");
            sb.append("<DateString>");
            sb.append(df.format(dt));
            sb.append("</DateString>");
            sb.append("<DateLong>");
            sb.append(currentDate);
            sb.append("</DateLong>");
            sb.append("<UserName>");
            sb.append(gadgetHitSchemeEvent.getUserName());
            sb.append("</UserName>");
            sb.append("<GadgetAssingmentName>");
            sb.append(gadgetHitSchemeEvent.getAssignment().getAssignmentName());
            sb.append("</GadgetAssingmentName>");
            sb.append("<GadgetAssingmentDN>");
            sb.append(gadgetHitSchemeEvent.getAssignment().getGadgetDN());
            sb.append("</GadgetAssingmentDN>");
            sb.append("<Action>");
            sb.append(gadgetHitSchemeEvent.getAction());
            sb.append("</Action>");
            sb.append("<Event>");
            sb.append("SchemeHitEvent");
            sb.append("</Event>");
            sb.append("</LogEntry>");
            PortalLoggingLogGadgetHitBean.writeToPrintWriter(m_p, sb.toString());
            m_p.flush();
        }
    }

    public void onPortalEvent(PortalEvent event) {
        if (event instanceof GadgetHitGadgetEvent) {
            this.writeGadgetHitEvent((GadgetHitGadgetEvent)event);
        } else if (event instanceof GadgetHitSchemeEvent) {
            this.writeSchemaHitEvent((GadgetHitSchemeEvent)event);
        }
    }
}

