/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.serviceProviders;

import com.novell.nps.serviceProviders.NPMInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class GetManifest
extends NPMInfo {
    public static final String MANIFEST = "META-INF/MANIFEST.MF";
    public static final String KEY_MANIFEST_VERSION = "Manifest-Version";
    public static final String KEY_MODULE_TITLE = "Implementation-Title";
    public static final String KEY_MODULE_VERSION = "Implementation-Version";
    public static final String KEY_MODULE_DESCRIPTION = "Implementation-Description";
    public static final String KEY_MODULE_VENDOR = "Implementation-Vendor";
    public static final String KEY_MODULE_ID = "Module-ID";
    public static final String KEY_REQUIRED_VERSION = "Required-Version";
    public static final String KEY_MODULE_OS = "Supported-OS";
    public static final String KEY_MIN_IMAN_VERSION = "Min-iManager-Version";
    public static final String KEY_MAX_IMAN_VERSION = "Max-iManager-Version";
    public static final String KEY_DEPENDS_ON = "Depends-on";
    public static final String FILE_EXT_PORTAL_MODULE = ".npm";

    GetManifest(String sArchiveFile) throws ManifestException, IOException {
        this(new File(sArchiveFile));
    }

    GetManifest(File fArchiveFile) throws ManifestException, IOException {
        BufferedReader reader;
        InputStream inputStream;
        JarFile jarFile;
        if (fArchiveFile.isFile() && fArchiveFile.canRead()) {
            String line;
            jarFile = new JarFile(fArchiveFile);
            ZipEntry entry = jarFile.getEntry(MANIFEST);
            if (entry == null) {
                throw new ManifestException("No manifest found in file.");
            }
            inputStream = jarFile.getInputStream(entry);
            reader = null;
            String key = "";
            String value = "";
            this.setModuleFileName(fArchiveFile.getName());
            reader = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = reader.readLine()) != null && line.length() > 0) {
                int inx = line.indexOf(":");
                if (inx > 0) {
                    key = line.substring(0, inx);
                    value = line.substring(inx + 1).trim();
                } else if (line.charAt(0) == ' ') {
                    value = value + line.substring(1);
                } else {
                    value = "";
                    key = "";
                    continue;
                }
                if (key.equalsIgnoreCase(KEY_MODULE_DESCRIPTION)) {
                    this.setModuleDescription(value);
                    continue;
                }
                if (key.equalsIgnoreCase(KEY_MODULE_VERSION)) {
                    this.setModuleVersion(value);
                    continue;
                }
                if (key.equalsIgnoreCase(KEY_MODULE_ID)) {
                    this.setModuleID(value);
                    continue;
                }
                if (key.equalsIgnoreCase(KEY_MODULE_TITLE)) {
                    this.setModuleTitle(value);
                    continue;
                }
                if (key.equalsIgnoreCase(KEY_MODULE_VENDOR)) {
                    this.setModuleVendor(value);
                    continue;
                }
                if (key.equalsIgnoreCase(KEY_REQUIRED_VERSION)) {
                    this.setModuleRequiredVersion(value);
                    continue;
                }
                if (key.equalsIgnoreCase(KEY_MODULE_OS)) {
                    this.setModuleSupportedOS(value);
                    continue;
                }
                if (key.equalsIgnoreCase(KEY_MIN_IMAN_VERSION)) {
                    this.setModuleMinImanagerVersion(value);
                    continue;
                }
                if (key.equalsIgnoreCase(KEY_MAX_IMAN_VERSION)) {
                    this.setModuleMaxImanagerVersion(value);
                    continue;
                }
                if (!key.equalsIgnoreCase(KEY_DEPENDS_ON)) continue;
                String[] sValuetemp = value.split(",");
                for (int i = 0; i < sValuetemp.length; ++i) {
                    this.setDependsOn(sValuetemp[i]);
                }
            }
        } else {
            throw new IOException("File does not exist or cannot be read");
        }
        inputStream.close();
        reader.close();
        jarFile.close();
    }

    public static class ManifestException
    extends Exception {
        public ManifestException() {
        }

        public ManifestException(String message) {
            super(message);
        }
    }
}

